/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.OutputStream;
import java.util.Properties;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.api.FetchRequest;
import kafka.api.FetchRequestBuilder;
import kafka.api.FetchResponse;
import kafka.api.OffsetRequest$;
import kafka.api.PartitionMetadata;
import kafka.api.Request$;
import kafka.api.TopicMetadata;
import kafka.client.ClientUtils$;
import kafka.cluster.Broker;
import kafka.common.TopicAndPartition;
import kafka.consumer.ConsumerConfig$;
import kafka.consumer.DefaultMessageFormatter;
import kafka.consumer.MessageFormatter;
import kafka.consumer.MessageFormatter$;
import kafka.consumer.SimpleConsumer;
import kafka.message.ByteBufferMessageSet;
import kafka.message.Message;
import kafka.message.MessageAndOffset;
import kafka.tools.SimpleConsumerShell$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class SimpleConsumerShell$
implements Logging {
    public static final SimpleConsumerShell$ MODULE$;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    static {
        new SimpleConsumerShell$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        SimpleConsumerShell$ simpleConsumerShell$ = this;
        synchronized (simpleConsumerShell$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public int UseLeaderReplica() {
        return -1;
    }

    public void main(String[] args) {
        ObjectRef<Object> fetchTargetBroker;
        FetchRequestBuilder fetchRequestBuilder;
        Properties formatterArgs;
        Class<?> messageFormatterClass;
        boolean noWaitAtEndOfLog;
        boolean printOffsets;
        boolean skipMessageOnError;
        int maxMessages;
        String clientId;
        int fetchSize;
        LongRef startingOffset;
        int replicaId;
        int partitionId;
        String topic;
        block14: {
            Seq<PartitionMetadata> partitionsMetadata;
            Option<PartitionMetadata> partitionMetadataOpt;
            OptionParser parser = new OptionParser();
            ArgumentAcceptingOptionSpec brokerListOpt = parser.accepts("broker-list", "REQUIRED: The list of hostname and port of the server to connect to.").withRequiredArg().describedAs("hostname:port,...,hostname:port").ofType(String.class);
            ArgumentAcceptingOptionSpec topicOpt = parser.accepts("topic", "REQUIRED: The topic to consume from.").withRequiredArg().describedAs("topic").ofType(String.class);
            ArgumentAcceptingOptionSpec partitionIdOpt = parser.accepts("partition", "The partition to consume from.").withRequiredArg().describedAs("partition").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(0), (Object[])new Integer[0]);
            ArgumentAcceptingOptionSpec replicaIdOpt = parser.accepts("replica", "The replica id to consume from, default -1 means leader broker.").withRequiredArg().describedAs("replica id").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(this.UseLeaderReplica()), (Object[])new Integer[0]);
            ArgumentAcceptingOptionSpec offsetOpt = parser.accepts("offset", "The offset id to consume from, default to -2 which means from beginning; while value -1 means from end").withRequiredArg().describedAs("consume offset").ofType(Long.class).defaultsTo((Object)Predef$.MODULE$.long2Long(OffsetRequest$.MODULE$.EarliestTime()), (Object[])new Long[0]);
            ArgumentAcceptingOptionSpec clientIdOpt = parser.accepts("clientId", "The ID of this client.").withRequiredArg().describedAs("clientId").ofType(String.class).defaultsTo((Object)"SimpleConsumerShell", (Object[])new String[0]);
            ArgumentAcceptingOptionSpec fetchSizeOpt = parser.accepts("fetchsize", "The fetch size of each request.").withRequiredArg().describedAs("fetchsize").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(0x100000), (Object[])new Integer[0]);
            ArgumentAcceptingOptionSpec messageFormatterOpt = parser.accepts("formatter", "The name of a class to use for formatting kafka messages for display.").withRequiredArg().describedAs("class").ofType(String.class).defaultsTo((Object)DefaultMessageFormatter.class.getName(), (Object[])new String[0]);
            ArgumentAcceptingOptionSpec messageFormatterArgOpt = parser.accepts("property").withRequiredArg().describedAs("prop").ofType(String.class);
            OptionSpecBuilder printOffsetOpt = parser.accepts("print-offsets", "Print the offsets returned by the iterator");
            ArgumentAcceptingOptionSpec maxWaitMsOpt = parser.accepts("max-wait-ms", "The max amount of time each fetch request waits.").withRequiredArg().describedAs("ms").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(1000), (Object[])new Integer[0]);
            ArgumentAcceptingOptionSpec maxMessagesOpt = parser.accepts("max-messages", "The number of messages to consume").withRequiredArg().describedAs("max-messages").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(Integer.MAX_VALUE), (Object[])new Integer[0]);
            OptionSpecBuilder skipMessageOnErrorOpt = parser.accepts("skip-message-on-error", "If there is an error when processing a message, skip it instead of halt.");
            OptionSpecBuilder noWaitAtEndOfLogOpt = parser.accepts("no-wait-at-logend", "If set, when the simple consumer reaches the end of the Log, it will stop, not waiting for new produced messages");
            OptionSet options = parser.parse(args);
            ((List)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new ArgumentAcceptingOptionSpec[]{brokerListOpt, topicOpt, partitionIdOpt}))).foreach(new Serializable(parser, options){
                public static final long serialVersionUID = 0L;
                private final OptionParser parser$1;
                private final OptionSet options$1;

                public final void apply(ArgumentAcceptingOptionSpec<? extends Comparable<? extends Object>> arg) {
                    if (!this.options$1.has(arg)) {
                        SimpleConsumerShell$.MODULE$.error((Function0<String>)((Object)new Serializable(this, arg){
                            public static final long serialVersionUID = 0L;
                            private final ArgumentAcceptingOptionSpec arg$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)"Missing required argument \"").append(this.arg$1).append((Object)"\"").toString();
                            }
                            {
                                this.arg$1 = arg$1;
                            }
                        }));
                        this.parser$1.printHelpOn((OutputStream)System.err);
                        System.exit(1);
                    }
                }
                {
                    this.parser$1 = parser$1;
                    this.options$1 = options$1;
                }
            });
            topic = (String)options.valueOf((OptionSpec)topicOpt);
            partitionId = (Integer)options.valueOf((OptionSpec)partitionIdOpt);
            replicaId = (Integer)options.valueOf((OptionSpec)replicaIdOpt);
            startingOffset = new LongRef((Long)options.valueOf((OptionSpec)offsetOpt));
            fetchSize = (Integer)options.valueOf((OptionSpec)fetchSizeOpt);
            clientId = ((String)options.valueOf((OptionSpec)clientIdOpt)).toString();
            int maxWaitMs = (Integer)options.valueOf((OptionSpec)maxWaitMsOpt);
            maxMessages = (Integer)options.valueOf((OptionSpec)maxMessagesOpt);
            skipMessageOnError = options.has((OptionSpec)skipMessageOnErrorOpt);
            printOffsets = options.has((OptionSpec)printOffsetOpt);
            noWaitAtEndOfLog = options.has((OptionSpec)noWaitAtEndOfLogOpt);
            messageFormatterClass = Class.forName((String)options.valueOf((OptionSpec)messageFormatterOpt));
            formatterArgs = MessageFormatter$.MODULE$.tryParseFormatterArgs(JavaConversions$.MODULE$.asScalaBuffer(options.valuesOf((OptionSpec)messageFormatterArgOpt)));
            fetchRequestBuilder = new FetchRequestBuilder().clientId(clientId).replicaId(Request$.MODULE$.DebuggingConsumerId()).maxWait(maxWaitMs).minBytes(ConsumerConfig$.MODULE$.MinFetchBytes());
            this.info((Function0<String>)((Object)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Getting topic metatdata...";
                }
            }));
            Seq<Broker> metadataTargetBrokers = ClientUtils$.MODULE$.parseBrokerList((String)options.valueOf((OptionSpec)brokerListOpt));
            Seq<TopicMetadata> topicsMetadata = ClientUtils$.MODULE$.fetchTopicMetadata((Set)Predef$.MODULE$.Set().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), metadataTargetBrokers, clientId, maxWaitMs, ClientUtils$.MODULE$.fetchTopicMetadata$default$5()).topicsMetadata();
            if (topicsMetadata.size() != 1 || !((TopicMetadata)topicsMetadata.apply(false)).topic().equals(topic)) {
                System.err.println(new StringOps(Predef$.MODULE$.augmentString("Error: no valid topic metadata for topic: %s, what we get from server is only: %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{topic, topicsMetadata})));
                System.exit(1);
            }
            if (!(partitionMetadataOpt = (partitionsMetadata = ((TopicMetadata)topicsMetadata.apply(false)).partitionsMetadata()).find((Function1<PartitionMetadata, Object>)((Object)new Serializable(partitionId){
                public static final long serialVersionUID = 0L;
                private final int partitionId$1;

                public final boolean apply(PartitionMetadata p) {
                    return p.partitionId() == this.partitionId$1;
                }
                {
                    this.partitionId$1 = partitionId$1;
                }
            }))).isDefined()) {
                System.err.println(new StringOps(Predef$.MODULE$.augmentString("Error: partition %d does not exist for topic %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(partitionId), topic})));
                System.exit(1);
            }
            fetchTargetBroker = new ObjectRef<Object>(null);
            Option<Broker> replicaOpt = null;
            if (replicaId == this.UseLeaderReplica()) {
                replicaOpt = partitionMetadataOpt.get().leader();
                if (!replicaOpt.isDefined()) {
                    System.err.println(new StringOps(Predef$.MODULE$.augmentString("Error: user speicifies to fetch from leader for partition (%s, %d) which has not been elected yet")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(replicaId), topic, BoxesRunTime.boxToInteger(partitionId)})));
                    System.exit(1);
                }
            } else {
                Seq<Broker> replicasForPartition2 = partitionMetadataOpt.get().replicas();
                replicaOpt = replicasForPartition2.find((Function1<Broker, Object>)((Object)new Serializable(replicaId){
                    public static final long serialVersionUID = 0L;
                    private final int replicaId$1;

                    public final boolean apply(Broker r) {
                        return r.id() == this.replicaId$1;
                    }
                    {
                        this.replicaId$1 = replicaId$1;
                    }
                }));
                if (!replicaOpt.isDefined()) {
                    System.err.println(new StringOps(Predef$.MODULE$.augmentString("Error: replica %d does not exist for partition (%s, %d)")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(replicaId), topic, BoxesRunTime.boxToInteger(partitionId)})));
                    System.exit(1);
                }
            }
            fetchTargetBroker.elem = replicaOpt.get();
            if (startingOffset.elem < OffsetRequest$.MODULE$.EarliestTime()) {
                System.err.println(new StringOps(Predef$.MODULE$.augmentString("Invalid starting offset: %d")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(startingOffset.elem)})));
                System.exit(1);
            }
            if (startingOffset.elem < 0L) {
                SimpleConsumer simpleConsumer = new SimpleConsumer(((Broker)fetchTargetBroker.elem).host(), ((Broker)fetchTargetBroker.elem).port(), ConsumerConfig$.MODULE$.SocketTimeout(), ConsumerConfig$.MODULE$.SocketBufferSize(), clientId);
                try {
                    startingOffset.elem = simpleConsumer.earliestOrLatestOffset(new TopicAndPartition(topic, partitionId), startingOffset.elem, Request$.MODULE$.DebuggingConsumerId());
                    if (simpleConsumer != null) {
                        simpleConsumer.close();
                    }
                }
                catch (Throwable throwable) {
                    try {
                        System.err.println(new StringBuilder().append((Object)"Error in getting earliest or latest offset due to: ").append((Object)Utils$.MODULE$.stackTrace(throwable)).toString());
                        System.exit(1);
                    }
                    finally {
                        if (simpleConsumer == null) break block14;
                        simpleConsumer.close();
                    }
                }
            }
        }
        MessageFormatter formatter = (MessageFormatter)messageFormatterClass.newInstance();
        formatter.init(formatterArgs);
        String replicaString = replicaId > 0 ? "leader" : "replica";
        this.info((Function0<String>)((Object)new Serializable(topic, partitionId, replicaId, startingOffset, fetchTargetBroker, replicaString){
            public static final long serialVersionUID = 0L;
            private final String topic$1;
            private final int partitionId$1;
            private final int replicaId$1;
            private final LongRef startingOffset$1;
            private final ObjectRef fetchTargetBroker$1;
            private final String replicaString$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Starting simple consumer shell to partition [%s, %d], %s [%d], host and port: [%s, %d], from offset [%d]")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.topic$1, BoxesRunTime.boxToInteger(this.partitionId$1), this.replicaString$1, BoxesRunTime.boxToInteger(this.replicaId$1), ((Broker)this.fetchTargetBroker$1.elem).host(), BoxesRunTime.boxToInteger(((Broker)this.fetchTargetBroker$1.elem).port()), BoxesRunTime.boxToLong(this.startingOffset$1.elem)}));
            }
            {
                this.topic$1 = topic$1;
                this.partitionId$1 = partitionId$1;
                this.replicaId$1 = replicaId$1;
                this.startingOffset$1 = startingOffset$1;
                this.fetchTargetBroker$1 = fetchTargetBroker$1;
                this.replicaString$1 = replicaString$1;
            }
        }));
        SimpleConsumer simpleConsumer = new SimpleConsumer(((Broker)fetchTargetBroker.elem).host(), ((Broker)fetchTargetBroker.elem).port(), 10000, 65536, clientId);
        Thread thread = Utils$.MODULE$.newThread("kafka-simpleconsumer-shell", new Runnable(topic, partitionId, replicaId, startingOffset, fetchSize, maxMessages, skipMessageOnError, printOffsets, noWaitAtEndOfLog, fetchRequestBuilder, formatter, simpleConsumer){
            public final String topic$1;
            public final int partitionId$1;
            public final int replicaId$1;
            private final LongRef startingOffset$1;
            private final int fetchSize$1;
            public final int maxMessages$1;
            public final boolean skipMessageOnError$1;
            public final boolean printOffsets$1;
            private final boolean noWaitAtEndOfLog$1;
            private final FetchRequestBuilder fetchRequestBuilder$1;
            public final MessageFormatter formatter$1;
            public final SimpleConsumer simpleConsumer$1;

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                LongRef offset = new LongRef(this.startingOffset$1.elem);
                IntRef numMessagesConsumed = new IntRef(0);
                while (true) {
                    ByteBufferMessageSet messageSet;
                    try {
                        if (numMessagesConsumed.elem >= this.maxMessages$1) break;
                        FetchRequest fetchRequest = this.fetchRequestBuilder$1.addFetch(this.topic$1, this.partitionId$1, offset.elem, this.fetchSize$1).build();
                        FetchResponse fetchResponse = this.simpleConsumer$1.fetch(fetchRequest);
                        messageSet = fetchResponse.messageSet(this.topic$1, this.partitionId$1);
                        if (messageSet.validBytes() <= 0 && this.noWaitAtEndOfLog$1) {
                            Predef$.MODULE$.println(new StringOps(Predef$.MODULE$.augmentString("Terminating. Reached the end of partition (%s, %d) at offset %d")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.topic$1, BoxesRunTime.boxToInteger(this.partitionId$1), BoxesRunTime.boxToLong(offset.elem)})));
                            SimpleConsumerShell$.MODULE$.info((Function0<String>)((Object)new Serializable(this, numMessagesConsumed){
                                public static final long serialVersionUID = 0L;
                                private final IntRef numMessagesConsumed$1;

                                public final String apply() {
                                    return new StringBuilder().append((Object)"Consumed ").append(BoxesRunTime.boxToInteger(this.numMessagesConsumed$1.elem)).append((Object)" messages").toString();
                                }
                                {
                                    this.numMessagesConsumed$1 = numMessagesConsumed$1;
                                }
                            }));
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            SimpleConsumerShell$.MODULE$.error((Function0<String>)((Object)new Serializable(this, offset){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anon.1 $outer;
                                private final LongRef offset$1;

                                public final String apply() {
                                    return new StringOps(Predef$.MODULE$.augmentString("Error consuming topic, partition, replica (%s, %d, %d) with offset [%d]")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.topic$1, BoxesRunTime.boxToInteger(this.$outer.partitionId$1), BoxesRunTime.boxToInteger(this.$outer.replicaId$1), BoxesRunTime.boxToLong(this.offset$1.elem)}));
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.offset$1 = offset$1;
                                }
                            }), (Function0<Throwable>)((Object)new Serializable(this, throwable){
                                public static final long serialVersionUID = 0L;
                                private final Throwable e$2;

                                public final Throwable apply() {
                                    return this.e$2;
                                }
                                {
                                    this.e$2 = e$2;
                                }
                            }));
                        }
                        catch (Throwable throwable2) {
                            SimpleConsumerShell$.MODULE$.info((Function0<String>)((Object)new /* invalid duplicate definition of identical inner class */));
                            throw throwable2;
                        }
                        SimpleConsumerShell$.MODULE$.info((Function0<String>)((Object)new /* invalid duplicate definition of identical inner class */));
                        return;
                    }
                    {
                        SimpleConsumerShell$.MODULE$.debug((Function0<String>)((Object)new Serializable(this, offset, messageSet){
                            public static final long serialVersionUID = 0L;
                            private final LongRef offset$1;
                            private final ByteBufferMessageSet messageSet$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)"multi fetched ").append(BoxesRunTime.boxToInteger(this.messageSet$1.sizeInBytes())).append((Object)" bytes from offset ").append(BoxesRunTime.boxToLong(this.offset$1.elem)).toString();
                            }
                            {
                                this.offset$1 = offset$1;
                                this.messageSet$1 = messageSet$1;
                            }
                        }));
                        messageSet.withFilter(new Serializable(this, numMessagesConsumed){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anon.1 $outer;
                            private final IntRef numMessagesConsumed$1;

                            public final boolean apply(MessageAndOffset messageAndOffset) {
                                return this.numMessagesConsumed$1.elem < this.$outer.maxMessages$1;
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.numMessagesConsumed$1 = numMessagesConsumed$1;
                            }
                        }).foreach(new Serializable(this, offset, numMessagesConsumed){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anon.1 $outer;
                            private final LongRef offset$1;
                            private final IntRef numMessagesConsumed$1;

                            public final void apply(MessageAndOffset messageAndOffset) {
                                Throwable throwable2;
                                block4: {
                                    try {
                                        Message message;
                                        this.offset$1.elem = messageAndOffset.nextOffset();
                                        if (this.$outer.printOffsets$1) {
                                            System.out.println(new StringBuilder().append((Object)"next offset = ").append(BoxesRunTime.boxToLong(this.offset$1.elem)).toString());
                                        }
                                        byte[] key = (message = messageAndOffset.message()).hasKey() ? Utils$.MODULE$.readBytes(message.key()) : null;
                                        this.$outer.formatter$1.writeTo(key, message.isNull() ? null : Utils$.MODULE$.readBytes(message.payload()), System.out);
                                        ++this.numMessagesConsumed$1.elem;
                                    }
                                    catch (Throwable throwable2) {
                                        if (!this.$outer.skipMessageOnError$1) break block4;
                                        SimpleConsumerShell$.MODULE$.error((Function0<String>)((Object)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final String apply() {
                                                return "Error processing message, skipping this message: ";
                                            }
                                        }), (Function0<Throwable>)((Object)new Serializable(this, throwable2){
                                            public static final long serialVersionUID = 0L;
                                            private final Throwable e$1;

                                            public final Throwable apply() {
                                                return this.e$1;
                                            }
                                            {
                                                this.e$1 = e$1;
                                            }
                                        }));
                                    }
                                    if (System.out.checkError()) {
                                        System.err.println("Unable to write to standard out, closing consumer.");
                                        this.$outer.formatter$1.close();
                                        this.$outer.simpleConsumer$1.close();
                                        System.exit(1);
                                    }
                                    return;
                                }
                                throw throwable2;
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.offset$1 = offset$1;
                                this.numMessagesConsumed$1 = numMessagesConsumed$1;
                            }
                        });
                        continue;
                    }
                    break;
                }
                SimpleConsumerShell$.MODULE$.info((Function0<String>)((Object)new /* invalid duplicate definition of identical inner class */));
            }
            {
                this.topic$1 = topic$1;
                this.partitionId$1 = partitionId$1;
                this.replicaId$1 = replicaId$1;
                this.startingOffset$1 = startingOffset$1;
                this.fetchSize$1 = fetchSize$1;
                this.maxMessages$1 = maxMessages$1;
                this.skipMessageOnError$1 = skipMessageOnError$1;
                this.printOffsets$1 = printOffsets$1;
                this.noWaitAtEndOfLog$1 = noWaitAtEndOfLog$1;
                this.fetchRequestBuilder$1 = fetchRequestBuilder$1;
                this.formatter$1 = formatter$1;
                this.simpleConsumer$1 = simpleConsumer$1;
            }
        }, false);
        thread.start();
        thread.join();
        System.out.flush();
        formatter.close();
        simpleConsumer.close();
    }

    private SimpleConsumerShell$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

