/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.bind;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.DatatypeConverterInterface;
import javax.xml.bind.WhiteSpaceProcessor;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;

final class DatatypeConverterImpl
implements DatatypeConverterInterface {
    public static final DatatypeConverterInterface theInstance = new DatatypeConverterImpl();
    private static final char[] hexCode = "0123456789ABCDEF".toCharArray();
    private static final byte[] decodeMap = DatatypeConverterImpl.initDecodeMap();
    private static final byte PADDING = 127;
    private static final char[] encodeMap = DatatypeConverterImpl.initEncodeMap();
    private static final DatatypeFactory datatypeFactory;

    protected DatatypeConverterImpl() {
    }

    public String parseString(String lexicalXSDString) {
        return lexicalXSDString;
    }

    public BigInteger parseInteger(String lexicalXSDInteger) {
        return DatatypeConverterImpl._parseInteger(lexicalXSDInteger);
    }

    public static BigInteger _parseInteger(CharSequence s2) {
        return new BigInteger(((Object)DatatypeConverterImpl.removeOptionalPlus(WhiteSpaceProcessor.trim(s2))).toString());
    }

    public String printInteger(BigInteger val) {
        return DatatypeConverterImpl._printInteger(val);
    }

    public static String _printInteger(BigInteger val) {
        return val.toString();
    }

    public int parseInt(String s2) {
        return DatatypeConverterImpl._parseInt(s2);
    }

    public static int _parseInt(CharSequence s2) {
        int len = s2.length();
        int sign2 = 1;
        int r = 0;
        for (int i = 0; i < len; ++i) {
            char ch = s2.charAt(i);
            if (WhiteSpaceProcessor.isWhiteSpace(ch)) continue;
            if ('0' <= ch && ch <= '9') {
                r = r * 10 + (ch - 48);
                continue;
            }
            if (ch == '-') {
                sign2 = -1;
                continue;
            }
            if (ch == '+') continue;
            throw new NumberFormatException("Not a number: " + s2);
        }
        return r * sign2;
    }

    public long parseLong(String lexicalXSLong) {
        return DatatypeConverterImpl._parseLong(lexicalXSLong);
    }

    public static long _parseLong(CharSequence s2) {
        return Long.valueOf(((Object)DatatypeConverterImpl.removeOptionalPlus(WhiteSpaceProcessor.trim(s2))).toString());
    }

    public short parseShort(String lexicalXSDShort) {
        return DatatypeConverterImpl._parseShort(lexicalXSDShort);
    }

    public static short _parseShort(CharSequence s2) {
        return (short)DatatypeConverterImpl._parseInt(s2);
    }

    public String printShort(short val) {
        return DatatypeConverterImpl._printShort(val);
    }

    public static String _printShort(short val) {
        return String.valueOf(val);
    }

    public BigDecimal parseDecimal(String content) {
        return DatatypeConverterImpl._parseDecimal(content);
    }

    public static BigDecimal _parseDecimal(CharSequence content) {
        if ((content = WhiteSpaceProcessor.trim(content)).length() <= 0) {
            return null;
        }
        return new BigDecimal(((Object)content).toString());
    }

    public float parseFloat(String lexicalXSDFloat) {
        return DatatypeConverterImpl._parseFloat(lexicalXSDFloat);
    }

    public static float _parseFloat(CharSequence _val) {
        String s2 = ((Object)WhiteSpaceProcessor.trim(_val)).toString();
        if (s2.equals("NaN")) {
            return Float.NaN;
        }
        if (s2.equals("INF")) {
            return Float.POSITIVE_INFINITY;
        }
        if (s2.equals("-INF")) {
            return Float.NEGATIVE_INFINITY;
        }
        if (s2.length() == 0 || !DatatypeConverterImpl.isDigitOrPeriodOrSign(s2.charAt(0)) || !DatatypeConverterImpl.isDigitOrPeriodOrSign(s2.charAt(s2.length() - 1))) {
            throw new NumberFormatException();
        }
        return Float.parseFloat(s2);
    }

    public String printFloat(float v) {
        return DatatypeConverterImpl._printFloat(v);
    }

    public static String _printFloat(float v) {
        if (Float.isNaN(v)) {
            return "NaN";
        }
        if (v == Float.POSITIVE_INFINITY) {
            return "INF";
        }
        if (v == Float.NEGATIVE_INFINITY) {
            return "-INF";
        }
        return String.valueOf(v);
    }

    public double parseDouble(String lexicalXSDDouble) {
        return DatatypeConverterImpl._parseDouble(lexicalXSDDouble);
    }

    public static double _parseDouble(CharSequence _val) {
        String val = ((Object)WhiteSpaceProcessor.trim(_val)).toString();
        if (val.equals("NaN")) {
            return Double.NaN;
        }
        if (val.equals("INF")) {
            return Double.POSITIVE_INFINITY;
        }
        if (val.equals("-INF")) {
            return Double.NEGATIVE_INFINITY;
        }
        if (val.length() == 0 || !DatatypeConverterImpl.isDigitOrPeriodOrSign(val.charAt(0)) || !DatatypeConverterImpl.isDigitOrPeriodOrSign(val.charAt(val.length() - 1))) {
            throw new NumberFormatException(val);
        }
        return Double.parseDouble(val);
    }

    public boolean parseBoolean(String lexicalXSDBoolean) {
        if (lexicalXSDBoolean.length() <= 0) {
            throw new IllegalArgumentException("Input is empty");
        }
        return DatatypeConverterImpl._parseBoolean(lexicalXSDBoolean);
    }

    public static Boolean _parseBoolean(CharSequence literal) {
        char ch;
        int i = 0;
        int len = literal.length();
        boolean value2 = false;
        if (literal.length() <= 0) {
            return null;
        }
        while (WhiteSpaceProcessor.isWhiteSpace(ch = literal.charAt(i++)) && i < len) {
        }
        int strIndex = 0;
        switch (ch) {
            case '1': {
                value2 = true;
                break;
            }
            case '0': {
                value2 = false;
                break;
            }
            case 't': {
                String strTrue = "rue";
                do {
                    ch = literal.charAt(i++);
                } while (strTrue.charAt(strIndex++) == ch && i < len && strIndex < 3);
                if (strIndex == 3) {
                    value2 = true;
                    break;
                }
                throw new IllegalArgumentException("String \"" + literal + "\" is not valid boolean value.");
            }
            case 'f': {
                String strFalse = "alse";
                do {
                    ch = literal.charAt(i++);
                } while (strFalse.charAt(strIndex++) == ch && i < len && strIndex < 4);
                if (strIndex == 4) {
                    value2 = false;
                    break;
                }
                throw new IllegalArgumentException("String \"" + literal + "\" is not valid boolean value.");
            }
        }
        if (i < len) {
            while (WhiteSpaceProcessor.isWhiteSpace(ch = literal.charAt(i++)) && i < len) {
            }
        }
        if (i == len) {
            return value2;
        }
        throw new IllegalArgumentException("String \"" + literal + "\" is not valid boolean value.");
    }

    public String printBoolean(boolean val) {
        return val ? "true" : "false";
    }

    public static String _printBoolean(boolean val) {
        return val ? "true" : "false";
    }

    public byte parseByte(String lexicalXSDByte) {
        return DatatypeConverterImpl._parseByte(lexicalXSDByte);
    }

    public static byte _parseByte(CharSequence literal) {
        return (byte)DatatypeConverterImpl._parseInt(literal);
    }

    public String printByte(byte val) {
        return DatatypeConverterImpl._printByte(val);
    }

    public static String _printByte(byte val) {
        return String.valueOf(val);
    }

    public QName parseQName(String lexicalXSDQName, NamespaceContext nsc) {
        return DatatypeConverterImpl._parseQName(lexicalXSDQName, nsc);
    }

    public static QName _parseQName(CharSequence text2, NamespaceContext nsc) {
        String prefix;
        String localPart;
        String uri;
        int idx;
        int end;
        int start;
        int length = text2.length();
        for (start = 0; start < length && WhiteSpaceProcessor.isWhiteSpace(text2.charAt(start)); ++start) {
        }
        for (end = length; end > start && WhiteSpaceProcessor.isWhiteSpace(text2.charAt(end - 1)); --end) {
        }
        if (end == start) {
            throw new IllegalArgumentException("input is empty");
        }
        for (idx = start + 1; idx < end && text2.charAt(idx) != ':'; ++idx) {
        }
        if (idx == end) {
            uri = nsc.getNamespaceURI("");
            localPart = ((Object)text2.subSequence(start, end)).toString();
            prefix = "";
        } else {
            prefix = ((Object)text2.subSequence(start, idx)).toString();
            localPart = ((Object)text2.subSequence(idx + 1, end)).toString();
            uri = nsc.getNamespaceURI(prefix);
            if (uri == null || uri.length() == 0) {
                throw new IllegalArgumentException("prefix " + prefix + " is not bound to a namespace");
            }
        }
        return new QName(uri, localPart, prefix);
    }

    public Calendar parseDateTime(String lexicalXSDDateTime) {
        return DatatypeConverterImpl._parseDateTime(lexicalXSDDateTime);
    }

    public static GregorianCalendar _parseDateTime(CharSequence s2) {
        String val = ((Object)WhiteSpaceProcessor.trim(s2)).toString();
        return datatypeFactory.newXMLGregorianCalendar(val).toGregorianCalendar();
    }

    public String printDateTime(Calendar val) {
        return DatatypeConverterImpl._printDateTime(val);
    }

    public static String _printDateTime(Calendar val) {
        return CalendarFormatter.doFormat("%Y-%M-%DT%h:%m:%s%z", val);
    }

    public byte[] parseBase64Binary(String lexicalXSDBase64Binary) {
        return DatatypeConverterImpl._parseBase64Binary(lexicalXSDBase64Binary);
    }

    public byte[] parseHexBinary(String s2) {
        int len = s2.length();
        if (len % 2 != 0) {
            throw new IllegalArgumentException("hexBinary needs to be even-length: " + s2);
        }
        byte[] out = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            int h = DatatypeConverterImpl.hexToBin(s2.charAt(i));
            int l = DatatypeConverterImpl.hexToBin(s2.charAt(i + 1));
            if (h == -1 || l == -1) {
                throw new IllegalArgumentException("contains illegal character for hexBinary: " + s2);
            }
            out[i / 2] = (byte)(h * 16 + l);
        }
        return out;
    }

    private static int hexToBin(char ch) {
        if ('0' <= ch && ch <= '9') {
            return ch - 48;
        }
        if ('A' <= ch && ch <= 'F') {
            return ch - 65 + 10;
        }
        if ('a' <= ch && ch <= 'f') {
            return ch - 97 + 10;
        }
        return -1;
    }

    public String printHexBinary(byte[] data2) {
        StringBuilder r = new StringBuilder(data2.length * 2);
        for (byte b : data2) {
            r.append(hexCode[b >> 4 & 0xF]);
            r.append(hexCode[b & 0xF]);
        }
        return r.toString();
    }

    public long parseUnsignedInt(String lexicalXSDUnsignedInt) {
        return DatatypeConverterImpl._parseLong(lexicalXSDUnsignedInt);
    }

    public String printUnsignedInt(long val) {
        return DatatypeConverterImpl._printLong(val);
    }

    public int parseUnsignedShort(String lexicalXSDUnsignedShort) {
        return DatatypeConverterImpl._parseInt(lexicalXSDUnsignedShort);
    }

    public Calendar parseTime(String lexicalXSDTime) {
        return datatypeFactory.newXMLGregorianCalendar(lexicalXSDTime).toGregorianCalendar();
    }

    public String printTime(Calendar val) {
        return CalendarFormatter.doFormat("%h:%m:%s%z", val);
    }

    public Calendar parseDate(String lexicalXSDDate) {
        return datatypeFactory.newXMLGregorianCalendar(lexicalXSDDate).toGregorianCalendar();
    }

    public String printDate(Calendar val) {
        return DatatypeConverterImpl._printDate(val);
    }

    public static String _printDate(Calendar val) {
        return CalendarFormatter.doFormat("%Y-%M-%D" + "%z", val);
    }

    public String parseAnySimpleType(String lexicalXSDAnySimpleType) {
        return lexicalXSDAnySimpleType;
    }

    public String printString(String val) {
        return val;
    }

    public String printInt(int val) {
        return DatatypeConverterImpl._printInt(val);
    }

    public static String _printInt(int val) {
        return String.valueOf(val);
    }

    public String printLong(long val) {
        return DatatypeConverterImpl._printLong(val);
    }

    public static String _printLong(long val) {
        return String.valueOf(val);
    }

    public String printDecimal(BigDecimal val) {
        return DatatypeConverterImpl._printDecimal(val);
    }

    public static String _printDecimal(BigDecimal val) {
        return val.toPlainString();
    }

    public String printDouble(double v) {
        return DatatypeConverterImpl._printDouble(v);
    }

    public static String _printDouble(double v) {
        if (Double.isNaN(v)) {
            return "NaN";
        }
        if (v == Double.POSITIVE_INFINITY) {
            return "INF";
        }
        if (v == Double.NEGATIVE_INFINITY) {
            return "-INF";
        }
        return String.valueOf(v);
    }

    public String printQName(QName val, NamespaceContext nsc) {
        return DatatypeConverterImpl._printQName(val, nsc);
    }

    public static String _printQName(QName val, NamespaceContext nsc) {
        String prefix = nsc.getPrefix(val.getNamespaceURI());
        String localPart = val.getLocalPart();
        String qname = prefix == null || prefix.length() == 0 ? localPart : prefix + ':' + localPart;
        return qname;
    }

    public String printBase64Binary(byte[] val) {
        return DatatypeConverterImpl._printBase64Binary(val);
    }

    public String printUnsignedShort(int val) {
        return String.valueOf(val);
    }

    public String printAnySimpleType(String val) {
        return val;
    }

    public static String installHook(String s2) {
        DatatypeConverter.setDatatypeConverter(theInstance);
        return s2;
    }

    private static byte[] initDecodeMap() {
        int i;
        byte[] map2 = new byte[128];
        for (i = 0; i < 128; ++i) {
            map2[i] = -1;
        }
        for (i = 65; i <= 90; ++i) {
            map2[i] = (byte)(i - 65);
        }
        for (i = 97; i <= 122; ++i) {
            map2[i] = (byte)(i - 97 + 26);
        }
        for (i = 48; i <= 57; ++i) {
            map2[i] = (byte)(i - 48 + 52);
        }
        map2[43] = 62;
        map2[47] = 63;
        map2[61] = 127;
        return map2;
    }

    private static int guessLength(String text2) {
        int padSize;
        int j;
        int len = text2.length();
        for (j = len - 1; j >= 0; --j) {
            byte code = decodeMap[text2.charAt(j)];
            if (code == 127) continue;
            if (code != -1) break;
            return text2.length() / 4 * 3;
        }
        if ((padSize = len - ++j) > 2) {
            return text2.length() / 4 * 3;
        }
        return text2.length() / 4 * 3 - padSize;
    }

    public static byte[] _parseBase64Binary(String text2) {
        int buflen = DatatypeConverterImpl.guessLength(text2);
        byte[] out = new byte[buflen];
        int o = 0;
        int len = text2.length();
        byte[] quadruplet = new byte[4];
        int q = 0;
        for (int i = 0; i < len; ++i) {
            char ch = text2.charAt(i);
            byte v = decodeMap[ch];
            if (v != -1) {
                quadruplet[q++] = v;
            }
            if (q != 4) continue;
            out[o++] = (byte)(quadruplet[0] << 2 | quadruplet[1] >> 4);
            if (quadruplet[2] != 127) {
                out[o++] = (byte)(quadruplet[1] << 4 | quadruplet[2] >> 2);
            }
            if (quadruplet[3] != 127) {
                out[o++] = (byte)(quadruplet[2] << 6 | quadruplet[3]);
            }
            q = 0;
        }
        if (buflen == o) {
            return out;
        }
        byte[] nb = new byte[o];
        System.arraycopy(out, 0, nb, 0, o);
        return nb;
    }

    private static char[] initEncodeMap() {
        int i;
        char[] map2 = new char[64];
        for (i = 0; i < 26; ++i) {
            map2[i] = (char)(65 + i);
        }
        for (i = 26; i < 52; ++i) {
            map2[i] = (char)(97 + (i - 26));
        }
        for (i = 52; i < 62; ++i) {
            map2[i] = (char)(48 + (i - 52));
        }
        map2[62] = 43;
        map2[63] = 47;
        return map2;
    }

    public static char encode(int i) {
        return encodeMap[i & 0x3F];
    }

    public static byte encodeByte(int i) {
        return (byte)encodeMap[i & 0x3F];
    }

    public static String _printBase64Binary(byte[] input2) {
        return DatatypeConverterImpl._printBase64Binary(input2, 0, input2.length);
    }

    public static String _printBase64Binary(byte[] input2, int offset, int len) {
        char[] buf = new char[(len + 2) / 3 * 4];
        int ptr = DatatypeConverterImpl._printBase64Binary(input2, offset, len, buf, 0);
        assert (ptr == buf.length);
        return new String(buf);
    }

    public static int _printBase64Binary(byte[] input2, int offset, int len, char[] buf, int ptr) {
        block4: for (int i = offset; i < len; i += 3) {
            switch (len - i) {
                case 1: {
                    buf[ptr++] = DatatypeConverterImpl.encode(input2[i] >> 2);
                    buf[ptr++] = DatatypeConverterImpl.encode((input2[i] & 3) << 4);
                    buf[ptr++] = 61;
                    buf[ptr++] = 61;
                    continue block4;
                }
                case 2: {
                    buf[ptr++] = DatatypeConverterImpl.encode(input2[i] >> 2);
                    buf[ptr++] = DatatypeConverterImpl.encode((input2[i] & 3) << 4 | input2[i + 1] >> 4 & 0xF);
                    buf[ptr++] = DatatypeConverterImpl.encode((input2[i + 1] & 0xF) << 2);
                    buf[ptr++] = 61;
                    continue block4;
                }
                default: {
                    buf[ptr++] = DatatypeConverterImpl.encode(input2[i] >> 2);
                    buf[ptr++] = DatatypeConverterImpl.encode((input2[i] & 3) << 4 | input2[i + 1] >> 4 & 0xF);
                    buf[ptr++] = DatatypeConverterImpl.encode((input2[i + 1] & 0xF) << 2 | input2[i + 2] >> 6 & 3);
                    buf[ptr++] = DatatypeConverterImpl.encode(input2[i + 2] & 0x3F);
                }
            }
        }
        return ptr;
    }

    public static int _printBase64Binary(byte[] input2, int offset, int len, byte[] out, int ptr) {
        byte[] buf = out;
        int max2 = len + offset;
        block4: for (int i = offset; i < max2; i += 3) {
            switch (max2 - i) {
                case 1: {
                    buf[ptr++] = DatatypeConverterImpl.encodeByte(input2[i] >> 2);
                    buf[ptr++] = DatatypeConverterImpl.encodeByte((input2[i] & 3) << 4);
                    buf[ptr++] = 61;
                    buf[ptr++] = 61;
                    continue block4;
                }
                case 2: {
                    buf[ptr++] = DatatypeConverterImpl.encodeByte(input2[i] >> 2);
                    buf[ptr++] = DatatypeConverterImpl.encodeByte((input2[i] & 3) << 4 | input2[i + 1] >> 4 & 0xF);
                    buf[ptr++] = DatatypeConverterImpl.encodeByte((input2[i + 1] & 0xF) << 2);
                    buf[ptr++] = 61;
                    continue block4;
                }
                default: {
                    buf[ptr++] = DatatypeConverterImpl.encodeByte(input2[i] >> 2);
                    buf[ptr++] = DatatypeConverterImpl.encodeByte((input2[i] & 3) << 4 | input2[i + 1] >> 4 & 0xF);
                    buf[ptr++] = DatatypeConverterImpl.encodeByte((input2[i + 1] & 0xF) << 2 | input2[i + 2] >> 6 & 3);
                    buf[ptr++] = DatatypeConverterImpl.encodeByte(input2[i + 2] & 0x3F);
                }
            }
        }
        return ptr;
    }

    private static CharSequence removeOptionalPlus(CharSequence s2) {
        int len = s2.length();
        if (len <= 1 || s2.charAt(0) != '+') {
            return s2;
        }
        char ch = (s2 = s2.subSequence(1, len)).charAt(0);
        if ('0' <= ch && ch <= '9') {
            return s2;
        }
        if ('.' == ch) {
            return s2;
        }
        throw new NumberFormatException();
    }

    private static boolean isDigitOrPeriodOrSign(char ch) {
        if ('0' <= ch && ch <= '9') {
            return true;
        }
        return ch == '+' || ch == '-' || ch == '.';
    }

    static {
        try {
            datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new Error(e);
        }
    }

    private static final class CalendarFormatter {
        private CalendarFormatter() {
        }

        public static String doFormat(String format2, Calendar cal) throws IllegalArgumentException {
            int fidx = 0;
            int flen = format2.length();
            StringBuilder buf = new StringBuilder();
            block9: while (fidx < flen) {
                char fch;
                if ((fch = format2.charAt(fidx++)) != '%') {
                    buf.append(fch);
                    continue;
                }
                switch (format2.charAt(fidx++)) {
                    case 'Y': {
                        CalendarFormatter.formatYear(cal, buf);
                        continue block9;
                    }
                    case 'M': {
                        CalendarFormatter.formatMonth(cal, buf);
                        continue block9;
                    }
                    case 'D': {
                        CalendarFormatter.formatDays(cal, buf);
                        continue block9;
                    }
                    case 'h': {
                        CalendarFormatter.formatHours(cal, buf);
                        continue block9;
                    }
                    case 'm': {
                        CalendarFormatter.formatMinutes(cal, buf);
                        continue block9;
                    }
                    case 's': {
                        CalendarFormatter.formatSeconds(cal, buf);
                        continue block9;
                    }
                    case 'z': {
                        CalendarFormatter.formatTimeZone(cal, buf);
                        continue block9;
                    }
                }
                throw new InternalError();
            }
            return buf.toString();
        }

        private static void formatYear(Calendar cal, StringBuilder buf) {
            int year = cal.get(1);
            String s2 = year <= 0 ? Integer.toString(1 - year) : Integer.toString(year);
            while (s2.length() < 4) {
                s2 = '0' + s2;
            }
            if (year <= 0) {
                s2 = '-' + s2;
            }
            buf.append(s2);
        }

        private static void formatMonth(Calendar cal, StringBuilder buf) {
            CalendarFormatter.formatTwoDigits(cal.get(2) + 1, buf);
        }

        private static void formatDays(Calendar cal, StringBuilder buf) {
            CalendarFormatter.formatTwoDigits(cal.get(5), buf);
        }

        private static void formatHours(Calendar cal, StringBuilder buf) {
            CalendarFormatter.formatTwoDigits(cal.get(11), buf);
        }

        private static void formatMinutes(Calendar cal, StringBuilder buf) {
            CalendarFormatter.formatTwoDigits(cal.get(12), buf);
        }

        private static void formatSeconds(Calendar cal, StringBuilder buf) {
            int n;
            CalendarFormatter.formatTwoDigits(cal.get(13), buf);
            if (cal.isSet(14) && (n = cal.get(14)) != 0) {
                String ms = Integer.toString(n);
                while (ms.length() < 3) {
                    ms = '0' + ms;
                }
                buf.append('.');
                buf.append(ms);
            }
        }

        private static void formatTimeZone(Calendar cal, StringBuilder buf) {
            TimeZone tz = cal.getTimeZone();
            if (tz == null) {
                return;
            }
            int offset = tz.getOffset(cal.getTime().getTime());
            if (offset == 0) {
                buf.append('Z');
                return;
            }
            if (offset >= 0) {
                buf.append('+');
            } else {
                buf.append('-');
                offset *= -1;
            }
            CalendarFormatter.formatTwoDigits((offset /= 60000) / 60, buf);
            buf.append(':');
            CalendarFormatter.formatTwoDigits(offset % 60, buf);
        }

        private static void formatTwoDigits(int n, StringBuilder buf) {
            if (n < 10) {
                buf.append('0');
            }
            buf.append(n);
        }
    }
}

