/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.runtime.reflect.opt;

import com.sun.xml.bind.Util;
import com.sun.xml.bind.v2.bytecode.ClassTailor;
import com.sun.xml.bind.v2.runtime.RuntimeUtil;
import com.sun.xml.bind.v2.runtime.reflect.Accessor;
import com.sun.xml.bind.v2.runtime.reflect.opt.AccessorInjector;
import com.sun.xml.bind.v2.runtime.reflect.opt.Bean;
import com.sun.xml.bind.v2.runtime.reflect.opt.FieldAccessor_Byte;
import com.sun.xml.bind.v2.runtime.reflect.opt.MethodAccessor_Byte;
import com.sun.xml.bind.v2.runtime.reflect.opt.Ref;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OptimizedAccessorFactory {
    private static final Logger logger = Util.getClassLogger();
    private static final String fieldTemplateName;
    private static final String methodTemplateName;

    private OptimizedAccessorFactory() {
    }

    public static final <B, V> Accessor<B, V> get(Method getter2, Method setter2) {
        if (getter2.getParameterTypes().length != 0) {
            return null;
        }
        Class<?>[] sparams = setter2.getParameterTypes();
        if (sparams.length != 1) {
            return null;
        }
        if (sparams[0] != getter2.getReturnType()) {
            return null;
        }
        if (setter2.getReturnType() != Void.TYPE) {
            return null;
        }
        if (getter2.getDeclaringClass() != setter2.getDeclaringClass()) {
            return null;
        }
        if (Modifier.isPrivate(getter2.getModifiers()) || Modifier.isPrivate(setter2.getModifiers())) {
            return null;
        }
        Class<?> t = sparams[0];
        String typeName = t.getName().replace('.', '_');
        if (t.isArray()) {
            typeName = "AOf_";
            String compName = t.getComponentType().getName().replace('.', '_');
            while (compName.startsWith("[L")) {
                compName = compName.substring(2);
                typeName = typeName + "AOf_";
            }
            typeName = typeName + compName;
        }
        String newClassName = ClassTailor.toVMClassName(getter2.getDeclaringClass()) + "$JaxbAccessorM_" + getter2.getName() + '_' + setter2.getName() + '_' + typeName;
        Class<?> opt2 = t.isPrimitive() ? AccessorInjector.prepare(getter2.getDeclaringClass(), methodTemplateName + RuntimeUtil.primitiveToBox.get(t).getSimpleName(), newClassName, ClassTailor.toVMClassName(Bean.class), ClassTailor.toVMClassName(getter2.getDeclaringClass()), "get_" + t.getName(), getter2.getName(), "set_" + t.getName(), setter2.getName()) : AccessorInjector.prepare(getter2.getDeclaringClass(), methodTemplateName + "Ref", newClassName, ClassTailor.toVMClassName(Bean.class), ClassTailor.toVMClassName(getter2.getDeclaringClass()), ClassTailor.toVMClassName(Ref.class), ClassTailor.toVMClassName(t), "()" + ClassTailor.toVMTypeName(Ref.class), "()" + ClassTailor.toVMTypeName(t), '(' + ClassTailor.toVMTypeName(Ref.class) + ")V", '(' + ClassTailor.toVMTypeName(t) + ")V", "get_ref", getter2.getName(), "set_ref", setter2.getName());
        if (opt2 == null) {
            return null;
        }
        Accessor<B, V> acc = OptimizedAccessorFactory.instanciate(opt2);
        if (acc != null) {
            logger.log(Level.FINE, "Using optimized Accessor for " + getter2 + " and " + setter2);
        }
        return acc;
    }

    public static final <B, V> Accessor<B, V> get(Field field2) {
        int mods = field2.getModifiers();
        if (Modifier.isPrivate(mods) || Modifier.isFinal(mods)) {
            return null;
        }
        String newClassName = ClassTailor.toVMClassName(field2.getDeclaringClass()) + "$JaxbAccessorF_" + field2.getName();
        Class<?> opt2 = field2.getType().isPrimitive() ? AccessorInjector.prepare(field2.getDeclaringClass(), fieldTemplateName + RuntimeUtil.primitiveToBox.get(field2.getType()).getSimpleName(), newClassName, ClassTailor.toVMClassName(Bean.class), ClassTailor.toVMClassName(field2.getDeclaringClass()), "f_" + field2.getType().getName(), field2.getName()) : AccessorInjector.prepare(field2.getDeclaringClass(), fieldTemplateName + "Ref", newClassName, ClassTailor.toVMClassName(Bean.class), ClassTailor.toVMClassName(field2.getDeclaringClass()), ClassTailor.toVMClassName(Ref.class), ClassTailor.toVMClassName(field2.getType()), ClassTailor.toVMTypeName(Ref.class), ClassTailor.toVMTypeName(field2.getType()), "f_ref", field2.getName());
        if (opt2 == null) {
            return null;
        }
        Accessor<B, V> acc = OptimizedAccessorFactory.instanciate(opt2);
        if (acc != null) {
            logger.log(Level.FINE, "Using optimized Accessor for " + field2);
        }
        return acc;
    }

    private static <B, V> Accessor<B, V> instanciate(Class opt2) {
        try {
            return (Accessor)opt2.newInstance();
        }
        catch (InstantiationException e) {
            logger.log(Level.INFO, "failed to load an optimized Accessor", e);
        }
        catch (IllegalAccessException e) {
            logger.log(Level.INFO, "failed to load an optimized Accessor", e);
        }
        catch (SecurityException e) {
            logger.log(Level.INFO, "failed to load an optimized Accessor", e);
        }
        return null;
    }

    static {
        String s2 = FieldAccessor_Byte.class.getName();
        fieldTemplateName = s2.substring(0, s2.length() - "Byte".length()).replace('.', '/');
        s2 = MethodAccessor_Byte.class.getName();
        methodTemplateName = s2.substring(0, s2.length() - "Byte".length()).replace('.', '/');
    }
}

