/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.logaggregation;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.sparkproject.guava.annotations.VisibleForTesting;

@InterfaceAudience.Private
public class LogAggregationUtils {
    public static final String TMP_FILE_SUFFIX = ".tmp";

    public static Path getRemoteNodeLogFileForApp(Path remoteRootLogDir, ApplicationId appId, String user, NodeId nodeId, String suffix) {
        return new Path(LogAggregationUtils.getRemoteAppLogDir(remoteRootLogDir, appId, user, suffix), LogAggregationUtils.getNodeString(nodeId));
    }

    public static Path getRemoteAppLogDir(Path remoteRootLogDir, ApplicationId appId, String user, String suffix) {
        return new Path(LogAggregationUtils.getRemoteLogSuffixedDir(remoteRootLogDir, user, suffix), appId.toString());
    }

    public static Path getRemoteLogSuffixedDir(Path remoteRootLogDir, String user, String suffix) {
        if (suffix == null || suffix.isEmpty()) {
            return LogAggregationUtils.getRemoteLogUserDir(remoteRootLogDir, user);
        }
        return new Path(LogAggregationUtils.getRemoteLogUserDir(remoteRootLogDir, user), suffix);
    }

    public static Path getRemoteLogUserDir(Path remoteRootLogDir, String user) {
        return new Path(remoteRootLogDir, user);
    }

    public static String getRemoteNodeLogDirSuffix(Configuration conf) {
        return conf.get("yarn.nodemanager.remote-app-log-dir-suffix", "logs");
    }

    @VisibleForTesting
    public static String getNodeString(NodeId nodeId) {
        return nodeId.toString().replace(":", "_");
    }

    @VisibleForTesting
    public static String getNodeString(String nodeId) {
        return nodeId.toString().replace(":", "_");
    }
}

