/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.cli;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptReport;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationResourceUsageReport;
import org.apache.hadoop.yarn.api.records.ContainerReport;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.cli.YarnCLI;
import org.apache.hadoop.yarn.exceptions.ApplicationAttemptNotFoundException;
import org.apache.hadoop.yarn.exceptions.ApplicationNotFoundException;
import org.apache.hadoop.yarn.exceptions.ContainerNotFoundException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.Times;
import org.sparkproject.guava.annotations.VisibleForTesting;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ApplicationCLI
extends YarnCLI {
    private static final String APPLICATIONS_PATTERN = "%30s\t%20s\t%20s\t%10s\t%10s\t%18s\t%18s\t%15s\t%35s" + System.getProperty("line.separator");
    private static final String APPLICATION_ATTEMPTS_PATTERN = "%30s\t%20s\t%35s\t%35s" + System.getProperty("line.separator");
    private static final String APP_TYPE_CMD = "appTypes";
    private static final String APP_STATE_CMD = "appStates";
    private static final String ALLSTATES_OPTION = "ALL";
    private static final String QUEUE_CMD = "queue";
    @VisibleForTesting
    protected static final String CONTAINER_PATTERN = "%30s\t%20s\t%20s\t%20s\t%20s\t%20s\t%35s" + System.getProperty("line.separator");
    public static final String APPLICATION = "application";
    public static final String APPLICATION_ATTEMPT = "applicationattempt";
    public static final String CONTAINER = "container";
    private boolean allAppStates;

    public static void main(String[] args) throws Exception {
        ApplicationCLI cli = new ApplicationCLI();
        cli.setSysOutPrintStream(System.out);
        cli.setSysErrPrintStream(System.err);
        int res = ToolRunner.run((Tool)cli, (String[])args);
        cli.stop();
        System.exit(res);
    }

    public int run(String[] args) throws Exception {
        Options opts = new Options();
        String title = null;
        if (args.length > 0 && args[0].equalsIgnoreCase(APPLICATION)) {
            title = APPLICATION;
            opts.addOption("status", true, "Prints the status of the application.");
            opts.addOption("list", false, "List applications. Supports optional use of -appTypes to filter applications based on application type, and -appStates to filter applications based on application state.");
            opts.addOption("kill", true, "Kills the application.");
            opts.addOption("movetoqueue", true, "Moves the application to a different queue.");
            opts.addOption(QUEUE_CMD, true, "Works with the movetoqueue command to specify which queue to move an application to.");
            opts.addOption("help", false, "Displays help for all commands.");
            Option appTypeOpt = new Option(APP_TYPE_CMD, true, "Works with -list to filter applications based on input comma-separated list of application types.");
            appTypeOpt.setValueSeparator(',');
            appTypeOpt.setArgs(-2);
            appTypeOpt.setArgName("Types");
            opts.addOption(appTypeOpt);
            Option appStateOpt = new Option(APP_STATE_CMD, true, "Works with -list to filter applications based on input comma-separated list of application states. " + this.getAllValidApplicationStates());
            appStateOpt.setValueSeparator(',');
            appStateOpt.setArgs(-2);
            appStateOpt.setArgName("States");
            opts.addOption(appStateOpt);
            opts.getOption("kill").setArgName("Application ID");
            opts.getOption("movetoqueue").setArgName("Application ID");
            opts.getOption(QUEUE_CMD).setArgName("Queue Name");
            opts.getOption("status").setArgName("Application ID");
        } else if (args.length > 0 && args[0].equalsIgnoreCase(APPLICATION_ATTEMPT)) {
            title = APPLICATION_ATTEMPT;
            opts.addOption("status", true, "Prints the status of the application attempt.");
            opts.addOption("list", true, "List application attempts for aplication.");
            opts.addOption("help", false, "Displays help for all commands.");
            opts.getOption("status").setArgName("Application Attempt ID");
            opts.getOption("list").setArgName("Application ID");
        } else if (args.length > 0 && args[0].equalsIgnoreCase(CONTAINER)) {
            title = CONTAINER;
            opts.addOption("status", true, "Prints the status of the container.");
            opts.addOption("list", true, "List containers for application attempt.");
            opts.addOption("help", false, "Displays help for all commands.");
            opts.getOption("status").setArgName("Container ID");
            opts.getOption("list").setArgName("Application Attempt ID");
        }
        int exitCode = -1;
        CommandLine cliParser = null;
        try {
            cliParser = new GnuParser().parse(opts, args);
        }
        catch (MissingArgumentException ex) {
            this.sysout.println("Missing argument for options");
            this.printUsage(title, opts);
            return exitCode;
        }
        if (cliParser.hasOption("status")) {
            if (args.length != 3) {
                this.printUsage(title, opts);
                return exitCode;
            }
            if (args[0].equalsIgnoreCase(APPLICATION)) {
                exitCode = this.printApplicationReport(cliParser.getOptionValue("status"));
            } else if (args[0].equalsIgnoreCase(APPLICATION_ATTEMPT)) {
                exitCode = this.printApplicationAttemptReport(cliParser.getOptionValue("status"));
            } else if (args[0].equalsIgnoreCase(CONTAINER)) {
                exitCode = this.printContainerReport(cliParser.getOptionValue("status"));
            }
            return exitCode;
        }
        if (cliParser.hasOption("list")) {
            if (args[0].equalsIgnoreCase(APPLICATION)) {
                String[] states;
                String[] types;
                this.allAppStates = false;
                HashSet<String> appTypes = new HashSet<String>();
                if (cliParser.hasOption(APP_TYPE_CMD) && (types = cliParser.getOptionValues(APP_TYPE_CMD)) != null) {
                    for (String type : types) {
                        if (type.trim().isEmpty()) continue;
                        appTypes.add(StringUtils.toUpperCase((String)type).trim());
                    }
                }
                EnumSet<YarnApplicationState> appStates = EnumSet.noneOf(YarnApplicationState.class);
                if (cliParser.hasOption(APP_STATE_CMD) && (states = cliParser.getOptionValues(APP_STATE_CMD)) != null) {
                    for (String state : states) {
                        if (state.trim().isEmpty()) continue;
                        if (state.trim().equalsIgnoreCase(ALLSTATES_OPTION)) {
                            this.allAppStates = true;
                            break;
                        }
                        try {
                            appStates.add(YarnApplicationState.valueOf(StringUtils.toUpperCase((String)state).trim()));
                        }
                        catch (IllegalArgumentException ex) {
                            this.sysout.println("The application state " + state + " is invalid.");
                            this.sysout.println(this.getAllValidApplicationStates());
                            return exitCode;
                        }
                    }
                }
                this.listApplications(appTypes, appStates);
            } else if (args[0].equalsIgnoreCase(APPLICATION_ATTEMPT)) {
                if (args.length != 3) {
                    this.printUsage(title, opts);
                    return exitCode;
                }
                this.listApplicationAttempts(cliParser.getOptionValue("list"));
            } else if (args[0].equalsIgnoreCase(CONTAINER)) {
                if (args.length != 3) {
                    this.printUsage(title, opts);
                    return exitCode;
                }
                this.listContainers(cliParser.getOptionValue("list"));
            }
        } else if (cliParser.hasOption("kill")) {
            if (args.length != 3) {
                this.printUsage(title, opts);
                return exitCode;
            }
            try {
                this.killApplication(cliParser.getOptionValue("kill"));
            }
            catch (ApplicationNotFoundException e) {
                return exitCode;
            }
        } else if (cliParser.hasOption("movetoqueue")) {
            if (!cliParser.hasOption(QUEUE_CMD)) {
                this.printUsage(title, opts);
                return exitCode;
            }
            this.moveApplicationAcrossQueues(cliParser.getOptionValue("movetoqueue"), cliParser.getOptionValue(QUEUE_CMD));
        } else {
            if (cliParser.hasOption("help")) {
                this.printUsage(title, opts);
                return 0;
            }
            this.syserr.println("Invalid Command Usage : ");
            this.printUsage(title, opts);
        }
        return 0;
    }

    @VisibleForTesting
    void printUsage(String title, Options opts) {
        new HelpFormatter().printHelp(title, opts);
    }

    private int printApplicationAttemptReport(String applicationAttemptId) throws YarnException, IOException {
        ApplicationAttemptReport appAttemptReport = null;
        try {
            appAttemptReport = this.client.getApplicationAttemptReport(ConverterUtils.toApplicationAttemptId(applicationAttemptId));
        }
        catch (ApplicationNotFoundException e) {
            this.sysout.println("Application for AppAttempt with id '" + applicationAttemptId + "' doesn't exist in RM or Timeline Server.");
            return -1;
        }
        catch (ApplicationAttemptNotFoundException e) {
            this.sysout.println("Application Attempt with id '" + applicationAttemptId + "' doesn't exist in RM or Timeline Server.");
            return -1;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter appAttemptReportStr = new PrintWriter(new OutputStreamWriter((OutputStream)baos, Charset.forName("UTF-8")));
        if (appAttemptReport == null) {
            appAttemptReportStr.print("Application Attempt with id '" + applicationAttemptId + "' doesn't exist in Timeline Server.");
            appAttemptReportStr.close();
            this.sysout.println(baos.toString("UTF-8"));
            return -1;
        }
        appAttemptReportStr.println("Application Attempt Report : ");
        appAttemptReportStr.print("\tApplicationAttempt-Id : ");
        appAttemptReportStr.println(appAttemptReport.getApplicationAttemptId());
        appAttemptReportStr.print("\tState : ");
        appAttemptReportStr.println((Object)appAttemptReport.getYarnApplicationAttemptState());
        appAttemptReportStr.print("\tAMContainer : ");
        appAttemptReportStr.println(appAttemptReport.getAMContainerId().toString());
        appAttemptReportStr.print("\tTracking-URL : ");
        appAttemptReportStr.println(appAttemptReport.getTrackingUrl());
        appAttemptReportStr.print("\tRPC Port : ");
        appAttemptReportStr.println(appAttemptReport.getRpcPort());
        appAttemptReportStr.print("\tAM Host : ");
        appAttemptReportStr.println(appAttemptReport.getHost());
        appAttemptReportStr.print("\tDiagnostics : ");
        appAttemptReportStr.print(appAttemptReport.getDiagnostics());
        appAttemptReportStr.close();
        this.sysout.println(baos.toString("UTF-8"));
        return 0;
    }

    private int printContainerReport(String containerId) throws YarnException, IOException {
        ContainerReport containerReport = null;
        try {
            containerReport = this.client.getContainerReport(ConverterUtils.toContainerId(containerId));
        }
        catch (ApplicationNotFoundException e) {
            this.sysout.println("Application for Container with id '" + containerId + "' doesn't exist in RM or Timeline Server.");
            return -1;
        }
        catch (ApplicationAttemptNotFoundException e) {
            this.sysout.println("Application Attempt for Container with id '" + containerId + "' doesn't exist in RM or Timeline Server.");
            return -1;
        }
        catch (ContainerNotFoundException e) {
            this.sysout.println("Container with id '" + containerId + "' doesn't exist in RM or Timeline Server.");
            return -1;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter containerReportStr = new PrintWriter(new OutputStreamWriter((OutputStream)baos, Charset.forName("UTF-8")));
        if (containerReport == null) {
            containerReportStr.print("Container with id '" + containerId + "' doesn't exist in Timeline Server.");
            containerReportStr.close();
            this.sysout.println(baos.toString("UTF-8"));
            return -1;
        }
        containerReportStr.println("Container Report : ");
        containerReportStr.print("\tContainer-Id : ");
        containerReportStr.println(containerReport.getContainerId());
        containerReportStr.print("\tStart-Time : ");
        containerReportStr.println(containerReport.getCreationTime());
        containerReportStr.print("\tFinish-Time : ");
        containerReportStr.println(containerReport.getFinishTime());
        containerReportStr.print("\tState : ");
        containerReportStr.println((Object)containerReport.getContainerState());
        containerReportStr.print("\tLOG-URL : ");
        containerReportStr.println(containerReport.getLogUrl());
        containerReportStr.print("\tHost : ");
        containerReportStr.println(containerReport.getAssignedNode());
        containerReportStr.print("\tNodeHttpAddress : ");
        containerReportStr.println(containerReport.getNodeHttpAddress() == null ? "N/A" : containerReport.getNodeHttpAddress());
        containerReportStr.print("\tDiagnostics : ");
        containerReportStr.print(containerReport.getDiagnosticsInfo());
        containerReportStr.close();
        this.sysout.println(baos.toString("UTF-8"));
        return 0;
    }

    private void listApplications(Set<String> appTypes, EnumSet<YarnApplicationState> appStates) throws YarnException, IOException {
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.sysout, Charset.forName("UTF-8")));
        if (this.allAppStates) {
            for (YarnApplicationState appState : YarnApplicationState.values()) {
                appStates.add(appState);
            }
        } else if (appStates.isEmpty()) {
            appStates.add(YarnApplicationState.RUNNING);
            appStates.add(YarnApplicationState.ACCEPTED);
            appStates.add(YarnApplicationState.SUBMITTED);
        }
        List<ApplicationReport> appsReport = this.client.getApplications(appTypes, appStates);
        writer.println("Total number of applications (application-types: " + appTypes + " and states: " + appStates + ")" + ":" + appsReport.size());
        writer.printf(APPLICATIONS_PATTERN, "Application-Id", "Application-Name", "Application-Type", "User", "Queue", "State", "Final-State", "Progress", "Tracking-URL");
        for (ApplicationReport appReport : appsReport) {
            DecimalFormat formatter = new DecimalFormat("###.##%");
            String progress = formatter.format(appReport.getProgress());
            writer.printf(APPLICATIONS_PATTERN, new Object[]{appReport.getApplicationId(), appReport.getName(), appReport.getApplicationType(), appReport.getUser(), appReport.getQueue(), appReport.getYarnApplicationState(), appReport.getFinalApplicationStatus(), progress, appReport.getOriginalTrackingUrl()});
        }
        writer.flush();
    }

    private void killApplication(String applicationId) throws YarnException, IOException {
        ApplicationId appId = ConverterUtils.toApplicationId(applicationId);
        ApplicationReport appReport = null;
        try {
            appReport = this.client.getApplicationReport(appId);
        }
        catch (ApplicationNotFoundException e) {
            this.sysout.println("Application with id '" + applicationId + "' doesn't exist in RM.");
            throw e;
        }
        if (appReport.getYarnApplicationState() == YarnApplicationState.FINISHED || appReport.getYarnApplicationState() == YarnApplicationState.KILLED || appReport.getYarnApplicationState() == YarnApplicationState.FAILED) {
            this.sysout.println("Application " + applicationId + " has already finished ");
        } else {
            this.sysout.println("Killing application " + applicationId);
            this.client.killApplication(appId);
        }
    }

    private void moveApplicationAcrossQueues(String applicationId, String queue) throws YarnException, IOException {
        ApplicationId appId = ConverterUtils.toApplicationId(applicationId);
        ApplicationReport appReport = this.client.getApplicationReport(appId);
        if (appReport.getYarnApplicationState() == YarnApplicationState.FINISHED || appReport.getYarnApplicationState() == YarnApplicationState.KILLED || appReport.getYarnApplicationState() == YarnApplicationState.FAILED) {
            this.sysout.println("Application " + applicationId + " has already finished ");
        } else {
            this.sysout.println("Moving application " + applicationId + " to queue " + queue);
            this.client.moveApplicationAcrossQueues(appId, queue);
            this.sysout.println("Successfully completed move.");
        }
    }

    private int printApplicationReport(String applicationId) throws YarnException, IOException {
        ApplicationReport appReport = null;
        try {
            appReport = this.client.getApplicationReport(ConverterUtils.toApplicationId(applicationId));
        }
        catch (ApplicationNotFoundException e) {
            this.sysout.println("Application with id '" + applicationId + "' doesn't exist in RM or Timeline Server.");
            return -1;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter appReportStr = new PrintWriter(new OutputStreamWriter((OutputStream)baos, Charset.forName("UTF-8")));
        if (appReport != null) {
            appReportStr.println("Application Report : ");
            appReportStr.print("\tApplication-Id : ");
            appReportStr.println(appReport.getApplicationId());
            appReportStr.print("\tApplication-Name : ");
            appReportStr.println(appReport.getName());
            appReportStr.print("\tApplication-Type : ");
            appReportStr.println(appReport.getApplicationType());
            appReportStr.print("\tUser : ");
            appReportStr.println(appReport.getUser());
            appReportStr.print("\tQueue : ");
            appReportStr.println(appReport.getQueue());
            appReportStr.print("\tStart-Time : ");
            appReportStr.println(appReport.getStartTime());
            appReportStr.print("\tFinish-Time : ");
            appReportStr.println(appReport.getFinishTime());
            appReportStr.print("\tProgress : ");
            DecimalFormat formatter = new DecimalFormat("###.##%");
            String progress = formatter.format(appReport.getProgress());
            appReportStr.println(progress);
            appReportStr.print("\tState : ");
            appReportStr.println((Object)appReport.getYarnApplicationState());
            appReportStr.print("\tFinal-State : ");
            appReportStr.println((Object)appReport.getFinalApplicationStatus());
            appReportStr.print("\tTracking-URL : ");
            appReportStr.println(appReport.getOriginalTrackingUrl());
            appReportStr.print("\tRPC Port : ");
            appReportStr.println(appReport.getRpcPort());
            appReportStr.print("\tAM Host : ");
            appReportStr.println(appReport.getHost());
            appReportStr.print("\tAggregate Resource Allocation : ");
            ApplicationResourceUsageReport usageReport = appReport.getApplicationResourceUsageReport();
            if (usageReport != null) {
                appReportStr.print(usageReport.getMemorySeconds() + " MB-seconds, ");
                appReportStr.println(usageReport.getVcoreSeconds() + " vcore-seconds");
            } else {
                appReportStr.println("N/A");
            }
        } else {
            appReportStr.print("Application with id '" + applicationId + "' doesn't exist in RM.");
            appReportStr.close();
            this.sysout.println(baos.toString("UTF-8"));
            return -1;
        }
        appReportStr.print("\tDiagnostics : ");
        appReportStr.print(appReport.getDiagnostics());
        appReportStr.close();
        this.sysout.println(baos.toString("UTF-8"));
        return 0;
    }

    private String getAllValidApplicationStates() {
        StringBuilder sb = new StringBuilder();
        sb.append("The valid application state can be one of the following: ");
        sb.append("ALL,");
        for (YarnApplicationState appState : YarnApplicationState.values()) {
            sb.append((Object)((Object)appState) + ",");
        }
        String output = sb.toString();
        return output.substring(0, output.length() - 1);
    }

    private void listApplicationAttempts(String applicationId) throws YarnException, IOException {
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.sysout, Charset.forName("UTF-8")));
        List<ApplicationAttemptReport> appAttemptsReport = this.client.getApplicationAttempts(ConverterUtils.toApplicationId(applicationId));
        writer.println("Total number of application attempts :" + appAttemptsReport.size());
        writer.printf(APPLICATION_ATTEMPTS_PATTERN, "ApplicationAttempt-Id", "State", "AM-Container-Id", "Tracking-URL");
        for (ApplicationAttemptReport appAttemptReport : appAttemptsReport) {
            writer.printf(APPLICATION_ATTEMPTS_PATTERN, new Object[]{appAttemptReport.getApplicationAttemptId(), appAttemptReport.getYarnApplicationAttemptState(), appAttemptReport.getAMContainerId().toString(), appAttemptReport.getTrackingUrl()});
        }
        writer.flush();
    }

    private void listContainers(String appAttemptId) throws YarnException, IOException {
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.sysout, Charset.forName("UTF-8")));
        List<ContainerReport> appsReport = this.client.getContainers(ConverterUtils.toApplicationAttemptId(appAttemptId));
        writer.println("Total number of containers :" + appsReport.size());
        writer.printf(CONTAINER_PATTERN, "Container-Id", "Start Time", "Finish Time", "State", "Host", "Node Http Address", "LOG-URL");
        for (ContainerReport containerReport : appsReport) {
            writer.printf(CONTAINER_PATTERN, new Object[]{containerReport.getContainerId(), Times.format(containerReport.getCreationTime()), Times.format(containerReport.getFinishTime()), containerReport.getContainerState(), containerReport.getAssignedNode(), containerReport.getNodeHttpAddress() == null ? "N/A" : containerReport.getNodeHttpAddress(), containerReport.getLogUrl()});
        }
        writer.flush();
    }
}

