/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.impl.pb;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationAttemptIdPBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.sparkproject.guava.base.Preconditions;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ContainerIdPBImpl
extends ContainerId {
    YarnProtos.ContainerIdProto proto = null;
    YarnProtos.ContainerIdProto.Builder builder = null;
    private ApplicationAttemptId applicationAttemptId = null;

    public ContainerIdPBImpl() {
        this.builder = YarnProtos.ContainerIdProto.newBuilder();
    }

    public ContainerIdPBImpl(YarnProtos.ContainerIdProto proto) {
        this.proto = proto;
        this.applicationAttemptId = this.convertFromProtoFormat(proto.getAppAttemptId());
    }

    public YarnProtos.ContainerIdProto getProto() {
        return this.proto;
    }

    @Override
    @Deprecated
    public int getId() {
        Preconditions.checkNotNull((Object)this.proto);
        return (int)this.proto.getId();
    }

    @Override
    public long getContainerId() {
        Preconditions.checkNotNull((Object)this.proto);
        return this.proto.getId();
    }

    @Override
    protected void setContainerId(long id) {
        Preconditions.checkNotNull((Object)this.builder);
        this.builder.setId(id);
    }

    @Override
    public ApplicationAttemptId getApplicationAttemptId() {
        return this.applicationAttemptId;
    }

    @Override
    protected void setApplicationAttemptId(ApplicationAttemptId atId) {
        if (atId != null) {
            Preconditions.checkNotNull((Object)this.builder);
            this.builder.setAppAttemptId(this.convertToProtoFormat(atId));
        }
        this.applicationAttemptId = atId;
    }

    private ApplicationAttemptIdPBImpl convertFromProtoFormat(YarnProtos.ApplicationAttemptIdProto p) {
        return new ApplicationAttemptIdPBImpl(p);
    }

    private YarnProtos.ApplicationAttemptIdProto convertToProtoFormat(ApplicationAttemptId t) {
        return ((ApplicationAttemptIdPBImpl)t).getProto();
    }

    @Override
    protected void build() {
        this.proto = this.builder.build();
        this.builder = null;
    }
}

