/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.webapp.view;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.hamlet.HamletImpl;
import org.apache.hadoop.yarn.webapp.hamlet.HamletSpec;
import org.apache.hadoop.yarn.webapp.view.Html;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.spark_project.guava.collect.Lists;

@InterfaceAudience.LimitedPrivate(value={"YARN", "MapReduce"})
public class JQueryUI
extends HtmlBlock {
    public static final String ACCORDION = "ui.accordion";
    public static final String ACCORDION_ID = "ui.accordion.id";
    public static final String DATATABLES = "ui.dataTables";
    public static final String DATATABLES_ID = "ui.dataTables.id";
    public static final String DATATABLES_SELECTOR = "ui.dataTables.selector";
    public static final String DIALOG = "ui.dialog";
    public static final String DIALOG_ID = "ui.dialog.id";
    public static final String DIALOG_SELECTOR = "ui.dialog.selector";
    public static final String PROGRESSBAR = "ui.progressbar";
    public static final String PROGRESSBAR_ID = "ui.progressbar.id";
    public static final String _PROGRESSBAR = ".ui-progressbar.ui-widget.ui-widget-content.ui-corner-all";
    public static final String C_PROGRESSBAR = ".ui-progressbar.ui-widget.ui-widget-content.ui-corner-all".replace('.', ' ').trim();
    public static final String _PROGRESSBAR_VALUE = ".ui-progressbar-value.ui-widget-header.ui-corner-left";
    public static final String C_PROGRESSBAR_VALUE = ".ui-progressbar-value.ui-widget-header.ui-corner-left".replace('.', ' ').trim();
    public static final String _INFO_WRAP = ".info-wrap.ui-widget-content.ui-corner-bottom";
    public static final String _TH = ".ui-state-default";
    public static final String C_TH = ".ui-state-default".replace('.', ' ').trim();
    public static final String C_TABLE = "table";
    public static final String _INFO = ".info";
    public static final String _ODD = ".odd";
    public static final String _EVEN = ".even";

    @Override
    protected void render(HtmlBlock.Block html) {
        html.link(this.root_url("static/jquery/themes-1.9.1/base/jquery-ui.css")).link(this.root_url("static/dt-1.9.4/css/jui-dt.css")).script(this.root_url("static/jquery/jquery-1.8.2.min.js")).script(this.root_url("static/jquery/jquery-ui-1.9.1.custom.min.js")).script(this.root_url("static/dt-1.9.4/js/jquery.dataTables.min.js")).script(this.root_url("static/yarn.dt.plugins.js")).style("#jsnotice { padding: 0.2em; text-align: center; }", ".ui-progressbar { height: 1em; min-width: 5em }");
        ArrayList list = Lists.newArrayList();
        this.initAccordions(list);
        this.initDataTables(list);
        this.initDialogs(list);
        this.initProgressBars(list);
        if (!list.isEmpty()) {
            ((HamletImpl.EImp)((Object)((Hamlet.SCRIPT)((Hamlet.SCRIPT)((Hamlet.SCRIPT)((Hamlet.SCRIPT)html.script()).$type("text/javascript"))._(new Object[]{"$(function() {"}))._(list.toArray()))._(new Object[]{"});"})))._();
        }
    }

    public static void jsnotice(HamletSpec.HTML html) {
        html.div("#jsnotice.ui-state-error")._("This page works best with javascript enabled.")._();
        html.script().$type("text/javascript")._("$('#jsnotice').hide();")._();
    }

    protected void initAccordions(List<String> list) {
        for (String id : StringHelper.split(this.$(ACCORDION_ID))) {
            if (!Html.isValidId(id)) continue;
            String init2 = this.$(JQueryUI.initID(ACCORDION, id));
            if (init2.isEmpty()) {
                init2 = "{autoHeight: false}";
            }
            list.add(StringHelper.join("  $('#", id, "').accordion(", init2, ");"));
        }
    }

    protected void initDataTables(List<String> list) {
        String defaultInit = "{bJQueryUI: true, sPaginationType: 'full_numbers'}";
        String stateSaveInit = "bStateSave : true, \"fnStateSave\": function (oSettings, oData) { sessionStorage.setItem( oSettings.sTableId, JSON.stringify(oData) ); }, \"fnStateLoad\": function (oSettings) { return JSON.parse( sessionStorage.getItem(oSettings.sTableId) );}, ";
        for (String id : StringHelper.split(this.$(DATATABLES_ID))) {
            if (!Html.isValidId(id)) continue;
            String init2 = this.$(JQueryUI.initID(DATATABLES, id));
            if (init2.isEmpty()) {
                init2 = defaultInit;
            }
            int pos = init2.indexOf(123) + 1;
            init2 = new StringBuffer(init2).insert(pos, stateSaveInit).toString();
            list.add(StringHelper.join(id, "DataTable =  $('#", id, "').dataTable(", init2, ").fnSetFilteringDelay(188);"));
            String postInit = this.$(JQueryUI.postInitID(DATATABLES, id));
            if (postInit.isEmpty()) continue;
            list.add(postInit);
        }
        String selector = this.$(DATATABLES_SELECTOR);
        if (!selector.isEmpty()) {
            String init3 = this.$(JQueryUI.initSelector(DATATABLES));
            if (init3.isEmpty()) {
                init3 = defaultInit;
            }
            int pos = init3.indexOf(123) + 1;
            init3 = new StringBuffer(init3).insert(pos, stateSaveInit).toString();
            list.add(StringHelper.join("  $('", StringEscapeUtils.escapeJavaScript((String)selector), "').dataTable(", init3, ").fnSetFilteringDelay(288);"));
        }
    }

    protected void initDialogs(List<String> list) {
        String defaultInit = "{autoOpen: false, show: transfer, hide: explode}";
        for (String id : StringHelper.split(this.$(DIALOG_ID))) {
            if (!Html.isValidId(id)) continue;
            String init2 = this.$(JQueryUI.initID(DIALOG, id));
            if (init2.isEmpty()) {
                init2 = defaultInit;
            }
            String opener = this.$(StringHelper.djoin(DIALOG, id, "opener"));
            list.add(StringHelper.join("  $('#", id, "').dialog(", init2, ");"));
            if (opener.isEmpty() || !Html.isValidId(opener)) continue;
            list.add(StringHelper.join("  $('#", opener, "').click(function() { ", "$('#", id, "').dialog('open'); return false; });"));
        }
        String selector = this.$(DIALOG_SELECTOR);
        if (!selector.isEmpty()) {
            String init3 = this.$(JQueryUI.initSelector(DIALOG));
            if (init3.isEmpty()) {
                init3 = defaultInit;
            }
            list.add(StringHelper.join("  $('", StringEscapeUtils.escapeJavaScript((String)selector), "').click(function() { $(this).children('.dialog').dialog(", init3, "); return false; });"));
        }
    }

    protected void initProgressBars(List<String> list) {
        for (String id : StringHelper.split(this.$(PROGRESSBAR_ID))) {
            if (!Html.isValidId(id)) continue;
            String init2 = this.$(JQueryUI.initID(PROGRESSBAR, id));
            list.add(StringHelper.join("  $('#", id, "').progressbar(", init2, ");"));
        }
    }

    public static String initID(String name, String id) {
        return StringHelper.djoin(name, id, "init");
    }

    public static String postInitID(String name, String id) {
        return StringHelper.djoin(name, id, "postinit");
    }

    public static String initSelector(String name) {
        return StringHelper.djoin(name, "selector.init");
    }

    public static StringBuilder tableInit() {
        return new StringBuilder("{bJQueryUI:true, ").append("sPaginationType: 'full_numbers', iDisplayLength:20, ").append("aLengthMenu:[20, 40, 60, 80, 100]");
    }
}

