/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.CommonFields;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.SyncGroupResponse;
import org.apache.kafka.common.utils.Utils;

public class SyncGroupRequest
extends AbstractRequest {
    private static final String MEMBER_ASSIGNMENT_KEY_NAME = "member_assignment";
    private static final String GROUP_ASSIGNMENT_KEY_NAME = "group_assignment";
    private static final Schema SYNC_GROUP_REQUEST_MEMBER_V0 = new Schema(CommonFields.MEMBER_ID, new Field("member_assignment", Type.BYTES));
    private static final Schema SYNC_GROUP_REQUEST_V0;
    private static final Schema SYNC_GROUP_REQUEST_V1;
    private static final Schema SYNC_GROUP_REQUEST_V2;
    private final String groupId;
    private final int generationId;
    private final String memberId;
    private final Map<String, ByteBuffer> groupAssignment;

    public static Schema[] schemaVersions() {
        return new Schema[]{SYNC_GROUP_REQUEST_V0, SYNC_GROUP_REQUEST_V1, SYNC_GROUP_REQUEST_V2};
    }

    private SyncGroupRequest(String groupId, int generationId, String memberId, Map<String, ByteBuffer> groupAssignment, short version) {
        super(version);
        this.groupId = groupId;
        this.generationId = generationId;
        this.memberId = memberId;
        this.groupAssignment = groupAssignment;
    }

    public SyncGroupRequest(Struct struct, short version) {
        super(version);
        this.groupId = struct.get(CommonFields.GROUP_ID);
        this.generationId = struct.get(CommonFields.GENERATION_ID);
        this.memberId = struct.get(CommonFields.MEMBER_ID);
        this.groupAssignment = new HashMap<String, ByteBuffer>();
        for (Object memberDataObj : struct.getArray(GROUP_ASSIGNMENT_KEY_NAME)) {
            Struct memberData = (Struct)memberDataObj;
            String memberId = memberData.get(CommonFields.MEMBER_ID);
            ByteBuffer memberMetadata = memberData.getBytes(MEMBER_ASSIGNMENT_KEY_NAME);
            this.groupAssignment.put(memberId, memberMetadata);
        }
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        short versionId = this.version();
        switch (versionId) {
            case 0: {
                return new SyncGroupResponse(Errors.forException(e), ByteBuffer.wrap(new byte[0]));
            }
            case 1: 
            case 2: {
                return new SyncGroupResponse(throttleTimeMs, Errors.forException(e), ByteBuffer.wrap(new byte[0]));
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ApiKeys.SYNC_GROUP.latestVersion()));
    }

    public String groupId() {
        return this.groupId;
    }

    public int generationId() {
        return this.generationId;
    }

    public Map<String, ByteBuffer> groupAssignment() {
        return this.groupAssignment;
    }

    public String memberId() {
        return this.memberId;
    }

    public static SyncGroupRequest parse(ByteBuffer buffer, short version) {
        return new SyncGroupRequest(ApiKeys.SYNC_GROUP.parseRequest(version, buffer), version);
    }

    @Override
    protected Struct toStruct() {
        Struct struct = new Struct(ApiKeys.SYNC_GROUP.requestSchema(this.version()));
        struct.set(CommonFields.GROUP_ID, this.groupId);
        struct.set(CommonFields.GENERATION_ID, this.generationId);
        struct.set(CommonFields.MEMBER_ID, this.memberId);
        ArrayList<Struct> memberArray = new ArrayList<Struct>();
        for (Map.Entry<String, ByteBuffer> entries : this.groupAssignment.entrySet()) {
            Struct memberData = struct.instance(GROUP_ASSIGNMENT_KEY_NAME);
            memberData.set(CommonFields.MEMBER_ID, entries.getKey());
            memberData.set(MEMBER_ASSIGNMENT_KEY_NAME, (Object)entries.getValue());
            memberArray.add(memberData);
        }
        struct.set(GROUP_ASSIGNMENT_KEY_NAME, (Object)memberArray.toArray());
        return struct;
    }

    static {
        SYNC_GROUP_REQUEST_V2 = SYNC_GROUP_REQUEST_V1 = (SYNC_GROUP_REQUEST_V0 = new Schema(CommonFields.GROUP_ID, CommonFields.GENERATION_ID, CommonFields.MEMBER_ID, new Field(GROUP_ASSIGNMENT_KEY_NAME, new ArrayOf(SYNC_GROUP_REQUEST_MEMBER_V0))));
    }

    public static class Builder
    extends AbstractRequest.Builder<SyncGroupRequest> {
        private final String groupId;
        private final int generationId;
        private final String memberId;
        private final Map<String, ByteBuffer> groupAssignment;

        public Builder(String groupId, int generationId, String memberId, Map<String, ByteBuffer> groupAssignment) {
            super(ApiKeys.SYNC_GROUP);
            this.groupId = groupId;
            this.generationId = generationId;
            this.memberId = memberId;
            this.groupAssignment = groupAssignment;
        }

        @Override
        public SyncGroupRequest build(short version) {
            return new SyncGroupRequest(this.groupId, this.generationId, this.memberId, this.groupAssignment, version);
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(type=SyncGroupRequest").append(", groupId=").append(this.groupId).append(", generationId=").append(this.generationId).append(", memberId=").append(this.memberId).append(", groupAssignment=").append(Utils.join(this.groupAssignment.keySet(), ",")).append(")");
            return bld.toString();
        }
    }
}

