/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.avro.AvroRemoteException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.ipc.CallFuture;
import org.apache.avro.ipc.Callback;
import org.apache.avro.ipc.HandshakeRequest;
import org.apache.avro.ipc.HandshakeResponse;
import org.apache.avro.ipc.MD5;
import org.apache.avro.ipc.RPCContext;
import org.apache.avro.ipc.RPCPlugin;
import org.apache.avro.ipc.Transceiver;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.util.ByteBufferInputStream;
import org.apache.avro.util.ByteBufferOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Requestor {
    private static final Logger LOG = LoggerFactory.getLogger(Requestor.class);
    private static final Schema META = Schema.createMap(Schema.create(Schema.Type.BYTES));
    private static final GenericDatumReader<Map<String, ByteBuffer>> META_READER = new GenericDatumReader(META);
    private static final GenericDatumWriter<Map<String, ByteBuffer>> META_WRITER = new GenericDatumWriter(META);
    private final Protocol local;
    private volatile Protocol remote;
    private volatile boolean sendLocalText;
    private final Transceiver transceiver;
    private final ReentrantLock handshakeLock = new ReentrantLock();
    protected final List<RPCPlugin> rpcMetaPlugins;
    private static final EncoderFactory ENCODER_FACTORY = new EncoderFactory();
    private static final ConcurrentMap<String, MD5> REMOTE_HASHES = new ConcurrentHashMap<String, MD5>();
    private static final ConcurrentMap<MD5, Protocol> REMOTE_PROTOCOLS = new ConcurrentHashMap<MD5, Protocol>();
    private static final SpecificDatumWriter<HandshakeRequest> HANDSHAKE_WRITER = new SpecificDatumWriter<HandshakeRequest>(HandshakeRequest.class);
    private static final SpecificDatumReader<HandshakeResponse> HANDSHAKE_READER = new SpecificDatumReader<HandshakeResponse>(HandshakeResponse.class);

    public Protocol getLocal() {
        return this.local;
    }

    public Transceiver getTransceiver() {
        return this.transceiver;
    }

    protected Requestor(Protocol local, Transceiver transceiver) throws IOException {
        this.local = local;
        this.transceiver = transceiver;
        this.rpcMetaPlugins = new CopyOnWriteArrayList<RPCPlugin>();
    }

    public void addRPCPlugin(RPCPlugin plugin) {
        this.rpcMetaPlugins.add(plugin);
    }

    public Object request(String messageName, Object request) throws Exception {
        Request rpcRequest = new Request(messageName, request, new RPCContext());
        CallFuture future = rpcRequest.getMessage().isOneWay() ? null : new CallFuture();
        this.request(rpcRequest, future);
        if (future == null) {
            return null;
        }
        try {
            return future.get();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof Exception) {
                throw (Exception)e.getCause();
            }
            throw new AvroRemoteException(e.getCause());
        }
    }

    public <T> void request(String messageName, Object request, Callback<T> callback) throws Exception {
        this.request(new Request(messageName, request, new RPCContext()), callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    <T> void request(Request request, Callback<T> callback) throws Exception {
        Transceiver t;
        block11: {
            t = this.getTransceiver();
            if (!t.isConnected()) {
                this.handshakeLock.lock();
                try {
                    Throwable error;
                    if (t.isConnected()) {
                        this.handshakeLock.unlock();
                        break block11;
                    }
                    CallFuture<Object> callFuture = new CallFuture<Object>(callback);
                    t.transceive(request.getBytes(), new TransceiverCallback<Object>(request, callFuture));
                    callFuture.await();
                    if (!request.getMessage().isOneWay() || (error = callFuture.getError()) == null) return;
                    if (!(error instanceof Exception)) throw new AvroRemoteException(error);
                    throw (Exception)error;
                }
                finally {
                    if (this.handshakeLock.isHeldByCurrentThread()) {
                        this.handshakeLock.unlock();
                    }
                }
            }
        }
        if (request.getMessage().isOneWay()) {
            t.lockChannel();
            try {
                t.writeBuffers(request.getBytes());
                if (callback == null) return;
                callback.handleResult(null);
                return;
            }
            finally {
                t.unlockChannel();
            }
        } else {
            t.transceive(request.getBytes(), new TransceiverCallback<Object>(request, callback));
        }
    }

    private void writeHandshake(Encoder out) throws IOException {
        if (this.getTransceiver().isConnected()) {
            return;
        }
        MD5 localHash = new MD5();
        localHash.bytes(this.local.getMD5());
        String remoteName = this.transceiver.getRemoteName();
        MD5 remoteHash = (MD5)REMOTE_HASHES.get(remoteName);
        if (remoteHash == null) {
            remoteHash = localHash;
            this.remote = this.local;
        } else {
            this.remote = (Protocol)REMOTE_PROTOCOLS.get(remoteHash);
        }
        HandshakeRequest handshake = new HandshakeRequest();
        handshake.clientHash = localHash;
        handshake.serverHash = remoteHash;
        if (this.sendLocalText) {
            handshake.clientProtocol = this.local.toString();
        }
        RPCContext context = new RPCContext();
        context.setHandshakeRequest(handshake);
        for (RPCPlugin plugin : this.rpcMetaPlugins) {
            plugin.clientStartConnect(context);
        }
        handshake.meta = context.requestHandshakeMeta();
        HANDSHAKE_WRITER.write(handshake, out);
    }

    private boolean readHandshake(Decoder in) throws IOException {
        if (this.getTransceiver().isConnected()) {
            return true;
        }
        boolean established = false;
        HandshakeResponse handshake = HANDSHAKE_READER.read(null, in);
        switch (handshake.match) {
            case BOTH: {
                established = true;
                this.sendLocalText = false;
                break;
            }
            case CLIENT: {
                LOG.debug("Handshake match = CLIENT");
                this.setRemote(handshake);
                established = true;
                this.sendLocalText = false;
                break;
            }
            case NONE: {
                LOG.debug("Handshake match = NONE");
                this.setRemote(handshake);
                this.sendLocalText = true;
                break;
            }
            default: {
                throw new AvroRuntimeException("Unexpected match: " + (Object)((Object)handshake.match));
            }
        }
        RPCContext context = new RPCContext();
        context.setHandshakeResponse(handshake);
        for (RPCPlugin plugin : this.rpcMetaPlugins) {
            plugin.clientFinishConnect(context);
        }
        if (established) {
            this.getTransceiver().setRemote(this.remote);
        }
        return established;
    }

    private void setRemote(HandshakeResponse handshake) throws IOException {
        this.remote = Protocol.parse(handshake.serverProtocol.toString());
        MD5 remoteHash = handshake.serverHash;
        REMOTE_HASHES.put(this.transceiver.getRemoteName(), remoteHash);
        REMOTE_PROTOCOLS.putIfAbsent(remoteHash, this.remote);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Protocol getRemote() throws IOException {
        if (this.remote != null) {
            return this.remote;
        }
        MD5 remoteHash = (MD5)REMOTE_HASHES.get(this.transceiver.getRemoteName());
        if (remoteHash != null) {
            this.remote = (Protocol)REMOTE_PROTOCOLS.get(remoteHash);
            if (this.remote != null) {
                return this.remote;
            }
        }
        this.handshakeLock.lock();
        try {
            ByteBufferOutputStream bbo = new ByteBufferOutputStream();
            BinaryEncoder out = ENCODER_FACTORY.directBinaryEncoder(bbo, null);
            this.writeHandshake(out);
            out.writeInt(0);
            ((Encoder)out).writeString("");
            List<ByteBuffer> response = this.getTransceiver().transceive(bbo.getBufferList());
            ByteBufferInputStream bbi = new ByteBufferInputStream(response);
            BinaryDecoder in = DecoderFactory.get().binaryDecoder(bbi, null);
            this.readHandshake(in);
            Protocol protocol = this.remote;
            return protocol;
        }
        finally {
            this.handshakeLock.unlock();
        }
    }

    public abstract void writeRequest(Schema var1, Object var2, Encoder var3) throws IOException;

    @Deprecated
    public Object readResponse(Schema schema, Decoder in) throws IOException {
        return this.readResponse(schema, schema, in);
    }

    public abstract Object readResponse(Schema var1, Schema var2, Decoder var3) throws IOException;

    @Deprecated
    public Object readError(Schema schema, Decoder in) throws IOException {
        return this.readError(schema, schema, in);
    }

    public abstract Exception readError(Schema var1, Schema var2, Decoder var3) throws IOException;

    class Response {
        private final Request request;
        private final BinaryDecoder in;

        public Response(Request request) {
            this(request, null);
        }

        public Response(Request request, BinaryDecoder in) {
            this.request = request;
            this.in = in;
        }

        public Object getResponse() throws Exception {
            Protocol.Message lm = this.request.getMessage();
            Protocol.Message rm = Requestor.this.remote.getMessages().get(this.request.getMessageName());
            if (rm == null) {
                throw new AvroRuntimeException("Not a remote message: " + this.request.getMessageName());
            }
            Transceiver t = Requestor.this.getTransceiver();
            if (lm.isOneWay() != rm.isOneWay() && t.isConnected()) {
                throw new AvroRuntimeException("Not both one-way messages: " + this.request.getMessageName());
            }
            if (lm.isOneWay() && t.isConnected()) {
                return null;
            }
            RPCContext context = this.request.getContext();
            context.setResponseCallMeta(META_READER.read(null, this.in));
            if (!this.in.readBoolean()) {
                Object response = Requestor.this.readResponse(rm.getResponse(), lm.getResponse(), this.in);
                context.setResponse(response);
                for (RPCPlugin plugin : Requestor.this.rpcMetaPlugins) {
                    plugin.clientReceiveResponse(context);
                }
                return response;
            }
            Exception error = Requestor.this.readError(rm.getErrors(), lm.getErrors(), this.in);
            context.setError(error);
            for (RPCPlugin plugin : Requestor.this.rpcMetaPlugins) {
                plugin.clientReceiveResponse(context);
            }
            throw error;
        }
    }

    class Request {
        private final String messageName;
        private final Object request;
        private final RPCContext context;
        private final BinaryEncoder encoder;
        private Protocol.Message message;
        private List<ByteBuffer> requestBytes;

        public Request(String messageName, Object request, RPCContext context) {
            this(messageName, request, context, null);
        }

        public Request(String messageName, Object request, RPCContext context, BinaryEncoder encoder) {
            this.messageName = messageName;
            this.request = request;
            this.context = context;
            this.encoder = ENCODER_FACTORY.binaryEncoder(new ByteBufferOutputStream(), encoder);
        }

        public Request(Request other) {
            this.messageName = other.messageName;
            this.request = other.request;
            this.context = other.context;
            this.encoder = other.encoder;
        }

        public String getMessageName() {
            return this.messageName;
        }

        public RPCContext getContext() {
            return this.context;
        }

        public Protocol.Message getMessage() {
            if (this.message == null) {
                this.message = Requestor.this.getLocal().getMessages().get(this.messageName);
                if (this.message == null) {
                    throw new AvroRuntimeException("Not a local message: " + this.messageName);
                }
            }
            return this.message;
        }

        public List<ByteBuffer> getBytes() throws Exception {
            if (this.requestBytes == null) {
                ByteBufferOutputStream bbo = new ByteBufferOutputStream();
                BinaryEncoder out = ENCODER_FACTORY.binaryEncoder(bbo, this.encoder);
                Protocol.Message m = this.getMessage();
                this.context.setMessage(m);
                Requestor.this.writeRequest(m.getRequest(), this.request, out);
                out.flush();
                List<ByteBuffer> payload = bbo.getBufferList();
                Requestor.this.writeHandshake(out);
                this.context.setRequestPayload(payload);
                for (RPCPlugin plugin : Requestor.this.rpcMetaPlugins) {
                    plugin.clientSendRequest(this.context);
                }
                META_WRITER.write(this.context.requestCallMeta(), out);
                out.writeString(m.getName());
                out.flush();
                bbo.append(payload);
                this.requestBytes = bbo.getBufferList();
            }
            return this.requestBytes;
        }
    }

    protected class TransceiverCallback<T>
    implements Callback<List<ByteBuffer>> {
        private final Request request;
        private final Callback<T> callback;

        public TransceiverCallback(Request request, Callback<T> callback) {
            this.request = request;
            this.callback = callback;
        }

        @Override
        public void handleResult(List<ByteBuffer> responseBytes) {
            ByteBufferInputStream bbi = new ByteBufferInputStream(responseBytes);
            BinaryDecoder in = DecoderFactory.get().binaryDecoder(bbi, null);
            try {
                if (!Requestor.this.readHandshake(in)) {
                    Request handshake = new Request(this.request);
                    Requestor.this.getTransceiver().transceive(handshake.getBytes(), new TransceiverCallback<T>(handshake, this.callback));
                    return;
                }
            }
            catch (Exception e) {
                LOG.error("Error handling transceiver callback: " + e, (Throwable)e);
            }
            Response response = new Response(this.request, in);
            try {
                Object responseObject;
                try {
                    responseObject = response.getResponse();
                }
                catch (Exception e) {
                    if (this.callback != null) {
                        this.callback.handleError(e);
                    }
                    return;
                }
                if (this.callback != null) {
                    this.callback.handleResult(responseObject);
                }
            }
            catch (Throwable t) {
                LOG.error("Error in callback handler: " + t, t);
            }
        }

        @Override
        public void handleError(Throwable error) {
            this.callback.handleError(error);
        }
    }
}

