/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.ProtoUtils;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractRequestResponse;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.utils.CollectionUtils;

public class ProduceRequest
extends AbstractRequest {
    private static final Schema CURRENT_SCHEMA = ProtoUtils.currentRequestSchema(ApiKeys.PRODUCE.id);
    private static final String ACKS_KEY_NAME = "acks";
    private static final String TIMEOUT_KEY_NAME = "timeout";
    private static final String TOPIC_DATA_KEY_NAME = "topic_data";
    private static final String TOPIC_KEY_NAME = "topic";
    private static final String PARTITION_DATA_KEY_NAME = "data";
    private static final String PARTITION_KEY_NAME = "partition";
    private static final String RECORD_SET_KEY_NAME = "record_set";
    private final short acks;
    private final int timeout;
    private final Map<TopicPartition, ByteBuffer> partitionRecords;

    public ProduceRequest(short acks, int timeout, Map<TopicPartition, ByteBuffer> partitionRecords) {
        super(new Struct(CURRENT_SCHEMA));
        Map<String, Map<Integer, ByteBuffer>> recordsByTopic = CollectionUtils.groupDataByTopic(partitionRecords);
        this.struct.set(ACKS_KEY_NAME, (Object)acks);
        this.struct.set(TIMEOUT_KEY_NAME, (Object)timeout);
        ArrayList<Struct> topicDatas = new ArrayList<Struct>(recordsByTopic.size());
        for (Map.Entry<String, Map<Integer, ByteBuffer>> entry : recordsByTopic.entrySet()) {
            Struct topicData = this.struct.instance(TOPIC_DATA_KEY_NAME);
            topicData.set(TOPIC_KEY_NAME, (Object)entry.getKey());
            ArrayList<Struct> partitionArray = new ArrayList<Struct>();
            for (Map.Entry<Integer, ByteBuffer> partitionEntry : entry.getValue().entrySet()) {
                ByteBuffer buffer = partitionEntry.getValue().duplicate();
                Struct part = topicData.instance(PARTITION_DATA_KEY_NAME).set(PARTITION_KEY_NAME, (Object)partitionEntry.getKey()).set(RECORD_SET_KEY_NAME, (Object)buffer);
                partitionArray.add(part);
            }
            topicData.set(PARTITION_DATA_KEY_NAME, (Object)partitionArray.toArray());
            topicDatas.add(topicData);
        }
        this.struct.set(TOPIC_DATA_KEY_NAME, (Object)topicDatas.toArray());
        this.acks = acks;
        this.timeout = timeout;
        this.partitionRecords = partitionRecords;
    }

    public ProduceRequest(Struct struct) {
        super(struct);
        this.partitionRecords = new HashMap<TopicPartition, ByteBuffer>();
        for (Object topicDataObj : struct.getArray(TOPIC_DATA_KEY_NAME)) {
            Struct topicData = (Struct)topicDataObj;
            String topic = topicData.getString(TOPIC_KEY_NAME);
            for (Object partitionResponseObj : topicData.getArray(PARTITION_DATA_KEY_NAME)) {
                Struct partitionResponse = (Struct)partitionResponseObj;
                int partition = partitionResponse.getInt(PARTITION_KEY_NAME);
                ByteBuffer records = partitionResponse.getBytes(RECORD_SET_KEY_NAME);
                this.partitionRecords.put(new TopicPartition(topic, partition), records);
            }
        }
        this.acks = struct.getShort(ACKS_KEY_NAME);
        this.timeout = struct.getInt(TIMEOUT_KEY_NAME);
    }

    @Override
    public AbstractRequestResponse getErrorResponse(int versionId, Throwable e) {
        if (this.acks == 0) {
            return null;
        }
        HashMap<TopicPartition, ProduceResponse.PartitionResponse> responseMap = new HashMap<TopicPartition, ProduceResponse.PartitionResponse>();
        for (Map.Entry<TopicPartition, ByteBuffer> entry : this.partitionRecords.entrySet()) {
            responseMap.put(entry.getKey(), new ProduceResponse.PartitionResponse(Errors.forException(e).code(), -1L, -1L));
        }
        switch (versionId) {
            case 0: {
                return new ProduceResponse(responseMap);
            }
            case 1: 
            case 2: {
                return new ProduceResponse(responseMap, 0, versionId);
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ProtoUtils.latestVersion(ApiKeys.PRODUCE.id)));
    }

    public short acks() {
        return this.acks;
    }

    public int timeout() {
        return this.timeout;
    }

    public Map<TopicPartition, ByteBuffer> partitionRecords() {
        return this.partitionRecords;
    }

    public void clearPartitionRecords() {
        this.partitionRecords.clear();
    }

    public static ProduceRequest parse(ByteBuffer buffer, int versionId) {
        return new ProduceRequest(ProtoUtils.parseRequest(ApiKeys.PRODUCE.id, versionId, buffer));
    }

    public static ProduceRequest parse(ByteBuffer buffer) {
        return new ProduceRequest(CURRENT_SCHEMA.read(buffer));
    }
}

