/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.flume;

import java.net.InetSocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.avro.ipc.NettyServer;
import org.apache.avro.ipc.Responder;
import org.apache.avro.ipc.specific.SpecificResponder;
import org.apache.flume.source.avro.AvroSourceProtocol;
import org.apache.spark.Logging;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.streaming.flume.FlumeEventServer;
import org.apache.spark.streaming.flume.SparkFlumeEvent;
import org.apache.spark.streaming.receiver.Receiver;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.handler.codec.compression.ZlibDecoder;
import org.jboss.netty.handler.codec.compression.ZlibEncoder;
import org.slf4j.Logger;
import scala.Function0;
import scala.Serializable;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005b!B\u0001\u0003\u0001\u0011a!!\u0004$mk6,'+Z2fSZ,'O\u0003\u0002\u0004\t\u0005)a\r\\;nK*\u0011QAB\u0001\ngR\u0014X-Y7j]\u001eT!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\n\u0004\u000159\u0002c\u0001\b\u0012'5\tqB\u0003\u0002\u0011\t\u0005A!/Z2fSZ,'/\u0003\u0002\u0013\u001f\tA!+Z2fSZ,'\u000f\u0005\u0002\u0015+5\t!!\u0003\u0002\u0017\u0005\ty1\u000b]1sW\u001acW/\\3Fm\u0016tG\u000f\u0005\u0002\u001935\ta!\u0003\u0002\u001b\r\t9Aj\\4hS:<\u0007\u0002\u0003\u000f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0010\u0002\t!|7\u000f^\u0002\u0001!\tyRE\u0004\u0002!G5\t\u0011EC\u0001#\u0003\u0015\u00198-\u00197b\u0013\t!\u0013%\u0001\u0004Qe\u0016$WMZ\u0005\u0003M\u001d\u0012aa\u0015;sS:<'B\u0001\u0013\"\u0011!I\u0003A!A!\u0002\u0013Q\u0013\u0001\u00029peR\u0004\"\u0001I\u0016\n\u00051\n#aA%oi\"Ia\u0006\u0001B\u0001B\u0003%q&N\u0001\rgR|'/Y4f\u0019\u00164X\r\u001c\t\u0003aMj\u0011!\r\u0006\u0003e\u0019\tqa\u001d;pe\u0006<W-\u0003\u00025c\ta1\u000b^8sC\u001e,G*\u001a<fY&\u0011a&\u0005\u0005\to\u0001\u0011\t\u0011)A\u0005q\u0005\u0019RM\\1cY\u0016$UmY8naJ,7o]5p]B\u0011\u0001%O\u0005\u0003u\u0005\u0012qAQ8pY\u0016\fg\u000eC\u0003=\u0001\u0011\u0005Q(\u0001\u0004=S:LGO\u0010\u000b\u0006}}\u0002\u0015I\u0011\t\u0003)\u0001AQ\u0001H\u001eA\u0002yAQ!K\u001eA\u0002)BQAL\u001eA\u0002=BQaN\u001eA\u0002aB\u0001\u0002\u0012\u0001\t\u0006\u0004%\t!R\u0001\ne\u0016\u001c\bo\u001c8eKJ,\u0012A\u0012\t\u0003\u000f:k\u0011\u0001\u0013\u0006\u0003\u0013*\u000b\u0001b\u001d9fG&4\u0017n\u0019\u0006\u0003\u00172\u000b1!\u001b9d\u0015\ti\u0005\"\u0001\u0003bmJ|\u0017BA(I\u0005E\u0019\u0006/Z2jM&\u001c'+Z:q_:$WM\u001d\u0005\t#\u0002A\t\u0011)Q\u0005\r\u0006Q!/Z:q_:$WM\u001d\u0011\t\u000fM\u0003\u0001\u0019!C\u0001)\u000611/\u001a:wKJ,\u0012!\u0016\t\u0003-^k\u0011AS\u0005\u00031*\u00131BT3uif\u001cVM\u001d<fe\"9!\f\u0001a\u0001\n\u0003Y\u0016AC:feZ,'o\u0018\u0013fcR\u0011Al\u0018\t\u0003AuK!AX\u0011\u0003\tUs\u0017\u000e\u001e\u0005\bAf\u000b\t\u00111\u0001V\u0003\rAH%\r\u0005\u0007E\u0002\u0001\u000b\u0015B+\u0002\u000fM,'O^3sA!)A\r\u0001C\u0005K\u0006Q\u0011N\\5u'\u0016\u0014h/\u001a:\u0015\u0003UCQa\u001a\u0001\u0005\u0002!\fqa\u001c8Ti\u0006\u0014H\u000fF\u0001]\u0011\u0015Q\u0007\u0001\"\u0001i\u0003\u0019ygn\u0015;pa\")A\u000e\u0001C![\u0006\t\u0002O]3gKJ\u0014X\r\u001a'pG\u0006$\u0018n\u001c8\u0016\u00039\u00042\u0001I8\u001f\u0013\t\u0001\u0018E\u0001\u0003T_6,g!\u0002:\u0001\u0001\u0011\u0019(!I\"p[B\u0014Xm]:j_:\u001c\u0005.\u00198oK2\u0004\u0016\u000e]3mS:,g)Y2u_JL8cA9uyB\u0011QO_\u0007\u0002m*\u0011q\u000f_\u0001\u0005Y\u0006twMC\u0001z\u0003\u0011Q\u0017M^1\n\u0005m4(AB(cU\u0016\u001cG\u000fE\u0002~\u0003\u0013i\u0011A \u0006\u0004\u007f\u0006\u0005\u0011aB2iC:tW\r\u001c\u0006\u0005\u0003\u0007\t)!A\u0003oKR$\u0018PC\u0002\u0002\b)\tQA\u001b2pgNL1!a\u0003\u007f\u0005Y\u0019\u0005.\u00198oK2\u0004\u0016\u000e]3mS:,g)Y2u_JL\bB\u0002\u001fr\t\u0003\ty\u0001\u0006\u0002\u0002\u0012A\u0019\u00111C9\u000e\u0003\u0001Aq!a\u0006r\t\u0003\tI\"A\u0006hKR\u0004\u0016\u000e]3mS:,GCAA\u000e!\ri\u0018QD\u0005\u0004\u0003?q(aD\"iC:tW\r\u001c)ja\u0016d\u0017N\\3")
public class FlumeReceiver
extends Receiver<SparkFlumeEvent>
implements Logging {
    private final String host;
    private final int port;
    private final boolean enableDecompression;
    private SpecificResponder responder;
    private NettyServer server;
    private transient Logger org$apache$spark$Logging$$log_;
    private volatile boolean bitmap$0;

    private SpecificResponder responder$lzycompute() {
        FlumeReceiver flumeReceiver = this;
        synchronized (flumeReceiver) {
            if (!this.bitmap$0) {
                this.responder = new SpecificResponder(AvroSourceProtocol.class, (Object)new FlumeEventServer(this));
                this.bitmap$0 = true;
            }
            return this.responder;
        }
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public SpecificResponder responder() {
        return this.bitmap$0 ? this.responder : this.responder$lzycompute();
    }

    public NettyServer server() {
        return this.server;
    }

    public void server_$eq(NettyServer x$1) {
        this.server = x$1;
    }

    private NettyServer initServer() {
        NettyServer nettyServer;
        if (this.enableDecompression) {
            NioServerSocketChannelFactory channelFactory = new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool());
            CompressionChannelPipelineFactory channelPipelineFactory = new CompressionChannelPipelineFactory();
            nettyServer = new NettyServer((Responder)this.responder(), new InetSocketAddress(this.host, this.port), (ChannelFactory)channelFactory, (ChannelPipelineFactory)channelPipelineFactory, null);
        } else {
            nettyServer = new NettyServer((Responder)this.responder(), new InetSocketAddress(this.host, this.port));
        }
        return nettyServer;
    }

    public void onStart() {
        FlumeReceiver flumeReceiver = this;
        synchronized (flumeReceiver) {
            BoxedUnit boxedUnit;
            if (this.server() == null) {
                this.server_$eq(this.initServer());
                this.server().start();
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.logWarning((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Flume receiver being asked to start more then once with out close";
                    }
                });
                boxedUnit = BoxedUnit.UNIT;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl11 : MonitorExitStatement: MONITOREXIT : var1_1
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Flume receiver started";
                }
            });
            return;
        }
    }

    public void onStop() {
        FlumeReceiver flumeReceiver = this;
        synchronized (flumeReceiver) {
            BoxedUnit boxedUnit;
            if (this.server() == null) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.server().close();
                this.server_$eq(null);
                boxedUnit = BoxedUnit.UNIT;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl11 : MonitorExitStatement: MONITOREXIT : var1_1
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Flume receiver stopped";
                }
            });
            return;
        }
    }

    public Some<String> preferredLocation() {
        return new Some((Object)this.host);
    }

    public FlumeReceiver(String host, int port, StorageLevel storageLevel, boolean enableDecompression) {
        this.host = host;
        this.port = port;
        this.enableDecompression = enableDecompression;
        super(storageLevel);
        Logging.class.$init$((Logging)this);
        this.server = null;
    }

    public class CompressionChannelPipelineFactory
    implements ChannelPipelineFactory {
        /*
         * WARNING - void declaration
         */
        public ChannelPipeline getPipeline() {
            void var1_1;
            ChannelPipeline pipeline = Channels.pipeline();
            ZlibEncoder encoder = new ZlibEncoder(6);
            pipeline.addFirst("deflater", (ChannelHandler)encoder);
            pipeline.addFirst("inflater", (ChannelHandler)new ZlibDecoder());
            return var1_1;
        }

        public /* synthetic */ FlumeReceiver org$apache$spark$streaming$flume$FlumeReceiver$CompressionChannelPipelineFactory$$$outer() {
            return FlumeReceiver.this;
        }

        public CompressionChannelPipelineFactory() {
            if (FlumeReceiver.this == null) {
                throw new NullPointerException();
            }
        }
    }
}

