/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.flume.sink;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.flume.Channel;
import org.apache.spark.streaming.flume.sink.EventBatch;
import org.apache.spark.streaming.flume.sink.Logging;
import org.apache.spark.streaming.flume.sink.Logging$class;
import org.apache.spark.streaming.flume.sink.SparkFlumeProtocol;
import org.apache.spark.streaming.flume.sink.SparkSinkEvent;
import org.apache.spark.streaming.flume.sink.SparkSinkUtils$;
import org.apache.spark.streaming.flume.sink.TransactionProcessor;
import org.slf4j.Logger;
import org.spark-project.guava.util.concurrent.ThreadFactoryBuilder;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u0005-f!B\u0001\u0003\u0001\u0011q!\u0001G*qCJ\\\u0017I\u001e:p\u0007\u0006dGNY1dW\"\u000bg\u000e\u001a7fe*\u00111\u0001B\u0001\u0005g&t7N\u0003\u0002\u0006\r\u0005)a\r\\;nK*\u0011q\u0001C\u0001\ngR\u0014X-Y7j]\u001eT!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\n\u0005\u0001=92\u0004\u0005\u0002\u0011+5\t\u0011C\u0003\u0002\u0013'\u0005!A.\u00198h\u0015\u0005!\u0012\u0001\u00026bm\u0006L!AF\t\u0003\r=\u0013'.Z2u!\tA\u0012$D\u0001\u0003\u0013\tQ\"A\u0001\nTa\u0006\u00148N\u00127v[\u0016\u0004&o\u001c;pG>d\u0007C\u0001\r\u001d\u0013\ti\"AA\u0004M_\u001e<\u0017N\\4\t\u0011}\u0001!Q1A\u0005\u0002\u0005\nq\u0001\u001e5sK\u0006$7o\u0001\u0001\u0016\u0003\t\u0002\"a\t\u0014\u000e\u0003\u0011R\u0011!J\u0001\u0006g\u000e\fG.Y\u0005\u0003O\u0011\u00121!\u00138u\u0011!I\u0003A!A!\u0002\u0013\u0011\u0013\u0001\u0003;ie\u0016\fGm\u001d\u0011\t\u0011-\u0002!Q1A\u0005\u00021\nqa\u00195b]:,G.F\u0001.!\tq\u0003'D\u00010\u0015\t)!\"\u0003\u00022_\t91\t[1o]\u0016d\u0007\u0002C\u001a\u0001\u0005\u0003\u0005\u000b\u0011B\u0017\u0002\u0011\rD\u0017M\u001c8fY\u0002B\u0001\"\u000e\u0001\u0003\u0006\u0004%\t!I\u0001\u0013iJ\fgn]1di&|g\u000eV5nK>,H\u000f\u0003\u00058\u0001\t\u0005\t\u0015!\u0003#\u0003M!(/\u00198tC\u000e$\u0018n\u001c8US6,w.\u001e;!\u0011!I\u0004A!b\u0001\n\u0003\t\u0013a\u00042bG.|eMZ%oi\u0016\u0014h/\u00197\t\u0011m\u0002!\u0011!Q\u0001\n\t\n\u0001CY1dW>3g-\u00138uKJ4\u0018\r\u001c\u0011\t\u000bu\u0002A\u0011\u0001 \u0002\rqJg.\u001b;?)\u0015y\u0004)\u0011\"D!\tA\u0002\u0001C\u0003 y\u0001\u0007!\u0005C\u0003,y\u0001\u0007Q\u0006C\u00036y\u0001\u0007!\u0005C\u0003:y\u0001\u0007!\u0005C\u0004F\u0001\t\u0007I\u0011\u0001$\u0002-Q\u0014\u0018M\\:bGRLwN\\#yK\u000e,Ho\u001c:PaR,\u0012a\u0012\t\u0004G!S\u0015BA%%\u0005\u0019y\u0005\u000f^5p]B\u00111\nU\u0007\u0002\u0019*\u0011QJT\u0001\u000bG>t7-\u001e:sK:$(BA(\u0014\u0003\u0011)H/\u001b7\n\u0005Ec%aD#yK\u000e,Ho\u001c:TKJ4\u0018nY3\t\rM\u0003\u0001\u0015!\u0003H\u0003]!(/\u00198tC\u000e$\u0018n\u001c8Fq\u0016\u001cW\u000f^8s\u001fB$\b\u0005C\u0004V\u0001\t\u0007I\u0011\u0002,\u00023M,\u0017/^3oG\u0016tU/\u001c2feR{\u0007K]8dKN\u001cxN]\u000b\u0002/B!\u0001,X0c\u001b\u0005I&B\u0001.\\\u0003\u001diW\u000f^1cY\u0016T!\u0001\u0018\u0013\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002_3\n9\u0001*Y:i\u001b\u0006\u0004\bC\u0001\ta\u0013\t\t\u0017C\u0001\u0007DQ\u0006\u00148+Z9vK:\u001cW\r\u0005\u0002\u0019G&\u0011AM\u0001\u0002\u0015)J\fgn]1di&|g\u000e\u0015:pG\u0016\u001c8o\u001c:\t\r\u0019\u0004\u0001\u0015!\u0003X\u0003i\u0019X-];f]\u000e,g*^7cKJ$v\u000e\u0015:pG\u0016\u001c8o\u001c:!\u0011\u001dA\u0007A1A\u0005\n%\fqa]3r\u0005\u0006\u001cX-F\u0001k!\t\u00012.\u0003\u0002m#\t11\u000b\u001e:j]\u001eDaA\u001c\u0001!\u0002\u0013Q\u0017\u0001C:fc\n\u000b7/\u001a\u0011\t\u000fA\u0004!\u0019!C\u0005c\u0006Q1/Z9D_VtG/\u001a:\u0016\u0003I\u0004\"a\u001d<\u000e\u0003QT!!\u001e'\u0002\r\u0005$x.\\5d\u0013\t9HO\u0001\u0006Bi>l\u0017n\u0019'p]\u001eDa!\u001f\u0001!\u0002\u0013\u0011\u0018aC:fc\u000e{WO\u001c;fe\u0002Bqa\u001f\u0001A\u0002\u0013%A0A\u0004ti>\u0004\b/\u001a3\u0016\u0003u\u0004\"a\t@\n\u0005}$#a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003\u0007\u0001\u0001\u0019!C\u0005\u0003\u000b\t1b\u001d;paB,Gm\u0018\u0013fcR!\u0011qAA\u0007!\r\u0019\u0013\u0011B\u0005\u0004\u0003\u0017!#\u0001B+oSRD\u0011\"a\u0004\u0002\u0002\u0005\u0005\t\u0019A?\u0002\u0007a$\u0013\u0007C\u0004\u0002\u0014\u0001\u0001\u000b\u0015B?\u0002\u0011M$x\u000e\u001d9fI\u0002B\u0011\"a\u0006\u0001\u0001\u0004%I!!\u0007\u0002\u0013Q,7\u000f\u001e'bi\u000eDWCAA\u000e!\rY\u0015QD\u0005\u0004\u0003?a%AD\"pk:$Hi\\<o\u0019\u0006$8\r\u001b\u0005\n\u0003G\u0001\u0001\u0019!C\u0005\u0003K\tQ\u0002^3ti2\u000bGo\u00195`I\u0015\fH\u0003BA\u0004\u0003OA!\"a\u0004\u0002\"\u0005\u0005\t\u0019AA\u000e\u0011!\tY\u0003\u0001Q!\n\u0005m\u0011A\u0003;fgRd\u0015\r^2iA!9\u0011q\u0006\u0001\u0005B\u0005E\u0012!D4fi\u00163XM\u001c;CCR\u001c\u0007\u000e\u0006\u0003\u00024\u0005e\u0002c\u0001\r\u00026%\u0019\u0011q\u0007\u0002\u0003\u0015\u00153XM\u001c;CCR\u001c\u0007\u000eC\u0004\u0002<\u00055\u0002\u0019\u0001\u0012\u0002\u00039Dq!a\u0010\u0001\t\u0013\t\t%A\bde\u0016\fG/\u001a)s_\u000e,7o]8s)\u0019\t\u0019%!\u0012\u0002VA\u00191\u0005\u00132\t\u0011\u0005\u001d\u0013Q\ba\u0001\u0003\u0013\n1a]3r!\u0011\tY%!\u0015\u000f\u0007\r\ni%C\u0002\u0002P\u0011\na\u0001\u0015:fI\u00164\u0017b\u00017\u0002T)\u0019\u0011q\n\u0013\t\u000f\u0005m\u0012Q\ba\u0001E!9\u0011\u0011\f\u0001\u0005B\u0005m\u0013aA1dWR!\u0011QLA2!\r\u0001\u0012qL\u0005\u0004\u0003C\n\"\u0001\u0002,pS\u0012Dq!!\u001a\u0002X\u0001\u0007q,\u0001\btKF,XM\\2f\u001dVl'-\u001a:\t\u000f\u0005%\u0004\u0001\"\u0011\u0002l\u0005!a.Y2l)\u0011\ti&!\u001c\t\u000f\u0005\u0015\u0014q\ra\u0001?\"9\u0011\u0011\u000f\u0001\u0005\n\u0005M\u0014aE2p[BdW\r^3Ue\u0006t7/Y2uS>tGCBA\u0004\u0003k\n9\bC\u0004\u0002f\u0005=\u0004\u0019A0\t\u000f\u0005e\u0014q\u000ea\u0001{\u000691/^2dKN\u001c\b\u0002CA?\u0001\u0011\u0005!!a \u0002+I,Wn\u001c<f\u0003:$w)\u001a;Qe>\u001cWm]:peR!\u00111IAA\u0011\u001d\t)'a\u001fA\u0002}C\u0001\"!\"\u0001\t\u0003\u0011\u0011qQ\u0001\u0018G>,h\u000e\u001e#po:<\u0006.\u001a8CCR\u001c\u0007.Q2lK\u0012$B!a\u0002\u0002\n\"A\u00111RAB\u0001\u0004\tY\"A\u0003mCR\u001c\u0007\u000eC\u0004\u0002\u0010\u0002!\t!!%\u0002\u0011MDW\u000f\u001e3po:$\"!a\u0002\t\u0011\u0005U\u0005\u00011A\u0005\nq\fa![:UKN$\b\"CAM\u0001\u0001\u0007I\u0011BAN\u0003)I7\u000fV3ti~#S-\u001d\u000b\u0005\u0003\u000f\ti\nC\u0005\u0002\u0010\u0005]\u0015\u0011!a\u0001{\"9\u0011\u0011\u0015\u0001!B\u0013i\u0018aB5t)\u0016\u001cH\u000f\t\u0015\u0005\u0003?\u000b)\u000bE\u0002$\u0003OK1!!+%\u0005!1x\u000e\\1uS2,\u0007")
public class SparkAvroCallbackHandler
implements SparkFlumeProtocol,
Logging {
    private final int threads;
    private final Channel channel;
    private final int transactionTimeout;
    private final int backOffInterval;
    private final Option<ExecutorService> transactionExecutorOpt;
    private final HashMap<CharSequence, TransactionProcessor> sequenceNumberToProcessor;
    private final String seqBase;
    private final AtomicLong seqCounter;
    private boolean stopped;
    private CountDownLatch testLatch;
    private volatile boolean isTest;
    private transient Logger org$apache$spark$streaming$flume$sink$Logging$$log_;

    @Override
    public Logger org$apache$spark$streaming$flume$sink$Logging$$log_() {
        return this.org$apache$spark$streaming$flume$sink$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$streaming$flume$sink$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$streaming$flume$sink$Logging$$log_ = x$1;
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    public int threads() {
        return this.threads;
    }

    public Channel channel() {
        return this.channel;
    }

    public int transactionTimeout() {
        return this.transactionTimeout;
    }

    public int backOffInterval() {
        return this.backOffInterval;
    }

    public Option<ExecutorService> transactionExecutorOpt() {
        return this.transactionExecutorOpt;
    }

    private HashMap<CharSequence, TransactionProcessor> sequenceNumberToProcessor() {
        return this.sequenceNumberToProcessor;
    }

    private String seqBase() {
        return this.seqBase;
    }

    private AtomicLong seqCounter() {
        return this.seqCounter;
    }

    private boolean stopped() {
        return this.stopped;
    }

    private void stopped_$eq(boolean x$1) {
        this.stopped = x$1;
    }

    private boolean isTest() {
        return this.isTest;
    }

    private void isTest_$eq(boolean x$1) {
        this.isTest = x$1;
    }

    private CountDownLatch testLatch() {
        return this.testLatch;
    }

    private void testLatch_$eq(CountDownLatch x$1) {
        this.testLatch = x$1;
    }

    @Override
    public EventBatch getEventBatch(int n) {
        Option<TransactionProcessor> option;
        block6: {
            EventBatch eventBatch;
            block5: {
                block4: {
                    this.logDebug((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Got getEventBatch call from Spark.";
                        }
                    });
                    String sequenceNumber = new StringBuilder().append((Object)this.seqBase()).append((Object)BoxesRunTime.boxToLong((long)this.seqCounter().incrementAndGet())).toString();
                    option = this.createProcessor(sequenceNumber, n);
                    if (!(option instanceof Some)) break block4;
                    Some some = (Some)option;
                    TransactionProcessor processor = (TransactionProcessor)some.x();
                    this.transactionExecutorOpt().foreach((Function1)new Serializable(this, processor){
                        public static final long serialVersionUID = 0L;
                        private final TransactionProcessor processor$1;

                        public final Future<Void> apply(ExecutorService x$1) {
                            return x$1.submit(this.processor$1);
                        }
                        {
                            this.processor$1 = processor$1;
                        }
                    });
                    EventBatch batch = processor.getEventBatch();
                    if (SparkSinkUtils$.MODULE$.isErrorBatch(batch)) {
                        this.removeAndGetProcessor(sequenceNumber);
                        this.logWarning((Function0<String>)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "Received an error batch - no events were received from channel! ";
                            }
                        });
                    }
                    eventBatch = batch;
                    break block5;
                }
                None$ none$ = None$.MODULE$;
                Option<TransactionProcessor> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block6;
                eventBatch = new EventBatch("Spark sink has been stopped!", "", Collections.<SparkSinkEvent>emptyList());
            }
            return eventBatch;
        }
        throw new MatchError(option);
    }

    private Option<TransactionProcessor> createProcessor(String seq, int n) {
        HashMap<CharSequence, TransactionProcessor> hashMap = this.sequenceNumberToProcessor();
        synchronized (hashMap) {
            None$ none$;
            if (this.stopped()) {
                none$ = None$.MODULE$;
            } else {
                TransactionProcessor processor = new TransactionProcessor(this.channel(), seq, n, this.transactionTimeout(), this.backOffInterval(), this);
                this.sequenceNumberToProcessor().put((Object)seq, (Object)processor);
                if (this.isTest()) {
                    processor.countDownWhenBatchAcked(this.testLatch());
                }
                none$ = new Some((Object)processor);
            }
            None$ none$2 = none$;
            return (Option)none$2;
        }
    }

    @Override
    public Void ack(CharSequence sequenceNumber) {
        this.logDebug((Function0<String>)new Serializable(this, sequenceNumber){
            public static final long serialVersionUID = 0L;
            private final CharSequence sequenceNumber$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Received Ack for batch with sequence number: ").append((Object)this.sequenceNumber$1).toString();
            }
            {
                this.sequenceNumber$1 = sequenceNumber$1;
            }
        });
        this.completeTransaction(sequenceNumber, true);
        return null;
    }

    @Override
    public Void nack(CharSequence sequenceNumber) {
        this.completeTransaction(sequenceNumber, false);
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Spark failed to commit transaction. Will reattempt events.";
            }
        });
        return null;
    }

    private void completeTransaction(CharSequence sequenceNumber, boolean success) {
        this.removeAndGetProcessor(sequenceNumber).foreach((Function1)new Serializable(this, success){
            public static final long serialVersionUID = 0L;
            private final boolean success$1;

            public final void apply(TransactionProcessor processor) {
                processor.batchProcessed(this.success$1);
            }
            {
                this.success$1 = success$1;
            }
        });
    }

    public Option<TransactionProcessor> removeAndGetProcessor(CharSequence sequenceNumber) {
        HashMap<CharSequence, TransactionProcessor> hashMap = this.sequenceNumberToProcessor();
        synchronized (hashMap) {
            Option option = this.sequenceNumberToProcessor().remove((Object)((Object)sequenceNumber).toString());
            return option;
        }
    }

    public void countDownWhenBatchAcked(CountDownLatch latch) {
        this.testLatch_$eq(latch);
        this.isTest_$eq(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void shutdown() {
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Shutting down Spark Avro Callback Handler";
            }
        });
        HashMap<CharSequence, TransactionProcessor> hashMap = this.sequenceNumberToProcessor();
        synchronized (hashMap) {
            this.stopped_$eq(true);
            this.sequenceNumberToProcessor().values().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(TransactionProcessor x$2) {
                    x$2.shutdown();
                }
            });
        }
        this.transactionExecutorOpt().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final List<Runnable> apply(ExecutorService x$3) {
                return x$3.shutdownNow();
            }
        });
    }

    public SparkAvroCallbackHandler(int threads, Channel channel, int transactionTimeout, int backOffInterval) {
        this.threads = threads;
        this.channel = channel;
        this.transactionTimeout = transactionTimeout;
        this.backOffInterval = backOffInterval;
        Logging$class.$init$(this);
        this.transactionExecutorOpt = Option$.MODULE$.apply((Object)Executors.newFixedThreadPool(threads, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Spark Sink Processor Thread - %d").build()));
        this.sequenceNumberToProcessor = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.seqBase = RandomStringUtils.randomAlphanumeric((int)8);
        this.seqCounter = new AtomicLong(0L);
        this.stopped = false;
        this.isTest = false;
        this.testLatch = null;
    }
}

