/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.flume.sink;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.flume.Channel;
import org.apache.flume.Event;
import org.apache.flume.Transaction;
import org.apache.spark.streaming.flume.sink.EventBatch;
import org.apache.spark.streaming.flume.sink.Logging;
import org.apache.spark.streaming.flume.sink.SparkAvroCallbackHandler;
import org.apache.spark.streaming.flume.sink.SparkSinkEvent;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction0;
import scala.util.control.Breaks;

@ScalaSignature(bytes="\u0006\u0001\u0005ug\u0001\u0002\u00192\tyB\u0001B\u0016\u0001\u0003\u0006\u0004%\ta\u0016\u0005\t;\u0002\u0011\t\u0011)A\u00051\"Aa\f\u0001BC\u0002\u0013\u0005q\f\u0003\u0005n\u0001\t\u0005\t\u0015!\u0003a\u0011!q\u0007A!a\u0001\n\u0003y\u0007\u0002\u0003;\u0001\u0005\u0003\u0007I\u0011A;\t\u0011m\u0004!\u0011!Q!\nAD\u0001\u0002 \u0001\u0003\u0006\u0004%\ta\u001c\u0005\t{\u0002\u0011\t\u0011)A\u0005a\"Aa\u0010\u0001BC\u0002\u0013\u0005q\u000e\u0003\u0005\u0000\u0001\t\u0005\t\u0015!\u0003q\u0011)\t\t\u0001\u0001BC\u0002\u0013\u0005\u00111\u0001\u0005\u000b\u0003\u0017\u0001!\u0011!Q\u0001\n\u0005\u0015\u0001bBA\u0007\u0001\u0011\u0005\u0011q\u0002\u0005\n\u0003?\u0001\u0001\u0019!C\u0005\u0003CA\u0011\"!\u000b\u0001\u0001\u0004%I!a\u000b\t\u0011\u0005=\u0002\u0001)Q\u0005\u0003GA\u0011\"!\u000f\u0001\u0005\u0004%\t!a\u000f\t\u0011\u0005\r\u0003\u0001)A\u0005\u0003{A\u0011\"!\u0012\u0001\u0005\u0004%\t!a\u000f\t\u0011\u0005\u001d\u0003\u0001)A\u0005\u0003{A\u0001\"!\u0013\u0001\u0005\u0004%\ta\u001c\u0005\b\u0003\u0017\u0002\u0001\u0015!\u0003q\u0011%\ti\u0005\u0001a\u0001\n\u0013\ty\u0005C\u0005\u0002X\u0001\u0001\r\u0011\"\u0003\u0002Z!A\u0011Q\f\u0001!B\u0013\t\t\u0006C\u0005\u0002b\u0001\u0001\r\u0011\"\u0003\u0002P!I\u00111\r\u0001A\u0002\u0013%\u0011Q\r\u0005\t\u0003S\u0002\u0001\u0015)\u0003\u0002R!I\u0011Q\u000e\u0001A\u0002\u0013%\u0011q\n\u0005\n\u0003_\u0002\u0001\u0019!C\u0005\u0003cB\u0001\"!\u001e\u0001A\u0003&\u0011\u0011\u000b\u0005\n\u0003s\u0002\u0001\u0019!C\u0005\u0003wA\u0011\"a\u001f\u0001\u0001\u0004%I!! \t\u0011\u0005\u0005\u0005\u0001)Q\u0005\u0003{A\u0011\"a!\u0001\u0001\u0004%\t!!\"\t\u0013\u0005M\u0005\u00011A\u0005\u0002\u0005U\u0005\u0002CAM\u0001\u0001\u0006K!a\"\t\u000f\u0005m\u0005\u0001\"\u0001\u0002\"!9\u0011Q\u0014\u0001\u0005\u0002\u0005}\u0005\u0002CAS\u0001\u0011\u00051'a*\t\u000f\u0005%\u0006\u0001\"\u0003\u0002(\"9\u00111\u0016\u0001\u0005\n\u0005\u001d\u0006bBAW\u0001\u0011%\u0011q\u0016\u0005\b\u0003s\u0003A\u0011BA^\u0011\u001d\t\t\u000e\u0001C!\u0003'D\u0001\"!6\u0001\t\u0003\t\u0014q\u001b\u0002\u0015)J\fgn]1di&|g\u000e\u0015:pG\u0016\u001c8o\u001c:\u000b\u0005I\u001a\u0014\u0001B:j].T!\u0001N\u001b\u0002\u000b\u0019dW/\\3\u000b\u0005Y:\u0014!C:ue\u0016\fW.\u001b8h\u0015\tA\u0014(A\u0003ta\u0006\u00148N\u0003\u0002;w\u00051\u0011\r]1dQ\u0016T\u0011\u0001P\u0001\u0004_J<7\u0001A\n\u0005\u0001}:%\u000b\u0005\u0002A\u000b6\t\u0011I\u0003\u0002C\u0007\u0006!A.\u00198h\u0015\u0005!\u0015\u0001\u00026bm\u0006L!AR!\u0003\r=\u0013'.Z2u!\rAUjT\u0007\u0002\u0013*\u0011!jS\u0001\u000bG>t7-\u001e:sK:$(B\u0001'D\u0003\u0011)H/\u001b7\n\u00059K%\u0001C\"bY2\f'\r\\3\u0011\u0005\u0001\u0003\u0016BA)B\u0005\u00111v.\u001b3\u0011\u0005M#V\"A\u0019\n\u0005U\u000b$a\u0002'pO\u001eLgnZ\u0001\bG\"\fgN\\3m+\u0005A\u0006CA-\\\u001b\u0005Q&B\u0001\u001b:\u0013\ta&LA\u0004DQ\u0006tg.\u001a7\u0002\u0011\rD\u0017M\u001c8fY\u0002\naa]3r\u001dVlW#\u00011\u0011\u0005\u0005TgB\u00012i!\t\u0019g-D\u0001e\u0015\t)W(\u0001\u0004=e>|GO\u0010\u0006\u0002O\u0006)1oY1mC&\u0011\u0011NZ\u0001\u0007!J,G-\u001a4\n\u0005-d'AB*ue&twM\u0003\u0002jM\u000691/Z9Ok6\u0004\u0013\u0001D7bq\n\u000bGo\u00195TSj,W#\u00019\u0011\u0005E\u0014X\"\u00014\n\u0005M4'aA%oi\u0006\u0001R.\u0019=CCR\u001c\u0007nU5{K~#S-\u001d\u000b\u0003mf\u0004\"!]<\n\u0005a4'\u0001B+oSRDqA\u001f\u0004\u0002\u0002\u0003\u0007\u0001/A\u0002yIE\nQ\"\\1y\u0005\u0006$8\r[*ju\u0016\u0004\u0013A\u0005;sC:\u001c\u0018m\u0019;j_:$\u0016.\\3pkR\f1\u0003\u001e:b]N\f7\r^5p]RKW.Z8vi\u0002\nqBY1dW>3g-\u00138uKJ4\u0018\r\\\u0001\u0011E\u0006\u001c7n\u00144g\u0013:$XM\u001d<bY\u0002\na\u0001]1sK:$XCAA\u0003!\r\u0019\u0016qA\u0005\u0004\u0003\u0013\t$\u0001G*qCJ\\\u0017I\u001e:p\u0007\u0006dGNY1dW\"\u000bg\u000e\u001a7fe\u00069\u0001/\u0019:f]R\u0004\u0013A\u0002\u001fj]&$h\b\u0006\b\u0002\u0012\u0005M\u0011QCA\f\u00033\tY\"!\b\u0011\u0005M\u0003\u0001\"\u0002,\u000f\u0001\u0004A\u0006\"\u00020\u000f\u0001\u0004\u0001\u0007\"\u00028\u000f\u0001\u0004\u0001\b\"\u0002?\u000f\u0001\u0004\u0001\b\"\u0002@\u000f\u0001\u0004\u0001\bbBA\u0001\u001d\u0001\u0007\u0011QA\u0001\u000bKZ,g\u000e\u001e\"bi\u000eDWCAA\u0012!\r\u0019\u0016QE\u0005\u0004\u0003O\t$AC#wK:$()\u0019;dQ\u0006qQM^3oi\n\u000bGo\u00195`I\u0015\fHc\u0001<\u0002.!A!\u0010EA\u0001\u0002\u0004\t\u0019#A\u0006fm\u0016tGOQ1uG\"\u0004\u0003fA\t\u00024A\u0019\u0011/!\u000e\n\u0007\u0005]bM\u0001\u0005w_2\fG/\u001b7f\u0003M\u0011\u0017\r^2i\u000f\u0016tWM]1uK\u0012d\u0015\r^2i+\t\ti\u0004E\u0002I\u0003\u007fI1!!\u0011J\u00059\u0019u.\u001e8u\t><h\u000eT1uG\"\fACY1uG\"<UM\\3sCR,G\rT1uG\"\u0004\u0013!\u00042bi\u000eD\u0017iY6MCR\u001c\u0007.\u0001\bcCR\u001c\u0007.Q2l\u0019\u0006$8\r\u001b\u0011\u0002AQ|G/\u00197BiR,W\u000e\u001d;t)>\u0014V-\\8wK\u001a\u0013x.\\\"iC:tW\r\\\u0001\"i>$\u0018\r\\!ui\u0016l\u0007\u000f^:U_J+Wn\u001c<f\rJ|Wn\u00115b]:,G\u000eI\u0001\rE\u0006$8\r[*vG\u000e,7o]\u000b\u0003\u0003#\u00022!]A*\u0013\r\t)F\u001a\u0002\b\u0005>|G.Z1o\u0003A\u0011\u0017\r^2i'V\u001c7-Z:t?\u0012*\u0017\u000fF\u0002w\u00037B\u0001B_\r\u0002\u0002\u0003\u0007\u0011\u0011K\u0001\u000eE\u0006$8\r[*vG\u000e,7o\u001d\u0011)\u0007i\t\u0019$A\u0004ti>\u0004\b/\u001a3\u0002\u0017M$x\u000e\u001d9fI~#S-\u001d\u000b\u0004m\u0006\u001d\u0004\u0002\u0003>\u001d\u0003\u0003\u0005\r!!\u0015\u0002\u0011M$x\u000e\u001d9fI\u0002B3!HA\u001a\u0003\u0019I7\u000fV3ti\u0006Q\u0011n\u001d+fgR|F%Z9\u0015\u0007Y\f\u0019\b\u0003\u0005{?\u0005\u0005\t\u0019AA)\u0003\u001dI7\u000fV3ti\u0002B3\u0001IA\u001a\u0003%!Xm\u001d;MCR\u001c\u0007.A\u0007uKN$H*\u0019;dQ~#S-\u001d\u000b\u0004m\u0006}\u0004\u0002\u0003>#\u0003\u0003\u0005\r!!\u0010\u0002\u0015Q,7\u000f\u001e'bi\u000eD\u0007%A\u0003uq>\u0003H/\u0006\u0002\u0002\bB)\u0011/!#\u0002\u000e&\u0019\u00111\u00124\u0003\r=\u0003H/[8o!\rI\u0016qR\u0005\u0004\u0003#S&a\u0003+sC:\u001c\u0018m\u0019;j_:\f\u0011\u0002\u001e=PaR|F%Z9\u0015\u0007Y\f9\n\u0003\u0005{K\u0005\u0005\t\u0019AAD\u0003\u0019!\bp\u00149uA\u0005iq-\u001a;Fm\u0016tGOQ1uG\"\faBY1uG\"\u0004&o\\2fgN,G\rF\u0002w\u0003CCq!a))\u0001\u0004\t\t&A\u0004tk\u000e\u001cWm]:\u0002\u0011MDW\u000f\u001e3po:$\u0012A^\u0001\u000fa>\u0004X\u000f\\1uK\u00163XM\u001c;t\u0003A\u0001(o\\2fgN\f5m[(s\u001d\u0006\u001c7.\u0001\ts_2d'-Y2l\u0003:$7\t\\8tKR)a/!-\u00026\"9\u00111\u0017\u0017A\u0002\u00055\u0015A\u0001;y\u0011\u001d\t9\f\fa\u0001\u0003#\nQa\u00197pg\u0016\f\u0011\u0003^8DQ\u0006\u00148+Z9vK:\u001cW-T1q)\u0011\ti,a3\u0011\u0011\u0005}\u0016\u0011YAc\u0003\u000bl\u0011aS\u0005\u0004\u0003\u0007\\%aA'baB\u0019\u0001)a2\n\u0007\u0005%\u0017I\u0001\u0007DQ\u0006\u00148+Z9vK:\u001cW\rC\u0004\u0002N6\u0002\r!a4\u0002\u000b%tW*\u00199\u0011\r\u0005}\u0016\u0011\u00191a\u0003\u0011\u0019\u0017\r\u001c7\u0015\u0003=\u000bqcY8v]R$un\u001e8XQ\u0016t')\u0019;dQ\u0006\u001b7.\u001a3\u0015\u0007Y\fI\u000eC\u0004\u0002\\>\u0002\r!!\u0010\u0002\u000b1\fGo\u00195")
public class TransactionProcessor
implements Callable<Void>,
Logging {
    private final Channel channel;
    private final String seqNum;
    private int maxBatchSize;
    private final int transactionTimeout;
    private final int backOffInterval;
    private final SparkAvroCallbackHandler parent;
    private volatile EventBatch eventBatch;
    private final CountDownLatch batchGeneratedLatch;
    private final CountDownLatch batchAckLatch;
    private final int totalAttemptsToRemoveFromChannel;
    private volatile boolean batchSuccess;
    private volatile boolean stopped;
    private volatile boolean isTest;
    private CountDownLatch testLatch;
    private Option<Transaction> txOpt;
    private transient Logger org$apache$spark$streaming$flume$sink$Logging$$_log;

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public Logger org$apache$spark$streaming$flume$sink$Logging$$_log() {
        return this.org$apache$spark$streaming$flume$sink$Logging$$_log;
    }

    @Override
    public void org$apache$spark$streaming$flume$sink$Logging$$_log_$eq(Logger x$1) {
        this.org$apache$spark$streaming$flume$sink$Logging$$_log = x$1;
    }

    public Channel channel() {
        return this.channel;
    }

    public String seqNum() {
        return this.seqNum;
    }

    public int maxBatchSize() {
        return this.maxBatchSize;
    }

    public void maxBatchSize_$eq(int x$1) {
        this.maxBatchSize = x$1;
    }

    public int transactionTimeout() {
        return this.transactionTimeout;
    }

    public int backOffInterval() {
        return this.backOffInterval;
    }

    public SparkAvroCallbackHandler parent() {
        return this.parent;
    }

    private EventBatch eventBatch() {
        return this.eventBatch;
    }

    private void eventBatch_$eq(EventBatch x$1) {
        this.eventBatch = x$1;
    }

    public CountDownLatch batchGeneratedLatch() {
        return this.batchGeneratedLatch;
    }

    public CountDownLatch batchAckLatch() {
        return this.batchAckLatch;
    }

    public int totalAttemptsToRemoveFromChannel() {
        return this.totalAttemptsToRemoveFromChannel;
    }

    private boolean batchSuccess() {
        return this.batchSuccess;
    }

    private void batchSuccess_$eq(boolean x$1) {
        this.batchSuccess = x$1;
    }

    private boolean stopped() {
        return this.stopped;
    }

    private void stopped_$eq(boolean x$1) {
        this.stopped = x$1;
    }

    private boolean isTest() {
        return this.isTest;
    }

    private void isTest_$eq(boolean x$1) {
        this.isTest = x$1;
    }

    private CountDownLatch testLatch() {
        return this.testLatch;
    }

    private void testLatch_$eq(CountDownLatch x$1) {
        this.testLatch = x$1;
    }

    public Option<Transaction> txOpt() {
        return this.txOpt;
    }

    public void txOpt_$eq(Option<Transaction> x$1) {
        this.txOpt = x$1;
    }

    public EventBatch getEventBatch() {
        this.batchGeneratedLatch().await();
        return this.eventBatch();
    }

    public void batchProcessed(boolean success) {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Batch processed for sequence number: ").append(this.seqNum()).toString());
        this.batchSuccess_$eq(success);
        this.batchAckLatch().countDown();
    }

    public void shutdown() {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutting down transaction processor");
        this.stopped_$eq(true);
    }

    private void populateEvents() {
        try {
            try {
                this.txOpt_$eq((Option<Transaction>)Option$.MODULE$.apply((Object)this.channel().getTransaction()));
                if (this.txOpt().isEmpty()) {
                    this.eventBatch().setErrorMsg("Something went wrong. Channel was unable to create a transaction!");
                }
                this.txOpt().foreach((Function1 & Serializable & scala.Serializable)tx -> {
                    TransactionProcessor.$anonfun$populateEvents$1(this, tx);
                    return BoxedUnit.UNIT;
                });
            }
            catch (InterruptedException interrupted) {
                if (!this.stopped()) {
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error while processing transaction.", interrupted);
                }
            }
            catch (Exception e) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error while processing transaction.", e);
                this.eventBatch().setErrorMsg(e.getMessage());
                try {
                    this.txOpt().foreach((Function1 & Serializable & scala.Serializable)tx -> {
                        this.rollbackAndClose(tx, true);
                        return BoxedUnit.UNIT;
                    });
                }
                finally {
                    this.txOpt_$eq((Option<Transaction>)None$.MODULE$);
                }
            }
        }
        finally {
            this.batchGeneratedLatch().countDown();
        }
    }

    private void processAckOrNack() {
        this.batchAckLatch().await(this.transactionTimeout(), TimeUnit.SECONDS);
        this.txOpt().foreach((Function1 & Serializable & scala.Serializable)tx -> {
            BoxedUnit boxedUnit;
            if (this.batchSuccess()) {
                try {
                    try {
                        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Committing transaction");
                        tx.commit();
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    catch (Exception e) {
                        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error while attempting to commit transaction. Transaction will be rolled back", e);
                        this.rollbackAndClose((Transaction)tx, false);
                        boxedUnit = BoxedUnit.UNIT;
                    }
                }
                finally {
                    tx.close();
                    if (this.isTest()) {
                        this.testLatch().countDown();
                    }
                }
            } else {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Spark could not commit transaction, NACK received. Rolling back transaction.");
                this.rollbackAndClose((Transaction)tx, true);
                boxedUnit = this.parent().removeAndGetProcessor(this.seqNum());
            }
            return boxedUnit;
        });
    }

    private void rollbackAndClose(Transaction tx, boolean close) {
        try {
            try {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Spark was unable to successfully process the events. Transaction is being rolled back.");
                tx.rollback();
            }
            catch (Exception e) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error rolling back transaction. Rollback may have failed!", e);
            }
        }
        finally {
            if (close) {
                tx.close();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private Map<CharSequence, CharSequence> toCharSequenceMap(Map<String, String> inMap) {
        void var2_2;
        HashMap<String, String> charSeqMap = new HashMap<String, String>(inMap.size());
        charSeqMap.putAll(inMap);
        return var2_2;
    }

    @Override
    public Void call() {
        this.populateEvents();
        this.processAckOrNack();
        return null;
    }

    public void countDownWhenBatchAcked(CountDownLatch latch) {
        this.testLatch_$eq(latch);
        this.isTest_$eq(true);
    }

    public static final /* synthetic */ void $anonfun$populateEvents$1(TransactionProcessor $this, Transaction tx) {
        tx.begin();
        ArrayList<SparkSinkEvent> events = new ArrayList<SparkSinkEvent>($this.maxBatchSize());
        Breaks loop = new Breaks();
        BooleanRef gotEventsInThisTxn = BooleanRef.create((boolean)false);
        IntRef loopCounter = IntRef.create((int)0);
        loop.breakable((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            while (!$this.stopped() && events.size() < $this.maxBatchSize() && loopCounter$1.elem < $this.totalAttemptsToRemoveFromChannel()) {
                BoxedUnit boxedUnit;
                ++loopCounter$1.elem;
                Option option = Option$.MODULE$.apply((Object)$this.channel().take());
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Event event = (Event)some.value();
                    events.add(new SparkSinkEvent($this.toCharSequenceMap(event.getHeaders()), ByteBuffer.wrap(event.getBody())));
                    gotEventsInThisTxn$1.elem = true;
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                if (None$.MODULE$.equals(option)) {
                    if (gotEventsInThisTxn$1.elem || $this.stopped()) {
                        throw loop.break();
                    }
                    $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(70).append("Sleeping for ").append($this.backOffInterval()).append(" millis as no events were read in").append(" the current transaction").toString());
                    TimeUnit.MILLISECONDS.sleep($this.backOffInterval());
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                throw new MatchError((Object)option);
            }
        });
        if (!gotEventsInThisTxn.elem && !$this.stopped()) {
            String msg = "Tried several times, but did not get any events from the channel!";
            $this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> msg);
            $this.eventBatch().setErrorMsg(msg);
        } else {
            $this.eventBatch_$eq(new EventBatch("", $this.seqNum(), events));
        }
    }

    public TransactionProcessor(Channel channel, String seqNum, int maxBatchSize, int transactionTimeout, int backOffInterval, SparkAvroCallbackHandler parent) {
        this.channel = channel;
        this.seqNum = seqNum;
        this.maxBatchSize = maxBatchSize;
        this.transactionTimeout = transactionTimeout;
        this.backOffInterval = backOffInterval;
        this.parent = parent;
        Logging.$init$(this);
        this.eventBatch = new EventBatch("Unknown Error", "", Collections.emptyList());
        this.batchGeneratedLatch = new CountDownLatch(1);
        this.batchAckLatch = new CountDownLatch(1);
        this.totalAttemptsToRemoveFromChannel = 0x3FFFFFFF;
        this.batchSuccess = false;
        this.stopped = false;
        this.isTest = false;
        this.testLatch = null;
        this.txOpt = None$.MODULE$;
    }
}

