/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.flume;

import java.net.InetSocketAddress;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.api.java.JavaReceiverInputDStream;
import org.apache.spark.streaming.api.java.JavaReceiverInputDStream$;
import org.apache.spark.streaming.api.java.JavaStreamingContext;
import org.apache.spark.streaming.dstream.ReceiverInputDStream;
import org.apache.spark.streaming.flume.FlumeInputDStream;
import org.apache.spark.streaming.flume.FlumePollingInputDStream;
import org.apache.spark.streaming.flume.SparkFlumeEvent;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassTag$;

public final class FlumeUtils$ {
    public static FlumeUtils$ MODULE$;
    private final int DEFAULT_POLLING_PARALLELISM;
    private final int DEFAULT_POLLING_BATCH_SIZE;

    static {
        new FlumeUtils$();
    }

    private int DEFAULT_POLLING_PARALLELISM() {
        return this.DEFAULT_POLLING_PARALLELISM;
    }

    private int DEFAULT_POLLING_BATCH_SIZE() {
        return this.DEFAULT_POLLING_BATCH_SIZE;
    }

    public ReceiverInputDStream<SparkFlumeEvent> createStream(StreamingContext ssc, String hostname, int port, StorageLevel storageLevel) {
        return this.createStream(ssc, hostname, port, storageLevel, false);
    }

    public ReceiverInputDStream<SparkFlumeEvent> createStream(StreamingContext ssc, String hostname, int port, StorageLevel storageLevel, boolean enableDecompression) {
        FlumeInputDStream inputStream = new FlumeInputDStream(ssc, hostname, port, storageLevel, enableDecompression, ClassTag$.MODULE$.apply(SparkFlumeEvent.class));
        return inputStream;
    }

    public JavaReceiverInputDStream<SparkFlumeEvent> createStream(JavaStreamingContext jssc, String hostname, int port) {
        return JavaReceiverInputDStream$.MODULE$.fromReceiverInputDStream(this.createStream(jssc.ssc(), hostname, port, this.createStream$default$4()), ClassTag$.MODULE$.apply(SparkFlumeEvent.class));
    }

    public JavaReceiverInputDStream<SparkFlumeEvent> createStream(JavaStreamingContext jssc, String hostname, int port, StorageLevel storageLevel) {
        return JavaReceiverInputDStream$.MODULE$.fromReceiverInputDStream(this.createStream(jssc.ssc(), hostname, port, storageLevel, false), ClassTag$.MODULE$.apply(SparkFlumeEvent.class));
    }

    public JavaReceiverInputDStream<SparkFlumeEvent> createStream(JavaStreamingContext jssc, String hostname, int port, StorageLevel storageLevel, boolean enableDecompression) {
        return JavaReceiverInputDStream$.MODULE$.fromReceiverInputDStream(this.createStream(jssc.ssc(), hostname, port, storageLevel, enableDecompression), ClassTag$.MODULE$.apply(SparkFlumeEvent.class));
    }

    public StorageLevel createStream$default$4() {
        return StorageLevel$.MODULE$.MEMORY_AND_DISK_SER_2();
    }

    public ReceiverInputDStream<SparkFlumeEvent> createPollingStream(StreamingContext ssc, String hostname, int port, StorageLevel storageLevel) {
        return this.createPollingStream(ssc, (Seq<InetSocketAddress>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InetSocketAddress[]{new InetSocketAddress(hostname, port)}))), storageLevel);
    }

    public ReceiverInputDStream<SparkFlumeEvent> createPollingStream(StreamingContext ssc, Seq<InetSocketAddress> addresses, StorageLevel storageLevel) {
        return this.createPollingStream(ssc, addresses, storageLevel, this.DEFAULT_POLLING_BATCH_SIZE(), this.DEFAULT_POLLING_PARALLELISM());
    }

    public ReceiverInputDStream<SparkFlumeEvent> createPollingStream(StreamingContext ssc, Seq<InetSocketAddress> addresses, StorageLevel storageLevel, int maxBatchSize, int parallelism) {
        return new FlumePollingInputDStream(ssc, addresses, maxBatchSize, parallelism, storageLevel, ClassTag$.MODULE$.apply(SparkFlumeEvent.class));
    }

    public JavaReceiverInputDStream<SparkFlumeEvent> createPollingStream(JavaStreamingContext jssc, String hostname, int port) {
        return this.createPollingStream(jssc, hostname, port, StorageLevel$.MODULE$.MEMORY_AND_DISK_SER_2());
    }

    public JavaReceiverInputDStream<SparkFlumeEvent> createPollingStream(JavaStreamingContext jssc, String hostname, int port, StorageLevel storageLevel) {
        return this.createPollingStream(jssc, (InetSocketAddress[])((Object[])new InetSocketAddress[]{new InetSocketAddress(hostname, port)}), storageLevel);
    }

    public JavaReceiverInputDStream<SparkFlumeEvent> createPollingStream(JavaStreamingContext jssc, InetSocketAddress[] addresses, StorageLevel storageLevel) {
        return this.createPollingStream(jssc, addresses, storageLevel, this.DEFAULT_POLLING_BATCH_SIZE(), this.DEFAULT_POLLING_PARALLELISM());
    }

    public JavaReceiverInputDStream<SparkFlumeEvent> createPollingStream(JavaStreamingContext jssc, InetSocketAddress[] addresses, StorageLevel storageLevel, int maxBatchSize, int parallelism) {
        return JavaReceiverInputDStream$.MODULE$.fromReceiverInputDStream(this.createPollingStream(jssc.ssc(), (Seq<InetSocketAddress>)Predef$.MODULE$.wrapRefArray((Object[])addresses), storageLevel, maxBatchSize, parallelism), ClassTag$.MODULE$.apply(SparkFlumeEvent.class));
    }

    public StorageLevel createPollingStream$default$4() {
        return StorageLevel$.MODULE$.MEMORY_AND_DISK_SER_2();
    }

    private FlumeUtils$() {
        MODULE$ = this;
        this.DEFAULT_POLLING_PARALLELISM = 5;
        this.DEFAULT_POLLING_BATCH_SIZE = 1000;
    }
}

