/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.flume;

import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import org.apache.avro.ipc.NettyTransceiver;
import org.apache.avro.ipc.Transceiver;
import org.apache.avro.ipc.specific.SpecificRequestor;
import org.apache.commons.lang3.RandomUtils;
import org.apache.flume.source.avro.AvroFlumeEvent;
import org.apache.flume.source.avro.AvroSourceProtocol;
import org.apache.flume.source.avro.Status;
import org.apache.spark.SparkConf;
import org.apache.spark.util.Utils$;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.socket.SocketChannel;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.handler.codec.compression.ZlibDecoder;
import org.jboss.netty.handler.codec.compression.ZlibEncoder;
import scala.Function1;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005a!B\b\u0011\u0001AQ\u0002\"B\u0011\u0001\t\u0003\u0019\u0003b\u0002\u0014\u0001\u0001\u0004%Ia\n\u0005\ba\u0001\u0001\r\u0011\"\u00032\u0011\u00199\u0004\u0001)Q\u0005Q!9\u0001\b\u0001b\u0001\n\u0013I\u0004BB\u001f\u0001A\u0003%!\bC\u0003?\u0001\u0011\u0005q\bC\u0003A\u0001\u0011%q\bC\u0003B\u0001\u0011\u0005!\tC\u0003^\u0001\u0011\u0005aL\u0002\u0003`\u0001\u0011\u0001\u0007\u0002C8\f\u0005\u0003\u0005\u000b\u0011\u0002\u001e\t\u000b\u0005ZA\u0011\u00019\t\u000bQ\\A\u0011I;\u0003\u001d\u0019cW/\\3UKN$X\u000b^5mg*\u0011\u0011CE\u0001\u0006M2,X.\u001a\u0006\u0003'Q\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005U1\u0012!B:qCJ\\'BA\f\u0019\u0003\u0019\t\u0007/Y2iK*\t\u0011$A\u0002pe\u001e\u001c\"\u0001A\u000e\u0011\u0005qyR\"A\u000f\u000b\u0003y\tQa]2bY\u0006L!\u0001I\u000f\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}\r\u0001A#\u0001\u0013\u0011\u0005\u0015\u0002Q\"\u0001\t\u0002\u0017Q\u0014\u0018M\\:dK&4XM]\u000b\u0002QA\u0011\u0011FL\u0007\u0002U)\u00111\u0006L\u0001\u0004SB\u001c'BA\u0017\u0017\u0003\u0011\tgO]8\n\u0005=R#\u0001\u0005(fiRLHK]1og\u000e,\u0017N^3s\u0003=!(/\u00198tG\u0016Lg/\u001a:`I\u0015\fHC\u0001\u001a6!\ta2'\u0003\u00025;\t!QK\\5u\u0011\u001d14!!AA\u0002!\n1\u0001\u001f\u00132\u00031!(/\u00198tG\u0016Lg/\u001a:!\u0003!!Xm\u001d;Q_J$X#\u0001\u001e\u0011\u0005qY\u0014B\u0001\u001f\u001e\u0005\rIe\u000e^\u0001\ni\u0016\u001cH\u000fU8si\u0002\n1bZ3u)\u0016\u001cH\u000fU8siR\t!(\u0001\u0007gS:$gI]3f!>\u0014H/\u0001\u0006xe&$X-\u00138qkR$2AM\"Y\u0011\u0015!\u0015\u00021\u0001F\u0003\u0015Ig\u000e];u!\r15*T\u0007\u0002\u000f*\u0011\u0001*S\u0001\u0005kRLGNC\u0001K\u0003\u0011Q\u0017M^1\n\u00051;%\u0001\u0002'jgR\u0004\"AT+\u000f\u0005=\u001b\u0006C\u0001)\u001e\u001b\u0005\t&B\u0001*#\u0003\u0019a$o\\8u}%\u0011A+H\u0001\u0007!J,G-\u001a4\n\u0005Y;&AB*ue&twM\u0003\u0002U;!)\u0011,\u0003a\u00015\u0006\tRM\\1cY\u0016\u001cu.\u001c9sKN\u001c\u0018n\u001c8\u0011\u0005qY\u0016B\u0001/\u001e\u0005\u001d\u0011un\u001c7fC:\fQa\u00197pg\u0016$\u0012A\r\u0002\u001a\u0007>l\u0007O]3tg&|gn\u00115b]:,GNR1di>\u0014\u0018p\u0005\u0002\fCB\u0011!-\\\u0007\u0002G*\u0011A-Z\u0001\u0004]&|'B\u00014h\u0003\u0019\u0019xnY6fi*\u0011\u0001.[\u0001\bG\"\fgN\\3m\u0015\tQ7.A\u0003oKR$\u0018P\u0003\u0002m1\u0005)!NY8tg&\u0011an\u0019\u0002\u001e\u001d&|7\t\\5f]R\u001cvnY6fi\u000eC\u0017M\u001c8fY\u001a\u000b7\r^8ss\u0006\u00012m\\7qe\u0016\u001c8/[8o\u0019\u00164X\r\u001c\u000b\u0003cN\u0004\"A]\u0006\u000e\u0003\u0001AQa\\\u0007A\u0002i\n!B\\3x\u0007\"\fgN\\3m)\t1(\u0010\u0005\u0002xq6\tQ-\u0003\u0002zK\ni1k\\2lKR\u001c\u0005.\u00198oK2DQa\u001f\bA\u0002q\f\u0001\u0002]5qK2Lg.\u001a\t\u0003{zl\u0011aZ\u0005\u0003\u007f\u001e\u0014qb\u00115b]:,G\u000eU5qK2Lg.\u001a")
public class FlumeTestUtils {
    private NettyTransceiver transceiver = null;
    private final int testPort = this.findFreePort();

    private NettyTransceiver transceiver() {
        return this.transceiver;
    }

    private void transceiver_$eq(NettyTransceiver x$1) {
        this.transceiver = x$1;
    }

    private int testPort() {
        return this.testPort;
    }

    public int getTestPort() {
        return this.testPort();
    }

    private int findFreePort() {
        int candidatePort = RandomUtils.nextInt((int)1024, (int)65536);
        return Utils$.MODULE$.startServiceOnPort(candidatePort, (Function1 & Serializable & scala.Serializable)trialPort -> FlumeTestUtils.$anonfun$findFreePort$1(BoxesRunTime.unboxToInt((Object)trialPort)), new SparkConf(), Utils$.MODULE$.startServiceOnPort$default$4())._2$mcI$sp();
    }

    public void writeInput(List<String> input, boolean enableCompression) {
        Status status;
        InetSocketAddress testAddress = new InetSocketAddress("localhost", this.testPort());
        Buffer inputEvents = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(input).asScala()).map((Function1 & Serializable & scala.Serializable)item -> {
            void var1_1;
            AvroFlumeEvent event = new AvroFlumeEvent();
            event.setBody(ByteBuffer.wrap(item.getBytes(StandardCharsets.UTF_8)));
            event.setHeaders(Collections.singletonMap("test", "header"));
            return var1_1;
        }, Buffer$.MODULE$.canBuildFrom());
        this.close();
        this.transceiver_$eq(enableCompression ? new NettyTransceiver(testAddress, (ChannelFactory)new CompressionChannelFactory(this, 6)) : new NettyTransceiver(testAddress));
        AvroSourceProtocol client = (AvroSourceProtocol)SpecificRequestor.getClient(AvroSourceProtocol.class, (Transceiver)this.transceiver());
        if (client == null) {
            throw new AssertionError((Object)"Cannot create client");
        }
        Status status2 = status = client.appendBatch((List)JavaConverters$.MODULE$.bufferAsJavaListConverter(inputEvents).asJava());
        Status status3 = Status.OK;
        if (status2 == null ? status3 != null : !((Object)((Object)status2)).equals((Object)status3)) {
            throw new AssertionError((Object)"Sent events unsuccessfully");
        }
    }

    public void close() {
        block0: {
            if (this.transceiver() == null) break block0;
            this.transceiver().close();
            this.transceiver_$eq(null);
        }
    }

    public static final /* synthetic */ Tuple2 $anonfun$findFreePort$1(int trialPort) {
        ServerSocket socket = new ServerSocket(trialPort);
        socket.close();
        return new Tuple2(null, (Object)BoxesRunTime.boxToInteger((int)trialPort));
    }

    public class CompressionChannelFactory
    extends NioClientSocketChannelFactory {
        private final int compressionLevel;
        public final /* synthetic */ FlumeTestUtils $outer;

        public SocketChannel newChannel(ChannelPipeline pipeline) {
            ZlibEncoder encoder = new ZlibEncoder(this.compressionLevel);
            pipeline.addFirst("deflater", (ChannelHandler)encoder);
            pipeline.addFirst("inflater", (ChannelHandler)new ZlibDecoder());
            return super.newChannel(pipeline);
        }

        public /* synthetic */ FlumeTestUtils org$apache$spark$streaming$flume$FlumeTestUtils$CompressionChannelFactory$$$outer() {
            return this.$outer;
        }

        public CompressionChannelFactory(FlumeTestUtils $outer, int compressionLevel) {
            this.compressionLevel = compressionLevel;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

