/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.conf.sink;

import java.util.Set;
import org.apache.flume.Context;
import org.apache.flume.conf.ComponentConfiguration;
import org.apache.flume.conf.ConfigurationException;

public class SinkProcessorConfiguration
extends ComponentConfiguration {
    protected Set<String> sinks;

    protected SinkProcessorConfiguration(String componentName) {
        super(componentName);
        this.setType("default");
    }

    @Override
    public void configure(Context context) throws ConfigurationException {
    }

    public Set<String> getSinks() {
        return this.sinks;
    }

    public void setSinks(Set<String> sinks) {
        this.sinks = sinks;
    }

    public static enum SinkProcessorConfigurationType {
        LOAD_BALANCE("org.apache.flume.conf.sink.LoadBalancingSinkProcessorConfiguration"),
        FAILOVER("org.apache.flume.conf.sink.FailoverSinkProcessorConfiguration"),
        DEFAULT(null);

        private final String processorClassName;

        private SinkProcessorConfigurationType(String processorClassName) {
            this.processorClassName = processorClassName;
        }

        public String getSinkProcessorConfigurationType() {
            return this.processorClassName;
        }

        public SinkProcessorConfiguration getConfiguration(String name) throws ConfigurationException {
            SinkProcessorConfiguration instance = null;
            try {
                if (this.processorClassName == null) {
                    return new SinkProcessorConfiguration(name);
                }
                Class<?> clazz = Class.forName(this.processorClassName);
                instance = (SinkProcessorConfiguration)clazz.getConstructor(String.class).newInstance(name);
            }
            catch (ClassNotFoundException e) {
                instance = new SinkProcessorConfiguration(name);
                instance.setNotFoundConfigClass();
            }
            catch (Exception e) {
                throw new ConfigurationException("Could not instantiate configuration!", e);
            }
            return instance;
        }
    }
}

