/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.channel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import org.apache.flume.Channel;
import org.apache.flume.ChannelException;
import org.apache.flume.Event;
import org.apache.flume.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelUtils {
    private static final Logger logger = LoggerFactory.getLogger(ChannelUtils.class);

    public static void put(final Channel channel, final Event event) throws ChannelException {
        ChannelUtils.transact(channel, new Runnable(){

            @Override
            public void run() {
                channel.put(event);
            }
        });
    }

    public static void put(final Channel channel, final Collection<Event> events) throws ChannelException {
        ChannelUtils.transact(channel, new Runnable(){

            @Override
            public void run() {
                for (Event event : events) {
                    channel.put(event);
                }
            }
        });
    }

    public static Event take(final Channel channel) throws ChannelException {
        return ChannelUtils.transact(channel, new Callable<Event>(){

            @Override
            public Event call() {
                return channel.take();
            }
        });
    }

    public static List<Event> take(final Channel channel, final int max) throws ChannelException {
        return ChannelUtils.transact(channel, new Callable<List<Event>>(){

            @Override
            public List<Event> call() {
                Event event;
                ArrayList<Event> events = new ArrayList<Event>(max);
                while (events.size() < max && (event = channel.take()) != null) {
                    events.add(event);
                }
                return events;
            }
        });
    }

    public static void transact(Channel channel, Runnable transactor) throws ChannelException {
        ChannelUtils.transact(channel, Executors.callable(transactor));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T transact(Channel channel, Callable<T> transactor) throws ChannelException {
        boolean bl;
        T t;
        Transaction transaction = channel.getTransaction();
        boolean committed = false;
        boolean interrupted = false;
        try {
            transaction.begin();
            T value = transactor.call();
            transaction.commit();
            committed = true;
            t = value;
            bl = interrupted || Thread.currentThread().isInterrupted();
        }
        catch (Throwable e) {
            try {
                interrupted = Thread.currentThread().isInterrupted();
                try {
                    transaction.rollback();
                }
                catch (Throwable e2) {
                    logger.error("Failed to roll back transaction, exception follows:", e2);
                }
                if (e instanceof InterruptedException) {
                    interrupted = true;
                    throw new ChannelException(e);
                }
                if (e instanceof Error) {
                    throw (Error)e;
                }
                if (!(e instanceof RuntimeException)) throw new ChannelException(e);
                throw (RuntimeException)e;
            }
            catch (Throwable throwable) {
                interrupted = interrupted || Thread.currentThread().isInterrupted();
                try {
                    transaction.close();
                    throw throwable;
                }
                catch (Throwable e2) {
                    if (!committed) {
                        logger.error("Failed to close transaction after error, exception follows:", e2);
                        throw throwable;
                    }
                    if (e2 instanceof Error) {
                        throw (Error)e2;
                    }
                    if (!(e2 instanceof RuntimeException)) throw new ChannelException(e2);
                    throw (RuntimeException)e2;
                }
                finally {
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
        interrupted = bl;
        try {
            transaction.close();
            return t;
        }
        catch (Throwable e) {
            if (!committed) {
                logger.error("Failed to close transaction after error, exception follows:", e);
                return t;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            if (!(e instanceof RuntimeException)) throw new ChannelException(e);
            throw (RuntimeException)e;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private ChannelUtils() {
    }
}

