/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.interceptor;

import java.util.List;
import org.apache.flume.Event;
import org.apache.flume.interceptor.Interceptor;
import org.spark_project.guava.base.Preconditions;
import org.spark_project.guava.collect.Lists;

public class InterceptorChain
implements Interceptor {
    private List<Interceptor> interceptors = Lists.newLinkedList();

    public void setInterceptors(List<Interceptor> interceptors) {
        this.interceptors = interceptors;
    }

    @Override
    public Event intercept(Event event) {
        for (Interceptor interceptor : this.interceptors) {
            if (event == null) {
                return null;
            }
            event = interceptor.intercept(event);
        }
        return event;
    }

    @Override
    public List<Event> intercept(List<Event> events) {
        for (Interceptor interceptor : this.interceptors) {
            if (events.isEmpty()) {
                return events;
            }
            events = interceptor.intercept(events);
            Preconditions.checkNotNull(events, (String)"Event list returned null from interceptor %s", (Object[])new Object[]{interceptor});
        }
        return events;
    }

    @Override
    public void initialize() {
        for (Interceptor interceptor : this.interceptors) {
            interceptor.initialize();
        }
    }

    @Override
    public void close() {
        for (Interceptor interceptor : this.interceptors) {
            interceptor.close();
        }
    }
}

