/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.io.Serializable;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.trees.LeafLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.command.AlterTableChangeColumnCommand$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.command.LeafRunnableCommand;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\tua\u0001\u0002\u0010 \u00012B\u0001\"\u0014\u0001\u0003\u0016\u0004%\tA\u0014\u0005\t'\u0002\u0011\t\u0012)A\u0005\u001f\"AA\u000b\u0001BK\u0002\u0013\u0005Q\u000b\u0003\u0005_\u0001\tE\t\u0015!\u0003W\u0011!y\u0006A!f\u0001\n\u0003\u0001\u0007\u0002C4\u0001\u0005#\u0005\u000b\u0011B1\t\u000b!\u0004A\u0011A5\t\u000b9\u0004A\u0011I8\t\u000bq\u0004A\u0011B?\t\u000f\u0005]\u0002\u0001\"\u0003\u0002:!9\u0011\u0011\n\u0001\u0005\n\u0005-\u0003\"CA/\u0001\u0005\u0005I\u0011AA0\u0011%\t9\u0007AI\u0001\n\u0003\tI\u0007C\u0005\u0002\u0000\u0001\t\n\u0011\"\u0001\u0002\u0002\"I\u0011Q\u0011\u0001\u0012\u0002\u0013\u0005\u0011q\u0011\u0005\n\u0003\u0017\u0003\u0011\u0011!C!\u0003\u001bC\u0011\"!(\u0001\u0003\u0003%\t!a(\t\u0013\u0005\u001d\u0006!!A\u0005\u0002\u0005%\u0006\"CA[\u0001\u0005\u0005I\u0011IA\\\u0011%\t)\rAA\u0001\n\u0003\t9\rC\u0005\u0002L\u0002\t\t\u0011\"\u0011\u0002N\"I\u0011\u0011\u001b\u0001\u0002\u0002\u0013\u0005\u00131[\u0004\n\u0003/|\u0012\u0011!E\u0001\u000334\u0001BH\u0010\u0002\u0002#\u0005\u00111\u001c\u0005\u0007Qb!\t!a=\t\u0013\u0005U\b$!A\u0005F\u0005]\b\"CA}1\u0005\u0005I\u0011QA~\u0011%\u0011\u0019\u0001GA\u0001\n\u0003\u0013)\u0001C\u0005\u0003\u0014a\t\t\u0011\"\u0003\u0003\u0016\ti\u0012\t\u001c;feR\u000b'\r\\3DQ\u0006tw-Z\"pYVlgnQ8n[\u0006tGM\u0003\u0002!C\u000591m\\7nC:$'B\u0001\u0012$\u0003%)\u00070Z2vi&|gN\u0003\u0002%K\u0005\u00191/\u001d7\u000b\u0005\u0019:\u0013!B:qCJ\\'B\u0001\u0015*\u0003\u0019\t\u0007/Y2iK*\t!&A\u0002pe\u001e\u001c\u0001aE\u0003\u0001[]Z\u0014\t\u0005\u0002/k5\tqF\u0003\u00021c\u00059An\\4jG\u0006d'B\u0001\u001a4\u0003\u0015\u0001H.\u00198t\u0015\t!4%\u0001\u0005dCR\fG._:u\u0013\t1tFA\u0006M_\u001eL7-\u00197QY\u0006t\u0007C\u0001\u001d:\u001b\u0005y\u0012B\u0001\u001e \u0005MaU-\u00194Sk:t\u0017M\u00197f\u0007>lW.\u00198e!\tat(D\u0001>\u0015\u0005q\u0014!B:dC2\f\u0017B\u0001!>\u0005\u001d\u0001&o\u001c3vGR\u0004\"A\u0011&\u000f\u0005\rCeB\u0001#H\u001b\u0005)%B\u0001$,\u0003\u0019a$o\\8u}%\ta(\u0003\u0002J{\u00059\u0001/Y2lC\u001e,\u0017BA&M\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\tIU(A\u0005uC\ndWMT1nKV\tq\n\u0005\u0002Q#6\t1'\u0003\u0002Sg\tyA+\u00192mK&#WM\u001c;jM&,'/\u0001\u0006uC\ndWMT1nK\u0002\n!bY8mk6tg*Y7f+\u00051\u0006CA,\\\u001d\tA\u0016\f\u0005\u0002E{%\u0011!,P\u0001\u0007!J,G-\u001a4\n\u0005qk&AB*ue&twM\u0003\u0002[{\u0005Y1m\u001c7v[:t\u0015-\\3!\u0003%qWm^\"pYVlg.F\u0001b!\t\u0011W-D\u0001d\u0015\t!7%A\u0003usB,7/\u0003\u0002gG\nY1\u000b\u001e:vGR4\u0015.\u001a7e\u0003)qWm^\"pYVlg\u000eI\u0001\u0007y%t\u0017\u000e\u001e \u0015\t)\\G.\u001c\t\u0003q\u0001AQ!T\u0004A\u0002=CQ\u0001V\u0004A\u0002YCQaX\u0004A\u0002\u0005\f1A];o)\t\u0001x\u000fE\u0002CcNL!A\u001d'\u0003\u0007M+\u0017\u000f\u0005\u0002uk6\t1%\u0003\u0002wG\t\u0019!k\\<\t\u000baD\u0001\u0019A=\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0011\u0005QT\u0018BA>$\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0003A1\u0017N\u001c3D_2,XN\u001c\"z\u001d\u0006lW\r\u0006\u0004b}\u0006\u001d\u00111\u0002\u0005\u0007\u007f&\u0001\r!!\u0001\u0002\rM\u001c\u0007.Z7b!\r\u0011\u00171A\u0005\u0004\u0003\u000b\u0019'AC*ueV\u001cG\u000fV=qK\"1\u0011\u0011B\u0005A\u0002Y\u000bAA\\1nK\"9\u0011QB\u0005A\u0002\u0005=\u0011\u0001\u0003:fg>dg/\u001a:\u0011\t\u0005E\u0011\u0011\u0007\b\u0005\u0003'\tiC\u0004\u0003\u0002\u0016\u0005%b\u0002BA\f\u0003OqA!!\u0007\u0002&9!\u00111DA\u0012\u001d\u0011\ti\"!\t\u000f\u0007\u0011\u000by\"C\u0001+\u0013\tA\u0013&\u0003\u0002'O%\u0011A%J\u0005\u0003i\rJ1!a\u000b4\u0003!\tg.\u00197zg&\u001c\u0018bA%\u00020)\u0019\u00111F\u001a\n\t\u0005M\u0012Q\u0007\u0002\t%\u0016\u001cx\u000e\u001c<fe*\u0019\u0011*a\f\u0002\u0015\u0005$GmQ8n[\u0016tG\u000fF\u0003b\u0003w\ty\u0004\u0003\u0004\u0002>)\u0001\r!Y\u0001\u0007G>dW/\u001c8\t\u000f\u0005\u0005#\u00021\u0001\u0002D\u000591m\\7nK:$\b\u0003\u0002\u001f\u0002FYK1!a\u0012>\u0005\u0019y\u0005\u000f^5p]\u0006Y1m\u001c7v[:,\u0015/^1m)!\ti%a\u0015\u0002X\u0005m\u0003c\u0001\u001f\u0002P%\u0019\u0011\u0011K\u001f\u0003\u000f\t{w\u000e\\3b]\"1\u0011QK\u0006A\u0002\u0005\fQAZ5fY\u0012Da!!\u0017\f\u0001\u0004\t\u0017!B8uQ\u0016\u0014\bbBA\u0007\u0017\u0001\u0007\u0011qB\u0001\u0005G>\u0004\u0018\u0010F\u0004k\u0003C\n\u0019'!\u001a\t\u000f5c\u0001\u0013!a\u0001\u001f\"9A\u000b\u0004I\u0001\u0002\u00041\u0006bB0\r!\u0003\u0005\r!Y\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tYGK\u0002P\u0003[Z#!a\u001c\u0011\t\u0005E\u00141P\u0007\u0003\u0003gRA!!\u001e\u0002x\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003sj\u0014AC1o]>$\u0018\r^5p]&!\u0011QPA:\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\t\u0019IK\u0002W\u0003[\nabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0002\n*\u001a\u0011-!\u001c\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\ty\t\u0005\u0003\u0002\u0012\u0006mUBAAJ\u0015\u0011\t)*a&\u0002\t1\fgn\u001a\u0006\u0003\u00033\u000bAA[1wC&\u0019A,a%\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005\u0005\u0006c\u0001\u001f\u0002$&\u0019\u0011QU\u001f\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005-\u0016\u0011\u0017\t\u0004y\u00055\u0016bAAX{\t\u0019\u0011I\\=\t\u0013\u0005M&#!AA\u0002\u0005\u0005\u0016a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002:B1\u00111XAa\u0003Wk!!!0\u000b\u0007\u0005}V(\u0001\u0006d_2dWm\u0019;j_:LA!a1\u0002>\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\ti%!3\t\u0013\u0005MF#!AA\u0002\u0005-\u0016A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!a$\u0002P\"I\u00111W\u000b\u0002\u0002\u0003\u0007\u0011\u0011U\u0001\u0007KF,\u0018\r\\:\u0015\t\u00055\u0013Q\u001b\u0005\n\u0003g3\u0012\u0011!a\u0001\u0003W\u000bQ$\u00117uKJ$\u0016M\u00197f\u0007\"\fgnZ3D_2,XN\\\"p[6\fg\u000e\u001a\t\u0003qa\u0019R\u0001GAo\u0003S\u0004\u0002\"a8\u0002f>3\u0016M[\u0007\u0003\u0003CT1!a9>\u0003\u001d\u0011XO\u001c;j[\u0016LA!a:\u0002b\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\u0011\t\u0005-\u0018\u0011_\u0007\u0003\u0003[TA!a<\u0002\u0018\u0006\u0011\u0011n\\\u0005\u0004\u0017\u00065HCAAm\u0003!!xn\u0015;sS:<GCAAH\u0003\u0015\t\u0007\u000f\u001d7z)\u001dQ\u0017Q`A\u0000\u0005\u0003AQ!T\u000eA\u0002=CQ\u0001V\u000eA\u0002YCQaX\u000eA\u0002\u0005\fq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003\b\t=\u0001#\u0002\u001f\u0002F\t%\u0001C\u0002\u001f\u0003\f=3\u0016-C\u0002\u0003\u000eu\u0012a\u0001V;qY\u0016\u001c\u0004\u0002\u0003B\t9\u0005\u0005\t\u0019\u00016\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0003\u0018A!\u0011\u0011\u0013B\r\u0013\u0011\u0011Y\"a%\u0003\r=\u0013'.Z2u\u0001")
public class AlterTableChangeColumnCommand
extends LogicalPlan
implements LeafRunnableCommand,
Serializable {
    private final TableIdentifier tableName;
    private final String columnName;
    private final StructField newColumn;
    private Map<String, SQLMetric> metrics;
    private Seq<Enumeration.Value> nodePatterns;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<TableIdentifier, String, StructField>> unapply(AlterTableChangeColumnCommand x$0) {
        return AlterTableChangeColumnCommand$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple3<TableIdentifier, String, StructField>, AlterTableChangeColumnCommand> tupled() {
        return AlterTableChangeColumnCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<String, Function1<StructField, AlterTableChangeColumnCommand>>> curried() {
        return AlterTableChangeColumnCommand$.MODULE$.curried();
    }

    @Override
    public final Seq<LogicalPlan> children() {
        return LeafLike.children$((LeafLike)this);
    }

    public final TreeNode mapChildren(Function1 f) {
        return LeafLike.mapChildren$((LeafLike)this, (Function1)f);
    }

    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return LeafLike.withNewChildrenInternal$((LeafLike)this, (IndexedSeq)newChildren);
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public AttributeSet producedAttributes() {
        return Command.producedAttributes$((Command)this);
    }

    public Statistics stats() {
        return Command.stats$((Command)this);
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        AlterTableChangeColumnCommand alterTableChangeColumnCommand = this;
        synchronized (alterTableChangeColumnCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$(this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    @Override
    public Map<String, SQLMetric> metrics() {
        return !this.bitmap$0 ? this.metrics$lzycompute() : this.metrics;
    }

    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    public final void org$apache$spark$sql$catalyst$plans$logical$Command$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public TableIdentifier tableName() {
        return this.tableName;
    }

    public String columnName() {
        return this.columnName;
    }

    public StructField newColumn() {
        return this.newColumn;
    }

    @Override
    public Seq<Row> run(SparkSession sparkSession) {
        SessionCatalog catalog = sparkSession.sessionState().catalog();
        CatalogTable table = catalog.getTableRawMetadata(this.tableName());
        Function2 resolver = sparkSession.sessionState().conf().resolver();
        DDLUtils$.MODULE$.verifyAlterTableType(catalog, table, false);
        StructField originColumn = this.findColumnByName(table.dataSchema(), this.columnName(), (Function2<String, String, Object>)resolver);
        if (!this.columnEqual(originColumn, this.newColumn(), (Function2<String, String, Object>)resolver)) {
            throw QueryCompilationErrors$.MODULE$.alterTableChangeColumnNotSupportedForColumnTypeError(originColumn, this.newColumn());
        }
        StructField[] newDataSchema = (StructField[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])table.dataSchema().fields()), (Function1 & Serializable)field -> {
            String string = field.name();
            String string2 = originColumn.name();
            return !(string != null ? !string.equals(string2) : string2 != null) ? this.addComment((StructField)field, (Option<String>)this.newColumn().getComment()) : field;
        }, ClassTag$.MODULE$.apply(StructField.class));
        catalog.alterTableDataSchema(this.tableName(), new StructType(newDataSchema));
        return (Seq)package$.MODULE$.Seq().empty();
    }

    private StructField findColumnByName(StructType schema, String name, Function2<String, String, Object> resolver) {
        return (StructField)ArrayOps$.MODULE$.collectFirst$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fields()), (PartialFunction)new Serializable(null, resolver, name){
            private static final long serialVersionUID = 0L;
            private final Function2 resolver$1;
            private final String name$1;

            public final <A1 extends StructField, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = BoxesRunTime.unboxToBoolean((Object)this.resolver$1.apply((Object)A1.name(), (Object)this.name$1)) ? A1 : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(StructField x1) {
                StructField structField = x1;
                boolean bl = BoxesRunTime.unboxToBoolean((Object)this.resolver$1.apply((Object)structField.name(), (Object)this.name$1));
                return bl;
            }
            {
                this.resolver$1 = resolver$1;
                this.name$1 = name$1;
            }
        }).getOrElse((Function0 & Serializable)() -> {
            throw QueryCompilationErrors$.MODULE$.cannotFindColumnError(name, schema.fieldNames());
        });
    }

    private StructField addComment(StructField column, Option<String> comment2) {
        return (StructField)comment2.map((Function1 & Serializable)comment -> column.withComment(comment)).getOrElse((Function0 & Serializable)() -> column);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean columnEqual(StructField field, StructField other, Function2<String, String, Object> resolver) {
        if (!BoxesRunTime.unboxToBoolean((Object)resolver.apply((Object)field.name(), (Object)other.name()))) return false;
        DataType dataType = field.dataType();
        DataType dataType2 = other.dataType();
        if (dataType != null) {
            if (!dataType.equals(dataType2)) return false;
            return true;
        }
        if (dataType2 == null) return true;
        return false;
    }

    public AlterTableChangeColumnCommand copy(TableIdentifier tableName, String columnName, StructField newColumn) {
        return new AlterTableChangeColumnCommand(tableName, columnName, newColumn);
    }

    public TableIdentifier copy$default$1() {
        return this.tableName();
    }

    public String copy$default$2() {
        return this.columnName();
    }

    public StructField copy$default$3() {
        return this.newColumn();
    }

    public String productPrefix() {
        return "AlterTableChangeColumnCommand";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.tableName();
                break;
            }
            case 1: {
                object = this.columnName();
                break;
            }
            case 2: {
                object = this.newColumn();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof AlterTableChangeColumnCommand;
    }

    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "tableName";
                break;
            }
            case 1: {
                string = "columnName";
                break;
            }
            case 2: {
                string = "newColumn";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof AlterTableChangeColumnCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        AlterTableChangeColumnCommand alterTableChangeColumnCommand = (AlterTableChangeColumnCommand)x$1;
        TableIdentifier tableIdentifier = this.tableName();
        TableIdentifier tableIdentifier2 = alterTableChangeColumnCommand.tableName();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        String string = this.columnName();
        String string2 = alterTableChangeColumnCommand.columnName();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        StructField structField = this.newColumn();
        StructField structField2 = alterTableChangeColumnCommand.newColumn();
        if (structField == null) {
            if (structField2 != null) {
                return false;
            }
        } else if (!structField.equals(structField2)) return false;
        if (!alterTableChangeColumnCommand.canEqual(this)) return false;
        return true;
    }

    public AlterTableChangeColumnCommand(TableIdentifier tableName, String columnName, StructField newColumn) {
        this.tableName = tableName;
        this.columnName = columnName;
        this.newColumn = newColumn;
        Command.$init$((Command)this);
        RunnableCommand.$init$(this);
        LeafLike.$init$((LeafLike)this);
        Statics.releaseFence();
    }
}

