/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Or;
import org.apache.spark.sql.connector.expressions.filter.And;
import org.apache.spark.sql.connector.expressions.filter.Not;
import org.apache.spark.sql.connector.expressions.filter.Predicate;
import org.apache.spark.sql.execution.datasources.v2.PushablePredicate;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.mutable.HashMap;

public final class DataSourceV2Strategy$ {
    public static final DataSourceV2Strategy$ MODULE$ = new DataSourceV2Strategy$();

    private Option<Predicate> translateLeafNodeFilterV2(Expression predicate, boolean supportNestedPredicatePushdown) {
        None$ none$;
        Option<Predicate> option;
        PushablePredicate pushablePredicate = new PushablePredicate(supportNestedPredicatePushdown);
        Expression expression = predicate;
        if (expression != null && !(option = pushablePredicate.unapply(expression)).isEmpty()) {
            Predicate expr = (Predicate)option.get();
            none$ = new Some((Object)expr);
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Option<Predicate> translateFilterV2(Expression predicate, boolean supportNestedPredicatePushdown) {
        return this.translateFilterV2WithMapping(predicate, (Option<HashMap<Predicate, Expression>>)None$.MODULE$, supportNestedPredicatePushdown);
    }

    public Option<Predicate> translateFilterV2WithMapping(Expression predicate, Option<HashMap<Predicate, Expression>> translatedFilterToExpr, boolean nestedPredicatePushdownEnabled) {
        Option option;
        Expression expression = predicate;
        if (expression instanceof org.apache.spark.sql.catalyst.expressions.And) {
            org.apache.spark.sql.catalyst.expressions.And and = (org.apache.spark.sql.catalyst.expressions.And)expression;
            Expression left = and.left();
            Expression right = and.right();
            option = this.translateFilterV2WithMapping(left, translatedFilterToExpr, nestedPredicatePushdownEnabled).flatMap((Function1 & Serializable)leftFilter -> MODULE$.translateFilterV2WithMapping(right, translatedFilterToExpr, nestedPredicatePushdownEnabled).map((Function1 & Serializable)rightFilter -> new And(leftFilter, rightFilter)));
        } else if (expression instanceof Or) {
            Or or = (Or)expression;
            Expression left = or.left();
            Expression right = or.right();
            option = this.translateFilterV2WithMapping(left, translatedFilterToExpr, nestedPredicatePushdownEnabled).flatMap((Function1 & Serializable)leftFilter -> MODULE$.translateFilterV2WithMapping(right, translatedFilterToExpr, nestedPredicatePushdownEnabled).map((Function1 & Serializable)rightFilter -> new org.apache.spark.sql.connector.expressions.filter.Or(leftFilter, rightFilter)));
        } else if (expression instanceof org.apache.spark.sql.catalyst.expressions.Not) {
            org.apache.spark.sql.catalyst.expressions.Not not = (org.apache.spark.sql.catalyst.expressions.Not)expression;
            Expression child = not.child();
            option = this.translateFilterV2WithMapping(child, translatedFilterToExpr, nestedPredicatePushdownEnabled).map((Function1 & Serializable)x$6 -> new Not(x$6));
        } else {
            Option filter = this.translateLeafNodeFilterV2(expression, nestedPredicatePushdownEnabled);
            if (filter.isDefined() && translatedFilterToExpr.isDefined()) {
                ((HashMap)translatedFilterToExpr.get()).update(filter.get(), (Object)predicate);
            }
            option = filter;
        }
        return option;
    }

    public Expression rebuildExpressionFromFilter(Predicate predicate, HashMap<Predicate, Expression> translatedFilterToExpr) {
        Expression expression;
        Predicate predicate2 = predicate;
        if (predicate2 instanceof And) {
            And and = (And)predicate2;
            expression = new org.apache.spark.sql.catalyst.expressions.And(this.rebuildExpressionFromFilter(and.left(), translatedFilterToExpr), this.rebuildExpressionFromFilter(and.right(), translatedFilterToExpr));
        } else if (predicate2 instanceof org.apache.spark.sql.connector.expressions.filter.Or) {
            org.apache.spark.sql.connector.expressions.filter.Or or = (org.apache.spark.sql.connector.expressions.filter.Or)predicate2;
            expression = new Or(this.rebuildExpressionFromFilter(or.left(), translatedFilterToExpr), this.rebuildExpressionFromFilter(or.right(), translatedFilterToExpr));
        } else if (predicate2 instanceof Not) {
            Not not = (Not)predicate2;
            expression = new org.apache.spark.sql.catalyst.expressions.Not(this.rebuildExpressionFromFilter(not.child(), translatedFilterToExpr));
        } else {
            expression = (Expression)translatedFilterToExpr.getOrElse((Object)predicate, (Function0 & Serializable)() -> {
                throw new IllegalStateException(new StringBuilder(41).append("Failed to rebuild Expression for filter: ").append(predicate).toString());
            });
        }
        return expression;
    }

    private DataSourceV2Strategy$() {
    }
}

