/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.orc;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.orc.OrcFile;
import org.apache.orc.Writer;
import org.apache.orc.mapred.OrcStruct;
import org.apache.orc.mapreduce.OrcMapreduceRecordWriter;
import org.apache.orc.mapreduce.OrcOutputFormat;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.orc.OrcSerializer;
import org.apache.spark.sql.execution.datasources.orc.OrcUtils$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005)4Qa\u0003\u0007\u0001%iA\u0001b\b\u0001\u0003\u0006\u0004%\t!\t\u0005\t_\u0001\u0011\t\u0011)A\u0005E!A\u0001\u0007\u0001B\u0001B\u0003%\u0011\u0007\u0003\u00058\u0001\t\u0005\t\u0015!\u00039\u0011\u0015\u0001\u0005\u0001\"\u0001B\u0011\u00199\u0005\u0001)A\u0005\u0011\"91\n\u0001b\u0001\n\u0013a\u0005BB-\u0001A\u0003%Q\nC\u0003[\u0001\u0011\u00053\fC\u0003i\u0001\u0011\u0005\u0013NA\bPe\u000e|U\u000f\u001e9vi^\u0013\u0018\u000e^3s\u0015\tia\"A\u0002pe\u000eT!a\u0004\t\u0002\u0017\u0011\fG/Y:pkJ\u001cWm\u001d\u0006\u0003#I\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005M!\u0012aA:rY*\u0011QCF\u0001\u0006gB\f'o\u001b\u0006\u0003/a\ta!\u00199bG\",'\"A\r\u0002\u0007=\u0014xm\u0005\u0002\u00017A\u0011A$H\u0007\u0002\u001d%\u0011aD\u0004\u0002\r\u001fV$\b/\u001e;Xe&$XM]\u0001\u0005a\u0006$\bn\u0001\u0001\u0016\u0003\t\u0002\"a\t\u0017\u000f\u0005\u0011R\u0003CA\u0013)\u001b\u00051#BA\u0014!\u0003\u0019a$o\\8u})\t\u0011&A\u0003tG\u0006d\u0017-\u0003\u0002,Q\u00051\u0001K]3eK\u001aL!!\f\u0018\u0003\rM#(/\u001b8h\u0015\tY\u0003&A\u0003qCRD\u0007%\u0001\u0006eCR\f7k\u00195f[\u0006\u0004\"AM\u001b\u000e\u0003MR!\u0001\u000e\n\u0002\u000bQL\b/Z:\n\u0005Y\u001a$AC*ueV\u001cG\u000fV=qK\u000691m\u001c8uKb$\bCA\u001d?\u001b\u0005Q$BA\u001e=\u0003%i\u0017\r\u001d:fIV\u001cWM\u0003\u0002>-\u00051\u0001.\u00193p_BL!a\u0010\u001e\u0003%Q\u000b7o[!ui\u0016l\u0007\u000f^\"p]R,\u0007\u0010^\u0001\u0007y%t\u0017\u000e\u001e \u0015\t\t#UI\u0012\t\u0003\u0007\u0002i\u0011\u0001\u0004\u0005\u0006?\u0015\u0001\rA\t\u0005\u0006a\u0015\u0001\r!\r\u0005\u0006o\u0015\u0001\r\u0001O\u0001\u000bg\u0016\u0014\u0018.\u00197ju\u0016\u0014\bCA\"J\u0013\tQEBA\u0007Pe\u000e\u001cVM]5bY&TXM]\u0001\re\u0016\u001cwN\u001d3Xe&$XM]\u000b\u0002\u001bB\u0019a*U*\u000e\u0003=S!a\u000f)\u000b\u000551\u0012B\u0001*P\u0005ay%oY'baJ,G-^2f%\u0016\u001cwN\u001d3Xe&$XM\u001d\t\u0003)^k\u0011!\u0016\u0006\u0003-B\u000ba!\\1qe\u0016$\u0017B\u0001-V\u0005%y%oY*ueV\u001cG/A\u0007sK\u000e|'\u000fZ,sSR,'\u000fI\u0001\u0006oJLG/\u001a\u000b\u00039\u0002\u0004\"!\u00180\u000e\u0003!J!a\u0018\u0015\u0003\tUs\u0017\u000e\u001e\u0005\u0006C&\u0001\rAY\u0001\u0004e><\bCA2g\u001b\u0005!'BA3\u0013\u0003!\u0019\u0017\r^1msN$\u0018BA4e\u0005-Ie\u000e^3s]\u0006d'k\\<\u0002\u000b\rdwn]3\u0015\u0003q\u0003")
public class OrcOutputWriter
extends OutputWriter {
    private final String path;
    private final TaskAttemptContext context;
    private final OrcSerializer serializer;
    private final OrcMapreduceRecordWriter<OrcStruct> recordWriter;

    @Override
    public String path() {
        return this.path;
    }

    private OrcMapreduceRecordWriter<OrcStruct> recordWriter() {
        return this.recordWriter;
    }

    @Override
    public void write(InternalRow row) {
        this.recordWriter().write(NullWritable.get(), (Writable)this.serializer.serialize(row));
    }

    @Override
    public void close() {
        this.recordWriter().close(this.context);
    }

    public OrcOutputWriter(String path, StructType dataSchema, TaskAttemptContext context) {
        this.path = path;
        this.context = context;
        this.serializer = new OrcSerializer(dataSchema);
        OrcOutputFormat<OrcStruct> orcOutputFormat = new OrcOutputFormat<OrcStruct>(this){
            private final /* synthetic */ OrcOutputWriter $outer;

            public Path getDefaultWorkFile(TaskAttemptContext context, String extension) {
                return new Path(this.$outer.path());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        Path filename = orcOutputFormat.getDefaultWorkFile(context, ".orc");
        OrcFile.WriterOptions options = org.apache.orc.mapred.OrcOutputFormat.buildOptions((Configuration)context.getConfiguration());
        options.setSchema(OrcUtils$.MODULE$.orcTypeDescription((DataType)dataSchema));
        Writer writer = OrcFile.createWriter((Path)filename, (OrcFile.WriterOptions)options);
        OrcMapreduceRecordWriter recordWriter = new OrcMapreduceRecordWriter(writer);
        OrcUtils$.MODULE$.addSparkVersionMetadata(writer);
        this.recordWriter = recordWriter;
    }
}

