/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar;

import java.nio.ByteBuffer;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.columnar.ByteBufferHelper$;
import org.apache.spark.sql.execution.columnar.ColumnType;
import org.apache.spark.sql.execution.columnar.MutableUnsafeRow;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.CalendarInterval;
import scala.runtime.BoxedUnit;

public final class CALENDAR_INTERVAL$
extends ColumnType<CalendarInterval> {
    public static final CALENDAR_INTERVAL$ MODULE$ = new CALENDAR_INTERVAL$();

    @Override
    public DataType dataType() {
        return CalendarIntervalType$.MODULE$;
    }

    @Override
    public int defaultSize() {
        return 16;
    }

    @Override
    public CalendarInterval getField(InternalRow row, int ordinal) {
        return row.getInterval(ordinal);
    }

    @Override
    public void setField(InternalRow row, int ordinal, CalendarInterval value) {
        row.setInterval(ordinal, value);
    }

    @Override
    public CalendarInterval extract(ByteBuffer buffer) {
        int months = ByteBufferHelper$.MODULE$.getInt(buffer);
        int days = ByteBufferHelper$.MODULE$.getInt(buffer);
        long microseconds = ByteBufferHelper$.MODULE$.getLong(buffer);
        return new CalendarInterval(months, days, microseconds);
    }

    @Override
    public void extract(ByteBuffer buffer, InternalRow row, int ordinal) {
        InternalRow internalRow = row;
        if (internalRow instanceof MutableUnsafeRow) {
            MutableUnsafeRow mutableUnsafeRow = (MutableUnsafeRow)internalRow;
            int cursor = buffer.position();
            buffer.position(cursor + this.defaultSize());
            mutableUnsafeRow.writer().write(ordinal, buffer.array(), buffer.arrayOffset() + cursor, this.defaultSize());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.setField(row, ordinal, this.extract(buffer));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    @Override
    public void append(CalendarInterval v, ByteBuffer buffer) {
        ByteBufferHelper$.MODULE$.putInt(buffer, v.months);
        ByteBufferHelper$.MODULE$.putInt(buffer, v.days);
        ByteBufferHelper$.MODULE$.putLong(buffer, v.microseconds);
    }

    private CALENDAR_INTERVAL$() {
    }
}

