/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.io.Serializable;
import java.sql.Connection;
import java.util.Locale;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions$;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcUtils$;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class PostgresDialect$
extends JdbcDialect {
    public static final PostgresDialect$ MODULE$ = new PostgresDialect$();

    @Override
    public boolean canHandle(String url) {
        return url.toLowerCase(Locale.ROOT).startsWith("jdbc:postgresql");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
        Some some;
        if (sqlType == 7) {
            some = new Some((Object)FloatType$.MODULE$);
            return some;
        }
        if (sqlType == 5) {
            some = new Some((Object)ShortType$.MODULE$);
            return some;
        }
        if (sqlType == -7) {
            String string = typeName;
            String string2 = "bit";
            if (!(string != null ? !string.equals(string2) : string2 != null) && size != 1) {
                some = new Some((Object)BinaryType$.MODULE$);
                return some;
            }
        }
        if (sqlType == 8) {
            String string = typeName;
            String string3 = "money";
            if (!(string != null ? !string.equals(string3) : string3 != null)) {
                some = new Some((Object)StringType$.MODULE$);
                return some;
            }
        }
        if (sqlType == 1111) {
            some = new Some((Object)StringType$.MODULE$);
            return some;
        }
        if (sqlType == 2003) {
            int scale = (int)md.build().getLong("scale");
            some = this.toCatalystType(StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(typeName), 1), size, scale).map((Function1 & Serializable)x$1 -> ArrayType$.MODULE$.apply(x$1));
            return some;
        }
        some = None$.MODULE$;
        return some;
    }

    private Option<DataType> toCatalystType(String typeName, int precision, int scale) {
        None$ none$;
        block59: {
            block46: {
                block58: {
                    block48: {
                        block54: {
                            block51: {
                                block57: {
                                    block47: {
                                        block50: {
                                            block49: {
                                                block53: {
                                                    block56: {
                                                        block55: {
                                                            block52: {
                                                                String string = typeName;
                                                                switch (string == null ? 0 : string.hashCode()) {
                                                                    case -2080719092: {
                                                                        if (!"pg_snapshot".equals(string)) break block46;
                                                                        break block47;
                                                                    }
                                                                    case -2000413939: {
                                                                        if (!"numeric".equals(string)) break block46;
                                                                        break block48;
                                                                    }
                                                                    case -1534143358: {
                                                                        if (!"tsvector".equals(string)) break block46;
                                                                        break block47;
                                                                    }
                                                                    case -1382823772: {
                                                                        if (!"bpchar".equals(string)) break block46;
                                                                        break block47;
                                                                    }
                                                                    case -1360216880: {
                                                                        if (!"circle".equals(string)) break block46;
                                                                        break block47;
                                                                    }
                                                                    case -1271649960: {
                                                                        if (!"float4".equals(string)) break block46;
                                                                        break block49;
                                                                    }
                                                                    case -1271649956: {
                                                                        if (!"float8".equals(string)) break block46;
                                                                        break block50;
                                                                    }
                                                                    case -1023458903: {
                                                                        if (!"tsquery".equals(string)) break block46;
                                                                        break block47;
                                                                    }
                                                                    case -990442113: {
                                                                        if (!"pg_lsn".equals(string)) break block46;
                                                                        break block47;
                                                                    }
                                                                    case -873668077: {
                                                                        if (!"timetz".equals(string)) break block46;
                                                                        break block51;
                                                                    }
                                                                    case -823652218: {
                                                                        if (!"varbit".equals(string)) break block46;
                                                                        break block47;
                                                                    }
                                                                    case -397519558: {
                                                                        if (!"polygon".equals(string)) break block46;
                                                                        break block47;
                                                                    }
                                                                    case -191744392: {
                                                                        if (!"macaddr8".equals(string)) break block46;
                                                                        break block47;
                                                                    }
                                                                    case 97549: {
                                                                        if (!"bit".equals(string)) break block46;
                                                                        break block52;
                                                                    }
                                                                    case 97739: {
                                                                        if (!"box".equals(string)) break block46;
                                                                        break block47;
                                                                    }
                                                                    case 110026: {
                                                                        if (!"oid".equals(string)) break block46;
                                                                        break block53;
                                                                    }
                                                                    case 118807: {
                                                                        if (!"xml".equals(string)) break block46;
                                                                        break block47;
                                                                    }
                                                                    case 3029738: {
                                                                        if ("bool".equals(string)) {
                                                                            break;
                                                                        }
                                                                        break block46;
                                                                    }
                                                                    case 3052374: {
                                                                        if (!"char".equals(string)) break block46;
                                                                        break block47;
                                                                    }
                                                                    case 3053428: {
                                                                        if (!"cidr".equals(string)) break block46;
                                                                        break block47;
                                                                    }
                                                                    case 3076014: {
                                                                        if (!"date".equals(string)) break block46;
                                                                        break block54;
                                                                    }
                                                                    case 3237012: {
                                                                        if (!"inet".equals(string)) break block46;
                                                                        break block47;
                                                                    }
                                                                    case 3237411: {
                                                                        if (!"int2".equals(string)) break block46;
                                                                        break block55;
                                                                    }
                                                                    case 3237413: {
                                                                        if (!"int4".equals(string)) break block46;
                                                                        break block56;
                                                                    }
                                                                    case 3237417: {
                                                                        if (!"int8".equals(string)) break block46;
                                                                        break block53;
                                                                    }
                                                                    case 3271912: {
                                                                        if (!"json".equals(string)) break block46;
                                                                        break block47;
                                                                    }
                                                                    case 3321844: {
                                                                        if (!"line".equals(string)) break block46;
                                                                        break block47;
                                                                    }
                                                                    case 3331177: {
                                                                        if (!"lseg".equals(string)) break block46;
                                                                        break block47;
                                                                    }
                                                                    case 3433509: {
                                                                        if (!"path".equals(string)) break block46;
                                                                        break block47;
                                                                    }
                                                                    case 3556653: {
                                                                        if (!"text".equals(string)) break block46;
                                                                        break block47;
                                                                    }
                                                                    case 3560141: {
                                                                        if (!"time".equals(string)) break block46;
                                                                        break block51;
                                                                    }
                                                                    case 3601339: {
                                                                        if (!"uuid".equals(string)) break block46;
                                                                        break block47;
                                                                    }
                                                                    case 55126294: {
                                                                        if (!"timestamp".equals(string)) break block46;
                                                                        break block51;
                                                                    }
                                                                    case 94224473: {
                                                                        if (!"bytea".equals(string)) break block46;
                                                                        break block57;
                                                                    }
                                                                    case 101429370: {
                                                                        if (!"jsonb".equals(string)) break block46;
                                                                        break block47;
                                                                    }
                                                                    case 104079552: {
                                                                        if (!"money".equals(string)) break block46;
                                                                        break block58;
                                                                    }
                                                                    case 106845584: {
                                                                        if (!"point".equals(string)) break block46;
                                                                        break block47;
                                                                    }
                                                                    case 236613373: {
                                                                        if (!"varchar".equals(string)) break block46;
                                                                        break block47;
                                                                    }
                                                                    case 570418373: {
                                                                        if (!"interval".equals(string)) break block46;
                                                                        break block47;
                                                                    }
                                                                    case 825098688: {
                                                                        if (!"macaddr".equals(string)) break block46;
                                                                        break block47;
                                                                    }
                                                                    case 1132592996: {
                                                                        if (!"txid_snapshot".equals(string)) break block46;
                                                                        break block47;
                                                                    }
                                                                    case 1436764700: {
                                                                        if (!"timestamptz".equals(string)) break block46;
                                                                        break block51;
                                                                    }
                                                                    case 1542263633: {
                                                                        if (!"decimal".equals(string)) break block46;
                                                                        break block48;
                                                                    }
                                                                    default: {
                                                                        break block46;
                                                                    }
                                                                }
                                                                none$ = new Some((Object)BooleanType$.MODULE$);
                                                                break block59;
                                                            }
                                                            none$ = new Some((Object)BinaryType$.MODULE$);
                                                            break block59;
                                                        }
                                                        none$ = new Some((Object)ShortType$.MODULE$);
                                                        break block59;
                                                    }
                                                    none$ = new Some((Object)IntegerType$.MODULE$);
                                                    break block59;
                                                }
                                                none$ = new Some((Object)LongType$.MODULE$);
                                                break block59;
                                            }
                                            none$ = new Some((Object)FloatType$.MODULE$);
                                            break block59;
                                        }
                                        none$ = new Some((Object)DoubleType$.MODULE$);
                                        break block59;
                                    }
                                    none$ = new Some((Object)StringType$.MODULE$);
                                    break block59;
                                }
                                none$ = new Some((Object)BinaryType$.MODULE$);
                                break block59;
                            }
                            none$ = new Some((Object)TimestampType$.MODULE$);
                            break block59;
                        }
                        none$ = new Some((Object)DateType$.MODULE$);
                        break block59;
                    }
                    none$ = precision > 0 ? new Some((Object)DecimalType$.MODULE$.bounded(precision, scale)) : new Some((Object)DecimalType$.MODULE$.SYSTEM_DEFAULT());
                    break block59;
                }
                none$ = None$.MODULE$;
                break block59;
            }
            none$ = None$.MODULE$;
        }
        return none$;
    }

    @Override
    public Option<JdbcType> getJDBCType(DataType dt) {
        Object object;
        DataType dataType = dt;
        if (StringType$.MODULE$.equals(dataType)) {
            object = new Some((Object)new JdbcType("TEXT", 1));
        } else if (BinaryType$.MODULE$.equals(dataType)) {
            object = new Some((Object)new JdbcType("BYTEA", -2));
        } else if (BooleanType$.MODULE$.equals(dataType)) {
            object = new Some((Object)new JdbcType("BOOLEAN", 16));
        } else if (FloatType$.MODULE$.equals(dataType)) {
            object = new Some((Object)new JdbcType("FLOAT4", 6));
        } else if (DoubleType$.MODULE$.equals(dataType)) {
            object = new Some((Object)new JdbcType("FLOAT8", 8));
        } else {
            boolean bl = ShortType$.MODULE$.equals(dataType) ? true : ByteType$.MODULE$.equals(dataType);
            if (bl) {
                object = new Some((Object)new JdbcType("SMALLINT", 5));
            } else if (dataType instanceof DecimalType) {
                DecimalType decimalType = (DecimalType)dataType;
                object = new Some((Object)new JdbcType(new StringBuilder(10).append("NUMERIC(").append(decimalType.precision()).append(",").append(decimalType.scale()).append(")").toString(), 2));
            } else {
                ArrayType arrayType;
                DataType et;
                object = dataType instanceof ArrayType && (et = (arrayType = (ArrayType)dataType).elementType()) instanceof AtomicType ? this.getJDBCType(et).map((Function1 & Serializable)x$2 -> x$2.databaseTypeDefinition()).orElse((Function0 & Serializable)() -> JdbcUtils$.MODULE$.getCommonJDBCType(et).map((Function1 & Serializable)x$3 -> x$3.databaseTypeDefinition())).map((Function1 & Serializable)typeName -> new JdbcType(new StringBuilder(2).append((String)typeName).append("[]").toString(), 2003)) : None$.MODULE$;
            }
        }
        return object;
    }

    @Override
    public String getTableExistsQuery(String table) {
        return new StringBuilder(22).append("SELECT 1 FROM ").append(table).append(" LIMIT 1").toString();
    }

    @Override
    public Option<Object> isCascadingTruncateTable() {
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    @Override
    public String getTruncateQuery(String table, Option<Object> cascade) {
        Some some;
        boolean bl;
        Option<Object> option = cascade;
        String string = option instanceof Some && (bl = BoxesRunTime.unboxToBoolean((Object)(some = (Some)option).value())) ? new StringBuilder(28).append("TRUNCATE TABLE ONLY ").append(table).append(" CASCADE").toString() : new StringBuilder(20).append("TRUNCATE TABLE ONLY ").append(table).toString();
        return string;
    }

    @Override
    public Option<Object> getTruncateQuery$default$2() {
        return this.isCascadingTruncateTable();
    }

    @Override
    public void beforeFetch(Connection connection, Map<String, String> properties) {
        block0: {
            super.beforeFetch(connection, properties);
            if (StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)properties.getOrElse((Object)JDBCOptions$.MODULE$.JDBC_BATCH_FETCH_SIZE(), (Function0 & Serializable)() -> "0"))) <= 0) break block0;
            connection.setAutoCommit(false);
        }
    }

    @Override
    public String getUpdateColumnTypeQuery(String tableName, String columnName, String newDataType) {
        return new StringBuilder(32).append("ALTER TABLE ").append(tableName).append(" ALTER COLUMN ").append(this.quoteIdentifier(columnName)).append(" TYPE ").append(newDataType).toString();
    }

    @Override
    public String getUpdateColumnNullabilityQuery(String tableName, String columnName, boolean isNullable) {
        String nullable = isNullable ? "DROP NOT NULL" : "SET NOT NULL";
        return new StringBuilder(27).append("ALTER TABLE ").append(tableName).append(" ALTER COLUMN ").append(this.quoteIdentifier(columnName)).append(" ").append(nullable).toString();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(PostgresDialect$.class);
    }

    private PostgresDialect$() {
    }
}

