/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.sql.SQLException;
import java.util.Locale;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.analysis.NoSuchNamespaceException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.jdbc.JdbcDialect;
import scala.Option;
import scala.Some;
import scala.runtime.ModuleSerializationProxy;

public final class H2Dialect$
extends JdbcDialect {
    public static final H2Dialect$ MODULE$ = new H2Dialect$();

    @Override
    public boolean canHandle(String url) {
        return url.toLowerCase(Locale.ROOT).startsWith("jdbc:h2");
    }

    @Override
    public AnalysisException classifyException(String message, Throwable e) {
        block5: {
            if (!(e instanceof SQLException)) break block5;
            int n = ((SQLException)e).getErrorCode();
            switch (n) {
                case 42101: {
                    throw new TableAlreadyExistsException(message, (Option)new Some((Object)e));
                }
                case 42102: {
                    throw new NoSuchTableException(message, (Option)new Some((Object)e));
                }
                case 90079: {
                    throw new NoSuchNamespaceException(message, (Option)new Some((Object)e));
                }
            }
        }
        return super.classifyException(message, e);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(H2Dialect$.class);
    }

    private H2Dialect$() {
    }
}

