/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2;

import java.io.Serializable;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.AttributeSet$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.expressions.SchemaPruning$;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateExpression;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.util.CharVarcharUtils$;
import org.apache.spark.sql.connector.expressions.FieldReference;
import org.apache.spark.sql.connector.expressions.FieldReference$;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.connector.expressions.aggregate.AggregateFunc;
import org.apache.spark.sql.connector.expressions.aggregate.Aggregation;
import org.apache.spark.sql.connector.read.Scan;
import org.apache.spark.sql.connector.read.ScanBuilder;
import org.apache.spark.sql.connector.read.SupportsPushDownAggregates;
import org.apache.spark.sql.connector.read.SupportsPushDownFilters;
import org.apache.spark.sql.connector.read.SupportsPushDownRequiredColumns;
import org.apache.spark.sql.execution.datasources.DataSourceStrategy$;
import org.apache.spark.sql.execution.datasources.PushableColumnWithoutNestedColumn$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class PushDownUtils$
implements PredicateHelper {
    public static final PushDownUtils$ MODULE$ = new PushDownUtils$();
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        AliasHelper.$init$((AliasHelper)MODULE$);
        Logging.$init$((Logging)MODULE$);
        PredicateHelper.$init$((PredicateHelper)MODULE$);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Option<Tuple2<Expression, LogicalPlan>> findExpressionAndTrackLineageDown(Expression exp, LogicalPlan plan) {
        return PredicateHelper.findExpressionAndTrackLineageDown$((PredicateHelper)this, (Expression)exp, (LogicalPlan)plan);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression buildBalancedPredicate(Seq<Expression> expressions, Function2<Expression, Expression, Expression> op) {
        return PredicateHelper.buildBalancedPredicate$((PredicateHelper)this, expressions, op);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public Option<Expression> extractPredicatesWithinOutputSet(Expression condition, AttributeSet outputSet) {
        return PredicateHelper.extractPredicatesWithinOutputSet$((PredicateHelper)this, (Expression)condition, (AttributeSet)outputSet);
    }

    public boolean isNullIntolerant(Expression expr) {
        return PredicateHelper.isNullIntolerant$((PredicateHelper)this, (Expression)expr);
    }

    public Seq<Attribute> outputWithNullability(Seq<Attribute> output, Seq<ExprId> nonNullAttrExprIds) {
        return PredicateHelper.outputWithNullability$((PredicateHelper)this, output, nonNullAttrExprIds);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public AttributeMap<Alias> getAliasMap(Project plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Project)plan);
    }

    public AttributeMap<Alias> getAliasMap(Aggregate plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Aggregate)plan);
    }

    public AttributeMap<Alias> getAliasMap(Seq<NamedExpression> exprs) {
        return AliasHelper.getAliasMap$((AliasHelper)this, exprs);
    }

    public Expression replaceAlias(Expression expr, AttributeMap<Alias> aliasMap2) {
        return AliasHelper.replaceAlias$((AliasHelper)this, (Expression)expr, aliasMap2);
    }

    public NamedExpression replaceAliasButKeepName(NamedExpression expr, AttributeMap<Alias> aliasMap2) {
        return AliasHelper.replaceAliasButKeepName$((AliasHelper)this, (NamedExpression)expr, aliasMap2);
    }

    public Expression trimAliases(Expression e) {
        return AliasHelper.trimAliases$((AliasHelper)this, (Expression)e);
    }

    public <T extends Expression> T trimNonTopLevelAliases(T e) {
        return (T)AliasHelper.trimNonTopLevelAliases$((AliasHelper)this, e);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Tuple2<Seq<Filter>, Seq<Expression>> pushFilters(ScanBuilder scanBuilder, Seq<Expression> filters) {
        Tuple2 tuple2;
        ScanBuilder scanBuilder2 = scanBuilder;
        if (scanBuilder2 instanceof SupportsPushDownFilters) {
            SupportsPushDownFilters supportsPushDownFilters = (SupportsPushDownFilters)scanBuilder2;
            HashMap translatedFilterToExpr = HashMap$.MODULE$.empty();
            ArrayBuffer translatedFilters = ArrayBuffer$.MODULE$.empty();
            ArrayBuffer untranslatableExprs = ArrayBuffer$.MODULE$.empty();
            filters.foreach((Function1 & Serializable)filterExpr -> {
                Option<Filter> translated = DataSourceStrategy$.MODULE$.translateFilterWithMapping((Expression)filterExpr, (Option<HashMap<Filter, Expression>>)new Some((Object)translatedFilterToExpr), true);
                return translated.isEmpty() ? (ArrayBuffer)untranslatableExprs.$plus$eq(filterExpr) : (ArrayBuffer)translatedFilters.$plus$eq(translated.get());
            });
            Expression[] postScanFilters = (Expression[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])supportsPushDownFilters.pushFilters((Filter[])translatedFilters.toArray(ClassTag$.MODULE$.apply(Filter.class)))), (Function1 & Serializable)filter -> DataSourceStrategy$.MODULE$.rebuildExpressionFromFilter((Filter)filter, (HashMap<Filter, Expression>)translatedFilterToExpr), ClassTag$.MODULE$.apply(Expression.class));
            tuple2 = new Tuple2((Object)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)supportsPushDownFilters.pushedFilters()), (Object)((IterableOnceOps)untranslatableExprs.$plus$plus((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])postScanFilters))).toSeq());
        } else {
            tuple2 = new Tuple2((Object)package$.MODULE$.Nil(), filters);
        }
        return tuple2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<Aggregation> pushAggregates(ScanBuilder scanBuilder, Seq<AggregateExpression> aggregates2, Seq<Expression> groupBy) {
        ScanBuilder scanBuilder2 = scanBuilder;
        if (!(scanBuilder2 instanceof SupportsPushDownAggregates)) return None$.MODULE$;
        SupportsPushDownAggregates supportsPushDownAggregates = (SupportsPushDownAggregates)scanBuilder2;
        if (!aggregates2.nonEmpty()) return None$.MODULE$;
        Seq translatedAggregates = (Seq)aggregates2.flatMap((Function1 & Serializable)aggregates -> DataSourceStrategy$.MODULE$.translateAggregate((AggregateExpression)aggregates));
        Seq translatedGroupBys = (Seq)groupBy.flatMap((Function1 & Serializable)e -> PushDownUtils$.columnAsString$1(e));
        if (translatedAggregates.length() != aggregates2.length()) return None$.MODULE$;
        if (translatedGroupBys.length() != groupBy.length()) {
            return None$.MODULE$;
        }
        Aggregation agg = new Aggregation((AggregateFunc[])translatedAggregates.toArray(ClassTag$.MODULE$.apply(AggregateFunc.class)), (NamedReference[])translatedGroupBys.toArray(ClassTag$.MODULE$.apply(NamedReference.class)));
        return new Some((Object)agg).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)supportsPushDownAggregates.pushAggregation(x$1)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Tuple2<Scan, Seq<AttributeReference>> pruneColumns(ScanBuilder scanBuilder, DataSourceV2Relation relation, Seq<NamedExpression> projects, Seq<Expression> filters) {
        Seq exprs = (Seq)projects.$plus$plus(filters);
        AttributeSet requiredColumns = AttributeSet$.MODULE$.apply((Iterable)exprs.flatMap((Function1 & Serializable)x$1 -> x$1.references()));
        Seq neededOutput = (Seq)relation.output().filter((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)requiredColumns.contains(elem)));
        boolean bl = false;
        SupportsPushDownRequiredColumns supportsPushDownRequiredColumns = null;
        ScanBuilder scanBuilder2 = scanBuilder;
        if (scanBuilder2 instanceof SupportsPushDownRequiredColumns) {
            bl = true;
            supportsPushDownRequiredColumns = (SupportsPushDownRequiredColumns)scanBuilder2;
            if (SQLConf$.MODULE$.get().nestedSchemaPruningEnabled()) {
                Seq rootFields = SchemaPruning$.MODULE$.identifyRootFields(projects, filters);
                StructType prunedSchema = rootFields.nonEmpty() ? SchemaPruning$.MODULE$.pruneDataSchema(relation.schema(), rootFields) : new StructType();
                Set neededFieldNames = ((IterableOnceOps)neededOutput.map((Function1 & Serializable)x$2 -> x$2.name())).toSet();
                supportsPushDownRequiredColumns.pruneColumns(StructType$.MODULE$.apply((Seq)prunedSchema.filter((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)neededFieldNames.contains((Object)f.name())))));
                Scan scan = supportsPushDownRequiredColumns.build();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)scan), this.toOutputAttrs(scan.readSchema(), relation));
            }
        }
        if (!bl) return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)scanBuilder.build()), (Object)relation.output());
        supportsPushDownRequiredColumns.pruneColumns(org.apache.spark.sql.catalyst.expressions.package$.MODULE$.AttributeSeq(neededOutput).toStructType());
        Scan scan = supportsPushDownRequiredColumns.build();
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)scan), this.toOutputAttrs(scan.readSchema(), relation));
    }

    private Seq<AttributeReference> toOutputAttrs(StructType schema, DataSourceV2Relation relation) {
        Map nameToAttr = ((IterableOnceOps)((IterableOps)relation.output().map((Function1 & Serializable)x$3 -> x$3.name())).zip((IterableOnce)relation.output())).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        StructType cleaned = CharVarcharUtils$.MODULE$.replaceCharVarcharWithStringInSchema(schema);
        return (Seq)cleaned.toAttributes().map((Function1 & Serializable)a -> a.withExprId(((AttributeReference)nameToAttr.apply((Object)a.name())).exprId()));
    }

    private static final Option columnAsString$1(Expression e) {
        None$ none$;
        Option<String> option;
        Expression expression = e;
        if (expression != null && !(option = PushableColumnWithoutNestedColumn$.MODULE$.unapply(expression)).isEmpty()) {
            String name = (String)option.get();
            none$ = new Some((Object)((FieldReference)FieldReference$.MODULE$.column(name)));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private PushDownUtils$() {
    }
}

