/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Locale;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkUpgradeException;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogUtils$;
import org.apache.spark.sql.catalyst.util.RebaseDateTime;
import org.apache.spark.sql.catalyst.util.RebaseDateTime$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.parquet.ParquetOptions$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.package$;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.apache.spark.util.Utils$;
import org.json4s.Formats;
import org.json4s.NoTypeHints$;
import org.json4s.TypeHints;
import org.json4s.jackson.Serialization$;
import scala.;
import scala.$less$colon$less$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.Set;
import scala.collection.SetOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class DataSourceUtils$ {
    public static final DataSourceUtils$ MODULE$ = new DataSourceUtils$();
    private static final String PARTITIONING_COLUMNS_KEY = "__partition_columns";
    private static final Formats formats = Serialization$.MODULE$.formats((TypeHints)NoTypeHints$.MODULE$);

    public String PARTITIONING_COLUMNS_KEY() {
        return PARTITIONING_COLUMNS_KEY;
    }

    private Formats formats() {
        return formats;
    }

    public String encodePartitioningColumns(Seq<String> columns) {
        return Serialization$.MODULE$.write(columns, this.formats());
    }

    public Seq<String> decodePartitioningColumns(String str) {
        return (Seq)Serialization$.MODULE$.read(str, this.formats(), ManifestFactory$.MODULE$.classType(Seq.class, ManifestFactory$.MODULE$.classType(String.class), (Seq)Nil$.MODULE$));
    }

    public void checkFieldNames(FileFormat format, StructType schema) {
        schema.foreach((Function1 & Serializable)field -> {
            DataSourceUtils$.$anonfun$checkFieldNames$1(format, field);
            return BoxedUnit.UNIT;
        });
    }

    public void verifySchema(FileFormat format, StructType schema) {
        schema.foreach((Function1 & Serializable)field -> {
            DataSourceUtils$.$anonfun$verifySchema$1(format, field);
            return BoxedUnit.UNIT;
        });
        this.checkFieldNames(format, schema);
    }

    public boolean isDataPath(Path path) {
        return this.isDataFile(path.getName());
    }

    public boolean isDataFile(String fileName) {
        return !fileName.startsWith("_") && !fileName.startsWith(".");
    }

    public boolean supportNestedPredicatePushdown(BaseRelation relation) {
        boolean bl;
        BaseRelation baseRelation = relation;
        if (baseRelation instanceof HadoopFsRelation) {
            HadoopFsRelation hadoopFsRelation = (HadoopFsRelation)baseRelation;
            Seq supportedDatasources = Utils$.MODULE$.stringToSeq(((String)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.NESTED_PREDICATE_PUSHDOWN_FILE_SOURCE_LIST())).toLowerCase(Locale.ROOT));
            bl = supportedDatasources.contains((Object)hadoopFsRelation.toString());
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    private RebaseDateTime.RebaseSpec getRebaseSpec(Function1<String, String> lookupFileMeta, String modeByConfig, String minVersion, String metadataKey) {
        if (!Utils$.MODULE$.isTesting()) ** GOTO lbl-1000
        v0 = SQLConf$.MODULE$.get().getConfString("spark.test.forceNoRebase", "");
        var7_5 = "true";
        if (!(v0 != null ? v0.equals(var7_5) == false : var7_5 != null)) {
            v1 = SQLConf.LegacyBehaviorPolicy$.MODULE$.CORRECTED();
        } else lbl-1000:
        // 2 sources

        {
            v1 = (Enumeration.Value)Option$.MODULE$.apply(lookupFileMeta.apply((Object)package$.MODULE$.SPARK_VERSION_METADATA_KEY())).map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$getRebaseSpec$1(java.lang.String scala.Function1 java.lang.String java.lang.String ), (Ljava/lang/String;)Lscala/Enumeration$Value;)((String)minVersion, lookupFileMeta, (String)metadataKey)).getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$getRebaseSpec$2(java.lang.String ), ()Lscala/Enumeration$Value;)((String)modeByConfig));
        }
        var8_7 = policy = v1;
        v2 = SQLConf.LegacyBehaviorPolicy$.MODULE$.LEGACY();
        var9_8 = var8_7;
        var5_9 = !(v2 != null ? v2.equals(var9_8) == false : var9_8 != null) ? new RebaseDateTime.RebaseSpec(SQLConf.LegacyBehaviorPolicy$.MODULE$.LEGACY(), Option$.MODULE$.apply(lookupFileMeta.apply((Object)package$.MODULE$.SPARK_TIMEZONE_METADATA_KEY()))) : new RebaseDateTime.RebaseSpec(policy, RebaseDateTime.RebaseSpec$.MODULE$.apply$default$2());
        return var5_9;
    }

    public RebaseDateTime.RebaseSpec datetimeRebaseSpec(Function1<String, String> lookupFileMeta, String modeByConfig) {
        return this.getRebaseSpec(lookupFileMeta, modeByConfig, "3.0.0", package$.MODULE$.SPARK_LEGACY_DATETIME_METADATA_KEY());
    }

    public RebaseDateTime.RebaseSpec int96RebaseSpec(Function1<String, String> lookupFileMeta, String modeByConfig) {
        return this.getRebaseSpec(lookupFileMeta, modeByConfig, "3.1.0", package$.MODULE$.SPARK_LEGACY_INT96_METADATA_KEY());
    }

    public SparkUpgradeException newRebaseExceptionInRead(String format) {
        Tuple2 tuple2;
        block10: {
            block7: {
                block8: {
                    block9: {
                        String string = format;
                        switch (string == null ? 0 : string.hashCode()) {
                            case -2017918496: {
                                if ("Parquet INT96".equals(string)) {
                                    break;
                                }
                                break block7;
                            }
                            case 2053458: {
                                if (!"Avro".equals(string)) break block7;
                                break block8;
                            }
                            case 871641556: {
                                if (!"Parquet".equals(string)) break block7;
                                break block9;
                            }
                            default: {
                                break block7;
                            }
                        }
                        tuple2 = new Tuple2((Object)SQLConf$.MODULE$.PARQUET_INT96_REBASE_MODE_IN_READ().key(), (Object)ParquetOptions$.MODULE$.INT96_REBASE_MODE());
                        break block10;
                    }
                    tuple2 = new Tuple2((Object)SQLConf$.MODULE$.PARQUET_REBASE_MODE_IN_READ().key(), (Object)ParquetOptions$.MODULE$.DATETIME_REBASE_MODE());
                    break block10;
                }
                tuple2 = new Tuple2((Object)SQLConf$.MODULE$.AVRO_REBASE_MODE_IN_READ().key(), (Object)"datetimeRebaseMode");
                break block10;
            }
            throw QueryExecutionErrors$.MODULE$.unrecognizedFileFormatError(format);
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        String config = (String)tuple22._1();
        String option = (String)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)config, (Object)option);
        Tuple2 tuple24 = tuple23;
        String config2 = (String)tuple24._1();
        String option2 = (String)tuple24._2();
        return QueryExecutionErrors$.MODULE$.sparkUpgradeInReadingDatesError(format, config2, option2);
    }

    public SparkUpgradeException newRebaseExceptionInWrite(String format) {
        String string;
        block9: {
            block6: {
                block7: {
                    block8: {
                        String string2 = format;
                        switch (string2 == null ? 0 : string2.hashCode()) {
                            case -2017918496: {
                                if ("Parquet INT96".equals(string2)) {
                                    break;
                                }
                                break block6;
                            }
                            case 2053458: {
                                if (!"Avro".equals(string2)) break block6;
                                break block7;
                            }
                            case 871641556: {
                                if (!"Parquet".equals(string2)) break block6;
                                break block8;
                            }
                            default: {
                                break block6;
                            }
                        }
                        string = SQLConf$.MODULE$.PARQUET_INT96_REBASE_MODE_IN_WRITE().key();
                        break block9;
                    }
                    string = SQLConf$.MODULE$.PARQUET_REBASE_MODE_IN_WRITE().key();
                    break block9;
                }
                string = SQLConf$.MODULE$.AVRO_REBASE_MODE_IN_WRITE().key();
                break block9;
            }
            throw QueryExecutionErrors$.MODULE$.unrecognizedFileFormatError(format);
        }
        String config = string;
        return QueryExecutionErrors$.MODULE$.sparkUpgradeInWritingDatesError(format, config);
    }

    public Function1<Object, Object> createDateRebaseFuncInRead(Enumeration.Value rebaseMode, String format) {
        JFunction1.mcII.sp & Serializable intersect;
        Enumeration.Value value = rebaseMode;
        Enumeration.Value value2 = SQLConf.LegacyBehaviorPolicy$.MODULE$.EXCEPTION();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            intersect = (JFunction1.mcII.sp & Serializable)days -> {
                if (days < RebaseDateTime$.MODULE$.lastSwitchJulianDay()) {
                    throw MODULE$.newRebaseExceptionInRead(format);
                }
                return days;
            };
        } else {
            Enumeration.Value value4 = SQLConf.LegacyBehaviorPolicy$.MODULE$.LEGACY();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                intersect = (JFunction1.mcII.sp & Serializable)days -> RebaseDateTime$.MODULE$.rebaseJulianToGregorianDays(days);
            } else {
                Enumeration.Value value6 = SQLConf.LegacyBehaviorPolicy$.MODULE$.CORRECTED();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    intersect = (JFunction1.mcII.sp & Serializable)x -> BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToInteger((int)x)));
                } else {
                    throw new MatchError((Object)value);
                }
            }
        }
        return intersect;
    }

    public Function1<Object, Object> createDateRebaseFuncInWrite(Enumeration.Value rebaseMode, String format) {
        JFunction1.mcII.sp & Serializable intersect;
        Enumeration.Value value = rebaseMode;
        Enumeration.Value value2 = SQLConf.LegacyBehaviorPolicy$.MODULE$.EXCEPTION();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            intersect = (JFunction1.mcII.sp & Serializable)days -> {
                if (days < RebaseDateTime$.MODULE$.lastSwitchGregorianDay()) {
                    throw MODULE$.newRebaseExceptionInWrite(format);
                }
                return days;
            };
        } else {
            Enumeration.Value value4 = SQLConf.LegacyBehaviorPolicy$.MODULE$.LEGACY();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                intersect = (JFunction1.mcII.sp & Serializable)days -> RebaseDateTime$.MODULE$.rebaseGregorianToJulianDays(days);
            } else {
                Enumeration.Value value6 = SQLConf.LegacyBehaviorPolicy$.MODULE$.CORRECTED();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    intersect = (JFunction1.mcII.sp & Serializable)x -> BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToInteger((int)x)));
                } else {
                    throw new MatchError((Object)value);
                }
            }
        }
        return intersect;
    }

    public Function1<Object, Object> createTimestampRebaseFuncInRead(RebaseDateTime.RebaseSpec rebaseSpec, String format) {
        JFunction1.mcJJ.sp & Serializable intersect;
        Enumeration.Value value = rebaseSpec.mode();
        Enumeration.Value value2 = SQLConf.LegacyBehaviorPolicy$.MODULE$.EXCEPTION();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            intersect = (JFunction1.mcJJ.sp & Serializable)micros -> {
                if (micros < RebaseDateTime$.MODULE$.lastSwitchJulianTs()) {
                    throw MODULE$.newRebaseExceptionInRead(format);
                }
                return micros;
            };
        } else {
            Enumeration.Value value4 = SQLConf.LegacyBehaviorPolicy$.MODULE$.LEGACY();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                intersect = (JFunction1.mcJJ.sp & Serializable)x$2 -> RebaseDateTime$.MODULE$.rebaseJulianToGregorianMicros(rebaseSpec.timeZone(), x$2);
            } else {
                Enumeration.Value value6 = SQLConf.LegacyBehaviorPolicy$.MODULE$.CORRECTED();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    intersect = (JFunction1.mcJJ.sp & Serializable)x -> BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToLong((long)x)));
                } else {
                    throw new MatchError((Object)value);
                }
            }
        }
        return intersect;
    }

    public Function1<Object, Object> createTimestampRebaseFuncInWrite(Enumeration.Value rebaseMode, String format) {
        JFunction1.mcJJ.sp & Serializable intersect;
        Enumeration.Value value = rebaseMode;
        Enumeration.Value value2 = SQLConf.LegacyBehaviorPolicy$.MODULE$.EXCEPTION();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            intersect = (JFunction1.mcJJ.sp & Serializable)micros -> {
                if (micros < RebaseDateTime$.MODULE$.lastSwitchGregorianTs()) {
                    throw MODULE$.newRebaseExceptionInWrite(format);
                }
                return micros;
            };
        } else {
            Enumeration.Value value4 = SQLConf.LegacyBehaviorPolicy$.MODULE$.LEGACY();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                String timeZone = SQLConf$.MODULE$.get().sessionLocalTimeZone();
                intersect = (JFunction1.mcJJ.sp & Serializable)x$3 -> RebaseDateTime$.MODULE$.rebaseGregorianToJulianMicros(timeZone, x$3);
            } else {
                Enumeration.Value value6 = SQLConf.LegacyBehaviorPolicy$.MODULE$.CORRECTED();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    intersect = (JFunction1.mcJJ.sp & Serializable)x -> BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToLong((long)x)));
                } else {
                    throw new MatchError((Object)value);
                }
            }
        }
        return intersect;
    }

    public Map<String, String> generateDatasourceOptions(CaseInsensitiveStringMap extraOptions, CatalogTable table) {
        Map map;
        Option pathOption = table.storage().locationUri().map((Function1 & Serializable)x$4 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)CatalogUtils$.MODULE$.URIToString(x$4)));
        Map options = (Map)table.storage().properties().$plus$plus((IterableOnce)pathOption);
        if (!BoxesRunTime.unboxToBoolean((Object)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.LEGACY_EXTRA_OPTIONS_BEHAVIOR()))) {
            table.storage().properties().foreach((Function1 & Serializable)x0$1 -> {
                DataSourceUtils$.$anonfun$generateDatasourceOptions$2(extraOptions, table, x0$1);
                return BoxedUnit.UNIT;
            });
            scala.collection.immutable.Set lowerCasedDuplicatedKeys = (scala.collection.immutable.Set)((SetOps)table.storage().properties().keySet().map((Function1 & Serializable)x$5 -> x$5.toLowerCase(Locale.ROOT))).intersect((Set)JavaConverters$.MODULE$.asScalaSetConverter(extraOptions.keySet()).asScala());
            map = (Map)((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(extraOptions.asCaseSensitiveMap()).asScala()).filterNot((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)DataSourceUtils$.$anonfun$generateDatasourceOptions$4(lowerCasedDuplicatedKeys, x0$2)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).$plus$plus((IterableOnce)options);
        } else {
            map = options;
        }
        return map;
    }

    public static final /* synthetic */ void $anonfun$checkFieldNames$1(FileFormat format$1, StructField field) {
        if (!format$1.supportFieldName(field.name())) {
            throw QueryCompilationErrors$.MODULE$.columnNameContainsInvalidCharactersError(field.name());
        }
        DataType dataType = field.dataType();
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            MODULE$.checkFieldNames(format$1, structType);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$verifySchema$1(FileFormat format$2, StructField field) {
        if (!format$2.supportDataType(field.dataType())) {
            throw QueryCompilationErrors$.MODULE$.dataTypeUnsupportedByDataSourceError(format$2.toString(), field);
        }
    }

    public static final /* synthetic */ Enumeration.Value $anonfun$getRebaseSpec$1(String minVersion$1, Function1 lookupFileMeta$1, String metadataKey$1, String version) {
        return StringOps$.MODULE$.$less$extension(Predef$.MODULE$.augmentString(version), minVersion$1) || lookupFileMeta$1.apply((Object)metadataKey$1) != null ? SQLConf.LegacyBehaviorPolicy$.MODULE$.LEGACY() : SQLConf.LegacyBehaviorPolicy$.MODULE$.CORRECTED();
    }

    public static final /* synthetic */ Enumeration.Value $anonfun$getRebaseSpec$2(String modeByConfig$1) {
        return SQLConf.LegacyBehaviorPolicy$.MODULE$.withName(modeByConfig$1);
    }

    public static final /* synthetic */ void $anonfun$generateDatasourceOptions$2(CaseInsensitiveStringMap extraOptions$1, CatalogTable table$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            if (extraOptions$1.containsKey((Object)k)) {
                String string = extraOptions$1.get((Object)k);
                String string2 = v;
                if (string == null ? string2 != null : !string.equals(string2)) {
                    throw QueryCompilationErrors$.MODULE$.failToResolveDataSourceForTableError(table$1, k);
                }
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$generateDatasourceOptions$4(scala.collection.immutable.Set lowerCasedDuplicatedKeys$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String k = (String)tuple2._1();
        boolean bl = lowerCasedDuplicatedKeys$1.contains((Object)k.toLowerCase(Locale.ROOT));
        return bl;
    }

    private DataSourceUtils$() {
    }
}

