/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.UUID;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.QueryPlanningTracker;
import org.apache.spark.sql.catalyst.QueryPlanningTracker$;
import org.apache.spark.sql.catalyst.analysis.UnsupportedOperationChecker$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.QueryPlan$;
import org.apache.spark.sql.catalyst.plans.logical.AppendData;
import org.apache.spark.sql.catalyst.plans.logical.CTERelationDef;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.CommandResult;
import org.apache.spark.sql.catalyst.plans.logical.CreateTableAsSelect;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.OverwriteByExpression;
import org.apache.spark.sql.catalyst.plans.logical.OverwritePartitionsDynamic;
import org.apache.spark.sql.catalyst.plans.logical.ReplaceTableAsSelect;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.StringUtils;
import org.apache.spark.sql.execution.CodegenMode$;
import org.apache.spark.sql.execution.CollectMetricsExec$;
import org.apache.spark.sql.execution.CommandExecutionMode$;
import org.apache.spark.sql.execution.CostMode$;
import org.apache.spark.sql.execution.ExplainMode;
import org.apache.spark.sql.execution.ExplainUtils$;
import org.apache.spark.sql.execution.ExtendedMode$;
import org.apache.spark.sql.execution.FormattedMode$;
import org.apache.spark.sql.execution.QueryExecution$;
import org.apache.spark.sql.execution.QueryExecution$debug$;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.execution.SQLExecutionRDD;
import org.apache.spark.sql.execution.SimpleMode$;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.SparkPlanner;
import org.apache.spark.sql.execution.adaptive.AdaptiveExecutionContext;
import org.apache.spark.sql.execution.adaptive.InsertAdaptiveSparkPlan;
import org.apache.spark.sql.execution.debug.package$;
import org.apache.spark.sql.execution.streaming.IncrementalExecution;
import org.apache.spark.sql.execution.streaming.OffsetSeqMetadata;
import org.apache.spark.sql.execution.streaming.OffsetSeqMetadata$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0005\rUc\u0001B\"E\u0001=C\u0001\u0002\u0018\u0001\u0003\u0006\u0004%\t!\u0018\u0005\tE\u0002\u0011\t\u0011)A\u0005=\"A1\r\u0001BC\u0002\u0013\u0005A\r\u0003\u0005o\u0001\t\u0005\t\u0015!\u0003f\u0011!y\u0007A!b\u0001\n\u0003\u0001\b\u0002C;\u0001\u0005\u0003\u0005\u000b\u0011B9\t\u0011Y\u0004!Q1A\u0005\u0002]D\u0011\"a\u0001\u0001\u0005\u0003\u0005\u000b\u0011\u0002=\t\u000f\u0005\u0015\u0001\u0001\"\u0001\u0002\b!I\u00111\u0003\u0001C\u0002\u0013\u0005\u0011Q\u0003\u0005\t\u0003;\u0001\u0001\u0015!\u0003\u0002\u0018!9\u0011q\u0004\u0001\u0005\u0012\u0005\u0005\u0002\"CA\u0015\u0001\t\u0007I\u0011BA\u0016\u0011!\t\u0019\u0005\u0001Q\u0001\n\u00055\u0002bBA#\u0001\u0011\u0005\u0011q\t\u0005\b\u0003W\u0002A\u0011AA7\u0011\u001d\t)\b\u0001C\u0001\u0003[B\u0011\"a\u001e\u0001\u0011\u000b\u0007I\u0011\u00013\t\u0013\u0005e\u0004\u0001#b\u0001\n\u0003!\u0007bBA>\u0001\u0011%\u0011Q\u0010\u0005\b\u0003?\u0003A\u0011BAQ\u0011%\t9\u000b\u0001EC\u0002\u0013\u0005A\rC\u0004\u0002*\u0002!\t!!\u001c\t\u0013\u0005-\u0006\u0001#b\u0001\n\u0003!\u0007bBAW\u0001\u0011%\u0011Q\u000e\u0005\u000b\u0003_\u0003\u0001R1A\u0005\u0002\u0005E\u0006BCA]\u0001!\u0015\r\u0011\"\u0001\u00022\"Q\u00111\u0018\u0001\t\u0006\u0004%\t!!0\t\u000f\u0005E\u0007\u0001\"\u0001\u0002T\"9\u0011\u0011\u001d\u0001\u0005\u0012\u0005\r\bb\u0002B\u0002\u0001\u0011E!Q\u0001\u0005\b\u00053\u0001A\u0011\u0001B\u000e\u0011\u001d\u0011I\u0002\u0001C\u0005\u0005;AqA!\u0010\u0001\t\u0003\u0011y\u0004C\u0004\u0003>\u0001!IA!\u0013\t\u000f\tE\u0003\u0001\"\u0003\u0003T!9!\u0011\f\u0001\u0005B\tm\u0003b\u0002B-\u0001\u0011%!Q\f\u0005\b\u0005G\u0002A\u0011\u0001B\u000e\u0011\u001d\u0011\u0019\u0007\u0001C\u0005\u0005KBqAa\u001b\u0001\t\u0013\u0011igB\u0004\u0003t\u0001A\tA!\u001e\u0007\u000f\te\u0004\u0001#\u0001\u0003|!9\u0011QA\u0016\u0005\u0002\tu\u0004b\u0002B@W\u0011\u0005\u0011Q\u000e\u0005\b\u0005\u0003[C\u0011\u0001BB\u0011\u001d\u0011Yj\u000bC\u0001\u0005;C\u0011Ba,,#\u0003%\tA!-\t\u0013\t\u001d7&%A\u0005\u0002\t%wa\u0002Bg\t\"\u0005!q\u001a\u0004\u0007\u0007\u0012C\tA!5\t\u000f\u0005\u00151\u0007\"\u0001\u0003T\"I!Q[\u001aC\u0002\u0013%!q\u001b\u0005\t\u0005c\u001c\u0004\u0015!\u0003\u0003Z\"9!1_\u001a\u0005\n\u0005U\u0001\u0002CAqg\u0011\u0005AI!>\t\u0015\r=1'%A\u0005\u0002\u0011\u001b\t\u0002\u0003\u0005\u0004\u0016M\"\t\u0001RB\f\u0011\u001d\u0019yb\rC\u0001\u0007CAqa!\u000b4\t\u0003\u0019Y\u0003C\u0004\u0004*M\"\ta!\r\t\u0013\r]2G1A\u0005\n\re\u0002\u0002CB$g\u0001\u0006Iaa\u000f\t\u000f\u0005%2\u0007\"\u0001\u0002,!I1\u0011J\u001a\u0012\u0002\u0013\u000511\n\u0005\n\u0007\u001f\u001a\u0014\u0013!C\u0001\u0007#\u0012a\"U;fef,\u00050Z2vi&|gN\u0003\u0002F\r\u0006IQ\r_3dkRLwN\u001c\u0006\u0003\u000f\"\u000b1a]9m\u0015\tI%*A\u0003ta\u0006\u00148N\u0003\u0002L\u0019\u00061\u0011\r]1dQ\u0016T\u0011!T\u0001\u0004_J<7\u0001A\n\u0004\u0001A3\u0006CA)U\u001b\u0005\u0011&\"A*\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0013&AB!osJ+g\r\u0005\u0002X56\t\u0001L\u0003\u0002Z\u0011\u0006A\u0011N\u001c;fe:\fG.\u0003\u0002\\1\n9Aj\\4hS:<\u0017\u0001D:qCJ\\7+Z:tS>tW#\u00010\u0011\u0005}\u0003W\"\u0001$\n\u0005\u00054%\u0001D*qCJ\\7+Z:tS>t\u0017!D:qCJ\\7+Z:tS>t\u0007%A\u0004m_\u001eL7-\u00197\u0016\u0003\u0015\u0004\"A\u001a7\u000e\u0003\u001dT!a\u00195\u000b\u0005%T\u0017!\u00029mC:\u001c(BA6G\u0003!\u0019\u0017\r^1msN$\u0018BA7h\u0005-aunZ5dC2\u0004F.\u00198\u0002\u00111|w-[2bY\u0002\nq\u0001\u001e:bG.,'/F\u0001r!\t\u00118/D\u0001k\u0013\t!(N\u0001\u000bRk\u0016\u0014\u0018\u0010\u00157b]:Lgn\u001a+sC\u000e\\WM]\u0001\tiJ\f7m[3sA\u0005!Qn\u001c3f+\u0005A\bCA=~\u001d\tQ80D\u0001E\u0013\taH)\u0001\u000bD_6l\u0017M\u001c3Fq\u0016\u001cW\u000f^5p]6{G-Z\u0005\u0003}~\u0014QAV1mk\u0016L1!!\u0001S\u0005-)e.^7fe\u0006$\u0018n\u001c8\u0002\u000b5|G-\u001a\u0011\u0002\rqJg.\u001b;?))\tI!a\u0003\u0002\u000e\u0005=\u0011\u0011\u0003\t\u0003u\u0002AQ\u0001X\u0005A\u0002yCQaY\u0005A\u0002\u0015Dqa\\\u0005\u0011\u0002\u0003\u0007\u0011\u000fC\u0004w\u0013A\u0005\t\u0019\u0001=\u0002\u0005%$WCAA\f!\r\t\u0016\u0011D\u0005\u0004\u00037\u0011&\u0001\u0002'p]\u001e\f1!\u001b3!\u0003\u001d\u0001H.\u00198oKJ,\"!a\t\u0011\u0007i\f)#C\u0002\u0002(\u0011\u0013Ab\u00159be.\u0004F.\u00198oKJ\faa\u0019;f\u001b\u0006\u0004XCAA\u0017!!\ty#!\u000f\u0002\u0018\u0005uRBAA\u0019\u0015\u0011\t\u0019$!\u000e\u0002\u000f5,H/\u00192mK*\u0019\u0011q\u0007*\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002<\u0005E\"a\u0002%bg\"l\u0015\r\u001d\t\u0004M\u0006}\u0012bAA!O\nq1\tV#SK2\fG/[8o\t\u00164\u0017aB2uK6\u000b\u0007\u000fI\u0001\u000bo&$\bn\u0011;f\u001b\u0006\u0004X\u0003BA%\u0003\u001f\"B!a\u0013\u0002bA!\u0011QJA(\u0019\u0001!q!!\u0015\u0010\u0005\u0004\t\u0019FA\u0001U#\u0011\t)&a\u0017\u0011\u0007E\u000b9&C\u0002\u0002ZI\u0013qAT8uQ&tw\rE\u0002R\u0003;J1!a\u0018S\u0005\r\te.\u001f\u0005\t\u0003GzA\u00111\u0001\u0002f\u0005\ta\rE\u0003R\u0003O\nY%C\u0002\u0002jI\u0013\u0001\u0002\u00102z]\u0006lWMP\u0001\u000fCN\u001cXM\u001d;B]\u0006d\u0017P_3e)\t\ty\u0007E\u0002R\u0003cJ1!a\u001dS\u0005\u0011)f.\u001b;\u0002\u001f\u0005\u001c8/\u001a:u'V\u0004\bo\u001c:uK\u0012\f\u0001\"\u00198bYfTX\rZ\u0001\u0010G>lW.\u00198e\u000bb,7-\u001e;fI\u0006!2m\\7nC:$W\t_3dkRLwN\u001c(b[\u0016$B!a \u0002\u0016B!\u0011\u0011QAH\u001d\u0011\t\u0019)a#\u0011\u0007\u0005\u0015%+\u0004\u0002\u0002\b*\u0019\u0011\u0011\u0012(\u0002\rq\u0012xn\u001c;?\u0013\r\tiIU\u0001\u0007!J,G-\u001a4\n\t\u0005E\u00151\u0013\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u00055%\u000bC\u0004\u0002\u0018R\u0001\r!!'\u0002\u000f\r|W.\\1oIB\u0019a-a'\n\u0007\u0005uuMA\u0004D_6l\u0017M\u001c3\u0002-\u0015\fw-\u001a:ms\u0016CXmY;uK\u000e{W.\\1oIN$2!ZAR\u0011\u0019\t)+\u0006a\u0001K\u0006\t\u0001/\u0001\bxSRD7)Y2iK\u0012$\u0015\r^1\u0002+\u0005\u001c8/\u001a:u\u0007>lW.\u00198e\u000bb,7-\u001e;fI\u0006iq\u000e\u001d;j[&TX\r\u001a)mC:\fq\"Y:tKJ$x\n\u001d;j[&TX\rZ\u0001\ngB\f'o\u001b)mC:,\"!a-\u0011\u0007i\f),C\u0002\u00028\u0012\u0013\u0011b\u00159be.\u0004F.\u00198\u0002\u0019\u0015DXmY;uK\u0012\u0004F.\u00198\u0002\u000bQ|'\u000b\u001a3\u0016\u0005\u0005}\u0006CBAa\u0003\u000f\fY-\u0004\u0002\u0002D*\u0019\u0011Q\u0019%\u0002\u0007I$G-\u0003\u0003\u0002J\u0006\r'a\u0001*E\tB\u0019!/!4\n\u0007\u0005='NA\u0006J]R,'O\\1m%><\u0018aD8cg\u0016\u0014h/\u001a3NKR\u0014\u0018nY:\u0016\u0005\u0005U\u0007\u0003CAA\u0003/\fy(a7\n\t\u0005e\u00171\u0013\u0002\u0004\u001b\u0006\u0004\bcA0\u0002^&\u0019\u0011q\u001c$\u0003\u0007I{w/\u0001\u0007qe\u0016\u0004\u0018M]1uS>t7/\u0006\u0002\u0002fB1\u0011q]Ay\u0003otA!!;\u0002n:!\u0011QQAv\u0013\u0005\u0019\u0016bAAx%\u00069\u0001/Y2lC\u001e,\u0017\u0002BAz\u0003k\u00141aU3r\u0015\r\tyO\u0015\t\u0007\u0003s\fy0a-\u000e\u0005\u0005m(bAA\u007fU\u0006)!/\u001e7fg&!!\u0011AA~\u0005\u0011\u0011V\u000f\\3\u0002\u0019\u0015DXmY;uKBC\u0017m]3\u0016\t\t\u001d!Q\u0002\u000b\u0005\u0005\u0013\u0011)\u0002\u0006\u0003\u0003\f\t=\u0001\u0003BA'\u0005\u001b!q!!\u0015 \u0005\u0004\t\u0019\u0006\u0003\u0005\u0003\u0012}!\t\u0019\u0001B\n\u0003\u0015\u0011Gn\\2l!\u0015\t\u0016q\rB\u0006\u0011\u001d\u00119b\ba\u0001\u0003\u007f\nQ\u0001\u001d5bg\u0016\fAb]5na2,7\u000b\u001e:j]\u001e,\"!a \u0015\u0011\u0005=$q\u0004B\u0015\u0005gAqA!\t\"\u0001\u0004\u0011\u0019#A\u0005g_Jl\u0017\r\u001e;fIB\u0019\u0011K!\n\n\u0007\t\u001d\"KA\u0004C_>dW-\u00198\t\u000f\t-\u0012\u00051\u0001\u0003.\u0005IQ.\u0019=GS\u0016dGm\u001d\t\u0004#\n=\u0012b\u0001B\u0019%\n\u0019\u0011J\u001c;\t\u000f\tU\u0012\u00051\u0001\u00038\u00051\u0011\r\u001d9f]\u0012\u0004r!\u0015B\u001d\u0003\u007f\ny'C\u0002\u0003<I\u0013\u0011BR;oGRLwN\\\u0019\u0002\u001b\u0015D\b\u000f\\1j]N#(/\u001b8h)\u0011\tyH!\u0011\t\rY\u0014\u0003\u0019\u0001B\"!\rQ(QI\u0005\u0004\u0005\u000f\"%aC#ya2\f\u0017N\\'pI\u0016$\u0002\"a\u001c\u0003L\t5#q\n\u0005\u0007m\u000e\u0002\rAa\u0011\t\u000f\t-2\u00051\u0001\u0003.!9!QG\u0012A\u0002\t]\u0012AC<sSR,\u0007\u000b\\1ogR1\u0011q\u000eB+\u0005/BqA!\u000e%\u0001\u0004\u00119\u0004C\u0004\u0003,\u0011\u0002\rA!\f\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a \u0015\r\u0005=$q\fB1\u0011\u001d\u0011YC\na\u0001\u0005[AqA!\u000e'\u0001\u0004\u00119$A\btiJLgnZ,ji\"\u001cF/\u0019;t)\u0019\tyGa\u001a\u0003j!9!1\u0006\u0015A\u0002\t5\u0002b\u0002B\u001bQ\u0001\u0007!qG\u0001\u000eo&$\bNU3eC\u000e$\u0018n\u001c8\u0015\t\u0005}$q\u000e\u0005\b\u0005cJ\u0003\u0019AA@\u0003\u001diWm]:bO\u0016\fQ\u0001Z3ck\u001e\u00042Aa\u001e,\u001b\u0005\u0001!!\u00023fEV<7CA\u0016Q)\t\u0011)(A\u0004d_\u0012,w-\u001a8\u0002\u0019\r|G-Z4f]R{7+Z9\u0015\u0005\t\u0015\u0005CBAt\u0003c\u00149\tE\u0005R\u0005\u0013\u000by(a \u0003\u000e&\u0019!1\u0012*\u0003\rQ+\b\u000f\\34!\u0011\u0011yIa&\u000e\u0005\tE%\u0002\u0002B@\u0005'S1A!&k\u0003-)\u0007\u0010\u001d:fgNLwN\\:\n\t\te%\u0011\u0013\u0002\u000e\u0005f$XmQ8eKN#\u0018\r^:\u0002\rQ|g)\u001b7f)!\tyGa(\u0003$\n\u0015\u0006b\u0002BQ_\u0001\u0007\u0011qP\u0001\u0005a\u0006$\b\u000eC\u0005\u0003,=\u0002\n\u00111\u0001\u0003.!I!qU\u0018\u0011\u0002\u0003\u0007!\u0011V\u0001\fKb\u0004H.Y5o\u001b>$W\rE\u0003R\u0005W\u000by(C\u0002\u0003.J\u0013aa\u00149uS>t\u0017\u0001\u0005;p\r&dW\r\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011\u0019L\u000b\u0003\u0003.\tU6F\u0001B\\!\u0011\u0011ILa1\u000e\u0005\tm&\u0002\u0002B_\u0005\u007f\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t\u0005'+\u0001\u0006b]:|G/\u0019;j_:LAA!2\u0003<\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002!Q|g)\u001b7fI\u0011,g-Y;mi\u0012\u001aTC\u0001BfU\u0011\u0011IK!.\u0002\u001dE+XM]=Fq\u0016\u001cW\u000f^5p]B\u0011!pM\n\u0003gA#\"Aa4\u0002!}sW\r\u001f;Fq\u0016\u001cW\u000f^5p]&#WC\u0001Bm!\u0011\u0011YN!<\u000e\u0005\tu'\u0002\u0002Bp\u0005C\fa!\u0019;p[&\u001c'\u0002\u0002Br\u0005K\f!bY8oGV\u0014(/\u001a8u\u0015\u0011\u00119O!;\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0005W\fAA[1wC&!!q\u001eBo\u0005)\tEo\\7jG2{gnZ\u0001\u0012?:,\u0007\u0010^#yK\u000e,H/[8o\u0013\u0012\u0004\u0013a\u00048fqR,\u00050Z2vi&|g.\u00133\u0015\u0011\u0005\u0015(q\u001fB}\u0007\u0017AQ\u0001\u0018\u001dA\u0002yC\u0011Ba?9!\u0003\u0005\rA!@\u0002+\u0005$\u0017\r\u001d;jm\u0016,\u00050Z2vi&|gNU;mKB)\u0011Ka+\u0003\u0000B!1\u0011AB\u0004\u001b\t\u0019\u0019AC\u0002\u0004\u0006\u0011\u000b\u0001\"\u00193baRLg/Z\u0005\u0005\u0007\u0013\u0019\u0019AA\fJ]N,'\u000f^!eCB$\u0018N^3Ta\u0006\u00148\u000e\u00157b]\"91Q\u0002\u001dA\u0002\t\r\u0012\u0001C:vEF,XM]=\u0002-A\u0014X\r]1sCRLwN\\:%I\u00164\u0017-\u001e7uII*\"aa\u0005+\t\tu(QW\u0001\u0014aJ,\u0007/\u0019:f\r>\u0014X\t_3dkRLwN\u001c\u000b\u0007\u0003g\u001bIba\u0007\t\u000f\u0005\u0005(\b1\u0001\u0002f\"91Q\u0004\u001eA\u0002\u0005M\u0016\u0001\u00029mC:\fqb\u0019:fCR,7\u000b]1sWBc\u0017M\u001c\u000b\t\u0003g\u001b\u0019c!\n\u0004(!)Al\u000fa\u0001=\"9\u0011qD\u001eA\u0002\u0005\r\u0002BBB\u000fw\u0001\u0007Q-A\nqe\u0016\u0004\u0018M]3Fq\u0016\u001cW\u000f^3e!2\fg\u000e\u0006\u0004\u00024\u000e52q\u0006\u0005\u0006\u0013r\u0002\rA\u0018\u0005\b\u0007;a\u0004\u0019AAZ)\u0019\t\u0019la\r\u00046!)\u0011*\u0010a\u0001=\"11QD\u001fA\u0002\u0015\fQbY;se\u0016tGo\u0011;f\u001b\u0006\u0004XCAB\u001e!\u0019\u0019ida\u0011\u0002.5\u00111q\b\u0006\u0005\u0007\u0003\u0012I/\u0001\u0003mC:<\u0017\u0002BB#\u0007\u007f\u00111\u0002\u00165sK\u0006$Gj\\2bY\u0006q1-\u001e:sK:$8\t^3NCB\u0004\u0013a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'\u0006\u0002\u0004N)\u001a\u0011O!.\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\u0019\u0019FK\u0002y\u0005k\u0003")
public class QueryExecution
implements Logging {
    private LogicalPlan analyzed;
    private LogicalPlan commandExecuted;
    private LogicalPlan withCachedData;
    private LogicalPlan optimizedPlan;
    private SparkPlan sparkPlan;
    private SparkPlan executedPlan;
    private RDD<InternalRow> toRdd;
    private volatile QueryExecution$debug$ debug$module;
    private final SparkSession sparkSession;
    private final LogicalPlan logical;
    private final QueryPlanningTracker tracker;
    private final Enumeration.Value mode;
    private final long id;
    private final HashMap<Object, CTERelationDef> cteMap;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public static Enumeration.Value $lessinit$greater$default$4() {
        return QueryExecution$.MODULE$.$lessinit$greater$default$4();
    }

    public static QueryPlanningTracker $lessinit$greater$default$3() {
        return QueryExecution$.MODULE$.$lessinit$greater$default$3();
    }

    public static SparkPlan prepareExecutedPlan(SparkSession sparkSession, LogicalPlan logicalPlan2) {
        return QueryExecution$.MODULE$.prepareExecutedPlan(sparkSession, logicalPlan2);
    }

    public static SparkPlan prepareExecutedPlan(SparkSession sparkSession, SparkPlan sparkPlan) {
        return QueryExecution$.MODULE$.prepareExecutedPlan(sparkSession, sparkPlan);
    }

    public static SparkPlan createSparkPlan(SparkSession sparkSession, SparkPlanner sparkPlanner, LogicalPlan logicalPlan2) {
        return QueryExecution$.MODULE$.createSparkPlan(sparkSession, sparkPlanner, logicalPlan2);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public QueryExecution$debug$ debug() {
        if (this.debug$module == null) {
            this.debug$lzycompute$1();
        }
        return this.debug$module;
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public SparkSession sparkSession() {
        return this.sparkSession;
    }

    public LogicalPlan logical() {
        return this.logical;
    }

    public QueryPlanningTracker tracker() {
        return this.tracker;
    }

    public Enumeration.Value mode() {
        return this.mode;
    }

    public long id() {
        return this.id;
    }

    public SparkPlanner planner() {
        return this.sparkSession().sessionState().planner();
    }

    private HashMap<Object, CTERelationDef> cteMap() {
        return this.cteMap;
    }

    public <T> T withCteMap(Function0<T> f) {
        Object object;
        HashMap<Object, CTERelationDef> old = QueryExecution$.MODULE$.org$apache$spark$sql$execution$QueryExecution$$currentCteMap().get();
        QueryExecution$.MODULE$.org$apache$spark$sql$execution$QueryExecution$$currentCteMap().set(this.cteMap());
        try {
            object = f.apply();
        }
        finally {
            QueryExecution$.MODULE$.org$apache$spark$sql$execution$QueryExecution$$currentCteMap().set(old);
        }
        return (T)object;
    }

    public void assertAnalyzed() {
        this.analyzed();
    }

    public void assertSupported() {
        block0: {
            if (!this.sparkSession().sessionState().conf().isUnsupportedOperationCheckEnabled()) break block0;
            UnsupportedOperationChecker$.MODULE$.checkForBatch(this.analyzed());
        }
    }

    private LogicalPlan analyzed$lzycompute() {
        QueryExecution queryExecution = this;
        synchronized (queryExecution) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.analyzed = (LogicalPlan)this.executePhase(QueryPlanningTracker$.MODULE$.ANALYSIS(), (Function0 & Serializable)() -> this.sparkSession().sessionState().analyzer().executeAndCheck(this.logical(), this.tracker()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.analyzed;
    }

    public LogicalPlan analyzed() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.analyzed$lzycompute() : this.analyzed;
    }

    private LogicalPlan commandExecuted$lzycompute() {
        QueryExecution queryExecution = this;
        synchronized (queryExecution) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                LogicalPlan logicalPlan2;
                Enumeration.Value value = this.mode();
                Enumeration.Value value2 = CommandExecutionMode$.MODULE$.NON_ROOT();
                Enumeration.Value value3 = value;
                if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                    logicalPlan2 = (LogicalPlan)this.analyzed().mapChildren((Function1 & Serializable)p -> this.eagerlyExecuteCommands((LogicalPlan)p));
                } else {
                    Enumeration.Value value4 = CommandExecutionMode$.MODULE$.ALL();
                    Enumeration.Value value5 = value;
                    if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                        logicalPlan2 = this.eagerlyExecuteCommands(this.analyzed());
                    } else {
                        Enumeration.Value value6 = CommandExecutionMode$.MODULE$.SKIP();
                        Enumeration.Value value7 = value;
                        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                            logicalPlan2 = this.analyzed();
                        } else {
                            throw new MatchError((Object)value);
                        }
                    }
                }
                this.commandExecuted = logicalPlan2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.commandExecuted;
    }

    public LogicalPlan commandExecuted() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.commandExecuted$lzycompute() : this.commandExecuted;
    }

    public String org$apache$spark$sql$execution$QueryExecution$$commandExecutionName(Command command) {
        Command command2 = command;
        String string = command2 instanceof CreateTableAsSelect ? "create" : (command2 instanceof ReplaceTableAsSelect ? "replace" : (command2 instanceof AppendData ? "append" : (command2 instanceof OverwriteByExpression ? "overwrite" : (command2 instanceof OverwritePartitionsDynamic ? "overwritePartitions" : "command"))));
        return string;
    }

    private LogicalPlan eagerlyExecuteCommands(LogicalPlan p) {
        return (LogicalPlan)p.transformDown((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ QueryExecution $outer;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof Command) {
                    Command command = (Command)A1;
                    QueryExecution qe = this.$outer.sparkSession().sessionState().executePlan((LogicalPlan)command, CommandExecutionMode$.MODULE$.NON_ROOT());
                    InternalRow[] result = (InternalRow[])SQLExecution$.MODULE$.withNewExecutionId(qe, (Option<String>)new Some((Object)this.$outer.org$apache$spark$sql$execution$QueryExecution$$commandExecutionName(command)), (Function0 & Serializable)() -> qe.executedPlan().executeCollect());
                    object = new CommandResult((Seq<Attribute>)qe.analyzed().output(), qe.commandExecuted(), qe.executedPlan(), (Seq<InternalRow>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)result));
                } else {
                    object = A1;
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan2 = x1;
                boolean bl = logicalPlan2 instanceof Command ? true : true;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.spark.sql.execution.QueryExecution )}, serializedLambda);
            }
        });
    }

    private LogicalPlan withCachedData$lzycompute() {
        QueryExecution queryExecution = this;
        synchronized (queryExecution) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.withCachedData = (LogicalPlan)this.sparkSession().withActive((Function0 & Serializable)() -> {
                    this.assertAnalyzed();
                    this.assertSupported();
                    return this.sparkSession().sharedState().cacheManager().useCachedData(this.commandExecuted().clone());
                });
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.withCachedData;
    }

    public LogicalPlan withCachedData() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.withCachedData$lzycompute() : this.withCachedData;
    }

    public void assertCommandExecuted() {
        this.commandExecuted();
    }

    private LogicalPlan optimizedPlan$lzycompute() {
        QueryExecution queryExecution = this;
        synchronized (queryExecution) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.assertCommandExecuted();
                this.optimizedPlan = (LogicalPlan)this.executePhase(QueryPlanningTracker$.MODULE$.OPTIMIZATION(), (Function0 & Serializable)() -> {
                    void var1_1;
                    LogicalPlan plan = (LogicalPlan)this.sparkSession().sessionState().optimizer().executeAndTrack((TreeNode)this.withCachedData().clone(), this.tracker());
                    plan.setAnalyzed();
                    return var1_1;
                });
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.optimizedPlan;
    }

    public LogicalPlan optimizedPlan() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.optimizedPlan$lzycompute() : this.optimizedPlan;
    }

    private void assertOptimized() {
        this.optimizedPlan();
    }

    private SparkPlan sparkPlan$lzycompute() {
        QueryExecution queryExecution = this;
        synchronized (queryExecution) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.sparkPlan = (SparkPlan)this.withCteMap((Function0 & Serializable)() -> {
                    this.assertOptimized();
                    return (SparkPlan)this.executePhase(QueryPlanningTracker$.MODULE$.PLANNING(), (Function0 & Serializable)() -> QueryExecution$.MODULE$.createSparkPlan(this.sparkSession(), this.planner(), this.optimizedPlan().clone()));
                });
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.sparkPlan;
    }

    public SparkPlan sparkPlan() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.sparkPlan$lzycompute() : this.sparkPlan;
    }

    private SparkPlan executedPlan$lzycompute() {
        QueryExecution queryExecution = this;
        synchronized (queryExecution) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.executedPlan = (SparkPlan)this.withCteMap((Function0 & Serializable)() -> {
                    this.assertOptimized();
                    return (SparkPlan)this.executePhase(QueryPlanningTracker$.MODULE$.PLANNING(), (Function0 & Serializable)() -> QueryExecution$.MODULE$.prepareForExecution(this.preparations(), (SparkPlan)this.sparkPlan().clone()));
                });
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
        }
        return this.executedPlan;
    }

    public SparkPlan executedPlan() {
        return (byte)(this.bitmap$0 & 0x20) == 0 ? this.executedPlan$lzycompute() : this.executedPlan;
    }

    private RDD<InternalRow> toRdd$lzycompute() {
        QueryExecution queryExecution = this;
        synchronized (queryExecution) {
            if ((byte)(this.bitmap$0 & 0x40) == 0) {
                this.toRdd = new SQLExecutionRDD(this.executedPlan().execute(), this.sparkSession().sessionState().conf());
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x40);
            }
        }
        return this.toRdd;
    }

    public RDD<InternalRow> toRdd() {
        return (byte)(this.bitmap$0 & 0x40) == 0 ? this.toRdd$lzycompute() : this.toRdd;
    }

    public Map<String, Row> observedMetrics() {
        return CollectMetricsExec$.MODULE$.collect(this.executedPlan());
    }

    public Seq<Rule<SparkPlan>> preparations() {
        return QueryExecution$.MODULE$.preparations(this.sparkSession(), (Option<InsertAdaptiveSparkPlan>)Option$.MODULE$.apply((Object)new InsertAdaptiveSparkPlan(new AdaptiveExecutionContext(this.sparkSession(), this))), false);
    }

    public <T> T executePhase(String phase, Function0<T> block) {
        return this.sparkSession().withActive((Function0 & Serializable)() -> this.tracker().measurePhase(phase, block));
    }

    public String simpleString() {
        StringUtils.PlanStringConcat concat = new StringUtils.PlanStringConcat();
        this.simpleString(false, SQLConf$.MODULE$.get().maxToStringFields(), (Function1<String, BoxedUnit>)(Function1 & Serializable)s -> {
            concat.append(s);
            return BoxedUnit.UNIT;
        });
        return this.withRedaction(concat.toString());
    }

    private void simpleString(boolean formatted, int maxFields, Function1<String, BoxedUnit> append) {
        Object object;
        append.apply((Object)"== Physical Plan ==\n");
        if (formatted) {
            try {
                ExplainUtils$.MODULE$.processPlan(this.executedPlan(), append);
                object = BoxedUnit.UNIT;
            }
            catch (AnalysisException e) {
                object = append.apply((Object)e.toString());
            }
            catch (IllegalArgumentException e) {
                object = append.apply((Object)e.toString());
            }
        } else {
            QueryPlan$.MODULE$.append((Function0 & Serializable)() -> this.executedPlan(), append, false, false, maxFields, QueryPlan$.MODULE$.append$default$6());
            object = BoxedUnit.UNIT;
        }
        append.apply((Object)"\n");
    }

    public String explainString(ExplainMode mode) {
        StringUtils.PlanStringConcat concat = new StringUtils.PlanStringConcat();
        this.org$apache$spark$sql$execution$QueryExecution$$explainString(mode, SQLConf$.MODULE$.get().maxToStringFields(), (Function1<String, BoxedUnit>)(Function1 & Serializable)s -> {
            concat.append(s);
            return BoxedUnit.UNIT;
        });
        return this.withRedaction(concat.toString());
    }

    public void org$apache$spark$sql$execution$QueryExecution$$explainString(ExplainMode mode, int maxFields, Function1<String, BoxedUnit> append) {
        QueryExecution queryExecution = this.logical().isStreaming() ? new IncrementalExecution(this.sparkSession(), this.logical(), OutputMode.Append(), "<unknown>", UUID.randomUUID(), UUID.randomUUID(), 0L, new OffsetSeqMetadata(0L, 0L, OffsetSeqMetadata$.MODULE$.apply$default$3())) : this;
        ExplainMode explainMode = mode;
        if (SimpleMode$.MODULE$.equals(explainMode)) {
            queryExecution.simpleString(false, maxFields, append);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (ExtendedMode$.MODULE$.equals(explainMode)) {
            queryExecution.toString(maxFields, append);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (CodegenMode$.MODULE$.equals(explainMode)) {
            BoxedUnit boxedUnit;
            try {
                package$.MODULE$.writeCodegen(append, queryExecution.executedPlan());
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (AnalysisException e) {
                boxedUnit = (BoxedUnit)append.apply((Object)e.toString());
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (CostMode$.MODULE$.equals(explainMode)) {
            queryExecution.stringWithStats(maxFields, append);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (FormattedMode$.MODULE$.equals(explainMode)) {
            queryExecution.simpleString(true, maxFields, append);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)explainMode);
        }
    }

    private void writePlans(Function1<String, BoxedUnit> append, int maxFields) {
        Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(true, false);
        if (sp2 == null) {
            throw new MatchError((Object)sp2);
        }
        boolean verbose = sp2._1$mcZ$sp();
        boolean addSuffix = sp2._2$mcZ$sp();
        Tuple2.mcZZ.sp sp3 = new Tuple2.mcZZ.sp(verbose, addSuffix);
        Tuple2.mcZZ.sp sp4 = sp3;
        boolean verbose2 = sp4._1$mcZ$sp();
        boolean addSuffix2 = sp4._2$mcZ$sp();
        append.apply((Object)"== Parsed Logical Plan ==\n");
        QueryPlan$.MODULE$.append((Function0 & Serializable)() -> this.logical(), append, verbose2, addSuffix2, maxFields, QueryPlan$.MODULE$.append$default$6());
        append.apply((Object)"\n== Analyzed Logical Plan ==\n");
        try {
            Object object;
            if (this.analyzed().output().nonEmpty()) {
                append.apply((Object)org.apache.spark.sql.catalyst.util.package$.MODULE$.truncatedString((Seq)this.analyzed().output().map((Function1 & Serializable)o -> new StringBuilder(2).append(o.name()).append(": ").append(o.dataType().simpleString()).toString()), ", ", maxFields));
                object = append.apply((Object)"\n");
            } else {
                object = BoxedUnit.UNIT;
            }
            QueryPlan$.MODULE$.append((Function0 & Serializable)() -> this.analyzed(), append, verbose2, addSuffix2, maxFields, QueryPlan$.MODULE$.append$default$6());
            append.apply((Object)"\n== Optimized Logical Plan ==\n");
            QueryPlan$.MODULE$.append((Function0 & Serializable)() -> this.optimizedPlan(), append, verbose2, addSuffix2, maxFields, QueryPlan$.MODULE$.append$default$6());
            append.apply((Object)"\n== Physical Plan ==\n");
            QueryPlan$.MODULE$.append((Function0 & Serializable)() -> this.executedPlan(), append, verbose2, addSuffix2, maxFields, QueryPlan$.MODULE$.append$default$6());
        }
        catch (AnalysisException e) {
            append.apply((Object)e.toString());
        }
    }

    public String toString() {
        StringUtils.PlanStringConcat concat = new StringUtils.PlanStringConcat();
        this.toString(SQLConf$.MODULE$.get().maxToStringFields(), (Function1<String, BoxedUnit>)(Function1 & Serializable)s -> {
            concat.append(s);
            return BoxedUnit.UNIT;
        });
        return this.withRedaction(this.withRedaction(concat.toString()));
    }

    private void toString(int maxFields, Function1<String, BoxedUnit> append) {
        this.writePlans(append, maxFields);
    }

    public String stringWithStats() {
        StringUtils.PlanStringConcat concat = new StringUtils.PlanStringConcat();
        this.stringWithStats(SQLConf$.MODULE$.get().maxToStringFields(), (Function1<String, BoxedUnit>)(Function1 & Serializable)s -> {
            concat.append(s);
            return BoxedUnit.UNIT;
        });
        return this.withRedaction(concat.toString());
    }

    private void stringWithStats(int maxFields, Function1<String, BoxedUnit> append) {
        Object object;
        int maxFields2 = SQLConf$.MODULE$.get().maxToStringFields();
        try {
            object = this.optimizedPlan().collectWithSubqueries((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    Statistics statistics = A1.stats();
                    return (B1)statistics;
                }

                public final boolean isDefinedAt(LogicalPlan x1) {
                    LogicalPlan logicalPlan2 = x1;
                    boolean bl = true;
                    return bl;
                }
            });
        }
        catch (AnalysisException e) {
            object = append.apply((Object)new StringBuilder(1).append(e.toString()).append("\n").toString());
        }
        append.apply((Object)"== Optimized Logical Plan ==\n");
        QueryPlan$.MODULE$.append((Function0 & Serializable)() -> this.optimizedPlan(), append, true, true, maxFields2, QueryPlan$.MODULE$.append$default$6());
        append.apply((Object)"\n== Physical Plan ==\n");
        QueryPlan$.MODULE$.append((Function0 & Serializable)() -> this.executedPlan(), append, true, false, maxFields2, QueryPlan$.MODULE$.append$default$6());
        append.apply((Object)"\n");
    }

    private String withRedaction(String message) {
        return Utils$.MODULE$.redact(this.sparkSession().sessionState().conf().stringRedactionPattern(), message);
    }

    private final void debug$lzycompute$1() {
        QueryExecution queryExecution = this;
        synchronized (queryExecution) {
            if (this.debug$module == null) {
                this.debug$module = new QueryExecution$debug$(this);
            }
        }
    }

    public QueryExecution(SparkSession sparkSession, LogicalPlan logical, QueryPlanningTracker tracker, Enumeration.Value mode) {
        this.sparkSession = sparkSession;
        this.logical = logical;
        this.tracker = tracker;
        this.mode = mode;
        Logging.$init$((Logging)this);
        this.id = QueryExecution$.MODULE$.org$apache$spark$sql$execution$QueryExecution$$nextExecutionId();
        this.cteMap = HashMap$.MODULE$.empty();
    }
}

