/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2;

import java.io.Serializable;
import java.net.URI;
import java.util.Map;
import org.apache.spark.sql.catalyst.FunctionIdentifier;
import org.apache.spark.sql.catalyst.FunctionIdentifier$;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.analysis.NoSuchDatabaseException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.catalyst.catalog.CatalogDatabase;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTable$;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.CatalogUtils$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.connector.catalog.CatalogManager$;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.CatalogV2Util$;
import org.apache.spark.sql.connector.catalog.Column;
import org.apache.spark.sql.connector.catalog.FunctionCatalog;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.NamespaceChange;
import org.apache.spark.sql.connector.catalog.SupportsNamespaces;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.catalog.TableCatalogCapability;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.connector.catalog.TableWritePrivilege;
import org.apache.spark.sql.connector.catalog.V1Table;
import org.apache.spark.sql.connector.catalog.functions.UnboundFunction;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.v2.V2SessionCatalog$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.internal.connector.V1Function;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\tMh\u0001B\u001a5\u0001\rC\u0001b\u0014\u0001\u0003\u0002\u0003\u0006I\u0001\u0019\u0005\u0006K\u0002!\tA\u001a\u0005\bU\u0002\u0011\r\u0011\"\u0011l\u0011\u0019i\b\u0001)A\u0005Y\")a\u0010\u0001C!\u007f\"9\u0011\u0011\u0001\u0001\u0005B\u0005\r\u0001bBA\u000f\u0001\u0011\u0005\u0013q\u0004\u0005\b\u0003c\u0001A\u0011IA\u001a\u0011\u001d\t\t\u0005\u0001C!\u0003\u0007Bq!!\u0011\u0001\t\u0003\ny\u0005C\u0004\u0002B\u0001!\t%!\u0018\t\u000f\u0005\u0015\u0004\u0001\"\u0003\u0002h!9\u0011q\u000e\u0001\u0005B\u0005E\u0004bBA;\u0001\u0011\u0005\u0013q\u000f\u0005\b\u0003k\u0002A\u0011IAR\u0011\u001d\tY\f\u0001C\u0005\u0003{Cq!!2\u0001\t\u0003\n9\rC\u0004\u0002\\\u0002!\t%!8\t\u000f\u0005\u001d\b\u0001\"\u0011\u0002j\"9\u0011Q\u001e\u0001\u0005\n\u0005=\b\"CA|\u0001E\u0005I\u0011BA}\u0011\u001d\u0011y\u0001\u0001C!\u0005#1aAa\u0007\u0001\u0003\tu\u0001BCA'/\t\u0005\t\u0015!\u0003\u00028!1Qm\u0006C\u0001\u0005KAqA!\f\u0018\t\u0003\u0011y\u0003C\u0004\u00038]!\tA!\u000f\t\u0013\t\u0005\u0003!!A\u0005\u0004\t\r\u0003b\u0002B$\u0001\u0011\u0005#\u0011\n\u0005\b\u0005\u001b\u0002A\u0011\tB(\u0011\u001d\u0011i\u0005\u0001C!\u0005'BqAa\u0016\u0001\t\u0003\u0012I\u0006C\u0004\u0003^\u0001!\tEa\u0018\t\u000f\t\u001d\u0004\u0001\"\u0011\u0003j!9!q\u000f\u0001\u0005B\te\u0004b\u0002BA\u0001\u0011\u0005!1\u0011\u0005\b\u0005\u000f\u0003A\u0011\tBE\u0011\u001d\u0011I\n\u0001C!\u00057CqAa(\u0001\t\u0003\u0012\t\u000b\u0003\u0004\u0003&\u0002!\te`\u0004\t\u0005O#\u0004\u0012\u0001\u001e\u0003*\u001a91\u0007\u000eE\u0001u\t-\u0006BB3+\t\u0003\u0011i\u000bC\u0004\u00030*\"IA!-\t\u0013\tU'&%A\u0005\n\t]gA\u0002BnU\u0015\u0011i\u000e\u0003\u0006\u0003`:\u0012\t\u0011)A\u0005\u0005gCa!\u001a\u0018\u0005\u0002\t\u0005\bb\u0002Bu]\u0011\u0005!1\u001e\u0005\n\u0005[T\u0013\u0011!C\u0006\u0005_\u0014\u0001C\u0016\u001aTKN\u001c\u0018n\u001c8DCR\fGn\\4\u000b\u0005U2\u0014A\u0001<3\u0015\t9\u0004(A\u0006eCR\f7o\\;sG\u0016\u001c(BA\u001d;\u0003%)\u00070Z2vi&|gN\u0003\u0002<y\u0005\u00191/\u001d7\u000b\u0005ur\u0014!B:qCJ\\'BA A\u0003\u0019\t\u0007/Y2iK*\t\u0011)A\u0002pe\u001e\u001c\u0001a\u0005\u0004\u0001\t2#vK\u0017\t\u0003\u000b*k\u0011A\u0012\u0006\u0003\u000f\"\u000bA\u0001\\1oO*\t\u0011*\u0001\u0003kCZ\f\u0017BA&G\u0005\u0019y%M[3diB\u0011QJU\u0007\u0002\u001d*\u0011q\nU\u0001\bG\u0006$\u0018\r\\8h\u0015\t\t&(A\u0005d_:tWm\u0019;pe&\u00111K\u0014\u0002\r)\u0006\u0014G.Z\"bi\u0006dwn\u001a\t\u0003\u001bVK!A\u0016(\u0003\u001f\u0019+hn\u0019;j_:\u001c\u0015\r^1m_\u001e\u0004\"!\u0014-\n\u0005es%AE*vaB|'\u000f^:OC6,7\u000f]1dKN\u0004\"a\u00170\u000e\u0003qS!!\u0018\u001e\u0002\u0011\r\fG/\u00197zgRL!a\u0018/\u0003\u001bM\u000bFjQ8oM\"+G\u000e]3s!\t\t7-D\u0001c\u0015\tyE,\u0003\u0002eE\nq1+Z:tS>t7)\u0019;bY><\u0017A\u0002\u001fj]&$h\b\u0006\u0002hSB\u0011\u0001\u000eA\u0007\u0002i!)qJ\u0001a\u0001A\u0006\u0001B-\u001a4bk2$h*Y7fgB\f7-Z\u000b\u0002YB\u0019Q\u000e\u001d:\u000e\u00039T\u0011a\\\u0001\u0006g\u000e\fG.Y\u0005\u0003c:\u0014Q!\u0011:sCf\u0004\"a\u001d>\u000f\u0005QD\bCA;o\u001b\u00051(BA<C\u0003\u0019a$o\\8u}%\u0011\u0011P\\\u0001\u0007!J,G-\u001a4\n\u0005md(AB*ue&twM\u0003\u0002z]\u0006\tB-\u001a4bk2$h*Y7fgB\f7-\u001a\u0011\u0002\t9\fW.\u001a\u000b\u0002e\u0006Q\u0011N\\5uS\u0006d\u0017N_3\u0015\r\u0005\u0015\u00111BA\u0007!\ri\u0017qA\u0005\u0004\u0003\u0013q'\u0001B+oSRDQA \u0004A\u0002IDq!a\u0004\u0007\u0001\u0004\t\t\"A\u0004paRLwN\\:\u0011\t\u0005M\u0011\u0011D\u0007\u0003\u0003+Q1!a\u0006;\u0003\u0011)H/\u001b7\n\t\u0005m\u0011Q\u0003\u0002\u0019\u0007\u0006\u001cX-\u00138tK:\u001c\u0018\u000e^5wKN#(/\u001b8h\u001b\u0006\u0004\u0018\u0001D2ba\u0006\u0014\u0017\u000e\\5uS\u0016\u001cHCAA\u0011!\u0019\t\u0019#a\n\u0002,5\u0011\u0011Q\u0005\u0006\u0004\u0003/A\u0015\u0002BA\u0015\u0003K\u00111aU3u!\ri\u0015QF\u0005\u0004\u0003_q%A\u0006+bE2,7)\u0019;bY><7)\u00199bE&d\u0017\u000e^=\u0002\u00151L7\u000f\u001e+bE2,7\u000f\u0006\u0003\u00026\u0005u\u0002\u0003B7q\u0003o\u00012!TA\u001d\u0013\r\tYD\u0014\u0002\u000b\u0013\u0012,g\u000e^5gS\u0016\u0014\bBBA \u0011\u0001\u0007A.A\u0005oC6,7\u000f]1dK\u0006IAn\\1e)\u0006\u0014G.\u001a\u000b\u0005\u0003\u000b\nY\u0005E\u0002N\u0003\u000fJ1!!\u0013O\u0005\u0015!\u0016M\u00197f\u0011\u001d\ti%\u0003a\u0001\u0003o\tQ!\u001b3f]R$b!!\u0012\u0002R\u0005M\u0003bBA'\u0015\u0001\u0007\u0011q\u0007\u0005\b\u0003+R\u0001\u0019AA,\u0003%!\u0018.\\3ti\u0006l\u0007\u000fE\u0002n\u00033J1!a\u0017o\u0005\u0011auN\\4\u0015\r\u0005\u0015\u0013qLA1\u0011\u001d\tie\u0003a\u0001\u0003oAa!a\u0019\f\u0001\u0004\u0011\u0018a\u0002<feNLwN\\\u0001\u000fM\u0006LG\u000eV5nKR\u0013\u0018M^3m)\u0019\t)%!\u001b\u0002l!9\u0011Q\n\u0007A\u0002\u0005]\u0002bBA7\u0019\u0001\u0007\u0011QI\u0001\u0002i\u0006y\u0011N\u001c<bY&$\u0017\r^3UC\ndW\r\u0006\u0003\u0002\u0006\u0005M\u0004bBA'\u001b\u0001\u0007\u0011qG\u0001\fGJ,\u0017\r^3UC\ndW\r\u0006\u0006\u0002F\u0005e\u00141PAD\u00033Cq!!\u0014\u000f\u0001\u0004\t9\u0004C\u0004\u0002~9\u0001\r!a \u0002\u000f\r|G.^7ogB!Q\u000e]AA!\ri\u00151Q\u0005\u0004\u0003\u000bs%AB\"pYVlg\u000eC\u0004\u0002\n:\u0001\r!a#\u0002\u0015A\f'\u000f^5uS>t7\u000f\u0005\u0003na\u00065\u0005\u0003BAH\u0003+k!!!%\u000b\u0007\u0005M\u0005+A\u0006fqB\u0014Xm]:j_:\u001c\u0018\u0002BAL\u0003#\u0013\u0011\u0002\u0016:b]N4wN]7\t\u000f\u0005me\u00021\u0001\u0002\u001e\u0006Q\u0001O]8qKJ$\u0018.Z:\u0011\r\u0005\r\u0012q\u0014:s\u0013\u0011\t\t+!\n\u0003\u00075\u000b\u0007\u000f\u0006\u0006\u0002F\u0005\u0015\u0016qUA\\\u0003sCq!!\u0014\u0010\u0001\u0004\t9\u0004C\u0004\u0002*>\u0001\r!a+\u0002\rM\u001c\u0007.Z7b!\u0011\ti+a-\u000e\u0005\u0005=&bAAYu\u0005)A/\u001f9fg&!\u0011QWAX\u0005)\u0019FO];diRK\b/\u001a\u0005\b\u0003\u0013{\u0001\u0019AAF\u0011\u001d\tYj\u0004a\u0001\u0003;\u000b\u0011\u0002^8PaRLwN\\:\u0015\t\u0005}\u00161\u0019\t\u0006g\u0006\u0005'O]\u0005\u0004\u0003Cc\bbBAN!\u0001\u0007\u0011qX\u0001\u000bC2$XM\u001d+bE2,GCBA#\u0003\u0013\fY\rC\u0004\u0002NE\u0001\r!a\u000e\t\u000f\u00055\u0017\u00031\u0001\u0002P\u000691\r[1oO\u0016\u001c\b#B7\u0002R\u0006U\u0017bAAj]\nQAH]3qK\u0006$X\r\u001a \u0011\u00075\u000b9.C\u0002\u0002Z:\u00131\u0002V1cY\u0016\u001c\u0005.\u00198hK\u0006Q\u0001/\u001e:hKR\u000b'\r\\3\u0015\t\u0005}\u0017Q\u001d\t\u0004[\u0006\u0005\u0018bAAr]\n9!i\\8mK\u0006t\u0007bBA'%\u0001\u0007\u0011qG\u0001\nIJ|\u0007\u000fV1cY\u0016$B!a8\u0002l\"9\u0011QJ\nA\u0002\u0005]\u0012!\u00053s_B$\u0016M\u00197f\u0013:$XM\u001d8bYR1\u0011q\\Ay\u0003gDq!!\u0014\u0015\u0001\u0004\t9\u0004C\u0005\u0002vR\u0001\n\u00111\u0001\u0002`\u0006)\u0001/\u001e:hK\u0006YBM]8q)\u0006\u0014G.Z%oi\u0016\u0014h.\u00197%I\u00164\u0017-\u001e7uII*\"!a?+\t\u0005}\u0017Q`\u0016\u0003\u0003\u007f\u0004BA!\u0001\u0003\f5\u0011!1\u0001\u0006\u0005\u0005\u000b\u00119!A\u0005v]\u000eDWmY6fI*\u0019!\u0011\u00028\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\u000e\t\r!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006Y!/\u001a8b[\u0016$\u0016M\u00197f)\u0019\t)Aa\u0005\u0003\u0018!9!Q\u0003\fA\u0002\u0005]\u0012\u0001C8mI&#WM\u001c;\t\u000f\tea\u00031\u0001\u00028\u0005Aa.Z<JI\u0016tGOA\u000bUC\ndW-\u00133f]RLg-[3s\u0011\u0016d\u0007/\u001a:\u0014\u0007]\u0011y\u0002E\u0002n\u0005CI1Aa\to\u0005\u0019\te.\u001f*fMR!!q\u0005B\u0016!\r\u0011IcF\u0007\u0002\u0001!9\u0011QJ\rA\u0002\u0005]\u0012!E1t)\u0006\u0014G.Z%eK:$\u0018NZ5feV\u0011!\u0011\u0007\t\u00047\nM\u0012b\u0001B\u001b9\nyA+\u00192mK&#WM\u001c;jM&,'/\u0001\u000bbg\u001a+hn\u0019;j_:LE-\u001a8uS\u001aLWM]\u000b\u0003\u0005w\u00012a\u0017B\u001f\u0013\r\u0011y\u0004\u0018\u0002\u0013\rVt7\r^5p]&#WM\u001c;jM&,'/A\u000bUC\ndW-\u00133f]RLg-[3s\u0011\u0016d\u0007/\u001a:\u0015\t\t\u001d\"Q\t\u0005\b\u0003\u001bb\u0002\u0019AA\u001c\u0003=q\u0017-\\3ta\u0006\u001cW-\u0012=jgR\u001cH\u0003BAp\u0005\u0017Ba!a\u0010\u001e\u0001\u0004a\u0017A\u00047jgRt\u0015-\\3ta\u0006\u001cWm\u001d\u000b\u0003\u0005#\u00022!\u001c9m)\u0011\u0011\tF!\u0016\t\r\u0005}r\u00041\u0001m\u0003Uaw.\u00193OC6,7\u000f]1dK6+G/\u00193bi\u0006$B!!(\u0003\\!1\u0011q\b\u0011A\u00021\fqb\u0019:fCR,g*Y7fgB\f7-\u001a\u000b\u0007\u0003\u000b\u0011\tGa\u0019\t\r\u0005}\u0012\u00051\u0001m\u0011\u001d\u0011)'\ta\u0001\u0003;\u000b\u0001\"\\3uC\u0012\fG/Y\u0001\u000fC2$XM\u001d(b[\u0016\u001c\b/Y2f)\u0019\t)Aa\u001b\u0003n!1\u0011q\b\u0012A\u00021Dq!!4#\u0001\u0004\u0011y\u0007E\u0003n\u0003#\u0014\t\bE\u0002N\u0005gJ1A!\u001eO\u0005=q\u0015-\\3ta\u0006\u001cWm\u00115b]\u001e,\u0017!\u00043s_Bt\u0015-\\3ta\u0006\u001cW\r\u0006\u0004\u0002`\nm$Q\u0010\u0005\u0007\u0003\u007f\u0019\u0003\u0019\u00017\t\u000f\t}4\u00051\u0001\u0002`\u000691-Y:dC\u0012,\u0017AC5t)\u0016l\u0007OV5foR!\u0011q\u001cBC\u0011\u001d\ti\u0005\na\u0001\u0003o\tA\u0002\\8bI\u001a+hn\u0019;j_:$BAa#\u0003\u0018B!!Q\u0012BJ\u001b\t\u0011yIC\u0002\u0003\u0012:\u000b\u0011BZ;oGRLwN\\:\n\t\tU%q\u0012\u0002\u0010+:\u0014w.\u001e8e\rVt7\r^5p]\"9\u0011QJ\u0013A\u0002\u0005]\u0012!\u00047jgR4UO\\2uS>t7\u000f\u0006\u0003\u00026\tu\u0005BBA M\u0001\u0007A.\u0001\bgk:\u001cG/[8o\u000bbL7\u000f^:\u0015\t\u0005}'1\u0015\u0005\b\u0003\u001b:\u0003\u0019AA\u001c\u0003!!xn\u0015;sS:<\u0017\u0001\u0005,3'\u0016\u001c8/[8o\u0007\u0006$\u0018\r\\8h!\tA'fE\u0002+\u0005?!\"A!+\u0002#Q|7)\u0019;bY><G)\u0019;bE\u0006\u001cX\r\u0006\u0005\u00034\ne&Q\u0018B`!\r\t'QW\u0005\u0004\u0005o\u0013'aD\"bi\u0006dwn\u001a#bi\u0006\u0014\u0017m]3\t\r\tmF\u00061\u0001s\u0003\t!'\rC\u0004\u0003f1\u0002\r!!(\t\u0013\t\u0005G\u0006%AA\u0002\t\r\u0017a\u00043fM\u0006,H\u000e\u001e'pG\u0006$\u0018n\u001c8\u0011\u000b5\u0014)M!3\n\u0007\t\u001dgN\u0001\u0004PaRLwN\u001c\t\u0005\u0005\u0017\u0014\t.\u0004\u0002\u0003N*\u0019!q\u001a%\u0002\u00079,G/\u0003\u0003\u0003T\n5'aA+S\u0013\u0006YBo\\\"bi\u0006dwn\u001a#bi\u0006\u0014\u0017m]3%I\u00164\u0017-\u001e7uIM*\"A!7+\t\t\r\u0017Q \u0002\u0016\u0007\u0006$\u0018\r\\8h\t\u0006$\u0018MY1tK\"+G\u000e]3s'\rq#qD\u0001\u0010G\u0006$\u0018\r\\8h\t\u0006$\u0018MY1tKR!!1\u001dBt!\r\u0011)OL\u0007\u0002U!9!q\u001c\u0019A\u0002\tM\u0016A\u0003;p\u001b\u0016$\u0018\rZ1uCV\u0011\u0011QT\u0001\u0016\u0007\u0006$\u0018\r\\8h\t\u0006$\u0018MY1tK\"+G\u000e]3s)\u0011\u0011\u0019O!=\t\u000f\t}'\u00071\u0001\u00034\u0002")
public class V2SessionCatalog
implements TableCatalog,
FunctionCatalog,
SupportsNamespaces,
SQLConfHelper {
    private final SessionCatalog catalog;
    private final String[] defaultNamespace;

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    public Table loadTable(Identifier x$1, java.util.Set<TableWritePrivilege> x$2) throws NoSuchTableException {
        return super.loadTable(x$1, x$2);
    }

    public boolean tableExists(Identifier x$1) {
        return super.tableExists(x$1);
    }

    public boolean useNullableQuerySchema() {
        return super.useNullableQuerySchema();
    }

    public String[] defaultNamespace() {
        return this.defaultNamespace;
    }

    public String name() {
        return CatalogManager$.MODULE$.SESSION_CATALOG_NAME();
    }

    public void initialize(String name, CaseInsensitiveStringMap options) {
    }

    public java.util.Set<TableCatalogCapability> capabilities() {
        return (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TableCatalogCapability[]{TableCatalogCapability.SUPPORT_COLUMN_DEFAULT_VALUE}))).asJava();
    }

    public Identifier[] listTables(String[] namespace) {
        String[] stringArray = namespace;
        Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(1) == 0) {
            String db = (String)((SeqLike)option.get()).apply(0);
            return (Identifier[])((TraversableOnce)this.catalog.listTables(db).map((Function1 & Serializable & scala.Serializable)ident -> Identifier.of((String[])((String[])ident.database().map((Function1 & Serializable & scala.Serializable)x$1 -> (String[])((Object[])new String[]{x$1})).getOrElse((Function0 & Serializable & scala.Serializable)() -> (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)))), (String)ident.table()), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Identifier.class));
        }
        throw QueryCompilationErrors$.MODULE$.noSuchNamespaceError(namespace);
    }

    public Table loadTable(Identifier ident) {
        V1Table v1Table;
        try {
            v1Table = new V1Table(this.catalog.getTableMetadata(this.TableIdentifierHelper(ident).asTableIdentifier()));
        }
        catch (NoSuchDatabaseException noSuchDatabaseException) {
            throw QueryCompilationErrors$.MODULE$.noSuchTableError(ident);
        }
        return v1Table;
    }

    public Table loadTable(Identifier ident, long timestamp) {
        return this.failTimeTravel(ident, this.loadTable(ident));
    }

    public Table loadTable(Identifier ident, String version) {
        return this.failTimeTravel(ident, this.loadTable(ident));
    }

    private Table failTimeTravel(Identifier ident, Table t) {
        Seq seq;
        Table table = t;
        if (table instanceof V1Table) {
            V1Table v1Table = (V1Table)table;
            CatalogTable catalogTable = v1Table.v1Table();
            seq = catalogTable.identifier().nameParts();
        } else {
            seq = this.TableIdentifierHelper(ident).asTableIdentifier().nameParts();
        }
        Seq nameParts = seq;
        throw QueryCompilationErrors$.MODULE$.timeTravelUnsupportedError(TypeUtils$.MODULE$.toSQLId(nameParts));
    }

    public void invalidateTable(Identifier ident) {
        this.catalog.refreshTable(this.TableIdentifierHelper(ident).asTableIdentifier());
    }

    public Table createTable(Identifier ident, Column[] columns, Transform[] partitions, Map<String, String> properties) {
        return this.createTable(ident, CatalogV2Util$.MODULE$.v2ColumnsToStructType(columns), partitions, properties);
    }

    public Table createTable(Identifier ident, StructType schema, Transform[] partitions, Map<String, String> properties) {
        Tuple2 tuple2 = CatalogV2Implicits$.MODULE$.TransformHelper(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitions)).toSeq()).convertTransforms();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq partitionColumns = (Seq)tuple2._1();
        Option maybeBucketSpec = (Option)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)partitionColumns, (Object)maybeBucketSpec);
        Seq partitionColumns2 = (Seq)tuple22._1();
        Option maybeBucketSpec2 = (Option)tuple22._2();
        String provider = properties.getOrDefault("provider", this.conf().defaultDataSourceName());
        scala.collection.mutable.Map tableProperties = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(properties).asScala();
        Option location = Option$.MODULE$.apply((Object)properties.get("location"));
        CatalogStorageFormat qual$1 = DataSource$.MODULE$.buildStorageFormatFromOptions(this.toOptions((scala.collection.immutable.Map<String, String>)tableProperties.toMap(Predef$.MODULE$.$conforms())));
        Option x$1 = location.map((Function1 & Serializable & scala.Serializable)str -> CatalogUtils$.MODULE$.stringToURI(str));
        Option x$2 = qual$1.copy$default$2();
        Option x$32 = qual$1.copy$default$3();
        Option x$4 = qual$1.copy$default$4();
        boolean x$5 = qual$1.copy$default$5();
        scala.collection.immutable.Map x$6 = qual$1.copy$default$6();
        CatalogStorageFormat storage = qual$1.copy(x$1, x$2, x$32, x$4, x$5, x$6);
        boolean isExternal = properties.containsKey("external");
        boolean isManagedLocation = Option$.MODULE$.apply((Object)properties.get("is_managed_location")).exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.equalsIgnoreCase("true")));
        CatalogTableType tableType = isExternal || location.isDefined() && !isManagedLocation ? CatalogTableType$.MODULE$.EXTERNAL() : CatalogTableType$.MODULE$.MANAGED();
        TableIdentifier x$7 = this.TableIdentifierHelper(ident).asTableIdentifier();
        CatalogTableType x$8 = tableType;
        CatalogStorageFormat x$9 = storage;
        StructType x$10 = schema;
        Some x$11 = new Some((Object)provider);
        Seq x$12 = partitionColumns2;
        Option x$13 = maybeBucketSpec2;
        scala.collection.immutable.Map x$14 = tableProperties.toMap(Predef$.MODULE$.$conforms());
        boolean x$15 = this.conf().manageFilesourcePartitions();
        Option x$16 = Option$.MODULE$.apply((Object)properties.get("comment"));
        String x$17 = CatalogTable$.MODULE$.apply$default$8();
        long x$18 = CatalogTable$.MODULE$.apply$default$9();
        long x$19 = CatalogTable$.MODULE$.apply$default$10();
        String x$20 = CatalogTable$.MODULE$.apply$default$11();
        Option x$21 = CatalogTable$.MODULE$.apply$default$13();
        Option x$22 = CatalogTable$.MODULE$.apply$default$14();
        Seq x$23 = CatalogTable$.MODULE$.apply$default$16();
        boolean x$24 = CatalogTable$.MODULE$.apply$default$18();
        scala.collection.immutable.Map x$25 = CatalogTable$.MODULE$.apply$default$19();
        Option x$26 = CatalogTable$.MODULE$.apply$default$20();
        CatalogTable tableDesc = new CatalogTable(x$7, x$8, x$9, x$10, (Option)x$11, x$12, x$13, x$17, x$18, x$19, x$20, x$14, x$21, x$22, x$16, x$23, x$15, x$24, x$25, x$26);
        try {
            this.catalog.createTable(tableDesc, false, this.catalog.createTable$default$3());
        }
        catch (TableAlreadyExistsException tableAlreadyExistsException) {
            throw QueryCompilationErrors$.MODULE$.tableAlreadyExistsError(ident);
        }
        return null;
    }

    private scala.collection.immutable.Map<String, String> toOptions(scala.collection.immutable.Map<String, String> properties) {
        return ((scala.collection.immutable.Map)properties.filterKeys((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.startsWith("option."))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(new StringOps(Predef$.MODULE$.augmentString(key)).drop("option.".length())), (Object)value);
            }
            throw new MatchError((Object)tuple2);
        }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Table alterTable(Identifier ident, Seq<TableChange> changes) {
        CatalogTable catalogTable;
        try {
            catalogTable = this.catalog.getTableMetadata(this.TableIdentifierHelper(ident).asTableIdentifier());
        }
        catch (NoSuchTableException noSuchTableException) {
            throw QueryCompilationErrors$.MODULE$.noSuchTableError(ident);
        }
        CatalogTable catalogTable2 = catalogTable;
        scala.collection.immutable.Map properties = CatalogV2Util$.MODULE$.applyPropertiesChanges(catalogTable2.properties(), changes);
        StructType schema = CatalogV2Util$.MODULE$.applySchemaChanges(catalogTable2.schema(), changes, catalogTable2.provider(), "ALTER TABLE");
        Option comment = properties.get((Object)"comment");
        String owner = (String)properties.getOrElse((Object)"owner", (Function0 & Serializable & scala.Serializable)() -> catalogTable2.owner());
        Option location = properties.get((Object)"location").map((Function1 & Serializable & scala.Serializable)str -> CatalogUtils$.MODULE$.stringToURI(str));
        CatalogStorageFormat storage = location.isDefined() ? catalogTable2.storage().copy(location, catalogTable2.storage().copy$default$2(), catalogTable2.storage().copy$default$3(), catalogTable2.storage().copy$default$4(), catalogTable2.storage().copy$default$5(), catalogTable2.storage().copy$default$6()) : catalogTable2.storage();
        try {
            scala.collection.immutable.Map x$1 = properties;
            StructType x$2 = schema;
            String x$3 = owner;
            Option x$4 = comment;
            CatalogStorageFormat x$5 = storage;
            TableIdentifier x$6 = catalogTable2.copy$default$1();
            CatalogTableType x$7 = catalogTable2.copy$default$2();
            Option x$8 = catalogTable2.copy$default$5();
            Seq x$9 = catalogTable2.copy$default$6();
            Option x$10 = catalogTable2.copy$default$7();
            long x$11 = catalogTable2.copy$default$9();
            long x$12 = catalogTable2.copy$default$10();
            String x$13 = catalogTable2.copy$default$11();
            Option x$14 = catalogTable2.copy$default$13();
            Option x$15 = catalogTable2.copy$default$14();
            Seq x$16 = catalogTable2.copy$default$16();
            boolean x$17 = catalogTable2.copy$default$17();
            boolean x$18 = catalogTable2.copy$default$18();
            scala.collection.immutable.Map x$19 = catalogTable2.copy$default$19();
            Option x$20 = catalogTable2.copy$default$20();
            this.catalog.alterTable(catalogTable2.copy(x$6, x$7, x$5, x$2, x$8, x$9, x$10, x$3, x$11, x$12, x$13, x$1, x$14, x$15, x$4, x$16, x$17, x$18, x$19, x$20));
        }
        catch (NoSuchTableException noSuchTableException) {
            throw QueryCompilationErrors$.MODULE$.noSuchTableError(ident);
        }
        return null;
    }

    public boolean purgeTable(Identifier ident) {
        return this.dropTableInternal(ident, true);
    }

    public boolean dropTable(Identifier ident) {
        return this.dropTableInternal(ident, this.dropTableInternal$default$2());
    }

    private boolean dropTableInternal(Identifier ident, boolean purge) {
        boolean bl;
        block5: {
            try {
                Table table = this.loadTable(ident);
                if (table instanceof V1Table) {
                    V1Table v1Table = (V1Table)table;
                    CatalogTable v1Table2 = v1Table.v1Table();
                    CatalogTableType catalogTableType = v1Table2.tableType();
                    CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
                    if (!(catalogTableType != null ? !catalogTableType.equals(catalogTableType2) : catalogTableType2 != null)) {
                        throw QueryCompilationErrors$.MODULE$.wrongCommandForObjectTypeError("DROP TABLE", new StringBuilder(4).append(CatalogTableType$.MODULE$.EXTERNAL().name()).append(" or").append(" ").append(CatalogTableType$.MODULE$.MANAGED().name()).toString(), v1Table2.qualifiedName(), v1Table2.tableType().name(), "DROP VIEW");
                    }
                }
                if (table == null) {
                    bl = false;
                    break block5;
                }
                this.catalog.invalidateCachedTable(this.TableIdentifierHelper(ident).asTableIdentifier());
                this.catalog.dropTable(this.TableIdentifierHelper(ident).asTableIdentifier(), true, purge);
                bl = true;
            }
            catch (NoSuchTableException noSuchTableException) {
                bl = false;
            }
        }
        return bl;
    }

    private boolean dropTableInternal$default$2() {
        return false;
    }

    public void renameTable(Identifier oldIdent, Identifier newIdent) {
        if (this.tableExists(newIdent)) {
            throw QueryCompilationErrors$.MODULE$.tableAlreadyExistsError(newIdent);
        }
        this.catalog.renameTable(this.TableIdentifierHelper(oldIdent).asTableIdentifier(), this.TableIdentifierHelper(newIdent).asTableIdentifier());
    }

    public TableIdentifierHelper TableIdentifierHelper(Identifier ident) {
        return new TableIdentifierHelper(this, ident);
    }

    public boolean namespaceExists(String[] namespace) {
        String[] stringArray = namespace;
        Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(1) == 0) {
            String db = (String)((SeqLike)option.get()).apply(0);
            return this.catalog.databaseExists(db);
        }
        return false;
    }

    public String[][] listNamespaces() {
        return (String[][])((TraversableOnce)this.catalog.listDatabases().map((Function1 & Serializable & scala.Serializable)x$5 -> (String[])((Object[])new String[]{x$5}), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
    }

    public String[][] listNamespaces(String[] namespace) {
        String db;
        String[] stringArray = namespace;
        Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(0) == 0) {
            return this.listNamespaces();
        }
        Option option2 = Array$.MODULE$.unapplySeq((Object)stringArray);
        if (!option2.isEmpty() && option2.get() != null && ((SeqLike)option2.get()).lengthCompare(1) == 0 && this.catalog.databaseExists(db = (String)((SeqLike)option2.get()).apply(0))) {
            return (String[][])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
        }
        throw QueryCompilationErrors$.MODULE$.noSuchNamespaceError(namespace);
    }

    public Map<String, String> loadNamespaceMetadata(String[] namespace) {
        String[] stringArray = namespace;
        Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(1) == 0) {
            Map<String, String> map;
            String db = (String)((SeqLike)option.get()).apply(0);
            try {
                map = V2SessionCatalog$.MODULE$.org$apache$spark$sql$execution$datasources$v2$V2SessionCatalog$$CatalogDatabaseHelper(this.catalog.getDatabaseMetadata(db)).toMetadata();
            }
            catch (NoSuchDatabaseException noSuchDatabaseException) {
                throw QueryCompilationErrors$.MODULE$.noSuchNamespaceError(namespace);
            }
            return map;
        }
        throw QueryCompilationErrors$.MODULE$.noSuchNamespaceError(namespace);
    }

    public void createNamespace(String[] namespace, Map<String, String> metadata) {
        String db;
        String[] stringArray = namespace;
        Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(1) == 0 && !this.catalog.databaseExists(db = (String)((SeqLike)option.get()).apply(0))) {
            this.catalog.createDatabase(V2SessionCatalog$.MODULE$.org$apache$spark$sql$execution$datasources$v2$V2SessionCatalog$$toCatalogDatabase(db, metadata, (Option<URI>)new Some((Object)this.catalog.getDefaultDBPath(db))), false);
            return;
        }
        Option option2 = Array$.MODULE$.unapplySeq((Object)stringArray);
        if (!option2.isEmpty() && option2.get() != null && ((SeqLike)option2.get()).lengthCompare(1) == 0) {
            throw QueryCompilationErrors$.MODULE$.namespaceAlreadyExistsError(namespace);
        }
        throw QueryExecutionErrors$.MODULE$.invalidNamespaceNameError(namespace);
    }

    public void alterNamespace(String[] namespace, Seq<NamespaceChange> changes) {
        String[] stringArray = namespace;
        Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(1) == 0) {
            String db = (String)((SeqLike)option.get()).apply(0);
            changes.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                V2SessionCatalog.$anonfun$alterNamespace$1(x0$1);
                return BoxedUnit.UNIT;
            });
            Map<String, String> metadata = V2SessionCatalog$.MODULE$.org$apache$spark$sql$execution$datasources$v2$V2SessionCatalog$$CatalogDatabaseHelper(this.catalog.getDatabaseMetadata(db)).toMetadata();
            this.catalog.alterDatabase(V2SessionCatalog$.MODULE$.org$apache$spark$sql$execution$datasources$v2$V2SessionCatalog$$toCatalogDatabase(db, CatalogV2Util$.MODULE$.applyNamespaceChanges(metadata, changes), V2SessionCatalog$.MODULE$.org$apache$spark$sql$execution$datasources$v2$V2SessionCatalog$$toCatalogDatabase$default$3()));
            return;
        }
        throw QueryCompilationErrors$.MODULE$.noSuchNamespaceError(namespace);
    }

    public boolean dropNamespace(String[] namespace, boolean cascade) {
        String db;
        String[] stringArray = namespace;
        Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(1) == 0 && this.catalog.databaseExists(db = (String)((SeqLike)option.get()).apply(0))) {
            this.catalog.dropDatabase(db, false, cascade);
            return true;
        }
        Option option2 = Array$.MODULE$.unapplySeq((Object)stringArray);
        if (!option2.isEmpty() && option2.get() != null && ((SeqLike)option2.get()).lengthCompare(1) == 0) {
            return false;
        }
        throw QueryCompilationErrors$.MODULE$.noSuchNamespaceError(namespace);
    }

    public boolean isTempView(Identifier ident) {
        return this.catalog.isTempView((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ident.namespace())).$colon$plus((Object)ident.name(), ClassTag$.MODULE$.apply(String.class))));
    }

    public UnboundFunction loadFunction(Identifier ident) {
        return new V1Function(this.catalog.lookupPersistentFunction(this.TableIdentifierHelper(ident).asFunctionIdentifier()));
    }

    public Identifier[] listFunctions(String[] namespace) {
        String[] stringArray = namespace;
        Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(1) == 0) {
            String db = (String)((SeqLike)option.get()).apply(0);
            return (Identifier[])((TraversableOnce)((TraversableLike)this.catalog.listFunctions(db).filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)V2SessionCatalog.$anonfun$listFunctions$1(x$6)))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    FunctionIdentifier funcIdent = (FunctionIdentifier)tuple2._1();
                    Predef$.MODULE$.assert(funcIdent.database().isDefined());
                    return Identifier.of((String[])((String[])((Object[])new String[]{(String)funcIdent.database().get()})), (String)funcIdent.identifier());
                }
                throw new MatchError((Object)tuple2);
            }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Identifier.class));
        }
        throw QueryCompilationErrors$.MODULE$.noSuchNamespaceError(namespace);
    }

    public boolean functionExists(Identifier ident) {
        return this.catalog.isPersistentFunction(this.TableIdentifierHelper(ident).asFunctionIdentifier());
    }

    public String toString() {
        return new StringBuilder(18).append("V2SessionCatalog(").append(this.name()).append(")").toString();
    }

    public void alterNamespace(String[] namespace, NamespaceChange[] changes) {
        this.alterNamespace(namespace, (Seq<NamespaceChange>)Predef$.MODULE$.wrapRefArray((Object[])changes));
    }

    public Table alterTable(Identifier ident, TableChange[] changes) {
        return this.alterTable(ident, (Seq<TableChange>)Predef$.MODULE$.wrapRefArray((Object[])changes));
    }

    public static final /* synthetic */ void $anonfun$alterNamespace$1(NamespaceChange x0$1) {
        NamespaceChange namespaceChange = x0$1;
        if (namespaceChange instanceof NamespaceChange.RemoveProperty) {
            NamespaceChange.RemoveProperty removeProperty = (NamespaceChange.RemoveProperty)namespaceChange;
            if (CatalogV2Util$.MODULE$.NAMESPACE_RESERVED_PROPERTIES().contains((Object)removeProperty.property())) {
                throw QueryExecutionErrors$.MODULE$.cannotRemoveReservedPropertyError(removeProperty.property());
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$listFunctions$1(Tuple2 x$6) {
        Object object = x$6._2();
        String string = "USER";
        return !(object != null ? !object.equals(string) : string != null);
    }

    public V2SessionCatalog(SessionCatalog catalog) {
        this.catalog = catalog;
        SQLConfHelper.$init$((SQLConfHelper)this);
        this.defaultNamespace = (String[])((Object[])new String[]{SQLConf$.MODULE$.get().defaultDatabase()});
    }

    private static class CatalogDatabaseHelper {
        private final CatalogDatabase catalogDatabase;

        public Map<String, String> toMetadata() {
            HashMap metadata = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
            this.catalogDatabase.properties().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    return metadata.put((Object)key, (Object)value);
                }
                throw new MatchError((Object)tuple2);
            });
            metadata.put((Object)"location", (Object)this.catalogDatabase.locationUri().toString());
            metadata.put((Object)"comment", (Object)this.catalogDatabase.description());
            return (Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)metadata).asJava();
        }

        public CatalogDatabaseHelper(CatalogDatabase catalogDatabase) {
            this.catalogDatabase = catalogDatabase;
        }
    }

    public class TableIdentifierHelper {
        private final Identifier ident;
        public final /* synthetic */ V2SessionCatalog $outer;

        public TableIdentifier asTableIdentifier() {
            String[] stringArray = this.ident.namespace();
            Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
            if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(1) == 0) {
                String db = (String)((SeqLike)option.get()).apply(0);
                return TableIdentifier$.MODULE$.apply(this.ident.name(), (Option)new Some((Object)db));
            }
            throw QueryCompilationErrors$.MODULE$.requiresSinglePartNamespaceError((Seq)Predef$.MODULE$.wrapRefArray((Object[])stringArray));
        }

        public FunctionIdentifier asFunctionIdentifier() {
            String[] stringArray = this.ident.namespace();
            Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
            if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(1) == 0) {
                String db = (String)((SeqLike)option.get()).apply(0);
                return FunctionIdentifier$.MODULE$.apply(this.ident.name(), (Option)new Some((Object)db));
            }
            throw QueryCompilationErrors$.MODULE$.requiresSinglePartNamespaceError((Seq)Predef$.MODULE$.wrapRefArray((Object[])stringArray));
        }

        public /* synthetic */ V2SessionCatalog org$apache$spark$sql$execution$datasources$v2$V2SessionCatalog$TableIdentifierHelper$$$outer() {
            return this.$outer;
        }

        public TableIdentifierHelper(V2SessionCatalog $outer, Identifier ident) {
            this.ident = ident;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

