/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.streaming.ui;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.streaming.ui.StreamingQueryUIData;
import scala.Function0;
import scala.Function1;
import scala.Serializable;

public final class UIUtils$ {
    public static UIUtils$ MODULE$;
    private final ThreadLocal<SimpleDateFormat> progressTimestampFormat;

    static {
        new UIUtils$();
    }

    public double withNumberInvalid(Function0<Object> number) {
        if (Double.isNaN(number.apply$mcD$sp()) || Double.isInfinite(number.apply$mcD$sp())) {
            return 0.0;
        }
        return number.apply$mcD$sp();
    }

    public <T> T withNoProgress(StreamingQueryUIData query, Function0<T> body, T t) {
        if (query.lastProgress() != null) {
            return (T)body.apply();
        }
        return t;
    }

    public String getQueryName(StreamingQueryUIData uiData) {
        if (uiData.summary().name() == null || uiData.summary().name().isEmpty()) {
            return "<no name>";
        }
        return uiData.summary().name();
    }

    public String getQueryStatus(StreamingQueryUIData uiData) {
        if (uiData.summary().isActive()) {
            return "RUNNING";
        }
        return (String)uiData.summary().exception().map((Function1 & java.io.Serializable & Serializable)x$1 -> "FAILED").getOrElse((Function0 & java.io.Serializable & Serializable)() -> "FINISHED");
    }

    private ThreadLocal<SimpleDateFormat> progressTimestampFormat() {
        return this.progressTimestampFormat;
    }

    public long parseProgressTimestamp(String timestamp) {
        return ((DateFormat)this.progressTimestampFormat().get()).parse(timestamp).getTime();
    }

    private UIUtils$() {
        MODULE$ = this;
        this.progressTimestampFormat = new ThreadLocal<SimpleDateFormat>(){

            public SimpleDateFormat initialValue() {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
                format.setTimeZone(DateTimeUtils$.MODULE$.getTimeZone("UTC"));
                return format;
            }
        };
    }
}

