/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.io.Serializable;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.jdbc.OracleDialect;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

public final class OracleDialect$
extends JdbcDialect
implements Product {
    public static OracleDialect$ MODULE$;
    private final int BINARY_FLOAT;
    private final int BINARY_DOUBLE;
    private final int TIMESTAMPTZ;
    private final Set<String> org$apache$spark$sql$jdbc$OracleDialect$$distinctUnsupportedAggregateFunctions;
    private final Set<String> supportedAggregateFunctions;
    private final Set<String> supportedFunctions;

    static {
        new OracleDialect$();
    }

    public int BINARY_FLOAT() {
        return this.BINARY_FLOAT;
    }

    public int BINARY_DOUBLE() {
        return this.BINARY_DOUBLE;
    }

    public int TIMESTAMPTZ() {
        return this.TIMESTAMPTZ;
    }

    @Override
    public boolean canHandle(String url) {
        return url.toLowerCase(Locale.ROOT).startsWith("jdbc:oracle");
    }

    public Set<String> org$apache$spark$sql$jdbc$OracleDialect$$distinctUnsupportedAggregateFunctions() {
        return this.org$apache$spark$sql$jdbc$OracleDialect$$distinctUnsupportedAggregateFunctions;
    }

    private Set<String> supportedAggregateFunctions() {
        return this.supportedAggregateFunctions;
    }

    private Set<String> supportedFunctions() {
        return this.supportedFunctions;
    }

    @Override
    public boolean isSupportedFunction(String funcName) {
        return this.supportedFunctions().contains((Object)funcName);
    }

    @Override
    public Option<String> compileExpression(Expression expr) {
        Some some;
        OracleDialect.OracleSQLBuilder oracleSQLBuilder = new OracleDialect.OracleSQLBuilder();
        try {
            some = new Some((Object)oracleSQLBuilder.build(expr));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error occurs while compiling V2 expression", e);
                some = None$.MODULE$;
            }
            throw throwable;
        }
        return some;
    }

    private boolean supportTimeZoneTypes() {
        TimeZone timeZone;
        TimeZone timeZone2 = timeZone = DateTimeUtils$.MODULE$.getTimeZone(SQLConf$.MODULE$.get().sessionLocalTimeZone());
        TimeZone timeZone3 = TimeZone.getDefault();
        return !(timeZone2 != null ? !timeZone2.equals(timeZone3) : timeZone3 != null);
    }

    @Override
    public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
        int n = sqlType;
        if (2 == n) {
            long scale = md != null ? md.build().getLong("scale") : 0L;
            int n2 = size;
            switch (n2) {
                case 0: {
                    return Option$.MODULE$.apply((Object)new DecimalType(DecimalType$.MODULE$.MAX_PRECISION(), 10));
                }
            }
            if (scale == -127L) {
                return Option$.MODULE$.apply((Object)new DecimalType(DecimalType$.MODULE$.MAX_PRECISION(), 10));
            }
            return None$.MODULE$;
        }
        if (this.TIMESTAMPTZ() == n && this.supportTimeZoneTypes()) {
            return new Some((Object)TimestampType$.MODULE$);
        }
        if (this.BINARY_FLOAT() == n) {
            return new Some((Object)FloatType$.MODULE$);
        }
        if (this.BINARY_DOUBLE() == n) {
            return new Some((Object)DoubleType$.MODULE$);
        }
        return None$.MODULE$;
    }

    @Override
    public Option<JdbcType> getJDBCType(DataType dt) {
        DataType dataType = dt;
        if (BooleanType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("NUMBER(1)", 16));
        }
        if (IntegerType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("NUMBER(10)", 4));
        }
        if (LongType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("NUMBER(19)", -5));
        }
        if (FloatType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("NUMBER(19, 4)", 6));
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("NUMBER(19, 4)", 8));
        }
        if (ByteType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("NUMBER(3)", 5));
        }
        if (ShortType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("NUMBER(5)", 5));
        }
        if (StringType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("VARCHAR2(255)", 12));
        }
        return None$.MODULE$;
    }

    @Override
    public Object compileValue(Object value2) {
        Object object = value2;
        if (object instanceof String) {
            String string = (String)object;
            return new StringBuilder(2).append("'").append(this.escapeSql(string)).append("'").toString();
        }
        if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            return new StringBuilder(7).append("{ts '").append(timestamp).append("'}").toString();
        }
        if (object instanceof Date) {
            Date date = (Date)object;
            return new StringBuilder(6).append("{d '").append(date).append("'}").toString();
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            return Predef$.MODULE$.genericArrayOps(Predef$.MODULE$.genericArrayOps((Object)objectArray).map((Function1 & Serializable & scala.Serializable)value -> MODULE$.compileValue(value), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()))).mkString(", ");
        }
        return value2;
    }

    @Override
    public Option<Object> isCascadingTruncateTable() {
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    @Override
    public String getTruncateQuery(String table, Option<Object> cascade) {
        Some some;
        boolean bl;
        Option<Object> option = cascade;
        if (option instanceof Some && (bl = BoxesRunTime.unboxToBoolean((Object)(some = (Some)option).value()))) {
            return new StringBuilder(23).append("TRUNCATE TABLE ").append(table).append(" CASCADE").toString();
        }
        return new StringBuilder(15).append("TRUNCATE TABLE ").append(table).toString();
    }

    @Override
    public Option<Object> getTruncateQuery$default$2() {
        return this.isCascadingTruncateTable();
    }

    @Override
    public String getAddColumnQuery(String tableName, String columnName, String dataType) {
        return new StringBuilder(18).append("ALTER TABLE ").append(tableName).append(" ADD ").append(this.quoteIdentifier(columnName)).append(" ").append(dataType).toString();
    }

    @Override
    public String getUpdateColumnTypeQuery(String tableName, String columnName, String newDataType) {
        return new StringBuilder(21).append("ALTER TABLE ").append(tableName).append(" MODIFY ").append(this.quoteIdentifier(columnName)).append(" ").append(newDataType).toString();
    }

    @Override
    public String getUpdateColumnNullabilityQuery(String tableName, String columnName, boolean isNullable) {
        String nullable = isNullable ? "NULL" : "NOT NULL";
        return new StringBuilder(21).append("ALTER TABLE ").append(tableName).append(" MODIFY ").append(this.quoteIdentifier(columnName)).append(" ").append(nullable).toString();
    }

    public String productPrefix() {
        return "OracleDialect";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof OracleDialect$;
    }

    public int hashCode() {
        return 959235752;
    }

    public String toString() {
        return "OracleDialect";
    }

    private Object readResolve() {
        return MODULE$;
    }

    private OracleDialect$() {
        MODULE$ = this;
        Product.$init$((Product)this);
        this.BINARY_FLOAT = 100;
        this.BINARY_DOUBLE = 101;
        this.TIMESTAMPTZ = -101;
        this.org$apache$spark$sql$jdbc$OracleDialect$$distinctUnsupportedAggregateFunctions = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"VAR_POP", "VAR_SAMP", "STDDEV_POP", "STDDEV_SAMP", "COVAR_POP", "COVAR_SAMP", "CORR", "REGR_INTERCEPT", "REGR_R2", "REGR_SLOPE", "REGR_SXY"}));
        this.supportedAggregateFunctions = (Set)((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MAX", "MIN", "SUM", "COUNT", "AVG"}))).$plus$plus(this.org$apache$spark$sql$jdbc$OracleDialect$$distinctUnsupportedAggregateFunctions());
        this.supportedFunctions = this.supportedAggregateFunctions();
    }
}

