/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.benchmark;

import java.io.Serializable;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.spark.benchmark.Benchmark;
import org.apache.spark.benchmark.Benchmark$;
import org.apache.spark.benchmark.BenchmarkBase;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.execution.vectorized.ColumnVectorUtils;
import org.apache.spark.sql.execution.vectorized.ConstantColumnVector;
import org.apache.spark.sql.execution.vectorized.OffHeapColumnVector;
import org.apache.spark.sql.execution.vectorized.OnHeapColumnVector;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.unsafe.UTF8StringBuilder;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class ConstantColumnVectorBenchmark$
extends BenchmarkBase {
    public static ConstantColumnVectorBenchmark$ MODULE$;

    static {
        new ConstantColumnVectorBenchmark$();
    }

    private void populate(WritableColumnVector col, int batchSize, InternalRow row, int fieldIdx) {
        DataType dataType = col.dataType();
        if (IntegerType$.MODULE$.equals(dataType)) {
            col.putInts(0, batchSize, row.getInt(fieldIdx));
            return;
        }
        if (LongType$.MODULE$.equals(dataType)) {
            col.putLongs(0, batchSize, row.getLong(fieldIdx));
            return;
        }
        if (FloatType$.MODULE$.equals(dataType)) {
            col.putFloats(0, batchSize, row.getFloat(fieldIdx));
            return;
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            col.putDoubles(0, batchSize, row.getDouble(fieldIdx));
            return;
        }
        if (StringType$.MODULE$.equals(dataType)) {
            UTF8String v = row.getUTF8String(fieldIdx);
            byte[] bytes = v.getBytes();
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), batchSize).foreach((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)i -> col.putByteArray(i, bytes));
            return;
        }
        throw new MatchError((Object)dataType);
    }

    private void readValues(DataType dataType, int batchSize, ColumnVector vector) {
        DataType dataType2 = dataType;
        if (IntegerType$.MODULE$.equals(dataType2)) {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), batchSize).foreach((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)i -> vector.getInt(i));
            return;
        }
        if (LongType$.MODULE$.equals(dataType2)) {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), batchSize).foreach((Function1)(JFunction1.mcJI.sp & Serializable & scala.Serializable)i -> vector.getLong(i));
            return;
        }
        if (FloatType$.MODULE$.equals(dataType2)) {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), batchSize).foreach((Function1)(JFunction1.mcFI.sp & Serializable & scala.Serializable)i -> vector.getFloat(i));
            return;
        }
        if (DoubleType$.MODULE$.equals(dataType2)) {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), batchSize).foreach((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)i -> vector.getDouble(i));
            return;
        }
        if (StringType$.MODULE$.equals(dataType2)) {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), batchSize).foreach((Function1 & Serializable & scala.Serializable)i -> vector.getUTF8String(BoxesRunTime.unboxToInt((Object)i)));
            return;
        }
        throw new MatchError((Object)dataType2);
    }

    public void testWrite(int valuesPerIteration, int batchSize, DataType dataType, InternalRow row) {
        OnHeapColumnVector onHeapColumnVector = new OnHeapColumnVector(batchSize, dataType);
        OffHeapColumnVector offHeapColumnVector = new OffHeapColumnVector(batchSize, dataType);
        ConstantColumnVector constantColumnVector = new ConstantColumnVector(batchSize, dataType);
        DataType dataType2 = dataType;
        StringType$ stringType$ = StringType$.MODULE$;
        String other = !(dataType2 != null ? !dataType2.equals(stringType$) : stringType$ != null) ? new StringBuilder(15).append(", row length = ").append(row.getUTF8String(0).toString().length()).toString() : "";
        String x$12 = new StringBuilder(16).append("Test write with ").append(dataType).append(other).toString();
        long x$22 = valuesPerIteration * batchSize;
        Option x$32 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark(x$12, x$22, x$4, x$5, x$6, x$7, x$32);
        benchmark.addCase("ConstantColumnVector", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$1 -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), valuesPerIteration).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> ColumnVectorUtils.populate((ConstantColumnVector)constantColumnVector, (InternalRow)row, (int)0)));
        benchmark.addCase("OnHeapColumnVector", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$2 -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), valuesPerIteration).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            onHeapColumnVector.reset();
            MODULE$.populate((WritableColumnVector)onHeapColumnVector, batchSize, row, 0);
        }));
        benchmark.addCase("OffHeapColumnVector", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$3 -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), valuesPerIteration).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            offHeapColumnVector.reset();
            MODULE$.populate((WritableColumnVector)offHeapColumnVector, batchSize, row, 0);
        }));
        benchmark.run();
        onHeapColumnVector.close();
        offHeapColumnVector.close();
        constantColumnVector.close();
    }

    public void testRead(int valuesPerIteration, int batchSize, DataType dataType, InternalRow row) {
        OnHeapColumnVector onHeapColumnVector = new OnHeapColumnVector(batchSize, dataType);
        OffHeapColumnVector offHeapColumnVector = new OffHeapColumnVector(batchSize, dataType);
        ConstantColumnVector constantColumnVector = new ConstantColumnVector(batchSize, dataType);
        onHeapColumnVector.reset();
        this.populate((WritableColumnVector)onHeapColumnVector, batchSize, row, 0);
        offHeapColumnVector.reset();
        this.populate((WritableColumnVector)offHeapColumnVector, batchSize, row, 0);
        ColumnVectorUtils.populate((ConstantColumnVector)constantColumnVector, (InternalRow)row, (int)0);
        DataType dataType2 = dataType;
        StringType$ stringType$ = StringType$.MODULE$;
        String other = !(dataType2 != null ? !dataType2.equals(stringType$) : stringType$ != null) ? new StringBuilder(15).append(", row length = ").append(row.getUTF8String(0).toString().length()).toString() : "";
        String x$1 = new StringBuilder(15).append("Test read with ").append(dataType).append(other).toString();
        long x$2 = valuesPerIteration * batchSize;
        Option x$3 = this.output();
        int x$42 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$52 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$62 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark(x$1, x$2, x$42, x$52, x$62, x$7, x$3);
        benchmark.addCase("ConstantColumnVector", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$4 -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), valuesPerIteration).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> MODULE$.readValues(dataType, batchSize, (ColumnVector)constantColumnVector)));
        benchmark.addCase("OnHeapColumnVector", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$5 -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), valuesPerIteration).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> MODULE$.readValues(dataType, batchSize, (ColumnVector)onHeapColumnVector)));
        benchmark.addCase("OffHeapColumnVector", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$6 -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), valuesPerIteration).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> MODULE$.readValues(dataType, batchSize, (ColumnVector)offHeapColumnVector)));
        benchmark.run();
        onHeapColumnVector.close();
        offHeapColumnVector.close();
        constantColumnVector.close();
    }

    public void testWriteAndRead(int valuesPerIteration, int batchSize, DataType dataType, InternalRow row) {
        OnHeapColumnVector onHeapColumnVector = new OnHeapColumnVector(batchSize, dataType);
        OffHeapColumnVector offHeapColumnVector = new OffHeapColumnVector(batchSize, dataType);
        ConstantColumnVector constantColumnVector = new ConstantColumnVector(batchSize, dataType);
        DataType dataType2 = dataType;
        StringType$ stringType$ = StringType$.MODULE$;
        String other = !(dataType2 != null ? !dataType2.equals(stringType$) : stringType$ != null) ? new StringBuilder(15).append(", row length = ").append(row.getUTF8String(0).toString().length()).toString() : "";
        String x$1 = new StringBuilder(25).append("Test write and read with ").append(dataType).append(other).toString();
        long x$2 = valuesPerIteration * batchSize;
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$72 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark(x$1, x$2, x$4, x$5, x$6, x$72, x$3);
        benchmark.addCase("ConstantColumnVector", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$7 -> {
            ColumnVectorUtils.populate((ConstantColumnVector)constantColumnVector, (InternalRow)row, (int)0);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), valuesPerIteration).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> MODULE$.readValues(dataType, batchSize, (ColumnVector)constantColumnVector));
        });
        benchmark.addCase("OnHeapColumnVector", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$8 -> {
            onHeapColumnVector.reset();
            MODULE$.populate((WritableColumnVector)onHeapColumnVector, batchSize, row, 0);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), valuesPerIteration).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> MODULE$.readValues(dataType, batchSize, (ColumnVector)onHeapColumnVector));
        });
        benchmark.addCase("OffHeapColumnVector", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$9 -> {
            offHeapColumnVector.reset();
            MODULE$.populate((WritableColumnVector)offHeapColumnVector, batchSize, row, 0);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), valuesPerIteration).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> MODULE$.readValues(dataType, batchSize, (ColumnVector)offHeapColumnVector));
        });
        benchmark.run();
        onHeapColumnVector.close();
        offHeapColumnVector.close();
        constantColumnVector.close();
    }

    public void testIsNull(int valuesPerIteration, int batchSize, DataType dataType) {
        OnHeapColumnVector onHeapColumnVector = new OnHeapColumnVector(batchSize, dataType);
        OffHeapColumnVector offHeapColumnVector = new OffHeapColumnVector(batchSize, dataType);
        ConstantColumnVector constantColumnVector = new ConstantColumnVector(batchSize, dataType);
        onHeapColumnVector.putNulls(0, batchSize);
        offHeapColumnVector.putNulls(0, batchSize);
        constantColumnVector.setNull();
        String x$1 = new StringBuilder(17).append("Test isNull with ").append(dataType).toString();
        long x$2 = valuesPerIteration * batchSize;
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark(x$1, x$2, x$4, x$5, x$6, x$7, x$3);
        benchmark.addCase("ConstantColumnVector", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$10 -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), valuesPerIteration).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), batchSize).foreach((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$1 -> constantColumnVector.isNullAt(x$1))));
        benchmark.addCase("OnHeapColumnVector", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$11 -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), valuesPerIteration).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), batchSize).foreach((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$1 -> onHeapColumnVector.isNullAt(x$1))));
        benchmark.addCase("OffHeapColumnVector", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$12 -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), valuesPerIteration).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), batchSize).foreach((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$1 -> offHeapColumnVector.isNullAt(x$1))));
        benchmark.run();
        onHeapColumnVector.close();
        offHeapColumnVector.close();
        constantColumnVector.close();
    }

    public void runBenchmarkSuite(String[] mainArgs) {
        int valuesPerIteration = 100000;
        int batchSize = 4096;
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 5, 10, 15, 20, 30}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)length -> {
            UTF8StringBuilder builder = new UTF8StringBuilder();
            builder.append(RandomStringUtils.random((int)length));
            InternalRow row = InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{builder.build()}));
            MODULE$.testWrite(valuesPerIteration, batchSize, (DataType)StringType$.MODULE$, row);
        });
        this.testWrite(valuesPerIteration, batchSize, (DataType)IntegerType$.MODULE$, InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)100)})));
        this.testWrite(valuesPerIteration, batchSize, (DataType)LongType$.MODULE$, InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)100L)})));
        this.testWrite(valuesPerIteration, batchSize, (DataType)FloatType$.MODULE$, InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)100.0f)})));
        this.testWrite(valuesPerIteration, batchSize, (DataType)DoubleType$.MODULE$, InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)100.0)})));
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 5, 10, 15, 20, 30}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)length -> {
            UTF8StringBuilder builder = new UTF8StringBuilder();
            builder.append(RandomStringUtils.random((int)length));
            InternalRow row = InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{builder.build()}));
            MODULE$.testRead(valuesPerIteration, batchSize, (DataType)StringType$.MODULE$, row);
        });
        this.testRead(valuesPerIteration, batchSize, (DataType)IntegerType$.MODULE$, InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)100)})));
        this.testRead(valuesPerIteration, batchSize, (DataType)LongType$.MODULE$, InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)100L)})));
        this.testRead(valuesPerIteration, batchSize, (DataType)FloatType$.MODULE$, InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)100.0f)})));
        this.testRead(valuesPerIteration, batchSize, (DataType)DoubleType$.MODULE$, InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)100.0)})));
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 5, 10, 15, 20, 30}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)length -> {
            UTF8StringBuilder builder = new UTF8StringBuilder();
            builder.append(RandomStringUtils.random((int)length));
            InternalRow row = InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{builder.build()}));
            MODULE$.testWriteAndRead(valuesPerIteration, batchSize, (DataType)StringType$.MODULE$, row);
        });
        this.testWriteAndRead(valuesPerIteration, batchSize, (DataType)IntegerType$.MODULE$, InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)100)})));
        this.testWriteAndRead(valuesPerIteration, batchSize, (DataType)LongType$.MODULE$, InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)100L)})));
        this.testWriteAndRead(valuesPerIteration, batchSize, (DataType)FloatType$.MODULE$, InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)100.0f)})));
        this.testWriteAndRead(valuesPerIteration, batchSize, (DataType)DoubleType$.MODULE$, InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)100.0)})));
        this.testIsNull(valuesPerIteration, batchSize, (DataType)StringType$.MODULE$);
        this.testIsNull(valuesPerIteration, batchSize, (DataType)IntegerType$.MODULE$);
        this.testIsNull(valuesPerIteration, batchSize, (DataType)LongType$.MODULE$);
        this.testIsNull(valuesPerIteration, batchSize, (DataType)FloatType$.MODULE$);
        this.testIsNull(valuesPerIteration, batchSize, (DataType)DoubleType$.MODULE$);
    }

    private ConstantColumnVectorBenchmark$() {
        MODULE$ = this;
    }
}

