/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Map;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.IndexAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.NoSuchIndexException;
import org.apache.spark.sql.catalyst.analysis.NonEmptyNamespaceException;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions$;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcUtils$;
import org.apache.spark.sql.execution.datasources.v2.TableSampleInfo;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class PostgresDialect$
extends JdbcDialect
implements SQLConfHelper {
    public static PostgresDialect$ MODULE$;
    private final Set<String> supportedAggregateFunctions;
    private final Set<String> supportedFunctions;

    static {
        new PostgresDialect$();
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    @Override
    public boolean canHandle(String url) {
        return url.toLowerCase(Locale.ROOT).startsWith("jdbc:postgresql");
    }

    private Set<String> supportedAggregateFunctions() {
        return this.supportedAggregateFunctions;
    }

    private Set<String> supportedFunctions() {
        return this.supportedFunctions;
    }

    @Override
    public boolean isSupportedFunction(String funcName) {
        return this.supportedFunctions().contains((Object)funcName);
    }

    @Override
    public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
        if (sqlType == 7) {
            return new Some((Object)FloatType$.MODULE$);
        }
        if (sqlType == 5) {
            return new Some((Object)ShortType$.MODULE$);
        }
        if (sqlType == -7) {
            String string = typeName;
            String string2 = "bit";
            if (!(string != null ? !string.equals(string2) : string2 != null) && size != 1) {
                return new Some((Object)BinaryType$.MODULE$);
            }
        }
        if (sqlType == 8) {
            String string = typeName;
            String string3 = "money";
            if (!(string != null ? !string.equals(string3) : string3 != null)) {
                return new Some((Object)StringType$.MODULE$);
            }
        }
        if (sqlType == 1111) {
            return new Some((Object)StringType$.MODULE$);
        }
        if (sqlType == 2003) {
            int scale = (int)md.build().getLong("scale");
            return this.toCatalystType((String)new StringOps(Predef$.MODULE$.augmentString(typeName)).drop(1), size, scale).map((Function1 & Serializable & scala.Serializable)x$1 -> ArrayType$.MODULE$.apply(x$1));
        }
        return None$.MODULE$;
    }

    private Option<DataType> toCatalystType(String typeName, int precision, int scale) {
        String string = typeName;
        if ("bool".equals(string)) {
            return new Some((Object)BooleanType$.MODULE$);
        }
        if ("bit".equals(string)) {
            return new Some((Object)BinaryType$.MODULE$);
        }
        if ("int2".equals(string)) {
            return new Some((Object)ShortType$.MODULE$);
        }
        if ("int4".equals(string)) {
            return new Some((Object)IntegerType$.MODULE$);
        }
        if ("int8".equals(string) ? true : "oid".equals(string)) {
            return new Some((Object)LongType$.MODULE$);
        }
        if ("float4".equals(string)) {
            return new Some((Object)FloatType$.MODULE$);
        }
        if ("float8".equals(string)) {
            return new Some((Object)DoubleType$.MODULE$);
        }
        if ("text".equals(string) ? true : ("varchar".equals(string) ? true : ("char".equals(string) ? true : ("bpchar".equals(string) ? true : ("cidr".equals(string) ? true : ("inet".equals(string) ? true : ("json".equals(string) ? true : ("jsonb".equals(string) ? true : ("uuid".equals(string) ? true : ("xml".equals(string) ? true : ("tsvector".equals(string) ? true : ("tsquery".equals(string) ? true : ("macaddr".equals(string) ? true : ("macaddr8".equals(string) ? true : ("txid_snapshot".equals(string) ? true : ("point".equals(string) ? true : ("line".equals(string) ? true : ("lseg".equals(string) ? true : ("box".equals(string) ? true : ("path".equals(string) ? true : ("polygon".equals(string) ? true : ("circle".equals(string) ? true : ("pg_lsn".equals(string) ? true : ("varbit".equals(string) ? true : ("interval".equals(string) ? true : "pg_snapshot".equals(string)))))))))))))))))))))))))) {
            return new Some((Object)StringType$.MODULE$);
        }
        if ("bytea".equals(string)) {
            return new Some((Object)BinaryType$.MODULE$);
        }
        if ("timestamp".equals(string) ? true : ("timestamptz".equals(string) ? true : ("time".equals(string) ? true : "timetz".equals(string)))) {
            return new Some((Object)TimestampType$.MODULE$);
        }
        if ("date".equals(string)) {
            return new Some((Object)DateType$.MODULE$);
        }
        if (("numeric".equals(string) ? true : "decimal".equals(string)) && precision > 0) {
            return new Some((Object)DecimalType$.MODULE$.bounded(precision, scale));
        }
        if ("numeric".equals(string) ? true : "decimal".equals(string)) {
            return new Some((Object)DecimalType$.MODULE$.SYSTEM_DEFAULT());
        }
        if ("money".equals(string)) {
            return None$.MODULE$;
        }
        return None$.MODULE$;
    }

    @Override
    public Option<JdbcType> getJDBCType(DataType dt) {
        ArrayType arrayType;
        DataType et;
        DataType dataType = dt;
        if (StringType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("TEXT", 1));
        }
        if (BinaryType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("BYTEA", -2));
        }
        if (BooleanType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("BOOLEAN", 16));
        }
        if (FloatType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("FLOAT4", 6));
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("FLOAT8", 8));
        }
        if (ShortType$.MODULE$.equals(dataType) ? true : ByteType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("SMALLINT", 5));
        }
        if (dataType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType;
            return new Some((Object)new JdbcType(new StringBuilder(10).append("NUMERIC(").append(decimalType.precision()).append(",").append(decimalType.scale()).append(")").toString(), 2));
        }
        if (dataType instanceof ArrayType && (et = (arrayType = (ArrayType)dataType).elementType()) instanceof AtomicType) {
            return this.getJDBCType(et).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.databaseTypeDefinition()).orElse((Function0 & Serializable & scala.Serializable)() -> JdbcUtils$.MODULE$.getCommonJDBCType(et).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.databaseTypeDefinition())).map((Function1 & Serializable & scala.Serializable)typeName -> new JdbcType(new StringBuilder(2).append((String)typeName).append("[]").toString(), 2003));
        }
        return None$.MODULE$;
    }

    @Override
    public Option<Object> isCascadingTruncateTable() {
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    @Override
    public String getTruncateQuery(String table, Option<Object> cascade) {
        Some some;
        boolean bl;
        Option<Object> option = cascade;
        if (option instanceof Some && (bl = BoxesRunTime.unboxToBoolean((Object)(some = (Some)option).value()))) {
            return new StringBuilder(28).append("TRUNCATE TABLE ONLY ").append(table).append(" CASCADE").toString();
        }
        return new StringBuilder(20).append("TRUNCATE TABLE ONLY ").append(table).toString();
    }

    @Override
    public Option<Object> getTruncateQuery$default$2() {
        return this.isCascadingTruncateTable();
    }

    @Override
    public void beforeFetch(Connection connection, scala.collection.immutable.Map<String, String> properties) {
        super.beforeFetch(connection, properties);
        if (new StringOps(Predef$.MODULE$.augmentString((String)properties.getOrElse((Object)JDBCOptions$.MODULE$.JDBC_BATCH_FETCH_SIZE(), (Function0 & Serializable & scala.Serializable)() -> "0"))).toInt() > 0) {
            connection.setAutoCommit(false);
            return;
        }
    }

    @Override
    public String getUpdateColumnTypeQuery(String tableName, String columnName, String newDataType) {
        return new StringBuilder(32).append("ALTER TABLE ").append(tableName).append(" ALTER COLUMN ").append(this.quoteIdentifier(columnName)).append(" TYPE ").append(newDataType).toString();
    }

    @Override
    public String getUpdateColumnNullabilityQuery(String tableName, String columnName, boolean isNullable) {
        String nullable = isNullable ? "DROP NOT NULL" : "SET NOT NULL";
        return new StringBuilder(27).append("ALTER TABLE ").append(tableName).append(" ALTER COLUMN ").append(this.quoteIdentifier(columnName)).append(" ").append(nullable).toString();
    }

    @Override
    public boolean supportsTableSample() {
        return true;
    }

    @Override
    public String getTableSample(TableSampleInfo sample) {
        return new StringBuilder(38).append("TABLESAMPLE BERNOULLI").append(" (").append((sample.upperBound() - sample.lowerBound()) * (double)100).append(") REPEATABLE (").append(sample.seed()).append(")").toString();
    }

    @Override
    public String createIndex(String indexName, Identifier tableIdent, NamedReference[] columns, Map<NamedReference, Map<String, String>> columnsProperties, Map<String, String> properties) {
        String[] columnList = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])columns)).map((Function1 & Serializable & scala.Serializable)col -> MODULE$.quoteIdentifier((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])col.fieldNames())).head()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        String indexProperties = "";
        Tuple2<String, String[]> tuple2 = JdbcUtils$.MODULE$.processIndexProperties(properties, "postgresql");
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String indexType = (String)tuple2._1();
        String[] indexPropertyList = (String[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)indexType, (Object)indexPropertyList);
        String indexType2 = (String)tuple22._1();
        String[] indexPropertyList2 = (String[])tuple22._2();
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])indexPropertyList2)).nonEmpty()) {
            indexProperties = new StringBuilder(7).append("WITH (").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])indexPropertyList2)).mkString(", ")).append(")").toString();
        }
        return new StringBuilder(22).append("CREATE INDEX ").append(this.quoteIdentifier(indexName)).append(" ON ").append(this.quoteIdentifier(tableIdent.name())).append(" ").append(indexType2).append(" (").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])columnList)).mkString(", ")).append(") ").append(indexProperties).toString();
    }

    @Override
    public boolean indexExists(Connection conn, String indexName, Identifier tableIdent, JDBCOptions options) {
        String sql = new StringBuilder(64).append("SELECT * FROM pg_indexes WHERE tablename = '").append(tableIdent.name()).append("' AND").append(" indexname = '").append(indexName).append("'").toString();
        return JdbcUtils$.MODULE$.checkIfIndexExists(conn, sql, options);
    }

    @Override
    public String dropIndex(String indexName, Identifier tableIdent) {
        return new StringBuilder(11).append("DROP INDEX ").append(this.quoteIdentifier(indexName)).toString();
    }

    @Override
    public AnalysisException classifyException(String message, Throwable e) {
        Throwable throwable = e;
        if (throwable instanceof SQLException) {
            SQLException sQLException = (SQLException)throwable;
            String string = sQLException.getSQLState();
            if ("42P07".equals(string)) {
                Regex regex = new StringOps(Predef$.MODULE$.augmentString("(?s)Failed to create index (.*) in (.*)")).r();
                String indexName = ((Regex.MatchData)regex.findFirstMatchIn((CharSequence)message).get()).group(1);
                String tableName = ((Regex.MatchData)regex.findFirstMatchIn((CharSequence)message).get()).group(2);
                throw new IndexAlreadyExistsException(indexName, tableName, (Option)new Some((Object)e));
            }
            if ("42704".equals(string)) {
                Regex regex = new StringOps(Predef$.MODULE$.augmentString("(?s)Failed to drop index (.*) in (.*)")).r();
                String indexName = ((Regex.MatchData)regex.findFirstMatchIn((CharSequence)message).get()).group(1);
                String tableName = ((Regex.MatchData)regex.findFirstMatchIn((CharSequence)message).get()).group(2);
                throw new NoSuchIndexException(indexName, tableName, (Option)new Some((Object)e));
            }
            if ("2BP01".equals(string)) {
                throw new NonEmptyNamespaceException(message, (Option)new Some((Object)e));
            }
            return super.classifyException(message, e);
        }
        if (throwable instanceof UnsupportedOperationException) {
            UnsupportedOperationException unsupportedOperationException = (UnsupportedOperationException)throwable;
            throw unsupportedOperationException;
        }
        return super.classifyException(message, e);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private PostgresDialect$() {
        MODULE$ = this;
        SQLConfHelper.$init$((SQLConfHelper)this);
        this.supportedAggregateFunctions = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MAX", "MIN", "SUM", "COUNT", "AVG", "VAR_POP", "VAR_SAMP", "STDDEV_POP", "STDDEV_SAMP", "COVAR_POP", "COVAR_SAMP", "CORR", "REGR_INTERCEPT", "REGR_R2", "REGR_SLOPE", "REGR_SXY"}));
        this.supportedFunctions = this.supportedAggregateFunctions();
    }
}

