/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.arrow;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.ipc.ReadChannel;
import org.apache.arrow.vector.ipc.WriteChannel;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.arrow.vector.ipc.message.MessageMetadataResult;
import org.apache.arrow.vector.ipc.message.MessageSerializer;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.internal.Logging;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.arrow.ArrowConverters;
import org.apache.spark.sql.types.DataType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.vectorized.ArrowColumnVector;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import org.apache.spark.util.ByteBufferOutputStream;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public final class ArrowConverters$
implements Logging {
    public static ArrowConverters$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new ArrowConverters$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public ArrowConverters.ArrowBatchIterator toBatchIterator(Iterator<InternalRow> rowIter, StructType schema, long maxRecordsPerBatch, String timeZoneId, TaskContext context) {
        return new ArrowConverters.ArrowBatchIterator(rowIter, schema, maxRecordsPerBatch, timeZoneId, context);
    }

    public ArrowConverters.ArrowBatchWithSchemaIterator toBatchWithSchemaIterator(Iterator<InternalRow> rowIter, StructType schema, long maxRecordsPerBatch, long maxEstimatedBatchSize, String timeZoneId) {
        return new ArrowConverters.ArrowBatchWithSchemaIterator(rowIter, schema, maxRecordsPerBatch, maxEstimatedBatchSize, timeZoneId, TaskContext$.MODULE$.get());
    }

    public byte[] createEmptyArrowBatch(StructType schema, String timeZoneId) {
        return new ArrowConverters.ArrowBatchWithSchemaIterator(schema, timeZoneId){

            public boolean hasNext() {
                return true;
            }
        }.next();
    }

    public Iterator<InternalRow> fromBatchIterator(Iterator<byte[]> arrowBatchIter, StructType schema, String timeZoneId, TaskContext context) {
        return new ArrowConverters.InternalRowIteratorWithoutSchema(arrowBatchIter, schema, timeZoneId, context);
    }

    public Tuple2<Iterator<InternalRow>, StructType> fromBatchWithSchemaIterator(Iterator<byte[]> arrowBatchIter, TaskContext context) {
        ArrowConverters.InternalRowIteratorWithSchema iterator = new ArrowConverters.InternalRowIteratorWithSchema(arrowBatchIter, context);
        return new Tuple2((Object)iterator, (Object)iterator.schema());
    }

    public Iterator<InternalRow> org$apache$spark$sql$execution$arrow$ArrowConverters$$vectorSchemaRootToIter(VectorSchemaRoot root) {
        ColumnVector[] columns = (ColumnVector[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(root.getFieldVectors()).asScala()).map((Function1 & Serializable & scala.Serializable)vector -> new ArrowColumnVector((ValueVector)vector), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ColumnVector.class));
        ColumnarBatch batch = new ColumnarBatch(columns);
        batch.setNumRows(root.getRowCount());
        return (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(batch.rowIterator()).asScala();
    }

    public ArrowRecordBatch loadBatch(byte[] batchBytes, BufferAllocator allocator) {
        ByteArrayInputStream in = new ByteArrayInputStream(batchBytes);
        return MessageSerializer.deserializeRecordBatch((ReadChannel)new ReadChannel(Channels.newChannel(in)), (BufferAllocator)allocator);
    }

    public Dataset<Row> toDataFrame(Iterator<byte[]> arrowBatches, String schemaString, SparkSession session) {
        boolean shouldUseRDD;
        StructType schema = (StructType)DataType$.MODULE$.fromJson(schemaString);
        Seq attrs = schema.toAttributes();
        byte[][] batchesInDriver = (byte[][])arrowBatches.toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
        boolean bl = shouldUseRDD = session.sessionState().conf().arrowLocalRelationThreshold() < BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])batchesInDriver)).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)ArrowConverters$.$anonfun$toDataFrame$1(x$4)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        if (shouldUseRDD) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Using RDD-based createDataFrame with Arrow optimization.");
            String timezone = session.sessionState().conf().sessionLocalTimeZone();
            RDD qual$1 = session.sparkContext().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])batchesInDriver), batchesInDriver.length, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
            Function1 & Serializable & scala.Serializable x$1 = (Function1 & Serializable & scala.Serializable)batchesInExecutors -> MODULE$.fromBatchIterator((Iterator<byte[]>)batchesInExecutors, schema, timezone, TaskContext$.MODULE$.get());
            boolean x$2 = qual$1.mapPartitions$default$2();
            RDD rdd = qual$1.mapPartitions((Function1)x$1, x$2, ClassTag$.MODULE$.apply(InternalRow.class));
            return session.internalCreateDataFrame((RDD<InternalRow>)rdd.setName("arrow"), schema, session.internalCreateDataFrame$default$3());
        }
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Using LocalRelation in createDataFrame with Arrow optimization.");
        Iterator<InternalRow> data = this.fromBatchIterator((Iterator<byte[]>)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])batchesInDriver)).toIterator(), schema, session.sessionState().conf().sessionLocalTimeZone(), TaskContext$.MODULE$.get());
        UnsafeProjection proj = UnsafeProjection$.MODULE$.create(attrs, attrs);
        return Dataset$.MODULE$.ofRows(session, (LogicalPlan)new LocalRelation(attrs, (Seq)Predef$.MODULE$.wrapRefArray((Object[])data.map((Function1 & Serializable & scala.Serializable)r -> proj.apply(r).copy()).toArray(ClassTag$.MODULE$.apply(UnsafeRow.class))), LocalRelation$.MODULE$.apply$default$3()));
    }

    public byte[][] readArrowStreamFromFile(String filename) {
        return (byte[][])Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> new FileInputStream(filename), (Function1 & Serializable & scala.Serializable)fileStream -> (byte[][])MODULE$.getBatchesFromStream(fileStream.getChannel()).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))));
    }

    public Iterator<byte[]> getBatchesFromStream(ReadableByteChannel in) {
        return new Iterator<byte[]>(in){
            private byte[] batch;
            private final ReadableByteChannel in$1;

            public Iterator<byte[]> seq() {
                return Iterator.seq$((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.isEmpty$((Iterator)this);
            }

            public boolean isTraversableAgain() {
                return Iterator.isTraversableAgain$((Iterator)this);
            }

            public boolean hasDefiniteSize() {
                return Iterator.hasDefiniteSize$((Iterator)this);
            }

            public Iterator<byte[]> take(int n) {
                return Iterator.take$((Iterator)this, (int)n);
            }

            public Iterator<byte[]> drop(int n) {
                return Iterator.drop$((Iterator)this, (int)n);
            }

            public Iterator<byte[]> slice(int from, int until) {
                return Iterator.slice$((Iterator)this, (int)from, (int)until);
            }

            public Iterator<byte[]> sliceIterator(int from, int until) {
                return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<B> map(Function1<byte[], B> f) {
                return Iterator.map$((Iterator)this, f);
            }

            public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                return Iterator.$plus$plus$((Iterator)this, that);
            }

            public <B> Iterator<B> flatMap(Function1<byte[], GenTraversableOnce<B>> f) {
                return Iterator.flatMap$((Iterator)this, f);
            }

            public Iterator<byte[]> filter(Function1<byte[], Object> p) {
                return Iterator.filter$((Iterator)this, p);
            }

            public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<byte[], B, Object> p) {
                return Iterator.corresponds$((Iterator)this, that, p);
            }

            public Iterator<byte[]> withFilter(Function1<byte[], Object> p) {
                return Iterator.withFilter$((Iterator)this, p);
            }

            public Iterator<byte[]> filterNot(Function1<byte[], Object> p) {
                return Iterator.filterNot$((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<byte[], B> pf) {
                return Iterator.collect$((Iterator)this, pf);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, byte[], B> op) {
                return Iterator.scanLeft$((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<byte[], B, B> op) {
                return Iterator.scanRight$((Iterator)this, z, op);
            }

            public Iterator<byte[]> takeWhile(Function1<byte[], Object> p) {
                return Iterator.takeWhile$((Iterator)this, p);
            }

            public Tuple2<Iterator<byte[]>, Iterator<byte[]>> partition(Function1<byte[], Object> p) {
                return Iterator.partition$((Iterator)this, p);
            }

            public Tuple2<Iterator<byte[]>, Iterator<byte[]>> span(Function1<byte[], Object> p) {
                return Iterator.span$((Iterator)this, p);
            }

            public Iterator<byte[]> dropWhile(Function1<byte[], Object> p) {
                return Iterator.dropWhile$((Iterator)this, p);
            }

            public <B> Iterator<Tuple2<byte[], B>> zip(Iterator<B> that) {
                return Iterator.zip$((Iterator)this, that);
            }

            public <A1> Iterator<A1> padTo(int len, A1 elem) {
                return Iterator.padTo$((Iterator)this, (int)len, elem);
            }

            public Iterator<Tuple2<byte[], Object>> zipWithIndex() {
                return Iterator.zipWithIndex$((Iterator)this);
            }

            public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
            }

            public <U> void foreach(Function1<byte[], U> f) {
                Iterator.foreach$((Iterator)this, f);
            }

            public boolean forall(Function1<byte[], Object> p) {
                return Iterator.forall$((Iterator)this, p);
            }

            public boolean exists(Function1<byte[], Object> p) {
                return Iterator.exists$((Iterator)this, p);
            }

            public boolean contains(Object elem) {
                return Iterator.contains$((Iterator)this, (Object)elem);
            }

            public Option<byte[]> find(Function1<byte[], Object> p) {
                return Iterator.find$((Iterator)this, p);
            }

            public int indexWhere(Function1<byte[], Object> p) {
                return Iterator.indexWhere$((Iterator)this, p);
            }

            public int indexWhere(Function1<byte[], Object> p, int from) {
                return Iterator.indexWhere$((Iterator)this, p, (int)from);
            }

            public <B> int indexOf(B elem) {
                return Iterator.indexOf$((Iterator)this, elem);
            }

            public <B> int indexOf(B elem, int from) {
                return Iterator.indexOf$((Iterator)this, elem, (int)from);
            }

            public BufferedIterator<byte[]> buffered() {
                return Iterator.buffered$((Iterator)this);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.grouped$((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.sliding$((Iterator)this, (int)size, (int)step);
            }

            public <B> int sliding$default$2() {
                return Iterator.sliding$default$2$((Iterator)this);
            }

            public int length() {
                return Iterator.length$((Iterator)this);
            }

            public Tuple2<Iterator<byte[]>, Iterator<byte[]>> duplicate() {
                return Iterator.duplicate$((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <B> void copyToArray(Object xs, int start, int len) {
                Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
            }

            public boolean sameElements(Iterator<?> that) {
                return Iterator.sameElements$((Iterator)this, that);
            }

            public Traversable<byte[]> toTraversable() {
                return Iterator.toTraversable$((Iterator)this);
            }

            public Iterator<byte[]> toIterator() {
                return Iterator.toIterator$((Iterator)this);
            }

            public Stream<byte[]> toStream() {
                return Iterator.toStream$((Iterator)this);
            }

            public String toString() {
                return Iterator.toString$((Iterator)this);
            }

            public List<byte[]> reversed() {
                return TraversableOnce.reversed$((TraversableOnce)this);
            }

            public int size() {
                return TraversableOnce.size$((TraversableOnce)this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.nonEmpty$((TraversableOnce)this);
            }

            public int count(Function1<byte[], Object> p) {
                return TraversableOnce.count$((TraversableOnce)this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<byte[], B> pf) {
                return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, byte[], B> op) {
                return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<byte[], B, B> op) {
                return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, byte[], B> op) {
                return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
            }

            public <B> B foldRight(B z, Function2<byte[], B, B> op) {
                return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
            }

            public <B> B reduceLeft(Function2<B, byte[], B> op) {
                return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
            }

            public <B> B reduceRight(Function2<byte[], B, B> op) {
                return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, byte[], B> op) {
                return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<byte[], B, B> op) {
                return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.reduceOption$((TraversableOnce)this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, byte[], B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.sum$((TraversableOnce)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.product$((TraversableOnce)this, num);
            }

            public Object min(Ordering cmp) {
                return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
            }

            public Object max(Ordering cmp) {
                return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
            }

            public Object maxBy(Function1 f, Ordering cmp) {
                return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public Object minBy(Function1 f, Ordering cmp) {
                return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
            }

            public <B> void copyToArray(Object xs, int start) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
            }

            public List<byte[]> toList() {
                return TraversableOnce.toList$((TraversableOnce)this);
            }

            public Iterable<byte[]> toIterable() {
                return TraversableOnce.toIterable$((TraversableOnce)this);
            }

            public Seq<byte[]> toSeq() {
                return TraversableOnce.toSeq$((TraversableOnce)this);
            }

            public IndexedSeq<byte[]> toIndexedSeq() {
                return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.toBuffer$((TraversableOnce)this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce.toSet$((TraversableOnce)this);
            }

            public Vector<byte[]> toVector() {
                return TraversableOnce.toVector$((TraversableOnce)this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, byte[], Col> cbf) {
                return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
            }

            public <T, U> Map<T, U> toMap(Predef.$less$colon$less<byte[], Tuple2<T, U>> ev) {
                return TraversableOnce.toMap$((TraversableOnce)this, ev);
            }

            public String mkString(String start, String sep, String end) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
            }

            public String mkString(String sep) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
            }

            public String mkString() {
                return TraversableOnce.mkString$((TraversableOnce)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
            }

            public int sizeHintIfCheap() {
                return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
            }

            private byte[] batch() {
                return this.batch;
            }

            private void batch_$eq(byte[] x$1) {
                this.batch = x$1;
            }

            public boolean hasNext() {
                return this.batch() != null;
            }

            public byte[] next() {
                byte[] prevBatch = this.batch();
                this.batch_$eq(this.readNextBatch());
                return prevBatch;
            }

            private byte[] readNextBatch() {
                MessageMetadataResult msgMetadata;
                while ((msgMetadata = MessageSerializer.readMessage((ReadChannel)new ReadChannel(this.in$1))) != null) {
                    int bodyLength = (int)msgMetadata.getMessageBodyLength();
                    if (msgMetadata.getMessage().headerType() == 3) {
                        ByteBufferOutputStream bbout = new ByteBufferOutputStream(8 + msgMetadata.getMessageLength() + bodyLength);
                        MessageSerializer.writeMessageBuffer((WriteChannel)new WriteChannel(Channels.newChannel((OutputStream)bbout)), (int)msgMetadata.getMessageLength(), (ByteBuffer)msgMetadata.getMessageBuffer());
                        bbout.close();
                        ByteBuffer bb = bbout.toByteBuffer();
                        bb.position(bbout.getCount());
                        bb.limit(bb.capacity());
                        JavaUtils.readFully((ReadableByteChannel)this.in$1, (ByteBuffer)bb);
                        return bb.array();
                    }
                    Object object = bodyLength > 0 ? BoxesRunTime.boxToLong((long)Channels.newInputStream(this.in$1).skip(bodyLength)) : BoxedUnit.UNIT;
                }
                return null;
            }
            {
                this.in$1 = in$1;
                GenTraversableOnce.$init$((GenTraversableOnce)this);
                TraversableOnce.$init$((TraversableOnce)this);
                Iterator.$init$((Iterator)this);
                this.batch = this.readNextBatch();
            }
        };
    }

    public void org$apache$spark$sql$execution$arrow$ArrowConverters$$closeAll(Seq<AutoCloseable> closeables) {
        closeables.foreach((Function1 & Serializable & scala.Serializable)closeable -> {
            ArrowConverters$.$anonfun$closeAll$1(closeable);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ long $anonfun$toDataFrame$1(byte[] x$4) {
        return x$4.length;
    }

    public static final /* synthetic */ void $anonfun$closeAll$1(AutoCloseable closeable) {
        if (closeable != null) {
            closeable.close();
            return;
        }
    }

    private ArrowConverters$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

