/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkException;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.streaming.StreamExecution$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public final class FileStreamSink$
implements Logging {
    public static FileStreamSink$ MODULE$;
    private final String metadataDir;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new FileStreamSink$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String metadataDir() {
        return this.metadataDir;
    }

    public boolean hasMetadata(Seq<String> path, Configuration hadoopConf, SQLConf sqlConf) {
        if (sqlConf.fileStreamSinkMetadataIgnored()) {
            return false;
        }
        Seq<String> seq = path;
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0) {
            boolean bl;
            String singlePath = (String)((SeqLike)some.get()).apply(0);
            Path hdfsPath = new Path(singlePath);
            try {
                FileSystem fs = hdfsPath.getFileSystem(hadoopConf);
                if (fs.isDirectory(hdfsPath)) {
                    Path metadataPath = this.getMetadataLogPath(fs, hdfsPath, sqlConf);
                    bl = fs.exists(metadataPath);
                } else {
                    bl = false;
                }
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof SparkException) {
                    SparkException sparkException = (SparkException)throwable2;
                    throw sparkException;
                }
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(87).append("Assume no metadata directory. Error while looking for ").append("metadata directory in the path: ").append(singlePath).append(".").toString(), e);
                    bl = false;
                }
                throw throwable;
            }
            return bl;
        }
        return false;
    }

    public Path getMetadataLogPath(FileSystem fs, Path path, SQLConf sqlConf) {
        Path metadataDir = new Path(path, this.metadataDir());
        this.checkEscapedMetadataPath(fs, metadataDir, sqlConf);
        return metadataDir;
    }

    public void checkEscapedMetadataPath(FileSystem fs, Path metadataPath, SQLConf sqlConf) {
        if (BoxesRunTime.unboxToBoolean((Object)sqlConf.getConf(SQLConf$.MODULE$.STREAMING_CHECKPOINT_ESCAPED_PATH_CHECK_ENABLED())) && StreamExecution$.MODULE$.containsSpecialCharsInPath(metadataPath)) {
            boolean bl;
            Path legacyMetadataPath = new Path(metadataPath.toUri().toString());
            try {
                bl = fs.exists(legacyMetadataPath);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> e.getMessage(), e);
                    bl = false;
                }
                throw throwable;
            }
            boolean legacyMetadataPathExists = bl;
            if (legacyMetadataPathExists) {
                throw QueryExecutionErrors$.MODULE$.legacyMetadataPathExistsError(metadataPath, legacyMetadataPath);
            }
            return;
        }
    }

    public boolean ancestorIsMetadataDirectory(Path path, Configuration hadoopConf) {
        FileSystem fs = path.getFileSystem(hadoopConf);
        for (Path currentPath = path.makeQualified(fs.getUri(), fs.getWorkingDirectory()); currentPath != null; currentPath = currentPath.getParent()) {
            String string = currentPath.getName();
            String string2 = this.metadataDir();
            if (string != null ? !string.equals(string2) : string2 != null) continue;
            return true;
        }
        return false;
    }

    private FileStreamSink$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.metadataDir = "_spark_metadata";
    }
}

