/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.stat;

import java.io.Serializable;
import java.util.Locale;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Column$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.ElementAt;
import org.apache.spark.sql.catalyst.expressions.ElementAt$;
import org.apache.spark.sql.catalyst.expressions.EvalMode$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.aggregate.ApproximatePercentile$;
import org.apache.spark.sql.catalyst.util.QuantileSummaries;
import org.apache.spark.sql.catalyst.util.QuantileSummaries$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.stat.StatFunctions$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.slf4j.Logger;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple1;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class StatFunctions$
implements Logging {
    public static StatFunctions$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new StatFunctions$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Seq<Seq<Object>> multipleApproxQuantiles(Dataset<Row> df, Seq<String> cols, Seq<Object> probabilities, double relativeError) {
        Predef$.MODULE$.require(relativeError >= 0.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Relative Error must be non-negative but got ").append(relativeError).toString());
        Seq columns = (Seq)cols.map((Function1 & Serializable & scala.Serializable)colName -> {
            NamedExpression field = df.resolve((String)colName);
            Predef$.MODULE$.require(((Expression)field).dataType() instanceof NumericType, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(66).append("Quantile calculation for column ").append((String)colName).append(" with data type ").append(((Expression)field).dataType()).append(" is not supported.").toString());
            return Column$.MODULE$.apply((Expression)new Cast(Column$.MODULE$.apply((String)colName).expr(), (DataType)DoubleType$.MODULE$, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4()));
        }, Seq$.MODULE$.canBuildFrom());
        QuantileSummaries[] emptySummaries = (QuantileSummaries[])Array$.MODULE$.fill(cols.size(), (Function0 & Serializable & scala.Serializable)() -> new QuantileSummaries(QuantileSummaries$.MODULE$.defaultCompressThreshold(), relativeError, QuantileSummaries$.MODULE$.$lessinit$greater$default$3(), QuantileSummaries$.MODULE$.$lessinit$greater$default$4(), QuantileSummaries$.MODULE$.$lessinit$greater$default$5()), ClassTag$.MODULE$.apply(QuantileSummaries.class));
        RDD<Row> qual$1 = df.select((Seq<Column>)columns).rdd();
        QuantileSummaries[] x$1 = emptySummaries;
        Function2 & Serializable & scala.Serializable x$2 = (Function2 & Serializable & scala.Serializable)(summaries, row) -> StatFunctions$.apply$1(summaries, row);
        Function2 & Serializable & scala.Serializable x$3 = (Function2 & Serializable & scala.Serializable)(sum1, sum2) -> StatFunctions$.merge$1(sum1, sum2);
        int x$4 = qual$1.treeAggregate$default$4((Object)x$1);
        QuantileSummaries[] summaries2 = (QuantileSummaries[])qual$1.treeAggregate((Object)x$1, (Function2)x$2, (Function2)x$3, x$4, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(QuantileSummaries.class)));
        return (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])summaries2)).map((Function1 & Serializable & scala.Serializable)summary -> {
            Option option = summary.query(probabilities);
            if (option instanceof Some) {
                Some some = (Some)option;
                Seq q = (Seq)some.value();
                return q;
            }
            if (None$.MODULE$.equals(option)) {
                return (Seq)Nil$.MODULE$;
            }
            throw new MatchError((Object)option);
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    public double pearsonCorrelation(Dataset<Row> df, Seq<String> cols) {
        Predef$.MODULE$.require(cols.length() == 2, (Function0 & Serializable & scala.Serializable)() -> "Currently correlation calculation is supported between two columns.");
        Seq seq = (Seq)cols.map((Function1 & Serializable & scala.Serializable)c -> {
            DataType dataType = ((Expression)df.resolve((String)c)).dataType();
            Predef$.MODULE$.require(dataType instanceof NumericType, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("Currently correlation calculation for columns with dataType ").append(dataType.catalogString()).append(" not supported.").toString());
            return functions$.MODULE$.when(functions$.MODULE$.isnull(functions$.MODULE$.col((String)c)), functions$.MODULE$.lit(BoxesRunTime.boxToDouble((double)0.0))).otherwise(functions$.MODULE$.col((String)c).cast((DataType)DoubleType$.MODULE$));
        }, Seq$.MODULE$.canBuildFrom());
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) {
            throw new MatchError((Object)seq);
        }
        Column col1 = (Column)((SeqLike)some.get()).apply(0);
        Column col2 = (Column)((SeqLike)some.get()).apply(1);
        Tuple2 tuple2 = new Tuple2((Object)col1, (Object)col2);
        Column col12 = (Column)tuple2._1();
        Column col22 = (Column)tuple2._2();
        Column correlation = functions$.MODULE$.corr(col12, col22);
        return df.select((Seq<Column>)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.when(functions$.MODULE$.isnull(correlation), functions$.MODULE$.lit(BoxesRunTime.boxToDouble((double)Double.NaN))).otherwise(correlation)})).head().getDouble(0);
    }

    public double calculateCov(Dataset<Row> df, Seq<String> cols) {
        Predef$.MODULE$.require(cols.length() == 2, (Function0 & Serializable & scala.Serializable)() -> "Currently covariance calculation is supported between two columns.");
        Seq seq = (Seq)cols.map((Function1 & Serializable & scala.Serializable)c -> {
            DataType dataType = ((Expression)df.resolve((String)c)).dataType();
            Predef$.MODULE$.require(dataType instanceof NumericType, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(74).append("Currently covariance calculation for columns with dataType ").append(dataType.catalogString()).append(" not supported.").toString());
            return functions$.MODULE$.when(functions$.MODULE$.isnull(functions$.MODULE$.col((String)c)), functions$.MODULE$.lit(BoxesRunTime.boxToDouble((double)0.0))).otherwise(functions$.MODULE$.col((String)c).cast((DataType)DoubleType$.MODULE$));
        }, Seq$.MODULE$.canBuildFrom());
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) {
            throw new MatchError((Object)seq);
        }
        Column col1 = (Column)((SeqLike)some.get()).apply(0);
        Column col2 = (Column)((SeqLike)some.get()).apply(1);
        Tuple2 tuple2 = new Tuple2((Object)col1, (Object)col2);
        Column col12 = (Column)tuple2._1();
        Column col22 = (Column)tuple2._2();
        Column covariance = functions$.MODULE$.covar_samp(col12, col22);
        return df.select((Seq<Column>)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.when(functions$.MODULE$.isnull(covariance), functions$.MODULE$.lit(BoxesRunTime.boxToDouble((double)0.0))).otherwise(covariance)})).head().getDouble(0);
    }

    public Dataset<Row> crossTabulate(Dataset<Row> df, String col1, String col2) {
        return df.groupBy((Seq<Column>)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.when(functions$.MODULE$.isnull(functions$.MODULE$.col(col1)), "null").otherwise(functions$.MODULE$.col(col1).cast("string")).as(new StringBuilder(1).append(col1).append("_").append(col2).toString())})).pivot(functions$.MODULE$.when(functions$.MODULE$.isnull(functions$.MODULE$.col(col2)), "null").otherwise(functions$.MODULE$.regexp_replace(functions$.MODULE$.col(col2).cast("string"), "`", ""))).count().na().fill(0L);
    }

    public Dataset<Row> summary(Dataset<?> ds, Seq<String> statistics) {
        String[] selectedStatistics = statistics.nonEmpty() ? (String[])statistics.toArray(ClassTag$.MODULE$.apply(String.class)) : (String[])((Object[])new String[]{"count", "mean", "stddev", "min", "25%", "50%", "75%", "max"});
        double[] percentiles = (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])selectedStatistics)).filter((Function1 & Serializable & scala.Serializable)a -> BoxesRunTime.boxToBoolean((boolean)a.endsWith("%"))))).map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToDouble((double)StatFunctions$.$anonfun$summary$2(p)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        Predef$.MODULE$.require(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(percentiles)).forall((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)p -> p >= 0.0 && p <= 1.0), (Function0 & Serializable & scala.Serializable)() -> "Percentiles must be in the range [0, 1]");
        ObjectRef mapColumns = ObjectRef.create((Object)((Seq)Nil$.MODULE$));
        ObjectRef columnNames = ObjectRef.create((Object)((Seq)Nil$.MODULE$));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ds.schema().fields())).foreach((Function1 & Serializable & scala.Serializable)field -> {
            StatFunctions$.$anonfun$summary$5(percentiles, selectedStatistics, mapColumns, columnNames, field);
            return BoxedUnit.UNIT;
        });
        if (((Seq)mapColumns.elem).isEmpty()) {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
            public final class Org_apache_spark_sql_execution_stat_StatFunctions$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple1"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$));
                }

                public Org_apache_spark_sql_execution_stat_StatFunctions$$typecreator1$1() {
                }
            }
            return ds.sparkSession().createDataFrame(Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])selectedStatistics)).map((Function1 & Serializable & scala.Serializable)_1 -> new Tuple1(_1), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple1.class)))), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_stat_StatFunctions$$typecreator1$1())).withColumnRenamed("_1", "summary");
        }
        Seq valueColumns = (Seq)((Seq)columnNames.elem).map((Function1 & Serializable & scala.Serializable)columnName -> new Column((Expression)new ElementAt(functions$.MODULE$.col((String)columnName).expr(), functions$.MODULE$.col("summary").expr(), ElementAt$.MODULE$.apply$default$3(), ElementAt$.MODULE$.apply$default$4())).as((String)columnName), Seq$.MODULE$.canBuildFrom());
        return ds.select((Seq<Column>)((Seq)mapColumns.elem)).withColumn("summary", functions$.MODULE$.explode(functions$.MODULE$.lit(selectedStatistics))).select((Seq<Column>)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new Column[]{functions$.MODULE$.col("summary")})).$plus$plus((GenTraversableOnce)valueColumns, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)))));
    }

    private static final QuantileSummaries[] apply$1(QuantileSummaries[] summaries, Row row) {
        for (int i = 0; i < summaries.length; ++i) {
            double v;
            if (row.isNullAt(i) || Double.isNaN(v = row.getDouble(i))) continue;
            summaries[i] = summaries[i].insert(v);
        }
        return summaries;
    }

    private static final QuantileSummaries[] merge$1(QuantileSummaries[] sum1, QuantileSummaries[] sum2) {
        return (QuantileSummaries[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sum1)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])sum2), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                QuantileSummaries s1 = (QuantileSummaries)tuple2._1();
                QuantileSummaries s2 = (QuantileSummaries)tuple2._2();
                return s1.compress().merge(s2.compress());
            }
            throw new MatchError((Object)tuple2);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(QuantileSummaries.class)));
    }

    public static final /* synthetic */ double $anonfun$summary$2(String p) {
        double d;
        try {
            d = new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(p)).stripSuffix("%"))).toDouble() / 100.0;
        }
        catch (NumberFormatException e) {
            throw QueryExecutionErrors$.MODULE$.cannotParseStatisticAsPercentileError(p, e);
        }
        return d;
    }

    public static final /* synthetic */ void $anonfun$summary$6(ObjectRef aggColumns$1, Column column$1, ObjectRef casted$1, Column percentilesCol$1, IntRef percentileIndex$1, String stats) {
        aggColumns$1.elem = (Seq)((Seq)aggColumns$1.elem).$colon$plus((Object)functions$.MODULE$.lit(stats), Seq$.MODULE$.canBuildFrom());
        String string = stats.toLowerCase(Locale.ROOT);
        if ("count".equals(string)) {
            aggColumns$1.elem = (Seq)((Seq)aggColumns$1.elem).$colon$plus((Object)functions$.MODULE$.count(column$1), Seq$.MODULE$.canBuildFrom());
            return;
        }
        if ("count_distinct".equals(string)) {
            aggColumns$1.elem = (Seq)((Seq)aggColumns$1.elem).$colon$plus((Object)functions$.MODULE$.count_distinct(column$1, (Seq<Column>)Predef$.MODULE$.wrapRefArray((Object[])new Column[0])), Seq$.MODULE$.canBuildFrom());
            return;
        }
        if ("approx_count_distinct".equals(string)) {
            aggColumns$1.elem = (Seq)((Seq)aggColumns$1.elem).$colon$plus((Object)functions$.MODULE$.approx_count_distinct(column$1), Seq$.MODULE$.canBuildFrom());
            return;
        }
        if ("mean".equals(string)) {
            aggColumns$1.elem = (Seq)((Seq)aggColumns$1.elem).$colon$plus((Object)functions$.MODULE$.avg((Column)casted$1.elem), Seq$.MODULE$.canBuildFrom());
            return;
        }
        if ("stddev".equals(string)) {
            aggColumns$1.elem = (Seq)((Seq)aggColumns$1.elem).$colon$plus((Object)functions$.MODULE$.stddev((Column)casted$1.elem), Seq$.MODULE$.canBuildFrom());
            return;
        }
        if ("min".equals(string)) {
            aggColumns$1.elem = (Seq)((Seq)aggColumns$1.elem).$colon$plus((Object)functions$.MODULE$.min(column$1), Seq$.MODULE$.canBuildFrom());
            return;
        }
        if ("max".equals(string)) {
            aggColumns$1.elem = (Seq)((Seq)aggColumns$1.elem).$colon$plus((Object)functions$.MODULE$.max(column$1), Seq$.MODULE$.canBuildFrom());
            return;
        }
        if (string.endsWith("%")) {
            aggColumns$1.elem = (Seq)((Seq)aggColumns$1.elem).$colon$plus((Object)functions$.MODULE$.get(percentilesCol$1, functions$.MODULE$.lit(BoxesRunTime.boxToInteger((int)percentileIndex$1.elem))), Seq$.MODULE$.canBuildFrom());
            ++percentileIndex$1.elem;
            return;
        }
        throw QueryExecutionErrors$.MODULE$.statisticNotRecognizedError(stats);
    }

    public static final /* synthetic */ void $anonfun$summary$5(double[] percentiles$1, String[] selectedStatistics$1, ObjectRef mapColumns$1, ObjectRef columnNames$1, StructField field) {
        if (field.dataType() instanceof NumericType || field.dataType() instanceof StringType) {
            Column column = functions$.MODULE$.col(field.name());
            ObjectRef casted = ObjectRef.create((Object)column);
            if (field.dataType() instanceof StringType) {
                Expression x$1 = column.expr();
                DoubleType$ x$2 = DoubleType$.MODULE$;
                Enumeration.Value x$32 = EvalMode$.MODULE$.TRY();
                Option x$4 = Cast$.MODULE$.apply$default$3();
                casted.elem = new Column((Expression)new Cast(x$1, (DataType)x$2, x$4, x$32));
            }
            Column percentilesCol = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(percentiles$1)).nonEmpty() ? functions$.MODULE$.percentile_approx((Column)casted.elem, functions$.MODULE$.lit(percentiles$1), functions$.MODULE$.lit(BoxesRunTime.boxToInteger((int)ApproximatePercentile$.MODULE$.DEFAULT_PERCENTILE_ACCURACY()))) : null;
            ObjectRef aggColumns = ObjectRef.create((Object)((Seq)Nil$.MODULE$));
            IntRef percentileIndex = IntRef.create((int)0);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])selectedStatistics$1)).foreach((Function1 & Serializable & scala.Serializable)stats -> {
                StatFunctions$.$anonfun$summary$6(aggColumns, column, casted, percentilesCol, percentileIndex, stats);
                return BoxedUnit.UNIT;
            });
            mapColumns$1.elem = (Seq)((Seq)mapColumns$1.elem).$colon$plus((Object)functions$.MODULE$.map((Seq<Column>)((Seq)((Seq)aggColumns.elem).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.cast((DataType)StringType$.MODULE$), Seq$.MODULE$.canBuildFrom()))).as(field.name()), Seq$.MODULE$.canBuildFrom());
            columnNames$1.elem = (Seq)((Seq)columnNames$1.elem).$colon$plus((Object)field.name(), Seq$.MODULE$.canBuildFrom());
            return;
        }
    }

    private StatFunctions$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

