/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.adaptive;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.optimizer.PropagateEmptyRelationBase;
import org.apache.spark.sql.catalyst.planning.ExtractSingleColumnNullAwareAntiJoin$;
import org.apache.spark.sql.catalyst.plans.logical.Join;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.adaptive.BroadcastQueryStageExec;
import org.apache.spark.sql.execution.adaptive.LogicalQueryStage;
import org.apache.spark.sql.execution.adaptive.QueryStageExec;
import org.apache.spark.sql.execution.adaptive.ShuffleQueryStageExec;
import org.apache.spark.sql.execution.aggregate.BaseAggregateExec;
import org.apache.spark.sql.execution.exchange.REPARTITION_BY_COL$;
import org.apache.spark.sql.execution.exchange.REPARTITION_BY_NUM$;
import org.apache.spark.sql.execution.exchange.ShuffleExchangeLike;
import org.apache.spark.sql.execution.exchange.ShuffleOrigin;
import org.apache.spark.sql.execution.joins.HashedRelationWithAllNullKeys$;
import scala.Enumeration;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.Seq;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.runtime.BoxesRunTime;

public final class AQEPropagateEmptyRelation$
extends PropagateEmptyRelationBase {
    public static AQEPropagateEmptyRelation$ MODULE$;

    static {
        new AQEPropagateEmptyRelation$();
    }

    public boolean isEmpty(LogicalPlan plan) {
        return super.isEmpty(plan) || !this.isRootRepartition(plan) && this.getEstimatedRowCount(plan).contains((Object)BoxesRunTime.boxToInteger((int)0));
    }

    public boolean nonEmpty(LogicalPlan plan) {
        return super.nonEmpty(plan) || this.getEstimatedRowCount(plan).exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.$greater((Object)BigInt$.MODULE$.int2bigInt(0))));
    }

    private boolean isRootRepartition(LogicalPlan plan) {
        LogicalQueryStage logicalQueryStage;
        LogicalPlan logicalPlan2 = plan;
        return logicalPlan2 instanceof LogicalQueryStage && (logicalQueryStage = (LogicalQueryStage)logicalPlan2).getTagValue(this.ROOT_REPARTITION()).isDefined();
    }

    private Option<BigInt> getEstimatedRowCount(LogicalPlan plan) {
        BaseAggregateExec baseAggregateExec;
        SparkPlan agg;
        boolean bl = false;
        LogicalQueryStage logicalQueryStage = null;
        LogicalPlan logicalPlan2 = plan;
        if (logicalPlan2 instanceof LogicalQueryStage) {
            QueryStageExec queryStageExec;
            bl = true;
            logicalQueryStage = (LogicalQueryStage)logicalPlan2;
            SparkPlan stage = logicalQueryStage.physicalPlan();
            if (stage instanceof QueryStageExec && (queryStageExec = (QueryStageExec)stage).isMaterialized()) {
                return queryStageExec.getRuntimeStatistics().rowCount();
            }
        }
        if (bl && (agg = logicalQueryStage.physicalPlan()) instanceof BaseAggregateExec && (baseAggregateExec = (BaseAggregateExec)((Object)agg)).groupingExpressions().nonEmpty() && baseAggregateExec.child() instanceof QueryStageExec) {
            QueryStageExec stage = (QueryStageExec)baseAggregateExec.child();
            if (stage.isMaterialized()) {
                return stage.getRuntimeStatistics().rowCount();
            }
            return None$.MODULE$;
        }
        return None$.MODULE$;
    }

    public boolean org$apache$spark$sql$execution$adaptive$AQEPropagateEmptyRelation$$isRelationWithAllNullKeys(LogicalPlan plan) {
        BroadcastQueryStageExec broadcastQueryStageExec;
        LogicalQueryStage logicalQueryStage;
        SparkPlan stage;
        LogicalPlan logicalPlan2 = plan;
        if (logicalPlan2 instanceof LogicalQueryStage && (stage = (logicalQueryStage = (LogicalQueryStage)logicalPlan2).physicalPlan()) instanceof BroadcastQueryStageExec && (broadcastQueryStageExec = (BroadcastQueryStageExec)stage).isMaterialized()) {
            Object object = broadcastQueryStageExec.broadcast().relationFuture().get().value();
            HashedRelationWithAllNullKeys$ hashedRelationWithAllNullKeys$ = HashedRelationWithAllNullKeys$.MODULE$;
            return !(object != null ? !object.equals(hashedRelationWithAllNullKeys$) : hashedRelationWithAllNullKeys$ != null);
        }
        return false;
    }

    private PartialFunction<LogicalPlan, LogicalPlan> eliminateSingleColumnNullAwareAntiJoin() {
        return new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Join join;
                Option option;
                A1 A1 = x1;
                if (A1 instanceof Join && !(option = ExtractSingleColumnNullAwareAntiJoin$.MODULE$.unapply(join = (Join)A1)).isEmpty() && AQEPropagateEmptyRelation$.MODULE$.org$apache$spark$sql$execution$adaptive$AQEPropagateEmptyRelation$$isRelationWithAllNullKeys(join.right())) {
                    return (B1)AQEPropagateEmptyRelation$.MODULE$.empty((LogicalPlan)join);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                Join join;
                Option option;
                LogicalPlan logicalPlan2 = x1;
                return logicalPlan2 instanceof Join && !(option = ExtractSingleColumnNullAwareAntiJoin$.MODULE$.unapply(join = (Join)logicalPlan2)).isEmpty() && AQEPropagateEmptyRelation$.MODULE$.org$apache$spark$sql$execution$adaptive$AQEPropagateEmptyRelation$$isRelationWithAllNullKeys(join.right());
            }
        };
    }

    public boolean userSpecifiedRepartition(LogicalPlan p) {
        block2: {
            block3: {
                ShuffleQueryStageExec shuffleQueryStageExec;
                SparkPlan shuffle;
                LogicalQueryStage logicalQueryStage;
                SparkPlan sparkPlan;
                LogicalPlan logicalPlan2 = p;
                if (!(logicalPlan2 instanceof LogicalQueryStage) || !((sparkPlan = (logicalQueryStage = (LogicalQueryStage)logicalPlan2).physicalPlan()) instanceof ShuffleQueryStageExec) || !((shuffle = (shuffleQueryStageExec = (ShuffleQueryStageExec)sparkPlan).plan()) instanceof ShuffleExchangeLike)) break block2;
                ShuffleExchangeLike shuffleExchangeLike = (ShuffleExchangeLike)((Object)shuffle);
                ShuffleOrigin shuffleOrigin = shuffleExchangeLike.shuffleOrigin();
                REPARTITION_BY_COL$ rEPARTITION_BY_COL$ = REPARTITION_BY_COL$.MODULE$;
                if (!(shuffleOrigin == null ? rEPARTITION_BY_COL$ != null : !shuffleOrigin.equals(rEPARTITION_BY_COL$))) break block3;
                ShuffleOrigin shuffleOrigin2 = shuffleExchangeLike.shuffleOrigin();
                REPARTITION_BY_NUM$ rEPARTITION_BY_NUM$ = REPARTITION_BY_NUM$.MODULE$;
                if (shuffleOrigin2 != null ? !shuffleOrigin2.equals(rEPARTITION_BY_NUM$) : rEPARTITION_BY_NUM$ != null) break block2;
            }
            return true;
        }
        return false;
    }

    public LogicalPlan applyInternal(LogicalPlan p) {
        return p.transformUpWithPruning((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.containsAnyPattern((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{TreePattern$.MODULE$.LOGICAL_QUERY_STAGE(), TreePattern$.MODULE$.LOCAL_RELATION(), TreePattern$.MODULE$.TRUE_OR_FALSE_LITERAL()}))), p.transformUpWithPruning$default$2(), this.eliminateSingleColumnNullAwareAntiJoin().orElse(this.commonApplyFunc()));
    }

    private AQEPropagateEmptyRelation$() {
        MODULE$ = this;
    }
}

