/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.adaptive;

import java.io.Serializable;
import org.apache.spark.MapOutputStatistics;
import org.apache.spark.MapOutputTrackerMaster;
import org.apache.spark.ShuffleStatus;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.MapStatus;
import org.apache.spark.sql.execution.CoalescedPartitionSpec;
import org.apache.spark.sql.execution.CoalescedPartitionSpec$;
import org.apache.spark.sql.execution.PartialReducerPartitionSpec;
import org.apache.spark.sql.execution.ShufflePartitionSpec;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ResizableArray;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

public final class ShufflePartitionsUtil$
implements Logging {
    public static ShufflePartitionsUtil$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new ShufflePartitionsUtil$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public final double SMALL_PARTITION_FACTOR() {
        return 0.2;
    }

    public final double MERGED_PARTITION_FACTOR() {
        return 1.2;
    }

    public Seq<Seq<ShufflePartitionSpec>> coalescePartitions(Seq<Option<MapOutputStatistics>> mapOutputStatistics, Seq<Option<Seq<ShufflePartitionSpec>>> inputPartitionSpecs, long advisoryTargetSize, int minNumPartitions, long minPartitionSize) {
        Predef$.MODULE$.assert(mapOutputStatistics.length() == inputPartitionSpecs.length());
        if (mapOutputStatistics.isEmpty()) {
            return (Seq)Nil$.MODULE$;
        }
        long totalPostShuffleInputSize = BoxesRunTime.unboxToLong((Object)((TraversableOnce)mapOutputStatistics.flatMap((Function1 & Serializable & scala.Serializable)x$1 -> Option$.MODULE$.option2Iterable(x$1.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)ShufflePartitionsUtil$.$anonfun$coalescePartitions$2(x$2)))), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        long maxTargetSize = (long)package$.MODULE$.ceil((double)totalPostShuffleInputSize / (double)minNumPartitions);
        long targetSize = RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(maxTargetSize), advisoryTargetSize)), minPartitionSize);
        String shuffleIds = ((TraversableOnce)mapOutputStatistics.flatMap((Function1 & Serializable & scala.Serializable)x$3 -> Option$.MODULE$.option2Iterable(x$3.map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.shuffleId()))), Seq$.MODULE$.canBuildFrom())).mkString(", ");
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(84).append("For shuffle(").append(shuffleIds).append("), advisory target size: ").append(advisoryTargetSize).append(", ").append("actual target size ").append(targetSize).append(", minimum partition size: ").append(minPartitionSize).toString());
        return inputPartitionSpecs.forall((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isEmpty())) ? this.coalescePartitionsWithoutSkew(mapOutputStatistics, targetSize, minPartitionSize) : this.coalescePartitionsWithSkew(mapOutputStatistics, inputPartitionSpecs, targetSize, minPartitionSize);
    }

    private Seq<Seq<ShufflePartitionSpec>> coalescePartitionsWithoutSkew(Seq<Option<MapOutputStatistics>> mapOutputStatistics, long targetSize, long minPartitionSize) {
        Seq validMetrics = (Seq)mapOutputStatistics.flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo));
        int numShuffles = mapOutputStatistics.length();
        if (validMetrics.isEmpty()) {
            return (Seq)Seq$.MODULE$.fill(numShuffles, (Function0 & Serializable & scala.Serializable)() -> (Seq)new .colon.colon((Object)CoalescedPartitionSpec$.MODULE$.apply(0, 0, 0L), (List)Nil$.MODULE$));
        }
        if (((SeqLike)((SeqLike)validMetrics.map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)ShufflePartitionsUtil$.$anonfun$coalescePartitionsWithoutSkew$3(x$6)), Seq$.MODULE$.canBuildFrom())).distinct()).length() > 1) {
            return (Seq)Nil$.MODULE$;
        }
        int numPartitions = ((MapOutputStatistics)validMetrics.head()).bytesByPartitionId().length;
        Seq<CoalescedPartitionSpec> newPartitionSpecs = this.coalescePartitions(0, numPartitions, (Seq<MapOutputStatistics>)validMetrics, targetSize, minPartitionSize, this.coalescePartitions$default$6());
        return newPartitionSpecs.length() < numPartitions ? this.attachDataSize(mapOutputStatistics, newPartitionSpecs) : (Seq<Seq<CoalescedPartitionSpec>>)Nil$.MODULE$;
    }

    private Seq<Seq<ShufflePartitionSpec>> coalescePartitionsWithSkew(Seq<Option<MapOutputStatistics>> mapOutputStatistics, Seq<Option<Seq<ShufflePartitionSpec>>> inputPartitionSpecs, long targetSize, long minPartitionSize) {
        if (!mapOutputStatistics.forall((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.isDefined())) || !inputPartitionSpecs.forall((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.isDefined()))) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Could not apply partition coalescing because of missing MapOutputStatistics or shuffle partition specs.");
            return (Seq)Nil$.MODULE$;
        }
        Seq validMetrics = (Seq)mapOutputStatistics.map((Function1 & Serializable & scala.Serializable)x$9 -> (MapOutputStatistics)x$9.get(), Seq$.MODULE$.canBuildFrom());
        Seq partitionIndicesSeq = (Seq)inputPartitionSpecs.map((Function1 & Serializable & scala.Serializable)x$10 -> (Seq)((TraversableLike)x$10.get()).map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)ShufflePartitionsUtil$.$anonfun$coalescePartitionsWithSkew$6(x0$1)), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        Predef$.MODULE$.assert(((SeqLike)partitionIndicesSeq.distinct()).length() == 1 && ((IterableLike)partitionIndicesSeq.head()).forall((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$11 -> x$11 >= 0), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Invalid shuffle partition specs: ").append(inputPartitionSpecs).toString());
        Seq partitionIndices = (Seq)partitionIndicesSeq.head();
        Predef$.MODULE$.assert(BoxesRunTime.unboxToInt((Object)partitionIndices.head()) == 0);
        Seq newPartitionSpecsSeq = (Seq)Seq$.MODULE$.fill(mapOutputStatistics.length(), (Function0 & Serializable & scala.Serializable)() -> (ArrayBuffer)ArrayBuffer$.MODULE$.empty());
        int numPartitions = partitionIndices.length();
        IntRef i = IntRef.create((int)1);
        int start = 0;
        while (i.elem < numPartitions) {
            if (BoxesRunTime.unboxToInt((Object)partitionIndices.apply(i.elem - 1)) == BoxesRunTime.unboxToInt((Object)partitionIndices.apply(i.elem))) {
                int repeatValue = BoxesRunTime.unboxToInt((Object)partitionIndices.apply(i.elem));
                if (i.elem - 1 > start) {
                    Seq<CoalescedPartitionSpec> partitionSpecs = this.coalescePartitions(BoxesRunTime.unboxToInt((Object)partitionIndices.apply(start)), repeatValue, (Seq<MapOutputStatistics>)validMetrics, targetSize, minPartitionSize, true);
                    ((IterableLike)newPartitionSpecsSeq.zip(this.attachDataSize(mapOutputStatistics, partitionSpecs), Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)spec -> ((ArrayBuffer)spec._1()).$plus$plus$eq((TraversableOnce)spec._2()));
                }
                IntRef repeatIndex = IntRef.create((int)(i.elem + 1));
                while (repeatIndex.elem < numPartitions && BoxesRunTime.unboxToInt((Object)partitionIndices.apply(repeatIndex.elem)) == repeatValue) {
                    ++repeatIndex.elem;
                }
                ((IterableLike)newPartitionSpecsSeq.zip(inputPartitionSpecs, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    ArrayBuffer newSpecs = (ArrayBuffer)tuple2._1();
                    Option oldSpecs = (Option)tuple2._2();
                    ArrayBuffer arrayBuffer = newSpecs.$plus$plus$eq((TraversableOnce)((IterableLike)oldSpecs.get()).slice(i$1.elem - 1, repeatIndex$1.elem));
                    return arrayBuffer;
                });
                start = repeatIndex.elem;
                i.elem = repeatIndex.elem;
                continue;
            }
            Predef$.MODULE$.assert(BoxesRunTime.unboxToInt((Object)partitionIndices.apply(i.elem - 1)) + 1 == BoxesRunTime.unboxToInt((Object)partitionIndices.apply(i.elem)));
            ++i.elem;
        }
        if (numPartitions > start) {
            Seq<CoalescedPartitionSpec> partitionSpecs = this.coalescePartitions(BoxesRunTime.unboxToInt((Object)partitionIndices.apply(start)), BoxesRunTime.unboxToInt((Object)partitionIndices.last()) + 1, (Seq<MapOutputStatistics>)validMetrics, targetSize, minPartitionSize, true);
            ((IterableLike)newPartitionSpecsSeq.zip(this.attachDataSize(mapOutputStatistics, partitionSpecs), Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)spec -> ((ArrayBuffer)spec._1()).$plus$plus$eq((TraversableOnce)spec._2()));
        }
        return ((ResizableArray)newPartitionSpecsSeq.head()).length() < numPartitions ? (Seq)newPartitionSpecsSeq.map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.toSeq(), Seq$.MODULE$.canBuildFrom()) : (Seq)Nil$.MODULE$;
    }

    private Seq<CoalescedPartitionSpec> coalescePartitions(int start, int end, Seq<MapOutputStatistics> mapOutputStatistics, long targetSize, long minPartitionSize, boolean allowReturnEmpty) {
        ArrayBuffer partitionSpecs = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        LongRef coalescedSize = LongRef.create((long)0L);
        IntRef i = IntRef.create((int)start);
        IntRef latestSplitPoint = IntRef.create((int)i.elem);
        long latestPartitionSize = 0L;
        while (i.elem < end) {
            long totalSizeOfCurrentPartition = 0L;
            for (int j = 0; j < mapOutputStatistics.length(); ++j) {
                totalSizeOfCurrentPartition += ((MapOutputStatistics)mapOutputStatistics.apply(j)).bytesByPartitionId()[i.elem];
            }
            if (i.elem > latestSplitPoint.elem && coalescedSize.elem + totalSizeOfCurrentPartition > targetSize) {
                if (coalescedSize.elem < minPartitionSize) {
                    if (latestPartitionSize > 0L && latestPartitionSize < totalSizeOfCurrentPartition) {
                        partitionSpecs.update(partitionSpecs.length() - 1, (Object)new CoalescedPartitionSpec(((CoalescedPartitionSpec)partitionSpecs.last()).startReducerIndex(), i.elem, CoalescedPartitionSpec$.MODULE$.apply$default$3()));
                        latestSplitPoint.elem = i.elem;
                        latestPartitionSize += coalescedSize.elem;
                        coalescedSize.elem = totalSizeOfCurrentPartition;
                    } else {
                        coalescedSize.elem += totalSizeOfCurrentPartition;
                    }
                } else {
                    ShufflePartitionsUtil$.createPartitionSpec$1(ShufflePartitionsUtil$.createPartitionSpec$default$1$1(), coalescedSize, partitionSpecs, latestSplitPoint, i);
                    latestSplitPoint.elem = i.elem;
                    latestPartitionSize = coalescedSize.elem;
                    coalescedSize.elem = totalSizeOfCurrentPartition;
                }
            } else {
                coalescedSize.elem += totalSizeOfCurrentPartition;
            }
            ++i.elem;
        }
        if (coalescedSize.elem < minPartitionSize && latestPartitionSize > 0L) {
            partitionSpecs.update(partitionSpecs.length() - 1, (Object)new CoalescedPartitionSpec(((CoalescedPartitionSpec)partitionSpecs.last()).startReducerIndex(), end, CoalescedPartitionSpec$.MODULE$.apply$default$3()));
        } else {
            ShufflePartitionsUtil$.createPartitionSpec$1(!allowReturnEmpty && partitionSpecs.isEmpty(), coalescedSize, partitionSpecs, latestSplitPoint, i);
        }
        return partitionSpecs.toSeq();
    }

    private boolean coalescePartitions$default$6() {
        return false;
    }

    private Seq<Seq<CoalescedPartitionSpec>> attachDataSize(Seq<Option<MapOutputStatistics>> mapOutputStatistics, Seq<CoalescedPartitionSpec> partitionSpecs) {
        return ((SeqLike)mapOutputStatistics.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Seq seq;
            Option option = x0$1;
            if (option instanceof Some) {
                Some some = (Some)option;
                MapOutputStatistics mapStats = (MapOutputStatistics)some.value();
                seq = ((SeqLike)partitionSpecs.map((Function1 & Serializable & scala.Serializable)spec -> {
                    long dataSize = BoxesRunTime.unboxToLong((Object)((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(spec.startReducerIndex()), spec.endReducerIndex()).map((Function1)Predef$.MODULE$.wrapLongArray(mapStats.bytesByPartitionId()), IndexedSeq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                    Some x$1 = new Some((Object)BoxesRunTime.boxToLong((long)dataSize));
                    int x$2 = spec.copy$default$1();
                    int x$3 = spec.copy$default$2();
                    return spec.copy(x$2, x$3, (Option<Object>)x$1);
                }, Seq$.MODULE$.canBuildFrom())).toSeq();
            } else if (None$.MODULE$.equals(option)) {
                seq = ((SeqLike)partitionSpecs.map((Function1 & Serializable & scala.Serializable)x$13 -> {
                    Some x$4 = new Some((Object)BoxesRunTime.boxToLong((long)0L));
                    int x$5 = x$13.copy$default$1();
                    int x$6 = x$13.copy$default$2();
                    return x$13.copy(x$5, x$6, (Option<Object>)x$4);
                }, Seq$.MODULE$.canBuildFrom())).toSeq();
            } else {
                throw new MatchError((Object)option);
            }
            return seq;
        }, Seq$.MODULE$.canBuildFrom())).toSeq();
    }

    public int[] splitSizeListByTargetSize(long[] sizes, long targetSize, double smallPartitionFactor) {
        ArrayBuffer partitionStartIndices = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        partitionStartIndices.$plus$eq((Object)BoxesRunTime.boxToInteger((int)0));
        LongRef currentPartitionSize = LongRef.create((long)0L);
        LongRef lastPartitionSize = LongRef.create((long)-1L);
        for (int i = 0; i < sizes.length; ++i) {
            if (i > 0 && currentPartitionSize.elem + sizes[i] > targetSize) {
                ShufflePartitionsUtil$.tryMergePartitions$1(lastPartitionSize, currentPartitionSize, targetSize, smallPartitionFactor, partitionStartIndices);
                partitionStartIndices.$plus$eq((Object)BoxesRunTime.boxToInteger((int)i));
                currentPartitionSize.elem = sizes[i];
                continue;
            }
            currentPartitionSize.elem += sizes[i];
        }
        ShufflePartitionsUtil$.tryMergePartitions$1(lastPartitionSize, currentPartitionSize, targetSize, smallPartitionFactor, partitionStartIndices);
        return (int[])partitionStartIndices.toArray(ClassTag$.MODULE$.Int());
    }

    private long[] getMapSizesForReduceId(int shuffleId, int partitionId) {
        MapOutputTrackerMaster mapOutputTracker = (MapOutputTrackerMaster)SparkEnv$.MODULE$.get().mapOutputTracker();
        return (long[])((ShuffleStatus)mapOutputTracker.shuffleStatuses().apply((Object)BoxesRunTime.boxToInteger((int)shuffleId))).withMapStatuses((Function1 & Serializable & scala.Serializable)x$14 -> (long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$14)).map((Function1 & Serializable & scala.Serializable)stat -> BoxesRunTime.boxToLong((long)ShufflePartitionsUtil$.$anonfun$getMapSizesForReduceId$2(partitionId, stat)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())));
    }

    public Option<Seq<PartialReducerPartitionSpec>> createSkewPartitionSpecs(int shuffleId, int reducerId, long targetSize, double smallPartitionFactor) {
        long[] mapPartitionSizes = this.getMapSizesForReduceId(shuffleId, reducerId);
        if (new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(mapPartitionSizes)).exists((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$15 -> x$15 < 0L)) {
            return None$.MODULE$;
        }
        int[] mapStartIndices = this.splitSizeListByTargetSize(mapPartitionSizes, targetSize, smallPartitionFactor);
        return mapStartIndices.length > 1 ? new Some(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(mapStartIndices)).indices().map((Function1 & Serializable & scala.Serializable)i -> ShufflePartitionsUtil$.$anonfun$createSkewPartitionSpecs$2(mapStartIndices, mapPartitionSizes, reducerId, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())) : None$.MODULE$;
    }

    public double createSkewPartitionSpecs$default$4() {
        return 0.2;
    }

    public static final /* synthetic */ long $anonfun$coalescePartitions$2(MapOutputStatistics x$2) {
        return BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(x$2.bytesByPartitionId())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public static final /* synthetic */ int $anonfun$coalescePartitionsWithoutSkew$3(MapOutputStatistics x$6) {
        return x$6.bytesByPartitionId().length;
    }

    public static final /* synthetic */ int $anonfun$coalescePartitionsWithSkew$6(ShufflePartitionSpec x0$1) {
        int n;
        int end;
        CoalescedPartitionSpec coalescedPartitionSpec;
        int start;
        ShufflePartitionSpec shufflePartitionSpec = x0$1;
        if (shufflePartitionSpec instanceof CoalescedPartitionSpec && (start = (coalescedPartitionSpec = (CoalescedPartitionSpec)shufflePartitionSpec).startReducerIndex()) + 1 == (end = coalescedPartitionSpec.endReducerIndex())) {
            n = start;
        } else if (shufflePartitionSpec instanceof PartialReducerPartitionSpec) {
            int reducerId;
            PartialReducerPartitionSpec partialReducerPartitionSpec = (PartialReducerPartitionSpec)shufflePartitionSpec;
            n = reducerId = partialReducerPartitionSpec.reducerIndex();
        } else {
            n = -1;
        }
        return n;
    }

    private static final void createPartitionSpec$1(boolean forceCreate, LongRef coalescedSize$1, ArrayBuffer partitionSpecs$1, IntRef latestSplitPoint$1, IntRef i$2) {
        block0: {
            if (coalescedSize$1.elem <= 0L && !forceCreate) break block0;
            partitionSpecs$1.$plus$eq((Object)new CoalescedPartitionSpec(latestSplitPoint$1.elem, i$2.elem, CoalescedPartitionSpec$.MODULE$.apply$default$3()));
        }
    }

    private static final boolean createPartitionSpec$default$1$1() {
        return false;
    }

    private static final void tryMergePartitions$1(LongRef lastPartitionSize$1, LongRef currentPartitionSize$1, long targetSize$2, double smallPartitionFactor$1, ArrayBuffer partitionStartIndices$1) {
        boolean shouldMergePartitions;
        boolean bl = shouldMergePartitions = lastPartitionSize$1.elem > -1L && ((double)(currentPartitionSize$1.elem + lastPartitionSize$1.elem) < (double)targetSize$2 * 1.2 || (double)currentPartitionSize$1.elem < (double)targetSize$2 * smallPartitionFactor$1 || (double)lastPartitionSize$1.elem < (double)targetSize$2 * smallPartitionFactor$1);
        if (shouldMergePartitions) {
            partitionStartIndices$1.remove(partitionStartIndices$1.length() - 1);
            lastPartitionSize$1.elem += currentPartitionSize$1.elem;
        } else {
            lastPartitionSize$1.elem = currentPartitionSize$1.elem;
        }
    }

    public static final /* synthetic */ long $anonfun$getMapSizesForReduceId$2(int partitionId$1, MapStatus stat) {
        return stat == null ? -1L : stat.getSizeForBlock(partitionId$1);
    }

    public static final /* synthetic */ PartialReducerPartitionSpec $anonfun$createSkewPartitionSpecs$2(int[] mapStartIndices$1, long[] mapPartitionSizes$1, int reducerId$1, int i) {
        int startMapIndex = mapStartIndices$1[i];
        int endMapIndex = i == mapStartIndices$1.length - 1 ? mapPartitionSizes$1.length : mapStartIndices$1[i + 1];
        long dataSize = 0L;
        for (int mapIndex = startMapIndex; mapIndex < endMapIndex; ++mapIndex) {
            dataSize += mapPartitionSizes$1[mapIndex];
        }
        return new PartialReducerPartitionSpec(reducerId$1, startMapIndex, endMapIndex, dataSize);
    }

    private ShufflePartitionsUtil$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

