/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.benchmark;

import java.io.File;
import java.io.Serializable;
import java.time.Instant;
import java.time.ZoneId;
import org.apache.spark.benchmark.Benchmark;
import org.apache.spark.benchmark.Benchmark$;
import org.apache.spark.benchmark.BenchmarkBase;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.execution.benchmark.SqlBasedBenchmark;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class ExtractBenchmark$
extends BenchmarkBase
implements SqlBasedBenchmark {
    public static ExtractBenchmark$ MODULE$;
    private final SparkSession spark;
    private String sparkHome;
    private volatile boolean bitmap$0;

    static {
        new ExtractBenchmark$();
    }

    @Override
    public SparkSession getSparkSession() {
        return SqlBasedBenchmark.getSparkSession$(this);
    }

    @Override
    public final void codegenBenchmark(String name, long cardinality, Function0<BoxedUnit> f) {
        SqlBasedBenchmark.codegenBenchmark$(this, name, cardinality, f);
    }

    @Override
    public SqlBasedBenchmark.DatasetToBenchmark DatasetToBenchmark(Dataset<?> ds) {
        return SqlBasedBenchmark.DatasetToBenchmark$(this, ds);
    }

    @Override
    public void prepareDataInfo(Benchmark benchmark) {
        SqlBasedBenchmark.prepareDataInfo$(this, benchmark);
    }

    @Override
    public StructType writeWideRow(String path, int rowsNum, int numCols) {
        return SqlBasedBenchmark.writeWideRow$(this, path, rowsNum, numCols);
    }

    @Override
    public void afterAll() {
        SqlBasedBenchmark.afterAll$(this);
    }

    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$((SQLHelper)this, pairs, f);
    }

    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$((SQLHelper)this, f);
    }

    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$((SQLHelper)this, test);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void org$apache$spark$sql$execution$benchmark$SqlBasedBenchmark$_setter_$spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    private String sparkHome$lzycompute() {
        ExtractBenchmark$ extractBenchmark$ = this;
        synchronized (extractBenchmark$) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$((SQLHelper)this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    public String sparkHome() {
        return !this.bitmap$0 ? this.sparkHome$lzycompute() : this.sparkHome;
    }

    private void doBenchmark(long cardinality, Seq<String> exprs) {
        long sinceSecond = Instant.parse("2010-01-01T00:00:00Z").getEpochSecond();
        this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.LEGACY_INTERVAL_ENABLED().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.WHOLESTAGE_CODEGEN_ENABLED().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.spark().range(sinceSecond, sinceSecond + cardinality, 1L, 1).selectExpr(exprs).queryExecution().toRdd().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            ExtractBenchmark$.$anonfun$doBenchmark$2(x$1);
            return BoxedUnit.UNIT;
        }));
    }

    private void run(Benchmark benchmark, long cardinality, String name, Seq<String> exprs) {
        benchmark.addCase(name, 3, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$2 -> MODULE$.doBenchmark(cardinality, exprs));
    }

    private String castExpr(String from) {
        String string;
        String string2 = from;
        if ("timestamp".equals(string2)) {
            string = "timestamp_seconds(id)";
        } else if ("date".equals(string2)) {
            string = "cast(timestamp_seconds(id) as date)";
        } else if ("interval".equals(string2)) {
            string = "(cast(timestamp_seconds(id) as date) - date'0001-01-01') + (timestamp_seconds(id) - timestamp'1000-01-01 01:02:03.123456')";
        } else {
            throw new IllegalArgumentException(new StringBuilder(71).append("Unsupported column type ").append(string2).append(". Valid column types are 'timestamp' and 'date'").toString());
        }
        return string;
    }

    private void run(Benchmark benchmark, String func, long cardinality, String field, String from) {
        String string;
        String string2 = func;
        if ("extract".equals(string2)) {
            string = new StringBuilder(19).append("EXTRACT(").append(field).append(" FROM ").append(this.castExpr(from)).append(") AS ").append(field).toString();
        } else if ("date_part".equals(string2)) {
            string = new StringBuilder(19).append("DATE_PART('").append(field).append("', ").append(this.castExpr(from)).append(") AS ").append(field).toString();
        } else {
            throw new IllegalArgumentException(new StringBuilder(71).append("Unsupported function '").append(string2).append("'. Valid functions are 'extract' and 'date_part'.").toString());
        }
        String expr = string;
        benchmark.addCase(new StringBuilder(4).append(field).append(" of ").append(from).toString(), 3, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$3 -> MODULE$.doBenchmark(cardinality, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{expr})));
    }

    public void runBenchmarkSuite(String[] mainArgs) {
        long N = 10000000L;
        Seq datetimeFields = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"YEAR", "YEAROFWEEK", "QUARTER", "MONTH", "WEEK", "DAY", "DAYOFWEEK", "DOW", "DOW_ISO", "DAYOFWEEK_ISO", "DOY", "HOUR", "MINUTE", "SECOND"}));
        Seq intervalFields = (Seq)new .colon.colon((Object)"YEAR", (List)new .colon.colon((Object)"MONTH", (List)new .colon.colon((Object)"DAY", (List)new .colon.colon((Object)"HOUR", (List)new .colon.colon((Object)"MINUTE", (List)new .colon.colon((Object)"SECOND", (List)Nil$.MODULE$))))));
        Map settings = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"timestamp"), (Object)datetimeFields), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"date"), (Object)datetimeFields), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"interval"), (Object)intervalFields)}));
        settings.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)ExtractBenchmark$.$anonfun$runBenchmarkSuite$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            ExtractBenchmark$.$anonfun$runBenchmarkSuite$2(N, x$5);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$doBenchmark$2(InternalRow x$1) {
    }

    public static final /* synthetic */ boolean $anonfun$runBenchmarkSuite$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$runBenchmarkSuite$3(String dataType$1, long N$1, Seq fields$1, String func) {
        String x$1 = new StringBuilder(12).append("Invoke ").append(func).append(" for ").append(dataType$1).toString();
        long x$2 = N$1;
        Option x$3 = MODULE$.output();
        int x$42 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark(x$1, x$2, x$42, x$5, x$6, x$7, x$3);
        MODULE$.run(benchmark, N$1, new StringBuilder(8).append("cast to ").append(dataType$1).toString(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{MODULE$.castExpr(dataType$1)}));
        fields$1.foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            ExtractBenchmark$.MODULE$.run(benchmark, func, N$1, x$4, dataType$1);
            return BoxedUnit.UNIT;
        });
        benchmark.run();
    }

    public static final /* synthetic */ void $anonfun$runBenchmarkSuite$2(long N$1, Tuple2 x$5) {
        Tuple2 tuple2 = x$5;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String dataType = (String)tuple2._1();
        Seq fields = (Seq)tuple2._2();
        ((IterableLike)new .colon.colon((Object)"extract", (List)new .colon.colon((Object)"date_part", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)func -> {
            ExtractBenchmark$.$anonfun$runBenchmarkSuite$3(dataType, N$1, fields, func);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private ExtractBenchmark$() {
        MODULE$ = this;
        SQLHelper.$init$((SQLHelper)this);
        SqlBasedBenchmark.$init$(this);
    }
}

