/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTable$;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.trees.LeafLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.CharVarcharUtils$;
import org.apache.spark.sql.execution.command.CreateTableLikeCommand$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.command.LeafRunnableCommand;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.types.StructType;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple6;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005uh\u0001B\u0013'\u0001NB\u0001b\u0013\u0001\u0003\u0016\u0004%\t\u0001\u0014\u0005\t#\u0002\u0011\t\u0012)A\u0005\u001b\"A!\u000b\u0001BK\u0002\u0013\u0005A\n\u0003\u0005T\u0001\tE\t\u0015!\u0003N\u0011!!\u0006A!f\u0001\n\u0003)\u0006\u0002\u0003/\u0001\u0005#\u0005\u000b\u0011\u0002,\t\u0011u\u0003!Q3A\u0005\u0002yC\u0001\"\u001c\u0001\u0003\u0012\u0003\u0006Ia\u0018\u0005\t]\u0002\u0011)\u001a!C\u0001_\"A1\u000f\u0001B\tB\u0003%\u0001\u000f\u0003\u0005u\u0001\tU\r\u0011\"\u0001v\u0011!I\bA!E!\u0002\u00131\b\"\u0002>\u0001\t\u0003Y\bbBA\u0004\u0001\u0011\u0005\u0013\u0011\u0002\u0005\n\u0003_\u0001\u0011\u0011!C\u0001\u0003cA\u0011\"a\u0010\u0001#\u0003%\t!!\u0011\t\u0013\u0005]\u0003!%A\u0005\u0002\u0005\u0005\u0003\"CA-\u0001E\u0005I\u0011AA.\u0011%\ty\u0006AI\u0001\n\u0003\t\t\u0007C\u0005\u0002f\u0001\t\n\u0011\"\u0001\u0002h!I\u00111\u000e\u0001\u0012\u0002\u0013\u0005\u0011Q\u000e\u0005\n\u0003c\u0002\u0011\u0011!C!\u0003gB\u0011\"a!\u0001\u0003\u0003%\t!!\"\t\u0013\u00055\u0005!!A\u0005\u0002\u0005=\u0005\"CAN\u0001\u0005\u0005I\u0011IAO\u0011%\tY\u000bAA\u0001\n\u0003\ti\u000bC\u0005\u00022\u0002\t\t\u0011\"\u0011\u00024\u001eI\u0011q\u0017\u0014\u0002\u0002#\u0005\u0011\u0011\u0018\u0004\tK\u0019\n\t\u0011#\u0001\u0002<\"1!0\bC\u0001\u0003\u0013D\u0011\"a3\u001e\u0003\u0003%)%!4\t\u0013\u0005=W$!A\u0005\u0002\u0006E\u0007\"CAp;E\u0005I\u0011AA4\u0011%\t\t/HA\u0001\n\u0003\u000b\u0019\u000fC\u0005\u0002rv\t\n\u0011\"\u0001\u0002h!I\u00111_\u000f\u0002\u0002\u0013%\u0011Q\u001f\u0002\u0017\u0007J,\u0017\r^3UC\ndW\rT5lK\u000e{W.\\1oI*\u0011q\u0005K\u0001\bG>lW.\u00198e\u0015\tI#&A\u0005fq\u0016\u001cW\u000f^5p]*\u00111\u0006L\u0001\u0004gFd'BA\u0017/\u0003\u0015\u0019\b/\u0019:l\u0015\ty\u0003'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002c\u0005\u0019qN]4\u0004\u0001M)\u0001\u0001\u000e C\u0011B\u0011Q\u0007P\u0007\u0002m)\u0011q\u0007O\u0001\bY><\u0017nY1m\u0015\tI$(A\u0003qY\u0006t7O\u0003\u0002<U\u0005A1-\u0019;bYf\u001cH/\u0003\u0002>m\tYAj\\4jG\u0006d\u0007\u000b\\1o!\ty\u0004)D\u0001'\u0013\t\teEA\nMK\u00064'+\u001e8oC\ndWmQ8n[\u0006tG\r\u0005\u0002D\r6\tAIC\u0001F\u0003\u0015\u00198-\u00197b\u0013\t9EIA\u0004Qe>$Wo\u0019;\u0011\u0005\rK\u0015B\u0001&E\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003-!\u0018M]4fiR\u000b'\r\\3\u0016\u00035\u0003\"AT(\u000e\u0003iJ!\u0001\u0015\u001e\u0003\u001fQ\u000b'\r\\3JI\u0016tG/\u001b4jKJ\fA\u0002^1sO\u0016$H+\u00192mK\u0002\n1b]8ve\u000e,G+\u00192mK\u0006a1o\\;sG\u0016$\u0016M\u00197fA\u0005Qa-\u001b7f\r>\u0014X.\u0019;\u0016\u0003Y\u0003\"a\u0016.\u000e\u0003aS!!\u0017\u001e\u0002\u000f\r\fG/\u00197pO&\u00111\f\u0017\u0002\u0015\u0007\u0006$\u0018\r\\8h'R|'/Y4f\r>\u0014X.\u0019;\u0002\u0017\u0019LG.\u001a$pe6\fG\u000fI\u0001\taJ|g/\u001b3feV\tq\fE\u0002DA\nL!!\u0019#\u0003\r=\u0003H/[8o!\t\u0019'N\u0004\u0002eQB\u0011Q\rR\u0007\u0002M*\u0011qMM\u0001\u0007yI|w\u000e\u001e \n\u0005%$\u0015A\u0002)sK\u0012,g-\u0003\u0002lY\n11\u000b\u001e:j]\u001eT!!\u001b#\u0002\u0013A\u0014xN^5eKJ\u0004\u0013A\u00039s_B,'\u000f^5fgV\t\u0001\u000f\u0005\u0003dc\n\u0014\u0017B\u0001:m\u0005\ri\u0015\r]\u0001\faJ|\u0007/\u001a:uS\u0016\u001c\b%A\u0006jM:{G/\u0012=jgR\u001cX#\u0001<\u0011\u0005\r;\u0018B\u0001=E\u0005\u001d\u0011un\u001c7fC:\fA\"\u001b4O_R,\u00050[:ug\u0002\na\u0001P5oSRtDC\u0003?~}~\f\t!a\u0001\u0002\u0006A\u0011q\b\u0001\u0005\u0006\u00176\u0001\r!\u0014\u0005\u0006%6\u0001\r!\u0014\u0005\u0006)6\u0001\rA\u0016\u0005\u0006;6\u0001\ra\u0018\u0005\b]6\u0001\n\u00111\u0001q\u0011\u0015!X\u00021\u0001w\u0003\r\u0011XO\u001c\u000b\u0005\u0003\u0017\t)\u0003\u0005\u0004\u0002\u000e\u0005]\u0011Q\u0004\b\u0005\u0003\u001f\t\u0019BD\u0002f\u0003#I\u0011!R\u0005\u0004\u0003+!\u0015a\u00029bG.\fw-Z\u0005\u0005\u00033\tYBA\u0002TKFT1!!\u0006E!\u0011\ty\"!\t\u000e\u0003)J1!a\t+\u0005\r\u0011vn\u001e\u0005\b\u0003Oq\u0001\u0019AA\u0015\u00031\u0019\b/\u0019:l'\u0016\u001c8/[8o!\u0011\ty\"a\u000b\n\u0007\u00055\"F\u0001\u0007Ta\u0006\u00148nU3tg&|g.\u0001\u0003d_BLH#\u0004?\u00024\u0005U\u0012qGA\u001d\u0003w\ti\u0004C\u0004L\u001fA\u0005\t\u0019A'\t\u000fI{\u0001\u0013!a\u0001\u001b\"9Ak\u0004I\u0001\u0002\u00041\u0006bB/\u0010!\u0003\u0005\ra\u0018\u0005\b]>\u0001\n\u00111\u0001q\u0011\u001d!x\u0002%AA\u0002Y\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002D)\u001aQ*!\u0012,\u0005\u0005\u001d\u0003\u0003BA%\u0003'j!!a\u0013\u000b\t\u00055\u0013qJ\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u0015E\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003+\nYEA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005u#f\u0001,\u0002F\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\"TCAA2U\ry\u0016QI\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00136+\t\tIGK\u0002q\u0003\u000b\nabY8qs\u0012\"WMZ1vYR$c'\u0006\u0002\u0002p)\u001aa/!\u0012\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t)\b\u0005\u0003\u0002x\u0005\u0005UBAA=\u0015\u0011\tY(! \u0002\t1\fgn\u001a\u0006\u0003\u0003\u007f\nAA[1wC&\u00191.!\u001f\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005\u001d\u0005cA\"\u0002\n&\u0019\u00111\u0012#\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005E\u0015q\u0013\t\u0004\u0007\u0006M\u0015bAAK\t\n\u0019\u0011I\\=\t\u0013\u0005e\u0005$!AA\u0002\u0005\u001d\u0015a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002 B1\u0011\u0011UAT\u0003#k!!a)\u000b\u0007\u0005\u0015F)\u0001\u0006d_2dWm\u0019;j_:LA!!+\u0002$\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\r1\u0018q\u0016\u0005\n\u00033S\u0012\u0011!a\u0001\u0003#\u000ba!Z9vC2\u001cHc\u0001<\u00026\"I\u0011\u0011T\u000e\u0002\u0002\u0003\u0007\u0011\u0011S\u0001\u0017\u0007J,\u0017\r^3UC\ndW\rT5lK\u000e{W.\\1oIB\u0011q(H\n\u0005;\u0005u\u0006\nE\u0006\u0002@\u0006\u0015W*\u0014,`aZdXBAAa\u0015\r\t\u0019\rR\u0001\beVtG/[7f\u0013\u0011\t9-!1\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>tg\u0007\u0006\u0002\u0002:\u0006AAo\\*ue&tw\r\u0006\u0002\u0002v\u0005)\u0011\r\u001d9msRiA0a5\u0002V\u0006]\u0017\u0011\\An\u0003;DQa\u0013\u0011A\u00025CQA\u0015\u0011A\u00025CQ\u0001\u0016\u0011A\u0002YCQ!\u0018\u0011A\u0002}CqA\u001c\u0011\u0011\u0002\u0003\u0007\u0001\u000fC\u0003uA\u0001\u0007a/A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00136\u0003\u001d)h.\u00199qYf$B!!:\u0002nB!1\tYAt!%\u0019\u0015\u0011^'N-~\u0003h/C\u0002\u0002l\u0012\u0013a\u0001V;qY\u00164\u0004\u0002CAxE\u0005\u0005\t\u0019\u0001?\u0002\u0007a$\u0003'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%N\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002xB!\u0011qOA}\u0013\u0011\tY0!\u001f\u0003\r=\u0013'.Z2u\u0001")
public class CreateTableLikeCommand
extends LogicalPlan
implements LeafRunnableCommand,
Serializable {
    private final TableIdentifier targetTable;
    private final TableIdentifier sourceTable;
    private final CatalogStorageFormat fileFormat;
    private final Option<String> provider;
    private final Map<String, String> properties;
    private final boolean ifNotExists;
    private Map<String, SQLMetric> metrics;
    private final Seq<Enumeration.Value> nodePatterns;
    private volatile boolean bitmap$0;

    public static Map<String, String> $lessinit$greater$default$5() {
        return CreateTableLikeCommand$.MODULE$.$lessinit$greater$default$5();
    }

    public static Option<Tuple6<TableIdentifier, TableIdentifier, CatalogStorageFormat, Option<String>, Map<String, String>, Object>> unapply(CreateTableLikeCommand createTableLikeCommand) {
        return CreateTableLikeCommand$.MODULE$.unapply(createTableLikeCommand);
    }

    public static Map<String, String> apply$default$5() {
        return CreateTableLikeCommand$.MODULE$.apply$default$5();
    }

    public static Function1<Tuple6<TableIdentifier, TableIdentifier, CatalogStorageFormat, Option<String>, Map<String, String>, Object>, CreateTableLikeCommand> tupled() {
        return CreateTableLikeCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<TableIdentifier, Function1<CatalogStorageFormat, Function1<Option<String>, Function1<Map<String, String>, Function1<Object, CreateTableLikeCommand>>>>>> curried() {
        return CreateTableLikeCommand$.MODULE$.curried();
    }

    @Override
    public final Seq<LogicalPlan> children() {
        return LeafLike.children$((LeafLike)this);
    }

    public final TreeNode mapChildren(Function1 f) {
        return LeafLike.mapChildren$((LeafLike)this, (Function1)f);
    }

    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return LeafLike.withNewChildrenInternal$((LeafLike)this, (IndexedSeq)newChildren);
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public AttributeSet producedAttributes() {
        return Command.producedAttributes$((Command)this);
    }

    public Statistics stats() {
        return Command.stats$((Command)this);
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        CreateTableLikeCommand createTableLikeCommand = this;
        synchronized (createTableLikeCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$(this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    @Override
    public Map<String, SQLMetric> metrics() {
        return !this.bitmap$0 ? this.metrics$lzycompute() : this.metrics;
    }

    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    public final void org$apache$spark$sql$catalyst$plans$logical$Command$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public TableIdentifier targetTable() {
        return this.targetTable;
    }

    public TableIdentifier sourceTable() {
        return this.sourceTable;
    }

    public CatalogStorageFormat fileFormat() {
        return this.fileFormat;
    }

    public Option<String> provider() {
        return this.provider;
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    public boolean ifNotExists() {
        return this.ifNotExists;
    }

    @Override
    public Seq<Row> run(SparkSession sparkSession) {
        Object object;
        SessionCatalog catalog = sparkSession.sessionState().catalog();
        CatalogTable sourceTableDesc = catalog.getTempViewOrPermanentTableMetadata(this.sourceTable());
        if (this.provider().isDefined()) {
            Object object2 = !DDLUtils$.MODULE$.isHiveTable(this.provider()) ? DataSource$.MODULE$.lookupDataSource((String)this.provider().get(), sparkSession.sessionState().conf()) : BoxedUnit.UNIT;
            object = this.provider();
        } else {
            CatalogTableType catalogTableType = sourceTableDesc.tableType();
            CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
            object = !(catalogTableType != null ? !catalogTableType.equals(catalogTableType2) : catalogTableType2 != null) ? new Some((Object)sparkSession.sessionState().conf().defaultDataSourceName()) : (this.fileFormat().inputFormat().isDefined() ? new Some((Object)DDLUtils$.MODULE$.HIVE_PROVIDER()) : sourceTableDesc.provider());
        }
        Some newProvider = object;
        CatalogStorageFormat newStorage = this.fileFormat().inputFormat().isDefined() ? this.fileFormat() : sourceTableDesc.storage().copy(this.fileFormat().locationUri(), sourceTableDesc.storage().copy$default$2(), sourceTableDesc.storage().copy$default$3(), sourceTableDesc.storage().copy$default$4(), sourceTableDesc.storage().copy$default$5(), sourceTableDesc.storage().copy$default$6());
        CatalogTableType tblType = newStorage.locationUri().isEmpty() ? CatalogTableType$.MODULE$.MANAGED() : CatalogTableType$.MODULE$.EXTERNAL();
        StructType newTableSchema = CharVarcharUtils$.MODULE$.getRawSchema(sourceTableDesc.schema(), sparkSession.sessionState().conf());
        TableIdentifier x$1 = this.targetTable();
        CatalogTableType x$2 = tblType;
        CatalogStorageFormat x$3 = newStorage;
        StructType x$4 = newTableSchema;
        Some x$5 = newProvider;
        Seq x$6 = sourceTableDesc.partitionColumnNames();
        Option x$7 = sourceTableDesc.bucketSpec();
        Map<String, String> x$8 = this.properties();
        boolean x$9 = sourceTableDesc.tracksPartitionsInCatalog();
        String x$10 = CatalogTable$.MODULE$.apply$default$8();
        long x$11 = CatalogTable$.MODULE$.apply$default$9();
        long x$12 = CatalogTable$.MODULE$.apply$default$10();
        String x$13 = CatalogTable$.MODULE$.apply$default$11();
        Option x$14 = CatalogTable$.MODULE$.apply$default$13();
        Option x$15 = CatalogTable$.MODULE$.apply$default$14();
        Option x$16 = CatalogTable$.MODULE$.apply$default$15();
        Seq x$17 = CatalogTable$.MODULE$.apply$default$16();
        boolean x$18 = CatalogTable$.MODULE$.apply$default$18();
        Map x$19 = CatalogTable$.MODULE$.apply$default$19();
        Option x$20 = CatalogTable$.MODULE$.apply$default$20();
        CatalogTable newTableDesc = new CatalogTable(x$1, x$2, x$3, x$4, (Option)x$5, x$6, x$7, x$10, x$11, x$12, x$13, x$8, x$14, x$15, x$16, x$17, x$9, x$18, x$19, x$20);
        catalog.createTable(newTableDesc, this.ifNotExists(), catalog.createTable$default$3());
        return (Seq)Nil$.MODULE$;
    }

    public CreateTableLikeCommand copy(TableIdentifier targetTable, TableIdentifier sourceTable, CatalogStorageFormat fileFormat, Option<String> provider, Map<String, String> properties, boolean ifNotExists) {
        return new CreateTableLikeCommand(targetTable, sourceTable, fileFormat, provider, properties, ifNotExists);
    }

    public TableIdentifier copy$default$1() {
        return this.targetTable();
    }

    public TableIdentifier copy$default$2() {
        return this.sourceTable();
    }

    public CatalogStorageFormat copy$default$3() {
        return this.fileFormat();
    }

    public Option<String> copy$default$4() {
        return this.provider();
    }

    public Map<String, String> copy$default$5() {
        return this.properties();
    }

    public boolean copy$default$6() {
        return this.ifNotExists();
    }

    public String productPrefix() {
        return "CreateTableLikeCommand";
    }

    public int productArity() {
        return 6;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.targetTable();
                break;
            }
            case 1: {
                object = this.sourceTable();
                break;
            }
            case 2: {
                object = this.fileFormat();
                break;
            }
            case 3: {
                object = this.provider();
                break;
            }
            case 4: {
                object = this.properties();
                break;
            }
            case 5: {
                object = BoxesRunTime.boxToBoolean((boolean)this.ifNotExists());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CreateTableLikeCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CreateTableLikeCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        CreateTableLikeCommand createTableLikeCommand = (CreateTableLikeCommand)x$1;
        TableIdentifier tableIdentifier = this.targetTable();
        TableIdentifier tableIdentifier2 = createTableLikeCommand.targetTable();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        TableIdentifier tableIdentifier3 = this.sourceTable();
        TableIdentifier tableIdentifier4 = createTableLikeCommand.sourceTable();
        if (tableIdentifier3 == null) {
            if (tableIdentifier4 != null) {
                return false;
            }
        } else if (!tableIdentifier3.equals(tableIdentifier4)) return false;
        CatalogStorageFormat catalogStorageFormat = this.fileFormat();
        CatalogStorageFormat catalogStorageFormat2 = createTableLikeCommand.fileFormat();
        if (catalogStorageFormat == null) {
            if (catalogStorageFormat2 != null) {
                return false;
            }
        } else if (!catalogStorageFormat.equals(catalogStorageFormat2)) return false;
        Option<String> option = this.provider();
        Option<String> option2 = createTableLikeCommand.provider();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Map<String, String> map = this.properties();
        Map<String, String> map2 = createTableLikeCommand.properties();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        if (this.ifNotExists() != createTableLikeCommand.ifNotExists()) return false;
        if (!createTableLikeCommand.canEqual(this)) return false;
        return true;
    }

    public CreateTableLikeCommand(TableIdentifier targetTable, TableIdentifier sourceTable, CatalogStorageFormat fileFormat, Option<String> provider, Map<String, String> properties, boolean ifNotExists) {
        this.targetTable = targetTable;
        this.sourceTable = sourceTable;
        this.fileFormat = fileFormat;
        this.provider = provider;
        this.properties = properties;
        this.ifNotExists = ifNotExists;
        Command.$init$((Command)this);
        RunnableCommand.$init$(this);
        LeafLike.$init$((LeafLike)this);
    }
}

