/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2;

import java.io.Serializable;
import org.apache.spark.InterruptibleIterator;
import org.apache.spark.Partition;
import org.apache.spark.SparkContext;
import org.apache.spark.TaskContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.metric.CustomTaskMetric;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.PartitionReader;
import org.apache.spark.sql.connector.read.PartitionReaderFactory;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceRDDPartition;
import org.apache.spark.sql.execution.datasources.v2.MetricsBatchIterator;
import org.apache.spark.sql.execution.datasources.v2.MetricsIterator;
import org.apache.spark.sql.execution.datasources.v2.MetricsRowIterator;
import org.apache.spark.sql.execution.datasources.v2.PartitionIterator;
import org.apache.spark.sql.execution.metric.CustomMetrics$;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005ma\u0001\u0002\u0007\u000e\u0001qA\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\t]\u0001\u0011)\u0019!C\u0005_!Aa\t\u0001B\u0001B\u0003%\u0001\u0007\u0003\u0005M\u0001\t\u0005\t\u0015!\u0003N\u0011!\u0001\u0006A!A!\u0002\u0013\t\u0006\u0002\u0003+\u0001\u0005\u0003\u0005\u000b\u0011B+\t\u000b\u0019\u0004A\u0011A4\t\u000b=\u0004A\u0011\u000b9\t\u000b]\u0004A\u0011\u0002=\t\u000by\u0004A\u0011I@\t\u000f\u0005M\u0001\u0001\"\u0011\u0002\u0016\tiA)\u0019;b'>,(oY3S\t\u0012S!AD\b\u0002\u0005Y\u0014$B\u0001\t\u0012\u0003-!\u0017\r^1t_V\u00148-Z:\u000b\u0005I\u0019\u0012!C3yK\u000e,H/[8o\u0015\t!R#A\u0002tc2T!AF\f\u0002\u000bM\u0004\u0018M]6\u000b\u0005aI\u0012AB1qC\u000eDWMC\u0001\u001b\u0003\ry'oZ\u0002\u0001'\t\u0001Q\u0004E\u0002\u001fC\rj\u0011a\b\u0006\u0003AU\t1A\u001d3e\u0013\t\u0011sDA\u0002S\t\u0012\u0003\"\u0001J\u0014\u000e\u0003\u0015R!AJ\n\u0002\u0011\r\fG/\u00197zgRL!\u0001K\u0013\u0003\u0017%sG/\u001a:oC2\u0014vn^\u0001\u0003g\u000e\u0004\"a\u000b\u0017\u000e\u0003UI!!L\u000b\u0003\u0019M\u0003\u0018M]6D_:$X\r\u001f;\u0002\u001f%t\u0007/\u001e;QCJ$\u0018\u000e^5p]N,\u0012\u0001\r\t\u0004cmrdB\u0001\u001a9\u001d\t\u0019d'D\u00015\u0015\t)4$\u0001\u0004=e>|GOP\u0005\u0002o\u0005)1oY1mC&\u0011\u0011HO\u0001\ba\u0006\u001c7.Y4f\u0015\u00059\u0014B\u0001\u001f>\u0005\r\u0019V-\u001d\u0006\u0003si\u0002\"a\u0010#\u000e\u0003\u0001S!!\u0011\"\u0002\tI,\u0017\r\u001a\u0006\u0003\u0007N\t\u0011bY8o]\u0016\u001cGo\u001c:\n\u0005\u0015\u0003%AD%oaV$\b+\u0019:uSRLwN\\\u0001\u0011S:\u0004X\u000f\u001e)beRLG/[8og\u0002B#a\u0001%\u0011\u0005%SU\"\u0001\u001e\n\u0005-S$!\u0003;sC:\u001c\u0018.\u001a8u\u0003Y\u0001\u0018M\u001d;ji&|gNU3bI\u0016\u0014h)Y2u_JL\bCA O\u0013\ty\u0005I\u0001\fQCJ$\u0018\u000e^5p]J+\u0017\rZ3s\r\u0006\u001cGo\u001c:z\u00035\u0019w\u000e\\;n]\u0006\u0014(+Z1egB\u0011\u0011JU\u0005\u0003'j\u0012qAQ8pY\u0016\fg.A\u0007dkN$x.\\'fiJL7m\u001d\t\u0005-jk\u0006M\u0004\u0002X1B\u00111GO\u0005\u00033j\na\u0001\u0015:fI\u00164\u0017BA.]\u0005\ri\u0015\r\u001d\u0006\u00033j\u0002\"A\u00160\n\u0005}c&AB*ue&tw\r\u0005\u0002bI6\t!M\u0003\u0002d#\u00051Q.\u001a;sS\u000eL!!\u001a2\u0003\u0013M\u000bF*T3ue&\u001c\u0017A\u0002\u001fj]&$h\b\u0006\u0004iU.dWN\u001c\t\u0003S\u0002i\u0011!\u0004\u0005\u0006S\u001d\u0001\rA\u000b\u0005\u0006]\u001d\u0001\r\u0001\r\u0005\u0006\u0019\u001e\u0001\r!\u0014\u0005\u0006!\u001e\u0001\r!\u0015\u0005\u0006)\u001e\u0001\r!V\u0001\u000eO\u0016$\b+\u0019:uSRLwN\\:\u0016\u0003E\u00042!\u0013:u\u0013\t\u0019(HA\u0003BeJ\f\u0017\u0010\u0005\u0002,k&\u0011a/\u0006\u0002\n!\u0006\u0014H/\u001b;j_:\fQbY1tiB\u000b'\u000f^5uS>tGCA=}!\tI'0\u0003\u0002|\u001b\t1B)\u0019;b'>,(oY3S\t\u0012\u0003\u0016M\u001d;ji&|g\u000eC\u0003~\u0013\u0001\u0007A/A\u0003ta2LG/A\u0004d_6\u0004X\u000f^3\u0015\r\u0005\u0005\u0011qAA\u0005!\u0011\t\u00141A\u0012\n\u0007\u0005\u0015QH\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011\u0015i(\u00021\u0001u\u0011\u001d\tYA\u0003a\u0001\u0003\u001b\tqaY8oi\u0016DH\u000fE\u0002,\u0003\u001fI1!!\u0005\u0016\u0005-!\u0016m]6D_:$X\r\u001f;\u0002+\u001d,G\u000f\u0015:fM\u0016\u0014(/\u001a3M_\u000e\fG/[8ogR!\u0011qCA\r!\r\t4(\u0018\u0005\u0006{.\u0001\r\u0001\u001e")
public class DataSourceRDD
extends RDD<InternalRow> {
    private final transient Seq<InputPartition> inputPartitions;
    private final PartitionReaderFactory partitionReaderFactory;
    private final boolean columnarReads;
    private final Map<String, SQLMetric> customMetrics;

    private Seq<InputPartition> inputPartitions() {
        return this.inputPartitions;
    }

    public Partition[] getPartitions() {
        return (Partition[])((TraversableOnce)((TraversableLike)this.inputPartitions().zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            InputPartition inputPartition = (InputPartition)tuple2._1();
            int index = tuple2._2$mcI$sp();
            DataSourceRDDPartition dataSourceRDDPartition = new DataSourceRDDPartition(index, inputPartition);
            return dataSourceRDDPartition;
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Partition.class));
    }

    private DataSourceRDDPartition castPartition(Partition split) {
        DataSourceRDDPartition dataSourceRDDPartition;
        Partition partition = split;
        if (!(partition instanceof DataSourceRDDPartition)) {
            throw QueryExecutionErrors$.MODULE$.notADatasourceRDDPartitionError(split);
        }
        DataSourceRDDPartition dataSourceRDDPartition2 = dataSourceRDDPartition = (DataSourceRDDPartition)partition;
        return dataSourceRDDPartition2;
    }

    public Iterator<InternalRow> compute(Partition split, TaskContext context) {
        Tuple2 tuple2;
        Tuple2 tuple22;
        InputPartition inputPartition = this.castPartition(split).inputPartition();
        if (this.columnarReads) {
            PartitionReader batchReader = this.partitionReaderFactory.createColumnarReader(inputPartition);
            MetricsBatchIterator iter = new MetricsBatchIterator((Iterator<ColumnarBatch>)new PartitionIterator<ColumnarBatch>(batchReader, this.customMetrics));
            tuple22 = new Tuple2((Object)iter, (Object)batchReader);
        } else {
            PartitionReader rowReader = this.partitionReaderFactory.createReader(inputPartition);
            MetricsRowIterator iter = new MetricsRowIterator((Iterator<InternalRow>)new PartitionIterator<InternalRow>(rowReader, this.customMetrics));
            tuple22 = tuple2 = new Tuple2((Object)iter, (Object)rowReader);
        }
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        MetricsIterator iter = (MetricsIterator)tuple2._1();
        PartitionReader reader = (PartitionReader)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)iter, (Object)reader);
        Tuple2 tuple24 = tuple23;
        MetricsIterator iter2 = (MetricsIterator)tuple24._1();
        PartitionReader reader2 = (PartitionReader)tuple24._2();
        context.addTaskCompletionListener((Function1 & Serializable & scala.Serializable)x$2 -> {
            DataSourceRDD.$anonfun$compute$1(this, reader2, x$2);
            return BoxedUnit.UNIT;
        });
        return new InterruptibleIterator(context, (Iterator)iter2);
    }

    public Seq<String> getPreferredLocations(Partition split) {
        return Predef$.MODULE$.wrapRefArray((Object[])this.castPartition(split).inputPartition().preferredLocations());
    }

    public static final /* synthetic */ void $anonfun$compute$1(DataSourceRDD $this, PartitionReader reader$1, TaskContext x$2) {
        CustomMetrics$.MODULE$.updateMetrics((Seq<CustomTaskMetric>)Predef$.MODULE$.wrapRefArray((Object[])reader$1.currentMetricsValues()), $this.customMetrics);
        reader$1.close();
    }

    public DataSourceRDD(SparkContext sc, Seq<InputPartition> inputPartitions, PartitionReaderFactory partitionReaderFactory, boolean columnarReads, Map<String, SQLMetric> customMetrics) {
        this.inputPartitions = inputPartitions;
        this.partitionReaderFactory = partitionReaderFactory;
        this.columnarReads = columnarReads;
        this.customMetrics = customMetrics;
        super(sc, (Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(InternalRow.class));
    }
}

