/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.concurrent.GuardedBy;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.TaskContext$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.execution.streaming.state.AcquiredThreadInfo;
import org.apache.spark.sql.execution.streaming.state.ByteArrayPair;
import org.apache.spark.sql.execution.streaming.state.ByteArrayPair$;
import org.apache.spark.sql.execution.streaming.state.RocksDB$;
import org.apache.spark.sql.execution.streaming.state.RocksDBCheckpointMetadata;
import org.apache.spark.sql.execution.streaming.state.RocksDBConf;
import org.apache.spark.sql.execution.streaming.state.RocksDBFileManager;
import org.apache.spark.sql.execution.streaming.state.RocksDBFileManagerMetrics;
import org.apache.spark.sql.execution.streaming.state.RocksDBFileManagerMetrics$;
import org.apache.spark.sql.execution.streaming.state.RocksDBLoader$;
import org.apache.spark.sql.execution.streaming.state.RocksDBMetrics;
import org.apache.spark.sql.execution.streaming.state.RocksDBNativeHistogram;
import org.apache.spark.sql.execution.streaming.state.RocksDBNativeHistogram$;
import org.apache.spark.util.NextIterator;
import org.apache.spark.util.Utils$;
import org.rocksdb.AbstractImmutableNativeReference;
import org.rocksdb.BlockBasedTableConfig;
import org.rocksdb.BloomFilter;
import org.rocksdb.Cache;
import org.rocksdb.Checkpoint;
import org.rocksdb.Filter;
import org.rocksdb.FlushOptions;
import org.rocksdb.HistogramType;
import org.rocksdb.InfoLogLevel;
import org.rocksdb.LRUCache;
import org.rocksdb.Options;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksIterator;
import org.rocksdb.Statistics;
import org.rocksdb.TableFormatConfig;
import org.rocksdb.TickerType;
import org.rocksdb.WriteBatchWithIndex;
import org.rocksdb.WriteOptions;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\r\rd\u0001B+W\u0001\u0015D\u0001B\u001d\u0001\u0003\u0002\u0003\u0006Ia\u001d\u0005\t}\u0002\u0011)\u0019!C\u0001\u007f\"Q\u0011\u0011\u0002\u0001\u0003\u0002\u0003\u0006I!!\u0001\t\u0015\u0005-\u0001A!A!\u0002\u0013\ti\u0001\u0003\u0006\u0002\u001e\u0001\u0011\t\u0011)A\u0005\u0003?A\u0011\"!\f\u0001\u0005\u0003\u0005\u000b\u0011B:\t\u000f\u0005=\u0002\u0001\"\u0001\u00022!I\u0011q\b\u0001C\u0002\u0013%\u0011\u0011\t\u0005\t\u0003\u001f\u0002\u0001\u0015!\u0003\u0002D!I\u0011\u0011\u000b\u0001C\u0002\u0013%\u00111\u000b\u0005\t\u00037\u0002\u0001\u0015!\u0003\u0002V!I\u0011Q\f\u0001C\u0002\u0013%\u0011q\f\u0005\t\u0003O\u0002\u0001\u0015!\u0003\u0002b!I\u0011\u0011\u000e\u0001C\u0002\u0013%\u00111\u000e\u0005\t\u0003g\u0002\u0001\u0015!\u0003\u0002n!I\u0011Q\u000f\u0001C\u0002\u0013%\u0011q\u000f\u0005\t\u0003\u007f\u0002\u0001\u0015!\u0003\u0002z!I\u0011\u0011\u0011\u0001C\u0002\u0013%\u00111\u0011\u0005\t\u0003\u0017\u0003\u0001\u0015!\u0003\u0002\u0006\"I\u0011Q\u0012\u0001C\u0002\u0013%\u0011q\u0012\u0005\t\u0003/\u0003\u0001\u0015!\u0003\u0002\u0012\"I\u0011\u0011\u0014\u0001C\u0002\u0013%\u00111\u0014\u0005\t\u0003G\u0003\u0001\u0015!\u0003\u0002\u001e\"I\u0011Q\u0015\u0001C\u0002\u0013%\u0011q\u0015\u0005\t\u0003_\u0003\u0001\u0015!\u0003\u0002*\"I\u0011\u0011\u0017\u0001C\u0002\u0013%\u00111\u0017\u0005\t\u0003k\u0003\u0001\u0015!\u0003\u0002\u000e!I\u0011q\u0017\u0001C\u0002\u0013%\u0011\u0011\u0018\u0005\t\u0003\u0003\u0004\u0001\u0015!\u0003\u0002<\"I\u00111\u0019\u0001C\u0002\u0013%\u0011Q\u0019\u0005\t\u0003\u001b\u0004\u0001\u0015!\u0003\u0002H\"I\u0011q\u001a\u0001C\u0002\u0013%\u0011\u0011\u001b\u0005\t\u0003S\u0004\u0001\u0015!\u0003\u0002T\"I\u00111\u001e\u0001C\u0002\u0013%\u0011Q\u001e\u0005\t\u0003w\u0004\u0001\u0015!\u0003\u0002p\"Y\u0011Q \u0001A\u0002\u0003\u0007I\u0011BA\u0000\u0011-\u0011)\u0001\u0001a\u0001\u0002\u0004%IAa\u0002\t\u0017\tM\u0001\u00011A\u0001B\u0003&!\u0011\u0001\u0005\n\u0005;\u0001\u0001\u0019!C\u0005\u0005?A\u0011B!\t\u0001\u0001\u0004%IAa\t\t\u0011\t\u001d\u0002\u0001)Q\u0005\u0003GD\u0011Ba\u000b\u0001\u0001\u0004%IAa\b\t\u0013\t5\u0002\u00011A\u0005\n\t=\u0002\u0002\u0003B\u001a\u0001\u0001\u0006K!a9\t\u0013\t]\u0002\u00011A\u0005\n\t}\u0001\"\u0003B\u001d\u0001\u0001\u0007I\u0011\u0002B\u001e\u0011!\u0011y\u0004\u0001Q!\n\u0005\r\b\"\u0003B\"\u0001\u0001\u0007I\u0011\u0002B#\u0011%\u0011i\u0005\u0001a\u0001\n\u0013\u0011y\u0005\u0003\u0005\u0003T\u0001\u0001\u000b\u0015\u0002B$\u0011-\u00119\u0006\u0001a\u0001\u0002\u0004%IA!\u0017\t\u0017\t\u0005\u0004\u00011AA\u0002\u0013%!1\r\u0005\f\u0005O\u0002\u0001\u0019!A!B\u0013\u0011Y\u0006C\u0005\u0003\u0006\u0002\u0011\r\u0011\"\u0003\u0003\b\"A!Q\u0014\u0001!\u0002\u0013\u0011I\tC\u0004\u0003 \u0002!\tA!)\t\u000f\t\u001d\u0006\u0001\"\u0001\u0003*\"9!1\u0018\u0001\u0005\u0002\tu\u0006b\u0002Bb\u0001\u0011\u0005!Q\u0019\u0005\b\u0005\u0013\u0004A\u0011\u0001Bf\u0011\u001d\u0011y\u000e\u0001C\u0001\u0005CDqAa:\u0001\t\u0003\u0011I\u000fC\u0004\u0003l\u0002!\tA!<\t\u000f\t=\b\u0001\"\u0001\u0003n\"9!\u0011\u001f\u0001\u0005\u0002\t5\bb\u0002Bz\u0001\u0011\u0005!\u0011\u001e\u0005\b\u0005k\u0004A\u0011\u0001B|\u0011\u001d\u0011y\u0010\u0001C\u0005\u0005[Dqa!\u0001\u0001\t\u0013\u0011i\u000fC\u0004\u0004\u0004\u0001!IA!<\t\u000f\r\u0015\u0001\u0001\"\u0003\u0004\b!91Q\u0002\u0001\u0005\n\t5\bbBB\b\u0001\u0011%!Q\u001e\u0005\b\u0007#\u0001A\u0011BB\n\u0011\u001d\u0019)\u0002\u0001C\u0005\u0007/Aqaa\u0007\u0001\t\u0013\u0019i\u0002C\u0004\u0004(\u0001!\tb!\u000b\t\u000f\rU\u0002\u0001\"\u0015\u00048\u001dI1\u0011\b,\u0002\u0002#\u000511\b\u0004\t+Z\u000b\t\u0011#\u0001\u0004>!9\u0011q\u0006)\u0005\u0002\r}\u0002\"CB!!F\u0005I\u0011AB\"\u0011%\u00199\u0006UI\u0001\n\u0003\u0019I\u0006C\u0005\u0004^A\u000b\n\u0011\"\u0001\u0004`\t9!k\\2lg\u0012\u0013%BA,Y\u0003\u0015\u0019H/\u0019;f\u0015\tI&,A\u0005tiJ,\u0017-\\5oO*\u00111\fX\u0001\nKb,7-\u001e;j_:T!!\u00180\u0002\u0007M\fHN\u0003\u0002`A\u0006)1\u000f]1sW*\u0011\u0011MY\u0001\u0007CB\f7\r[3\u000b\u0003\r\f1a\u001c:h\u0007\u0001\u00192\u0001\u00014m!\t9'.D\u0001i\u0015\u0005I\u0017!B:dC2\f\u0017BA6i\u0005\u0019\te.\u001f*fMB\u0011Q\u000e]\u0007\u0002]*\u0011qNX\u0001\tS:$XM\u001d8bY&\u0011\u0011O\u001c\u0002\b\u0019><w-\u001b8h\u0003)!gm\u001d*p_R$\u0015N\u001d\t\u0003int!!^=\u0011\u0005YDW\"A<\u000b\u0005a$\u0017A\u0002\u001fs_>$h(\u0003\u0002{Q\u00061\u0001K]3eK\u001aL!\u0001`?\u0003\rM#(/\u001b8h\u0015\tQ\b.\u0001\u0003d_:4WCAA\u0001!\u0011\t\u0019!!\u0002\u000e\u0003YK1!a\u0002W\u0005-\u0011vnY6t\t\n\u001buN\u001c4\u0002\u000b\r|gN\u001a\u0011\u0002\u00191|7-\u00197S_>$H)\u001b:\u0011\t\u0005=\u0011\u0011D\u0007\u0003\u0003#QA!a\u0005\u0002\u0016\u0005\u0011\u0011n\u001c\u0006\u0003\u0003/\tAA[1wC&!\u00111DA\t\u0005\u00111\u0015\u000e\\3\u0002\u0015!\fGm\\8q\u0007>tg\r\u0005\u0003\u0002\"\u0005%RBAA\u0012\u0015\rq\u0018Q\u0005\u0006\u0004\u0003O\u0001\u0017A\u00025bI>|\u0007/\u0003\u0003\u0002,\u0005\r\"!D\"p]\u001aLw-\u001e:bi&|g.A\u0005m_\u001e<\u0017N\\4JI\u00061A(\u001b8jiz\"B\"a\r\u00026\u0005]\u0012\u0011HA\u001e\u0003{\u00012!a\u0001\u0001\u0011\u0015\u0011x\u00011\u0001t\u0011\u0019qx\u00011\u0001\u0002\u0002!I\u00111B\u0004\u0011\u0002\u0003\u0007\u0011Q\u0002\u0005\n\u0003;9\u0001\u0013!a\u0001\u0003?A\u0001\"!\f\b!\u0003\u0005\ra]\u0001\fe\u0016\fGm\u00149uS>t7/\u0006\u0002\u0002DA!\u0011QIA&\u001b\t\t9EC\u0002\u0002J\t\fqA]8dWN$'-\u0003\u0003\u0002N\u0005\u001d#a\u0003*fC\u0012|\u0005\u000f^5p]N\fAB]3bI>\u0003H/[8og\u0002\nAb\u001e:ji\u0016|\u0005\u000f^5p]N,\"!!\u0016\u0011\t\u0005\u0015\u0013qK\u0005\u0005\u00033\n9E\u0001\u0007Xe&$Xm\u00149uS>t7/A\u0007xe&$Xm\u00149uS>t7\u000fI\u0001\rM2,8\u000f[(qi&|gn]\u000b\u0003\u0003C\u0002B!!\u0012\u0002d%!\u0011QMA$\u000511E.^:i\u001fB$\u0018n\u001c8t\u000351G.^:i\u001fB$\u0018n\u001c8tA\u0005QqO]5uK\n\u000bGo\u00195\u0016\u0005\u00055\u0004\u0003BA#\u0003_JA!!\u001d\u0002H\t\u0019rK]5uK\n\u000bGo\u00195XSRD\u0017J\u001c3fq\u0006YqO]5uK\n\u000bGo\u00195!\u0003-\u0011Gn\\8n\r&dG/\u001a:\u0016\u0005\u0005e\u0004\u0003BA#\u0003wJA!! \u0002H\tY!\t\\8p[\u001aKG\u000e^3s\u00031\u0011Gn\\8n\r&dG/\u001a:!\u0003E!\u0018M\u00197f\r>\u0014X.\u0019;D_:4\u0017nZ\u000b\u0003\u0003\u000b\u0003B!!\u0012\u0002\b&!\u0011\u0011RA$\u0005U\u0011En\\2l\u0005\u0006\u001cX\r\u001a+bE2,7i\u001c8gS\u001e\f!\u0003^1cY\u00164uN]7bi\u000e{gNZ5hA\u0005IAMY(qi&|gn]\u000b\u0003\u0003#\u0003B!!\u0012\u0002\u0014&!\u0011QSA$\u0005\u001dy\u0005\u000f^5p]N\f!\u0002\u001a2PaRLwN\\:!\u0003!!'\rT8hO\u0016\u0014XCAAO!\u0011\t)%a(\n\t\u0005\u0005\u0016q\t\u0002\u0007\u0019><w-\u001a:\u0002\u0013\u0011\u0014Gj\\4hKJ\u0004\u0013a\u00038bi&4Xm\u0015;biN,\"!!+\u0011\t\u0005\u0015\u00131V\u0005\u0005\u0003[\u000b9E\u0001\u0006Ti\u0006$\u0018n\u001d;jGN\fAB\\1uSZ,7\u000b^1ug\u0002\n!b^8sW&tw\rR5s+\t\ti!A\u0006x_J\\\u0017N\\4ESJ\u0004\u0013a\u00034jY\u0016l\u0015M\\1hKJ,\"!a/\u0011\t\u0005\r\u0011QX\u0005\u0004\u0003\u007f3&A\u0005*pG.\u001cHI\u0011$jY\u0016l\u0015M\\1hKJ\fABZ5mK6\u000bg.Y4fe\u0002\nQBY=uK\u0006\u0013(/Y=QC&\u0014XCAAd!\u0011\t\u0019!!3\n\u0007\u0005-gKA\u0007CsR,\u0017I\u001d:bsB\u000b\u0017N]\u0001\u000fEf$X-\u0011:sCf\u0004\u0016-\u001b:!\u0003=\u0019w.\\7ji2\u000bG/\u001a8ds6\u001bXCAAj!\u001d\t).a8t\u0003Gl!!a6\u000b\t\u0005e\u00171\\\u0001\b[V$\u0018M\u00197f\u0015\r\ti\u000e[\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAq\u0003/\u0014q\u0001S1tQ6\u000b\u0007\u000fE\u0002h\u0003KL1!a:i\u0005\u0011auN\\4\u0002!\r|W.\\5u\u0019\u0006$XM\\2z\u001bN\u0004\u0013aC1dcVL'/\u001a'pG.,\"!a<\u0011\t\u0005E\u0018q_\u0007\u0003\u0003gTA!!>\u0002\u0016\u0005!A.\u00198h\u0013\u0011\tI0a=\u0003\r=\u0013'.Z2u\u00031\t7-];je\u0016dunY6!\u0003\t!'-\u0006\u0002\u0003\u0002A!\u0011Q\tB\u0002\u0013\r)\u0016qI\u0001\u0007I\n|F%Z9\u0015\t\t%!q\u0002\t\u0004O\n-\u0011b\u0001B\u0007Q\n!QK\\5u\u0011%\u0011\t\"JA\u0001\u0002\u0004\u0011\t!A\u0002yIE\n1\u0001\u001a2!Q\r1#q\u0003\t\u0004O\ne\u0011b\u0001B\u000eQ\nAao\u001c7bi&dW-A\u0007m_\u0006$W\r\u001a,feNLwN\\\u000b\u0003\u0003G\f\u0011\u0003\\8bI\u0016$g+\u001a:tS>tw\fJ3r)\u0011\u0011IA!\n\t\u0013\tE\u0001&!AA\u0002\u0005\r\u0018A\u00047pC\u0012,GMV3sg&|g\u000e\t\u0015\u0004S\t]\u0011A\u00068v[.+\u0017p](o\u0019>\fG-\u001a3WKJ\u001c\u0018n\u001c8\u000259,XnS3zg>sGj\\1eK\u00124VM]:j_:|F%Z9\u0015\t\t%!\u0011\u0007\u0005\n\u0005#Y\u0013\u0011!a\u0001\u0003G\fqC\\;n\u0017\u0016L8o\u00148M_\u0006$W\r\u001a,feNLwN\u001c\u0011)\u00071\u00129\"A\fok6\\U-_:P]^\u0013\u0018\u000e^5oOZ+'o]5p]\u0006Yb.^7LKf\u001cxJ\\,sSRLgn\u001a,feNLwN\\0%KF$BA!\u0003\u0003>!I!\u0011\u0003\u0018\u0002\u0002\u0003\u0007\u00111]\u0001\u0019]Vl7*Z=t\u001f:<&/\u001b;j]\u001e4VM]:j_:\u0004\u0003fA\u0018\u0003\u0018\u0005\u0011b-\u001b7f\u001b\u0006t\u0017mZ3s\u001b\u0016$(/[2t+\t\u00119\u0005\u0005\u0003\u0002\u0004\t%\u0013b\u0001B&-\nI\"k\\2lg\u0012\u0013e)\u001b7f\u001b\u0006t\u0017mZ3s\u001b\u0016$(/[2t\u0003Y1\u0017\u000e\\3NC:\fw-\u001a:NKR\u0014\u0018nY:`I\u0015\fH\u0003\u0002B\u0005\u0005#B\u0011B!\u00052\u0003\u0003\u0005\rAa\u0012\u0002'\u0019LG.Z'b]\u0006<WM]'fiJL7m\u001d\u0011)\u0007I\u00129\"\u0001\nbGF,\u0018N]3e)\"\u0014X-\u00193J]\u001a|WC\u0001B.!\u0011\t\u0019A!\u0018\n\u0007\t}cK\u0001\nBGF,\u0018N]3e)\"\u0014X-\u00193J]\u001a|\u0017AF1dcVL'/\u001a3UQJ,\u0017\rZ%oM>|F%Z9\u0015\t\t%!Q\r\u0005\n\u0005#!\u0014\u0011!a\u0001\u00057\n1#Y2rk&\u0014X\r\u001a+ie\u0016\fG-\u00138g_\u0002B3!\u000eB\fQ\u001d)$Q\u000eBA\u0005\u0007\u0003BAa\u001c\u0003~5\u0011!\u0011\u000f\u0006\u0005\u0005g\u0012)(\u0001\u0006d_:\u001cWO\u001d:f]RTAAa\u001e\u0003z\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005\tm\u0014!\u00026bm\u0006D\u0018\u0002\u0002B@\u0005c\u0012\u0011bR;be\u0012,GMQ=\u0002\u000bY\fG.^3\"\u0005\u0005-\u0018a\u00059sK\u001aL\u0007pU2b]J+Wo]3Ji\u0016\u0014XC\u0001BE!!\u0011YIa%\u0002d\n]UB\u0001BG\u0015\u0011\u0011\u0019Ha$\u000b\t\tE\u0015QC\u0001\u0005kRLG.\u0003\u0003\u0003\u0016\n5%!E\"p]\u000e,(O]3oi\"\u000b7\u000f['baB!\u0011Q\tBM\u0013\u0011\u0011Y*a\u0012\u0003\u001bI{7m[:Ji\u0016\u0014\u0018\r^8s\u0003Q\u0001(/\u001a4jqN\u001b\u0017M\u001c*fkN,\u0017\n^3sA\u0005!An\\1e)\u0011\t\u0019Da)\t\u000f\t\u0015\u0006\b1\u0001\u0002d\u00069a/\u001a:tS>t\u0017aA4fiR!!1\u0016B\\!\u00159'Q\u0016BY\u0013\r\u0011y\u000b\u001b\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004O\nM\u0016b\u0001B[Q\n!!)\u001f;f\u0011\u001d\u0011I,\u000fa\u0001\u0005W\u000b1a[3z\u0003\r\u0001X\u000f\u001e\u000b\u0007\u0005W\u0013yL!1\t\u000f\te&\b1\u0001\u0003,\"9!\u0011\u0011\u001eA\u0002\t-\u0016A\u0002:f[>4X\r\u0006\u0003\u0003,\n\u001d\u0007b\u0002B]w\u0001\u0007!1V\u0001\tSR,'/\u0019;peR\u0011!Q\u001a\t\u0007\u0005\u001f\u0014I.a2\u000f\t\tE'Q\u001b\b\u0004m\nM\u0017\"A5\n\u0007\t]\u0007.A\u0004qC\u000e\\\u0017mZ3\n\t\tm'Q\u001c\u0002\t\u0013R,'/\u0019;pe*\u0019!q\u001b5\u0002\u0015A\u0014XMZ5y'\u000e\fg\u000e\u0006\u0003\u0003N\n\r\bb\u0002Bs{\u0001\u0007!1V\u0001\u0007aJ,g-\u001b=\u0002\r\r|W.\\5u)\t\t\u0019/\u0001\u0005s_2d'-Y2l)\t\u0011I!A\u0004dY\u0016\fg.\u001e9\u0002\u000b\rdwn]3\u0002!\u001d,G\u000fT1uKN$h+\u001a:tS>t\u0017aB7fiJL7m]\u000b\u0003\u0005s\u0004B!a\u0001\u0003|&\u0019!Q ,\u0003\u001dI{7m[:E\u00056+GO]5dg\u00069\u0011mY9vSJ,\u0017a\u0002:fY\u0016\f7/Z\u0001\u0019G2|7/\u001a)sK\u001aL\u0007pU2b]&#XM]1u_J\u001c\u0018!D4fi\u0012\u0013\u0005K]8qKJ$\u0018\u0010\u0006\u0003\u0002d\u000e%\u0001BBB\u0006\u000f\u0002\u00071/\u0001\u0005qe>\u0004XM\u001d;z\u0003\u0019y\u0007/\u001a8E\u0005\u000691\r\\8tK\u0012\u0013\u0015\u0001D2sK\u0006$X\rT8hO\u0016\u0014HCAAO\u00035\u0019'/Z1uKR+W\u000e\u001d#jeR!\u0011QBB\r\u0011\u0019\u0011)o\u0013a\u0001g\u000692/\u001b7f]R$U\r\\3uKJ+7-\u001e:tSZ,G.\u001f\u000b\u0007\u0005\u0013\u0019yba\t\t\u000f\r\u0005B\n1\u0001\u0002\u000e\u0005!a-\u001b7f\u0011\u0019\u0019)\u0003\u0014a\u0001g\u0006\u0019Qn]4\u0002\u0017QLW.\u001a+bW\u0016tWj\u001d\u000b\u0005\u0003G\u001cY\u0003\u0003\u0005\u0004.5#\t\u0019AB\u0018\u0003\u0011\u0011w\u000eZ=\u0011\u000b\u001d\u001c\tD!\u0003\n\u0007\rM\u0002N\u0001\u0005=Eft\u0017-\\3?\u0003\u001dawn\u001a(b[\u0016,\u0012a]\u0001\b%>\u001c7n\u001d#C!\r\t\u0019\u0001U\n\u0003!\u001a$\"aa\u000f\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\u0019)E\u000b\u0003\u0002\u000e\r\u001d3FAB%!\u0011\u0019Yea\u0015\u000e\u0005\r5#\u0002BB(\u0007#\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t]\u0004.\u0003\u0003\u0004V\r5#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIQ*\"aa\u0017+\t\u0005}1qI\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\r\u0005$fA:\u0004H\u0001")
public class RocksDB
implements Logging {
    private final RocksDBConf conf;
    private final File localRootDir;
    private final String loggingId;
    private final ReadOptions readOptions;
    private final WriteOptions writeOptions;
    private final FlushOptions flushOptions;
    private final WriteBatchWithIndex writeBatch;
    private final BloomFilter bloomFilter;
    private final BlockBasedTableConfig tableFormatConfig;
    private final Options org$apache$spark$sql$execution$streaming$state$RocksDB$$dbOptions;
    private final org.rocksdb.Logger dbLogger;
    private final Statistics nativeStats;
    private final File workingDir;
    private final RocksDBFileManager fileManager;
    private final ByteArrayPair org$apache$spark$sql$execution$streaming$state$RocksDB$$byteArrayPair;
    private final HashMap<String, Object> commitLatencyMs;
    private final Object acquireLock;
    private volatile org.rocksdb.RocksDB db;
    private volatile long loadedVersion;
    private volatile long numKeysOnLoadedVersion;
    private volatile long numKeysOnWritingVersion;
    private volatile RocksDBFileManagerMetrics fileManagerMetrics;
    @GuardedBy(value="acquireLock")
    private volatile AcquiredThreadInfo acquiredThreadInfo;
    private final ConcurrentHashMap<Object, RocksIterator> prefixScanReuseIter;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static String $lessinit$greater$default$5() {
        return RocksDB$.MODULE$.$lessinit$greater$default$5();
    }

    public static Configuration $lessinit$greater$default$4() {
        return RocksDB$.MODULE$.$lessinit$greater$default$4();
    }

    public static File $lessinit$greater$default$3() {
        return RocksDB$.MODULE$.$lessinit$greater$default$3();
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public RocksDBConf conf() {
        return this.conf;
    }

    private ReadOptions readOptions() {
        return this.readOptions;
    }

    private WriteOptions writeOptions() {
        return this.writeOptions;
    }

    private FlushOptions flushOptions() {
        return this.flushOptions;
    }

    private WriteBatchWithIndex writeBatch() {
        return this.writeBatch;
    }

    private BloomFilter bloomFilter() {
        return this.bloomFilter;
    }

    private BlockBasedTableConfig tableFormatConfig() {
        return this.tableFormatConfig;
    }

    public Options org$apache$spark$sql$execution$streaming$state$RocksDB$$dbOptions() {
        return this.org$apache$spark$sql$execution$streaming$state$RocksDB$$dbOptions;
    }

    private org.rocksdb.Logger dbLogger() {
        return this.dbLogger;
    }

    private Statistics nativeStats() {
        return this.nativeStats;
    }

    private File workingDir() {
        return this.workingDir;
    }

    private RocksDBFileManager fileManager() {
        return this.fileManager;
    }

    public ByteArrayPair org$apache$spark$sql$execution$streaming$state$RocksDB$$byteArrayPair() {
        return this.org$apache$spark$sql$execution$streaming$state$RocksDB$$byteArrayPair;
    }

    private HashMap<String, Object> commitLatencyMs() {
        return this.commitLatencyMs;
    }

    private Object acquireLock() {
        return this.acquireLock;
    }

    private org.rocksdb.RocksDB db() {
        return this.db;
    }

    private void db_$eq(org.rocksdb.RocksDB x$1) {
        this.db = x$1;
    }

    private long loadedVersion() {
        return this.loadedVersion;
    }

    private void loadedVersion_$eq(long x$1) {
        this.loadedVersion = x$1;
    }

    private long numKeysOnLoadedVersion() {
        return this.numKeysOnLoadedVersion;
    }

    private void numKeysOnLoadedVersion_$eq(long x$1) {
        this.numKeysOnLoadedVersion = x$1;
    }

    private long numKeysOnWritingVersion() {
        return this.numKeysOnWritingVersion;
    }

    private void numKeysOnWritingVersion_$eq(long x$1) {
        this.numKeysOnWritingVersion = x$1;
    }

    private RocksDBFileManagerMetrics fileManagerMetrics() {
        return this.fileManagerMetrics;
    }

    private void fileManagerMetrics_$eq(RocksDBFileManagerMetrics x$1) {
        this.fileManagerMetrics = x$1;
    }

    private AcquiredThreadInfo acquiredThreadInfo() {
        return this.acquiredThreadInfo;
    }

    private void acquiredThreadInfo_$eq(AcquiredThreadInfo x$1) {
        this.acquiredThreadInfo = x$1;
    }

    private ConcurrentHashMap<Object, RocksIterator> prefixScanReuseIter() {
        return this.prefixScanReuseIter;
    }

    public RocksDB load(long version) {
        Predef$.MODULE$.assert(version >= 0L);
        this.acquire();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(8).append("Loading ").append(version).toString());
        try {
            if (this.loadedVersion() != version) {
                this.closeDB();
                RocksDBCheckpointMetadata metadata = this.fileManager().loadCheckpointFromDfs(version, this.workingDir());
                this.openDB();
                this.numKeysOnWritingVersion_$eq(metadata.numKeys());
                this.numKeysOnLoadedVersion_$eq(metadata.numKeys());
                this.loadedVersion_$eq(version);
                this.fileManagerMetrics_$eq(this.fileManager().latestLoadCheckpointMetrics());
            }
            if (this.conf().resetStatsOnLoad()) {
                this.nativeStats().reset();
            }
            this.closePrefixScanIterators();
            this.writeBatch().clear();
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(7).append("Loaded ").append(version).toString());
        }
        catch (Throwable t) {
            this.loadedVersion_$eq(-1L);
            throw t;
        }
        return this;
    }

    public byte[] get(byte[] key) {
        return this.writeBatch().getFromBatchAndDB(this.db(), this.readOptions(), key);
    }

    /*
     * WARNING - void declaration
     */
    public byte[] put(byte[] key, byte[] value) {
        void var3_3;
        block0: {
            byte[] oldValue = this.writeBatch().getFromBatchAndDB(this.db(), this.readOptions(), key);
            this.writeBatch().put(key, value);
            if (oldValue != null) break block0;
            this.numKeysOnWritingVersion_$eq(this.numKeysOnWritingVersion() + 1L);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] remove(byte[] key) {
        void var2_2;
        block0: {
            byte[] value = this.writeBatch().getFromBatchAndDB(this.db(), this.readOptions(), key);
            if (value == null) break block0;
            this.writeBatch().remove(key);
            this.numKeysOnWritingVersion_$eq(this.numKeysOnWritingVersion() - 1L);
        }
        return var2_2;
    }

    public Iterator<ByteArrayPair> iterator() {
        RocksIterator iter = this.writeBatch().newIteratorWithBase(this.db().newIterator());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Getting iterator from version ").append(this.loadedVersion()).toString());
        iter.seekToFirst();
        Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).foreach((Function1 & Serializable & scala.Serializable)tc -> tc.addTaskCompletionListener((Function1 & Serializable & scala.Serializable)x$1 -> {
            iter.close();
            return BoxedUnit.UNIT;
        }));
        return new NextIterator<ByteArrayPair>(this, iter){
            private final /* synthetic */ RocksDB $outer;
            private final RocksIterator iter$1;

            public ByteArrayPair getNext() {
                ByteArrayPair byteArrayPair;
                if (this.iter$1.isValid()) {
                    this.$outer.org$apache$spark$sql$execution$streaming$state$RocksDB$$byteArrayPair().set(this.iter$1.key(), this.iter$1.value());
                    this.iter$1.next();
                    byteArrayPair = this.$outer.org$apache$spark$sql$execution$streaming$state$RocksDB$$byteArrayPair();
                } else {
                    this.finished_$eq(true);
                    this.iter$1.close();
                    byteArrayPair = null;
                }
                return byteArrayPair;
            }

            public void close() {
                this.iter$1.close();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.iter$1 = iter$1;
            }
        };
    }

    public Iterator<ByteArrayPair> prefixScan(byte[] prefix) {
        long threadId = Thread.currentThread().getId();
        RocksIterator iter = this.prefixScanReuseIter().computeIfAbsent(BoxesRunTime.boxToLong((long)threadId), tid -> RocksDB.$anonfun$prefixScan$1(this, BoxesRunTime.unboxToLong((Object)tid)));
        iter.seek(prefix);
        return new NextIterator<ByteArrayPair>(this, iter, prefix){
            private final /* synthetic */ RocksDB $outer;
            private final RocksIterator iter$2;
            private final byte[] prefix$1;

            public ByteArrayPair getNext() {
                ByteArrayPair byteArrayPair;
                if (this.iter$2.isValid() && new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(this.iter$2.key())).take(this.prefix$1.length))).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(this.prefix$1))) {
                    this.$outer.org$apache$spark$sql$execution$streaming$state$RocksDB$$byteArrayPair().set(this.iter$2.key(), this.iter$2.value());
                    this.iter$2.next();
                    byteArrayPair = this.$outer.org$apache$spark$sql$execution$streaming$state$RocksDB$$byteArrayPair();
                } else {
                    this.finished_$eq(true);
                    byteArrayPair = null;
                }
                return byteArrayPair;
            }

            public void close() {
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.iter$2 = iter$2;
                this.prefix$1 = prefix$1;
            }
        };
    }

    public long commit() {
        long l;
        long newVersion = this.loadedVersion() + 1L;
        File checkpointDir = this.createTempDir("checkpoint");
        try {
            try {
                long l2;
                Utils$.MODULE$.deleteRecursively(checkpointDir);
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Writing updates for ").append(newVersion).toString());
                long writeTimeMs = this.timeTakenMs((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.db().write(this.writeOptions(), this.writeBatch()));
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Flushing updates for ").append(newVersion).toString());
                long flushTimeMs = this.timeTakenMs((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.db().flush(this.flushOptions()));
                if (this.conf().compactOnCommit()) {
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Compacting");
                    l2 = this.timeTakenMs((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.db().compactRange());
                } else {
                    l2 = 0L;
                }
                long compactTimeMs = l2;
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Pausing background work");
                long pauseTimeMs = this.timeTakenMs((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.db().pauseBackgroundWork());
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Creating checkpoint for ").append(newVersion).append(" in ").append(checkpointDir).toString());
                long checkpointTimeMs = this.timeTakenMs((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    Checkpoint cp = Checkpoint.create((org.rocksdb.RocksDB)this.db());
                    cp.createCheckpoint(checkpointDir.toString());
                });
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Syncing checkpoint for ").append(newVersion).append(" to DFS").toString());
                long fileSyncTimeMs = this.timeTakenMs((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.fileManager().saveCheckpointToDfs(checkpointDir, newVersion, this.numKeysOnWritingVersion()));
                this.numKeysOnLoadedVersion_$eq(this.numKeysOnWritingVersion());
                this.loadedVersion_$eq(newVersion);
                this.fileManagerMetrics_$eq(this.fileManager().latestSaveCheckpointMetrics());
                this.commitLatencyMs().$plus$plus$eq((TraversableOnce)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"writeBatch"), (Object)BoxesRunTime.boxToLong((long)writeTimeMs)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"flush"), (Object)BoxesRunTime.boxToLong((long)flushTimeMs)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"compact"), (Object)BoxesRunTime.boxToLong((long)compactTimeMs)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pause"), (Object)BoxesRunTime.boxToLong((long)pauseTimeMs)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"checkpoint"), (Object)BoxesRunTime.boxToLong((long)checkpointTimeMs)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fileSync"), (Object)BoxesRunTime.boxToLong((long)fileSyncTimeMs))})));
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Committed ").append(newVersion).append(", stats = ").append(this.metrics().json()).toString());
                l = this.loadedVersion();
            }
            catch (Throwable t) {
                this.loadedVersion_$eq(-1L);
                throw t;
            }
        }
        finally {
            this.db().continueBackgroundWork();
            this.silentDeleteRecursively(checkpointDir, new StringBuilder(11).append("committing ").append(newVersion).toString());
            this.release();
        }
        return l;
    }

    public void rollback() {
        this.closePrefixScanIterators();
        this.writeBatch().clear();
        this.numKeysOnWritingVersion_$eq(this.numKeysOnLoadedVersion());
        this.release();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("Rolled back to ").append(this.loadedVersion()).toString());
    }

    public void cleanup() {
        long cleanupTime = this.timeTakenMs((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.fileManager().deleteOldVersions(this.conf().minVersionsToRetain()));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Cleaned old data, time taken: ").append(cleanupTime).append(" ms").toString());
    }

    public void close() {
        this.closePrefixScanIterators();
        try {
            this.closeDB();
            this.writeBatch().clear();
            this.writeBatch().close();
            this.readOptions().close();
            this.writeOptions().close();
            this.flushOptions().close();
            this.org$apache$spark$sql$execution$streaming$state$RocksDB$$dbOptions().close();
            this.dbLogger().close();
            this.silentDeleteRecursively(this.localRootDir, "closing RocksDB");
        }
        catch (Exception e) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error closing RocksDB", e);
        }
    }

    public long getLatestVersion() {
        return this.fileManager().getLatestVersion();
    }

    public RocksDBMetrics metrics() {
        long totalSSTFilesBytes = this.getDBProperty("rocksdb.total-sst-files-size");
        long readerMemUsage = this.getDBProperty("rocksdb.estimate-table-readers-mem");
        long memTableMemUsage = this.getDBProperty("rocksdb.size-all-mem-tables");
        long blockCacheUsage = this.getDBProperty("rocksdb.block-cache-usage");
        scala.collection.immutable.Map nativeOpsHistograms = ((TraversableOnce)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"get"), (Object)HistogramType.DB_GET), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"put"), (Object)HistogramType.DB_WRITE), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"compaction"), (Object)HistogramType.COMPACTION_TIME), (List)Nil$.MODULE$)))).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map nativeOpsLatencyMicros = nativeOpsHistograms.mapValues((Function1 & Serializable & scala.Serializable)typ -> RocksDBNativeHistogram$.MODULE$.apply(this.nativeStats().getHistogramData(typ)));
        scala.collection.immutable.Map nativeOpsMetricTickers = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"readBlockCacheMissCount"), (Object)TickerType.BLOCK_CACHE_MISS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"readBlockCacheHitCount"), (Object)TickerType.BLOCK_CACHE_HIT), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"totalBytesRead"), (Object)TickerType.BYTES_READ), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"totalBytesWritten"), (Object)TickerType.BYTES_WRITTEN), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"totalBytesReadThroughIterator"), (Object)TickerType.ITER_BYTES_READ), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"writerStallDuration"), (Object)TickerType.STALL_MICROS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"totalBytesReadByCompaction"), (Object)TickerType.COMPACT_READ_BYTES), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"totalBytesWrittenByCompaction"), (Object)TickerType.COMPACT_WRITE_BYTES)}))).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map nativeOpsMetrics = nativeOpsMetricTickers.mapValues((Function1 & Serializable & scala.Serializable)typ -> BoxesRunTime.boxToLong((long)RocksDB.$anonfun$metrics$2(this, typ)));
        long x$1 = this.numKeysOnLoadedVersion();
        long x$2 = this.numKeysOnWritingVersion();
        long x$3 = readerMemUsage + memTableMemUsage + blockCacheUsage;
        long x$4 = totalSSTFilesBytes;
        scala.collection.immutable.Map x$5 = nativeOpsLatencyMicros.toMap(Predef$.MODULE$.$conforms());
        HashMap<String, Object> x$6 = this.commitLatencyMs();
        long x$7 = this.fileManagerMetrics().bytesCopied();
        long x$8 = this.fileManagerMetrics().filesCopied();
        long x$9 = this.fileManagerMetrics().filesReused();
        Option<Object> x$10 = this.fileManagerMetrics().zipFileBytesUncompressed();
        scala.collection.immutable.Map x$11 = nativeOpsMetrics.toMap(Predef$.MODULE$.$conforms());
        return new RocksDBMetrics(x$1, x$2, x$3, x$4, (Map<String, RocksDBNativeHistogram>)x$5, (Map<String, Object>)x$6, x$8, x$7, x$9, x$10, (Map<String, Object>)x$11);
    }

    private void acquire() {
        Object object = this.acquireLock();
        synchronized (object) {
            AcquiredThreadInfo newAcquiredThreadInfo = new AcquiredThreadInfo();
            long waitStartTime = System.currentTimeMillis();
            while (this.isAcquiredByDifferentThread$1(newAcquiredThreadInfo) && RocksDB.timeWaitedMs$1(waitStartTime) < this.conf().lockAcquireTimeoutMs()) {
                this.acquireLock().wait(10L);
            }
            if (this.isAcquiredByDifferentThread$1(newAcquiredThreadInfo)) {
                String stackTraceOutput = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((Thread)this.acquiredThreadInfo().threadRef().get().get()).getStackTrace())).mkString("\n");
                String msg = new StringBuilder(116).append("RocksDB instance could not be acquired by ").append(newAcquiredThreadInfo).append(" as it ").append("was not released by ").append(this.acquiredThreadInfo()).append(" after ").append(RocksDB.timeWaitedMs$1(waitStartTime)).append(" ms.\n").append("Thread holding the lock has trace: ").append(stackTraceOutput).toString();
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> msg);
                throw new IllegalStateException(new StringBuilder(2).append(this.loggingId).append(": ").append(msg).toString());
            }
            this.acquiredThreadInfo_$eq(newAcquiredThreadInfo);
            Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).foreach((Function1 & Serializable & scala.Serializable)x$2 -> x$2.addTaskCompletionListener((Function1 & Serializable & scala.Serializable)x$3 -> {
                this.release();
                return BoxedUnit.UNIT;
            }));
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("RocksDB instance was acquired by ").append(this.acquiredThreadInfo()).toString());
        }
    }

    private void release() {
        Object object = this.acquireLock();
        synchronized (object) {
            this.acquiredThreadInfo_$eq(null);
            this.acquireLock().notifyAll();
        }
    }

    private void closePrefixScanIterators() {
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(this.prefixScanReuseIter().entrySet()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            RocksDB.$anonfun$closePrefixScanIterators$1(x$4);
            return BoxedUnit.UNIT;
        });
        this.prefixScanReuseIter().clear();
    }

    private long getDBProperty(String property) {
        return new StringOps(Predef$.MODULE$.augmentString(this.db().getProperty(property))).toLong();
    }

    private void openDB() {
        Predef$.MODULE$.assert(this.db() == null);
        this.db_$eq(org.rocksdb.RocksDB.open((Options)this.org$apache$spark$sql$execution$streaming$state$RocksDB$$dbOptions(), (String)this.workingDir().toString()));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Opened DB with conf ").append(this.conf()).toString());
    }

    private void closeDB() {
        block0: {
            if (this.db() == null) break block0;
            this.db().close();
            this.db_$eq(null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private org.rocksdb.Logger createLogger() {
        void var1_1;
        org.rocksdb.Logger dbLogger = new org.rocksdb.Logger(this){
            private final /* synthetic */ RocksDB $outer;

            public void log(InfoLogLevel infoLogLevel, String logMsg) {
                Function1 & Serializable & scala.Serializable intersect;
                InfoLogLevel infoLogLevel2 = infoLogLevel;
                boolean bl = InfoLogLevel.FATAL_LEVEL.equals(infoLogLevel2) ? true : InfoLogLevel.ERROR_LEVEL.equals(infoLogLevel2);
                if (bl) {
                    intersect = (Function1 & Serializable & scala.Serializable)x$5 -> {
                        $anon$3.$anonfun$log$1(this, x$5);
                        return BoxedUnit.UNIT;
                    };
                } else {
                    boolean bl2 = InfoLogLevel.WARN_LEVEL.equals(infoLogLevel2) ? true : InfoLogLevel.INFO_LEVEL.equals(infoLogLevel2);
                    intersect = bl2 ? (Function1 & Serializable & scala.Serializable)x$6 -> {
                        $anon$3.$anonfun$log$2(this, x$6);
                        return BoxedUnit.UNIT;
                    } : (InfoLogLevel.DEBUG_LEVEL.equals(infoLogLevel2) ? (Function1 & Serializable & scala.Serializable)x$7 -> {
                        $anon$3.$anonfun$log$3(this, x$7);
                        return BoxedUnit.UNIT;
                    } : (Function1 & Serializable & scala.Serializable)x$8 -> {
                        $anon$3.$anonfun$log$4(this, x$8);
                        return BoxedUnit.UNIT;
                    });
                }
                Function1 & Serializable & scala.Serializable loggingFunc = intersect;
                loggingFunc.apply((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("[NativeRocksDB-").append(infoLogLevel.getValue()).append("] ").append(logMsg).toString());
            }

            public static final /* synthetic */ void $anonfun$log$1($anon$3 $this, Function0 x$5) {
                $this.$outer.logError((Function0<String>)x$5);
            }

            public static final /* synthetic */ void $anonfun$log$2($anon$3 $this, Function0 x$6) {
                $this.$outer.logInfo((Function0<String>)x$6);
            }

            public static final /* synthetic */ void $anonfun$log$3($anon$3 $this, Function0 x$7) {
                $this.$outer.logDebug((Function0<String>)x$7);
            }

            public static final /* synthetic */ void $anonfun$log$4($anon$3 $this, Function0 x$8) {
                $this.$outer.logTrace((Function0<String>)x$8);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super($outer.org$apache$spark$sql$execution$streaming$state$RocksDB$$dbOptions());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$log$1$adapted(org.apache.spark.sql.execution.streaming.state.RocksDB$$anon$3 scala.Function0 ), $anonfun$log$2$adapted(org.apache.spark.sql.execution.streaming.state.RocksDB$$anon$3 scala.Function0 ), $anonfun$log$3$adapted(org.apache.spark.sql.execution.streaming.state.RocksDB$$anon$3 scala.Function0 ), $anonfun$log$4$adapted(org.apache.spark.sql.execution.streaming.state.RocksDB$$anon$3 scala.Function0 ), $anonfun$log$5(org.rocksdb.InfoLogLevel java.lang.String )}, serializedLambda);
            }
        };
        ObjectRef dbLogLevel = ObjectRef.create((Object)InfoLogLevel.ERROR_LEVEL);
        if (this.log().isWarnEnabled()) {
            dbLogLevel.elem = InfoLogLevel.WARN_LEVEL;
        }
        if (this.log().isInfoEnabled()) {
            dbLogLevel.elem = InfoLogLevel.INFO_LEVEL;
        }
        if (this.log().isDebugEnabled()) {
            dbLogLevel.elem = InfoLogLevel.DEBUG_LEVEL;
        }
        this.org$apache$spark$sql$execution$streaming$state$RocksDB$$dbOptions().setLogger(dbLogger);
        this.org$apache$spark$sql$execution$streaming$state$RocksDB$$dbOptions().setInfoLogLevel((InfoLogLevel)dbLogLevel.elem);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Set RocksDB native logging level to ").append((InfoLogLevel)dbLogLevel$1.elem).toString());
        return var1_1;
    }

    private File createTempDir(String prefix) {
        return Utils$.MODULE$.createDirectory(this.localRootDir.getAbsolutePath(), prefix);
    }

    private void silentDeleteRecursively(File file, String msg) {
        try {
            Utils$.MODULE$.deleteRecursively(file);
        }
        catch (Exception e) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Error recursively deleting local dir ").append(file).append(" while ").append(msg).toString(), e);
        }
    }

    public long timeTakenMs(Function0<BoxedUnit> body) {
        return Utils$.MODULE$.timeTakenMs(body)._2$mcJ$sp();
    }

    public String logName() {
        return new StringBuilder(1).append(Logging.logName$((Logging)this)).append(" ").append(this.loggingId).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ RocksIterator $anonfun$prefixScan$1(RocksDB $this, long tid) {
        void var3_2;
        RocksIterator it = $this.writeBatch().newIteratorWithBase($this.db().newIterator());
        $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("Getting iterator from version ").append($this.loadedVersion()).append(" for prefix scan on ").append("thread ID ").append(tid).toString());
        return var3_2;
    }

    public static final /* synthetic */ long $anonfun$metrics$2(RocksDB $this, TickerType typ) {
        return $this.nativeStats().getTickerCount(typ);
    }

    private static final long timeWaitedMs$1(long waitStartTime$1) {
        return System.currentTimeMillis() - waitStartTime$1;
    }

    private final boolean isAcquiredByDifferentThread$1(AcquiredThreadInfo newAcquiredThreadInfo$1) {
        return this.acquiredThreadInfo() != null && this.acquiredThreadInfo().threadRef().get().isDefined() && ((Thread)newAcquiredThreadInfo$1.threadRef().get().get()).getId() != ((Thread)this.acquiredThreadInfo().threadRef().get().get()).getId();
    }

    public static final /* synthetic */ void $anonfun$closePrefixScanIterators$1(Map.Entry x$4) {
        ((AbstractImmutableNativeReference)x$4.getValue()).close();
    }

    public RocksDB(String dfsRootDir, RocksDBConf conf, File localRootDir, Configuration hadoopConf, String loggingId) {
        this.conf = conf;
        this.localRootDir = localRootDir;
        this.loggingId = loggingId;
        Logging.$init$((Logging)this);
        RocksDBLoader$.MODULE$.loadLibrary();
        this.readOptions = new ReadOptions();
        this.writeOptions = new WriteOptions().setSync(true);
        this.flushOptions = new FlushOptions().setWaitForFlush(true);
        this.writeBatch = new WriteBatchWithIndex(true);
        this.bloomFilter = new BloomFilter();
        this.tableFormatConfig = new BlockBasedTableConfig();
        this.tableFormatConfig().setBlockSize(conf.blockSizeKB() * 1024L);
        this.tableFormatConfig().setBlockCache((Cache)new LRUCache(conf.blockCacheSizeMB() * 1024L * 1024L));
        this.tableFormatConfig().setFilterPolicy((Filter)this.bloomFilter());
        this.tableFormatConfig().setFormatVersion(conf.formatVersion());
        this.org$apache$spark$sql$execution$streaming$state$RocksDB$$dbOptions = new Options();
        this.org$apache$spark$sql$execution$streaming$state$RocksDB$$dbOptions().setCreateIfMissing(true);
        this.org$apache$spark$sql$execution$streaming$state$RocksDB$$dbOptions().setTableFormatConfig((TableFormatConfig)this.tableFormatConfig());
        this.dbLogger = this.createLogger();
        this.org$apache$spark$sql$execution$streaming$state$RocksDB$$dbOptions().setStatistics(new Statistics());
        this.nativeStats = this.org$apache$spark$sql$execution$streaming$state$RocksDB$$dbOptions().statistics();
        this.workingDir = this.createTempDir("workingDir");
        this.fileManager = new RocksDBFileManager(dfsRootDir, this.createTempDir("fileManager"), hadoopConf, loggingId);
        this.org$apache$spark$sql$execution$streaming$state$RocksDB$$byteArrayPair = new ByteArrayPair(ByteArrayPair$.MODULE$.$lessinit$greater$default$1(), ByteArrayPair$.MODULE$.$lessinit$greater$default$2());
        this.commitLatencyMs = new HashMap();
        this.acquireLock = new Object();
        this.loadedVersion = -1L;
        this.numKeysOnLoadedVersion = 0L;
        this.numKeysOnWritingVersion = 0L;
        this.fileManagerMetrics = RocksDBFileManagerMetrics$.MODULE$.EMPTY_METRICS();
        this.prefixScanReuseIter = new ConcurrentHashMap();
    }
}

