/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.sources;

import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;

public final class RateStreamProvider$ {
    public static RateStreamProvider$ MODULE$;
    private final StructType SCHEMA;
    private final int VERSION;
    private final String NUM_PARTITIONS;
    private final String ROWS_PER_SECOND;
    private final String RAMP_UP_TIME;

    static {
        new RateStreamProvider$();
    }

    public StructType SCHEMA() {
        return this.SCHEMA;
    }

    public int VERSION() {
        return this.VERSION;
    }

    public String NUM_PARTITIONS() {
        return this.NUM_PARTITIONS;
    }

    public String ROWS_PER_SECOND() {
        return this.ROWS_PER_SECOND;
    }

    public String RAMP_UP_TIME() {
        return this.RAMP_UP_TIME;
    }

    public long valueAtSecond(long seconds, long rowsPerSecond, long rampUpTimeSeconds) {
        long l;
        long speedDeltaPerSecond = rowsPerSecond / (rampUpTimeSeconds + 1L);
        if (seconds <= rampUpTimeSeconds) {
            l = seconds % 2L == 1L ? (seconds + 1L) / 2L * speedDeltaPerSecond * seconds : seconds / 2L * speedDeltaPerSecond * (seconds + 1L);
        } else {
            long rampUpPart = this.valueAtSecond(rampUpTimeSeconds, rowsPerSecond, rampUpTimeSeconds);
            l = rampUpPart + (seconds - rampUpTimeSeconds) * rowsPerSecond;
        }
        return l;
    }

    private RateStreamProvider$() {
        MODULE$ = this;
        StructField structField = new StructField("timestamp", (DataType)TimestampType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructField structField2 = new StructField("value", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        this.SCHEMA = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField2).$colon$colon((Object)structField));
        this.VERSION = 1;
        this.NUM_PARTITIONS = "numPartitions";
        this.ROWS_PER_SECOND = "rowsPerSecond";
        this.RAMP_UP_TIME = "rampUpTime";
    }
}

