/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.exchange;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.expressions.SortOrder$;
import org.apache.spark.sql.catalyst.optimizer.BuildSide;
import org.apache.spark.sql.catalyst.plans.JoinType;
import org.apache.spark.sql.catalyst.plans.physical.BroadcastDistribution;
import org.apache.spark.sql.catalyst.plans.physical.BroadcastMode;
import org.apache.spark.sql.catalyst.plans.physical.Distribution;
import org.apache.spark.sql.catalyst.plans.physical.HashPartitioning;
import org.apache.spark.sql.catalyst.plans.physical.Partitioning;
import org.apache.spark.sql.catalyst.plans.physical.PartitioningCollection;
import org.apache.spark.sql.catalyst.plans.physical.UnspecifiedDistribution$;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.execution.SortExec;
import org.apache.spark.sql.execution.SortExec$;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.exchange.BroadcastExchangeExec;
import org.apache.spark.sql.execution.exchange.ShuffleExchangeExec;
import org.apache.spark.sql.execution.exchange.ShuffleExchangeExec$;
import org.apache.spark.sql.execution.joins.ShuffledHashJoinExec;
import org.apache.spark.sql.execution.joins.SortMergeJoinExec;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.BitSet;
import scala.collection.mutable.BitSet$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class EnsureRequirements$
extends Rule<SparkPlan> {
    public static EnsureRequirements$ MODULE$;

    static {
        new EnsureRequirements$();
    }

    public SparkPlan org$apache$spark$sql$execution$exchange$EnsureRequirements$$ensureDistributionAndOrdering(SparkPlan operator) {
        Seq<Distribution> requiredChildDistributions = operator.requiredChildDistribution();
        Seq<Seq<SortOrder>> requiredChildOrderings = operator.requiredChildOrdering();
        ObjectRef children = ObjectRef.create((Object)operator.children());
        Predef$.MODULE$.assert(requiredChildDistributions.length() == ((Seq)children.elem).length());
        Predef$.MODULE$.assert(requiredChildOrderings.length() == ((Seq)children.elem).length());
        children.elem = (Seq)((TraversableLike)((Seq)children.elem).zip(requiredChildDistributions, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                SparkPlan child = (SparkPlan)((Object)((Object)tuple2._1()));
                Distribution distribution = (Distribution)tuple2._2();
                if (child.outputPartitioning().satisfies(distribution)) {
                    return child;
                }
            }
            if (tuple2 != null) {
                SparkPlan child = (SparkPlan)((Object)((Object)tuple2._1()));
                Distribution distribution = (Distribution)tuple2._2();
                if (distribution instanceof BroadcastDistribution) {
                    BroadcastDistribution broadcastDistribution = (BroadcastDistribution)distribution;
                    BroadcastMode mode = broadcastDistribution.mode();
                    return new BroadcastExchangeExec(mode, child);
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            SparkPlan child = (SparkPlan)((Object)((Object)tuple2._1()));
            Distribution distribution = (Distribution)tuple2._2();
            int numPartitions = BoxesRunTime.unboxToInt((Object)distribution.requiredNumPartitions().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> MODULE$.conf().numShufflePartitions()));
            return new ShuffleExchangeExec(distribution.createPartitioning(numPartitions), child, ShuffleExchangeExec$.MODULE$.apply$default$3());
        }, Seq$.MODULE$.canBuildFrom());
        Seq childrenIndexes = (Seq)((TraversableLike)((TraversableLike)requiredChildDistributions.zipWithIndex(Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)EnsureRequirements$.$anonfun$ensureDistributionAndOrdering$3(x0$2)))).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1._2$mcI$sp()), Seq$.MODULE$.canBuildFrom());
        Set childrenNumPartitions = ((TraversableOnce)childrenIndexes.map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)x$2 -> ((SparkPlan)((Object)((Object)((Seq)children$1.elem).apply(x$2)))).outputPartitioning().numPartitions(), Seq$.MODULE$.canBuildFrom())).toSet();
        if (childrenNumPartitions.size() > 1) {
            Set numPartitionsSet = ((TraversableOnce)childrenIndexes.flatMap((Function1 & Serializable & scala.Serializable)index -> Option$.MODULE$.option2Iterable(((Distribution)requiredChildDistributions.apply(BoxesRunTime.unboxToInt((Object)index))).requiredNumPartitions()), Seq$.MODULE$.canBuildFrom())).toSet();
            Predef$.MODULE$.assert(numPartitionsSet.size() <= 1, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(76).append((Object)operator).append(" have incompatible requirements of the number of partitions for its children").toString());
            Option requiredNumPartitions = numPartitionsSet.headOption();
            Seq nonShuffleChildrenNumPartitions = (Seq)((TraversableLike)((TraversableLike)childrenIndexes.map((Function1)((Seq)children.elem), Seq$.MODULE$.canBuildFrom())).filterNot((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)EnsureRequirements$.$anonfun$ensureDistributionAndOrdering$8(x$3)))).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)EnsureRequirements$.$anonfun$ensureDistributionAndOrdering$9(x$4)), Seq$.MODULE$.canBuildFrom());
            int expectedChildrenNumPartitions = nonShuffleChildrenNumPartitions.nonEmpty() ? (nonShuffleChildrenNumPartitions.length() == childrenIndexes.length() ? BoxesRunTime.unboxToInt((Object)nonShuffleChildrenNumPartitions.max((Ordering)Ordering.Int$.MODULE$)) : package$.MODULE$.max(BoxesRunTime.unboxToInt((Object)nonShuffleChildrenNumPartitions.max((Ordering)Ordering.Int$.MODULE$)), this.conf().defaultNumShufflePartitions())) : BoxesRunTime.unboxToInt((Object)childrenNumPartitions.max((Ordering)Ordering.Int$.MODULE$));
            int targetNumPartitions = BoxesRunTime.unboxToInt((Object)requiredNumPartitions.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> expectedChildrenNumPartitions));
            children.elem = (Seq)((TraversableLike)((IterableLike)((Seq)children.elem).zip(requiredChildDistributions, Seq$.MODULE$.canBuildFrom())).zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    int index = tuple2._2$mcI$sp();
                    if (tuple22 != null) {
                        SparkPlan child = (SparkPlan)((Object)((Object)tuple22._1()));
                        Distribution distribution = (Distribution)tuple22._2();
                        if (childrenIndexes.contains((Object)BoxesRunTime.boxToInteger((int)index))) {
                            SparkPlan sparkPlan;
                            if (child.outputPartitioning().numPartitions() == targetNumPartitions) {
                                sparkPlan = child;
                                return sparkPlan;
                            } else {
                                ShuffleExchangeExec shuffleExchangeExec;
                                Partitioning defaultPartitioning = distribution.createPartitioning(targetNumPartitions);
                                SparkPlan sparkPlan2 = child;
                                if (sparkPlan2 instanceof ShuffleExchangeExec) {
                                    ShuffleExchangeExec shuffleExchangeExec2 = (ShuffleExchangeExec)sparkPlan2;
                                    SparkPlan c = shuffleExchangeExec2.child();
                                    shuffleExchangeExec = new ShuffleExchangeExec(defaultPartitioning, c, ShuffleExchangeExec$.MODULE$.apply$default$3());
                                } else {
                                    shuffleExchangeExec = new ShuffleExchangeExec(defaultPartitioning, child, ShuffleExchangeExec$.MODULE$.apply$default$3());
                                }
                                sparkPlan = shuffleExchangeExec;
                            }
                            return sparkPlan;
                        }
                    }
                }
                if (tuple2 == null) throw new MatchError((Object)tuple2);
                Tuple2 tuple23 = (Tuple2)tuple2._1();
                if (tuple23 == null) throw new MatchError((Object)tuple2);
                SparkPlan child = (SparkPlan)((Object)((Object)tuple23._1()));
                return child;
            }, Seq$.MODULE$.canBuildFrom());
        }
        children.elem = (Seq)((TraversableLike)((Seq)children.elem).zip(requiredChildOrderings, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$4 -> {
            Tuple2 tuple2 = x0$4;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            SparkPlan child = (SparkPlan)((Object)((Object)tuple2._1()));
            Seq requiredOrdering = (Seq)tuple2._2();
            SparkPlan sparkPlan = SortOrder$.MODULE$.orderingSatisfies(child.outputOrdering(), requiredOrdering) ? child : new SortExec((Seq<SortOrder>)requiredOrdering, false, child, SortExec$.MODULE$.apply$default$4());
            return sparkPlan;
        }, Seq$.MODULE$.canBuildFrom());
        return (SparkPlan)operator.withNewChildren((Seq)children.elem);
    }

    private Option<Tuple2<Seq<Expression>, Seq<Expression>>> reorder(IndexedSeq<Expression> leftKeys, IndexedSeq<Expression> rightKeys, Seq<Expression> expectedOrderOfKeys, Seq<Expression> currentOrderOfKeys) {
        if (expectedOrderOfKeys.size() != currentOrderOfKeys.size()) {
            return None$.MODULE$;
        }
        if (((IterableLike)expectedOrderOfKeys.zip(currentOrderOfKeys, Seq$.MODULE$.canBuildFrom())).forall((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)EnsureRequirements$.$anonfun$reorder$1(p)))) {
            return new Some((Object)new Tuple2(leftKeys, rightKeys));
        }
        Map keyToIndexMap = Map$.MODULE$.empty();
        ((IterableLike)currentOrderOfKeys.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)EnsureRequirements$.$anonfun$reorder$2(keyToIndexMap, x0$1)));
        ArrayBuffer leftKeysBuffer = new ArrayBuffer(leftKeys.size());
        ArrayBuffer rightKeysBuffer = new ArrayBuffer(rightKeys.size());
        Iterator iterator = expectedOrderOfKeys.iterator();
        while (iterator.hasNext()) {
            Some some;
            BitSet indices;
            Option option = keyToIndexMap.get((Object)((Expression)iterator.next()).canonicalized());
            if (!(option instanceof Some) || !(indices = (BitSet)(some = (Some)option).value()).nonEmpty()) {
                return None$.MODULE$;
            }
            int index = BoxesRunTime.unboxToInt((Object)indices.firstKey());
            indices.remove(index);
            leftKeysBuffer.$plus$eq(leftKeys.apply(index));
            ArrayBuffer arrayBuffer = rightKeysBuffer.$plus$eq(rightKeys.apply(index));
        }
        return new Some((Object)new Tuple2((Object)leftKeysBuffer.toSeq(), (Object)rightKeysBuffer.toSeq()));
    }

    private Tuple2<Seq<Expression>, Seq<Expression>> reorderJoinKeys(Seq<Expression> leftKeys, Seq<Expression> rightKeys, Partitioning leftPartitioning, Partitioning rightPartitioning) {
        return leftKeys.forall((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.deterministic())) && rightKeys.forall((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.deterministic())) ? (Tuple2)this.reorderJoinKeysRecursively(leftKeys, rightKeys, (Option<Partitioning>)new Some((Object)leftPartitioning), (Option<Partitioning>)new Some((Object)rightPartitioning)).getOrElse((Function0 & Serializable & scala.Serializable)() -> new Tuple2((Object)leftKeys, (Object)rightKeys)) : new Tuple2(leftKeys, rightKeys);
    }

    private Option<Tuple2<Seq<Expression>, Seq<Expression>>> reorderJoinKeysRecursively(Seq<Expression> leftKeys, Seq<Expression> rightKeys, Option<Partitioning> leftPartitioning, Option<Partitioning> rightPartitioning) {
        Some some;
        Partitioning partitioning;
        Option option;
        Some some2;
        Partitioning partitioning2;
        Option option2;
        Some some3;
        Partitioning partitioning3;
        Option option3;
        None$ none$;
        Some some4;
        Partitioning partitioning4;
        Option option4;
        Tuple2 tuple2 = new Tuple2(leftPartitioning, rightPartitioning);
        if (tuple2 != null && (option4 = (Option)tuple2._1()) instanceof Some && (partitioning4 = (Partitioning)(some4 = (Some)option4).value()) instanceof HashPartitioning) {
            HashPartitioning hashPartitioning = (HashPartitioning)partitioning4;
            Seq leftExpressions = hashPartitioning.expressions();
            none$ = this.reorder((IndexedSeq<Expression>)leftKeys.toIndexedSeq(), (IndexedSeq<Expression>)rightKeys.toIndexedSeq(), (Seq<Expression>)leftExpressions, leftKeys).orElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.reorderJoinKeysRecursively(leftKeys, rightKeys, (Option<Partitioning>)None$.MODULE$, rightPartitioning));
        } else if (tuple2 != null && (option3 = (Option)tuple2._2()) instanceof Some && (partitioning3 = (Partitioning)(some3 = (Some)option3).value()) instanceof HashPartitioning) {
            HashPartitioning hashPartitioning = (HashPartitioning)partitioning3;
            Seq rightExpressions = hashPartitioning.expressions();
            none$ = this.reorder((IndexedSeq<Expression>)leftKeys.toIndexedSeq(), (IndexedSeq<Expression>)rightKeys.toIndexedSeq(), (Seq<Expression>)rightExpressions, rightKeys).orElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.reorderJoinKeysRecursively(leftKeys, rightKeys, leftPartitioning, (Option<Partitioning>)None$.MODULE$));
        } else if (tuple2 != null && (option2 = (Option)tuple2._1()) instanceof Some && (partitioning2 = (Partitioning)(some2 = (Some)option2).value()) instanceof PartitioningCollection) {
            PartitioningCollection partitioningCollection = (PartitioningCollection)partitioning2;
            Seq partitionings = partitioningCollection.partitionings();
            none$ = ((Option)partitionings.foldLeft((Object)Option$.MODULE$.empty(), (Function2 & Serializable & scala.Serializable)(res, p) -> res.orElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.reorderJoinKeysRecursively(leftKeys, rightKeys, (Option<Partitioning>)new Some(p), rightPartitioning)))).orElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.reorderJoinKeysRecursively(leftKeys, rightKeys, (Option<Partitioning>)None$.MODULE$, rightPartitioning));
        } else if (tuple2 != null && (option = (Option)tuple2._2()) instanceof Some && (partitioning = (Partitioning)(some = (Some)option).value()) instanceof PartitioningCollection) {
            PartitioningCollection partitioningCollection = (PartitioningCollection)partitioning;
            Seq partitionings = partitioningCollection.partitionings();
            none$ = ((Option)partitionings.foldLeft((Object)Option$.MODULE$.empty(), (Function2 & Serializable & scala.Serializable)(res, p) -> res.orElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.reorderJoinKeysRecursively(leftKeys, rightKeys, leftPartitioning, (Option<Partitioning>)new Some(p))))).orElse((Function0 & Serializable & scala.Serializable)() -> None$.MODULE$);
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public SparkPlan org$apache$spark$sql$execution$exchange$EnsureRequirements$$reorderJoinPredicates(SparkPlan plan) {
        SparkPlan sparkPlan;
        SparkPlan sparkPlan2 = plan;
        if (sparkPlan2 instanceof ShuffledHashJoinExec) {
            ShuffledHashJoinExec shuffledHashJoinExec = (ShuffledHashJoinExec)sparkPlan2;
            Seq<Expression> leftKeys = shuffledHashJoinExec.leftKeys();
            Seq<Expression> rightKeys = shuffledHashJoinExec.rightKeys();
            JoinType joinType = shuffledHashJoinExec.joinType();
            BuildSide buildSide = shuffledHashJoinExec.buildSide();
            Option<Expression> condition = shuffledHashJoinExec.condition();
            SparkPlan left = shuffledHashJoinExec.left();
            SparkPlan right = shuffledHashJoinExec.right();
            Tuple2<Seq<Expression>, Seq<Expression>> tuple2 = this.reorderJoinKeys(leftKeys, rightKeys, left.outputPartitioning(), right.outputPartitioning());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Seq reorderedLeftKeys = (Seq)tuple2._1();
            Seq reorderedRightKeys = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)reorderedLeftKeys, (Object)reorderedRightKeys);
            Tuple2 tuple23 = tuple22;
            Seq reorderedLeftKeys2 = (Seq)tuple23._1();
            Seq reorderedRightKeys2 = (Seq)tuple23._2();
            sparkPlan = new ShuffledHashJoinExec((Seq<Expression>)reorderedLeftKeys2, (Seq<Expression>)reorderedRightKeys2, joinType, buildSide, condition, left, right);
        } else if (sparkPlan2 instanceof SortMergeJoinExec) {
            SortMergeJoinExec sortMergeJoinExec = (SortMergeJoinExec)sparkPlan2;
            Seq<Expression> leftKeys = sortMergeJoinExec.leftKeys();
            Seq<Expression> rightKeys = sortMergeJoinExec.rightKeys();
            JoinType joinType = sortMergeJoinExec.joinType();
            Option<Expression> condition = sortMergeJoinExec.condition();
            SparkPlan left = sortMergeJoinExec.left();
            SparkPlan right = sortMergeJoinExec.right();
            boolean isPartial = sortMergeJoinExec.isSkewJoin();
            Tuple2<Seq<Expression>, Seq<Expression>> tuple2 = this.reorderJoinKeys(leftKeys, rightKeys, left.outputPartitioning(), right.outputPartitioning());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Seq reorderedLeftKeys = (Seq)tuple2._1();
            Seq reorderedRightKeys = (Seq)tuple2._2();
            Tuple2 tuple24 = new Tuple2((Object)reorderedLeftKeys, (Object)reorderedRightKeys);
            Tuple2 tuple25 = tuple24;
            Seq reorderedLeftKeys3 = (Seq)tuple25._1();
            Seq reorderedRightKeys3 = (Seq)tuple25._2();
            sparkPlan = new SortMergeJoinExec((Seq<Expression>)reorderedLeftKeys3, (Seq<Expression>)reorderedRightKeys3, joinType, condition, left, right, isPartial);
        } else {
            sparkPlan = sparkPlan2;
        }
        return sparkPlan;
    }

    public SparkPlan apply(SparkPlan plan) {
        return (SparkPlan)plan.transformUp((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                void var3_16;
                A1 A1 = x1;
                if (A1 instanceof ShuffleExchangeExec) {
                    ShuffleExchangeExec shuffleExchangeExec = (ShuffleExchangeExec)A1;
                    Partitioning upper = shuffleExchangeExec.outputPartitioning();
                    SparkPlan child = shuffleExchangeExec.child();
                    if (upper instanceof HashPartitioning) {
                        void var4_12;
                        HashPartitioning hashPartitioning;
                        HashPartitioning hashPartitioning2 = (HashPartitioning)upper;
                        Partitioning partitioning = child.outputPartitioning();
                        if (partitioning instanceof HashPartitioning && hashPartitioning2.semanticEquals((Expression)(hashPartitioning = (HashPartitioning)partitioning))) {
                            SparkPlan sparkPlan = child;
                        } else {
                            ShuffleExchangeExec shuffleExchangeExec2 = shuffleExchangeExec;
                        }
                        void var3_13 = var4_12;
                        return var3_16;
                    }
                }
                if (A1 != null) {
                    A1 A12 = A1;
                    SparkPlan sparkPlan = EnsureRequirements$.MODULE$.org$apache$spark$sql$execution$exchange$EnsureRequirements$$ensureDistributionAndOrdering(EnsureRequirements$.MODULE$.org$apache$spark$sql$execution$exchange$EnsureRequirements$$reorderJoinPredicates(A12));
                    return var3_16;
                }
                Object object = function1.apply(x1);
                return var3_16;
            }

            public final boolean isDefinedAt(SparkPlan x1) {
                ShuffleExchangeExec shuffleExchangeExec;
                Partitioning upper;
                SparkPlan sparkPlan = x1;
                boolean bl = sparkPlan instanceof ShuffleExchangeExec && (upper = (shuffleExchangeExec = (ShuffleExchangeExec)sparkPlan).outputPartitioning()) instanceof HashPartitioning ? true : sparkPlan != null;
                return bl;
            }
        });
    }

    public static final /* synthetic */ boolean $anonfun$ensureDistributionAndOrdering$3(Tuple2 x0$2) {
        Distribution distribution;
        Tuple2 tuple2 = x0$2;
        boolean bl = tuple2 != null && UnspecifiedDistribution$.MODULE$.equals(distribution = (Distribution)tuple2._1()) ? false : tuple2 == null || !(tuple2._1() instanceof BroadcastDistribution);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$ensureDistributionAndOrdering$8(SparkPlan x$3) {
        return x$3 instanceof ShuffleExchangeExec;
    }

    public static final /* synthetic */ int $anonfun$ensureDistributionAndOrdering$9(SparkPlan x$4) {
        return x$4.outputPartitioning().numPartitions();
    }

    public static final /* synthetic */ boolean $anonfun$reorder$1(Tuple2 p) {
        return ((Expression)p._1()).semanticEquals((Expression)p._2());
    }

    public static final /* synthetic */ boolean $anonfun$reorder$2(Map keyToIndexMap$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Expression key = (Expression)tuple2._1();
        int index = tuple2._2$mcI$sp();
        boolean bl = ((BitSet)keyToIndexMap$1.getOrElseUpdate((Object)key.canonicalized(), (Function0 & Serializable & scala.Serializable)() -> BitSet$.MODULE$.empty())).add(index);
        return bl;
    }

    private EnsureRequirements$() {
        MODULE$ = this;
    }
}

