/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.spark.internal.io.FileCommitProtocol;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.package$;
import org.apache.spark.sql.execution.datasources.FileFormatDataWriter;
import org.apache.spark.sql.execution.datasources.WriteJobDescription;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00054A!\u0004\b\u00017!A\u0001\u0005\u0001B\u0001B\u0003%\u0011\u0005\u0003\u0005%\u0001\t\u0005\t\u0015!\u0003&\u0011!i\u0003A!A!\u0002\u0013q\u0003\"\u0002\u001c\u0001\t\u00039\u0004\"\u0003\u001f\u0001\u0001\u0004\u0005\r\u0011\"\u0003>\u0011%!\u0005\u00011AA\u0002\u0013%Q\tC\u0005L\u0001\u0001\u0007\t\u0011)Q\u0005}!IA\n\u0001a\u0001\u0002\u0004%I!\u0014\u0005\n#\u0002\u0001\r\u00111A\u0005\nIC\u0011\u0002\u0016\u0001A\u0002\u0003\u0005\u000b\u0015\u0002(\t\u000bU\u0003A\u0011\u0002,\t\u000b]\u0003A\u0011\t-\u00033MKgn\u001a7f\t&\u0014Xm\u0019;pef$\u0015\r^1Xe&$XM\u001d\u0006\u0003\u001fA\t1\u0002Z1uCN|WO]2fg*\u0011\u0011CE\u0001\nKb,7-\u001e;j_:T!a\u0005\u000b\u0002\u0007M\fHN\u0003\u0002\u0016-\u0005)1\u000f]1sW*\u0011q\u0003G\u0001\u0007CB\f7\r[3\u000b\u0003e\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u000f\u0011\u0005uqR\"\u0001\b\n\u0005}q!\u0001\u0006$jY\u00164uN]7bi\u0012\u000bG/Y,sSR,'/A\u0006eKN\u001c'/\u001b9uS>t\u0007CA\u000f#\u0013\t\u0019cBA\nXe&$XMS8c\t\u0016\u001c8M]5qi&|g.\u0001\nuCN\\\u0017\t\u001e;f[B$8i\u001c8uKb$\bC\u0001\u0014,\u001b\u00059#B\u0001\u0015*\u0003%i\u0017\r\u001d:fIV\u001cWM\u0003\u0002+-\u00051\u0001.\u00193p_BL!\u0001L\u0014\u0003%Q\u000b7o[!ui\u0016l\u0007\u000f^\"p]R,\u0007\u0010^\u0001\nG>lW.\u001b;uKJ\u0004\"a\f\u001b\u000e\u0003AR!!\r\u001a\u0002\u0005%|'BA\u001a\u0015\u0003!Ig\u000e^3s]\u0006d\u0017BA\u001b1\u0005I1\u0015\u000e\\3D_6l\u0017\u000e\u001e)s_R|7m\u001c7\u0002\rqJg.\u001b;?)\u0011A\u0014HO\u001e\u0011\u0005u\u0001\u0001\"\u0002\u0011\u0005\u0001\u0004\t\u0003\"\u0002\u0013\u0005\u0001\u0004)\u0003\"B\u0017\u0005\u0001\u0004q\u0013a\u00034jY\u0016\u001cu.\u001e8uKJ,\u0012A\u0010\t\u0003\u007f\tk\u0011\u0001\u0011\u0006\u0002\u0003\u0006)1oY1mC&\u00111\t\u0011\u0002\u0004\u0013:$\u0018a\u00044jY\u0016\u001cu.\u001e8uKJ|F%Z9\u0015\u0005\u0019K\u0005CA H\u0013\tA\u0005I\u0001\u0003V]&$\bb\u0002&\u0007\u0003\u0003\u0005\rAP\u0001\u0004q\u0012\n\u0014\u0001\u00044jY\u0016\u001cu.\u001e8uKJ\u0004\u0013!\u0004:fG>\u0014Hm]%o\r&dW-F\u0001O!\tyt*\u0003\u0002Q\u0001\n!Aj\u001c8h\u0003E\u0011XmY8sINLeNR5mK~#S-\u001d\u000b\u0003\rNCqAS\u0005\u0002\u0002\u0003\u0007a*\u0001\bsK\u000e|'\u000fZ:J]\u001aKG.\u001a\u0011\u0002\u001f9,woT;uaV$xK]5uKJ$\u0012AR\u0001\u0006oJLG/\u001a\u000b\u0003\rfCQA\u0017\u0007A\u0002m\u000baA]3d_J$\u0007C\u0001/`\u001b\u0005i&B\u00010\u0013\u0003!\u0019\u0017\r^1msN$\u0018B\u00011^\u0005-Ie\u000e^3s]\u0006d'k\\<")
public class SingleDirectoryDataWriter
extends FileFormatDataWriter {
    private final WriteJobDescription description;
    private final TaskAttemptContext taskAttemptContext;
    private final FileCommitProtocol committer;
    private int fileCounter;
    private long recordsInFile;

    private int fileCounter() {
        return this.fileCounter;
    }

    private void fileCounter_$eq(int x$1) {
        this.fileCounter = x$1;
    }

    private long recordsInFile() {
        return this.recordsInFile;
    }

    private void recordsInFile_$eq(long x$1) {
        this.recordsInFile = x$1;
    }

    private void newOutputWriter() {
        this.recordsInFile_$eq(0L);
        this.releaseResources();
        String ext = this.description.outputWriterFactory().getFileExtension(this.taskAttemptContext);
        int arg$macro$1 = this.fileCounter();
        String currentPath = this.committer.newTaskTempFile(this.taskAttemptContext, (Option)None$.MODULE$, new StringBuilder(0).append(new StringOps("-c%03d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)arg$macro$1)}))).append(ext).toString());
        this.currentWriter_$eq(this.description.outputWriterFactory().newInstance(currentPath, package$.MODULE$.AttributeSeq(this.description.dataColumns()).toStructType(), this.taskAttemptContext));
        this.statsTrackers().foreach((Function1 & java.io.Serializable & Serializable)x$3 -> {
            x$3.newFile(currentPath);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void write(InternalRow record) {
        if (this.description.maxRecordsPerFile() > 0L && this.recordsInFile() >= this.description.maxRecordsPerFile()) {
            this.fileCounter_$eq(this.fileCounter() + 1);
            Predef$.MODULE$.assert(this.fileCounter() < this.MAX_FILE_COUNTER(), (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(34).append("File counter ").append(this.fileCounter()).append(" is beyond max value ").append(this.MAX_FILE_COUNTER()).toString());
            this.newOutputWriter();
        }
        this.currentWriter().write(record);
        this.statsTrackers().foreach((Function1 & java.io.Serializable & Serializable)x$4 -> {
            x$4.newRow(record);
            return BoxedUnit.UNIT;
        });
        this.recordsInFile_$eq(this.recordsInFile() + 1L);
    }

    public SingleDirectoryDataWriter(WriteJobDescription description, TaskAttemptContext taskAttemptContext, FileCommitProtocol committer) {
        this.description = description;
        this.taskAttemptContext = taskAttemptContext;
        this.committer = committer;
        super(description, taskAttemptContext, committer);
        this.newOutputWriter();
    }
}

