/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.io.Serializable;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.execution.CachedData;
import org.apache.spark.sql.execution.command.AlterTableRenameCommand$;
import org.apache.spark.sql.execution.command.CommandUtils$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.storage.StorageLevel;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005-e\u0001\u0002\u000e\u001c\u0001\"B\u0001\u0002\u0011\u0001\u0003\u0016\u0004%\t!\u0011\u0005\t\r\u0002\u0011\t\u0012)A\u0005\u0005\"Aq\t\u0001BK\u0002\u0013\u0005\u0011\t\u0003\u0005I\u0001\tE\t\u0015!\u0003C\u0011!I\u0005A!f\u0001\n\u0003Q\u0005\u0002\u0003(\u0001\u0005#\u0005\u000b\u0011B&\t\u000b=\u0003A\u0011\u0001)\t\u000bU\u0003A\u0011\t,\t\u000f1\u0004\u0011\u0011!C\u0001[\"9\u0011\u000fAI\u0001\n\u0003\u0011\bbB?\u0001#\u0003%\tA\u001d\u0005\b}\u0002\t\n\u0011\"\u0001\u0000\u0011%\t\u0019\u0001AA\u0001\n\u0003\n)\u0001C\u0005\u0002\u0018\u0001\t\t\u0011\"\u0001\u0002\u001a!I\u0011\u0011\u0005\u0001\u0002\u0002\u0013\u0005\u00111\u0005\u0005\n\u0003_\u0001\u0011\u0011!C!\u0003cA\u0011\"a\u0010\u0001\u0003\u0003%\t!!\u0011\t\u0013\u0005\u0015\u0003!!A\u0005B\u0005\u001ds!CA&7\u0005\u0005\t\u0012AA'\r!Q2$!A\t\u0002\u0005=\u0003BB(\u0015\t\u0003\ti\u0006C\u0005\u0002`Q\t\t\u0011\"\u0012\u0002b!I\u00111\r\u000b\u0002\u0002\u0013\u0005\u0015Q\r\u0005\n\u0003[\"\u0012\u0011!CA\u0003_B\u0011\"!!\u0015\u0003\u0003%I!a!\u0003/\u0005cG/\u001a:UC\ndWMU3oC6,7i\\7nC:$'B\u0001\u000f\u001e\u0003\u001d\u0019w.\\7b]\u0012T!AH\u0010\u0002\u0013\u0015DXmY;uS>t'B\u0001\u0011\"\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003E\r\nQa\u001d9be.T!\u0001J\u0013\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00051\u0013aA8sO\u000e\u00011#\u0002\u0001*g]j\u0004C\u0001\u00162\u001b\u0005Y#B\u0001\u0017.\u0003\u001dawnZ5dC2T!AL\u0018\u0002\u000bAd\u0017M\\:\u000b\u0005Az\u0012\u0001C2bi\u0006d\u0017p\u001d;\n\u0005IZ#a\u0003'pO&\u001c\u0017\r\u001c)mC:\u0004\"\u0001N\u001b\u000e\u0003mI!AN\u000e\u0003\u001fI+hN\\1cY\u0016\u001cu.\\7b]\u0012\u0004\"\u0001O\u001e\u000e\u0003eR\u0011AO\u0001\u0006g\u000e\fG.Y\u0005\u0003ye\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u00029}%\u0011q(\u000f\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\b_2$g*Y7f+\u0005\u0011\u0005CA\"E\u001b\u0005y\u0013BA#0\u0005=!\u0016M\u00197f\u0013\u0012,g\u000e^5gS\u0016\u0014\u0018\u0001C8mI:\u000bW.\u001a\u0011\u0002\u000f9,wOT1nK\u0006Aa.Z<OC6,\u0007%\u0001\u0004jgZKWm^\u000b\u0002\u0017B\u0011\u0001\bT\u0005\u0003\u001bf\u0012qAQ8pY\u0016\fg.A\u0004jgZKWm\u001e\u0011\u0002\rqJg.\u001b;?)\u0011\t&k\u0015+\u0011\u0005Q\u0002\u0001\"\u0002!\b\u0001\u0004\u0011\u0005\"B$\b\u0001\u0004\u0011\u0005\"B%\b\u0001\u0004Y\u0015a\u0001:v]R\u0011qk\u001a\t\u00041\u0002\u001cgBA-_\u001d\tQV,D\u0001\\\u0015\tav%\u0001\u0004=e>|GOP\u0005\u0002u%\u0011q,O\u0001\ba\u0006\u001c7.Y4f\u0013\t\t'MA\u0002TKFT!aX\u001d\u0011\u0005\u0011,W\"A\u0010\n\u0005\u0019|\"a\u0001*po\")\u0001\u000e\u0003a\u0001S\u0006a1\u000f]1sWN+7o]5p]B\u0011AM[\u0005\u0003W~\u0011Ab\u00159be.\u001cVm]:j_:\fAaY8qsR!\u0011K\\8q\u0011\u001d\u0001\u0015\u0002%AA\u0002\tCqaR\u0005\u0011\u0002\u0003\u0007!\tC\u0004J\u0013A\u0005\t\u0019A&\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\t1O\u000b\u0002Ci.\nQ\u000f\u0005\u0002ww6\tqO\u0003\u0002ys\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003uf\n!\"\u00198o_R\fG/[8o\u0013\taxOA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005\u0005!FA&u\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011q\u0001\t\u0005\u0003\u0013\t\u0019\"\u0004\u0002\u0002\f)!\u0011QBA\b\u0003\u0011a\u0017M\\4\u000b\u0005\u0005E\u0011\u0001\u00026bm\u0006LA!!\u0006\u0002\f\t11\u000b\u001e:j]\u001e\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a\u0007\u0011\u0007a\ni\"C\u0002\u0002 e\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!\n\u0002,A\u0019\u0001(a\n\n\u0007\u0005%\u0012HA\u0002B]fD\u0011\"!\f\u0010\u0003\u0003\u0005\r!a\u0007\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t\u0019\u0004\u0005\u0004\u00026\u0005m\u0012QE\u0007\u0003\u0003oQ1!!\u000f:\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003{\t9D\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGcA&\u0002D!I\u0011QF\t\u0002\u0002\u0003\u0007\u0011QE\u0001\u0007KF,\u0018\r\\:\u0015\u0007-\u000bI\u0005C\u0005\u0002.I\t\t\u00111\u0001\u0002&\u00059\u0012\t\u001c;feR\u000b'\r\\3SK:\fW.Z\"p[6\fg\u000e\u001a\t\u0003iQ\u0019B\u0001FA){AA\u00111KA-\u0005\n[\u0015+\u0004\u0002\u0002V)\u0019\u0011qK\u001d\u0002\u000fI,h\u000e^5nK&!\u00111LA+\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\u000b\u0003\u0003\u001b\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003\u000f\tQ!\u00199qYf$r!UA4\u0003S\nY\u0007C\u0003A/\u0001\u0007!\tC\u0003H/\u0001\u0007!\tC\u0003J/\u0001\u00071*A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005E\u0014Q\u0010\t\u0006q\u0005M\u0014qO\u0005\u0004\u0003kJ$AB(qi&|g\u000e\u0005\u00049\u0003s\u0012%iS\u0005\u0004\u0003wJ$A\u0002+va2,7\u0007\u0003\u0005\u0002\u0000a\t\t\u00111\u0001R\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002\u0006B!\u0011\u0011BAD\u0013\u0011\tI)a\u0003\u0003\r=\u0013'.Z2u\u0001")
public class AlterTableRenameCommand
extends LogicalPlan
implements RunnableCommand,
scala.Serializable {
    private final TableIdentifier oldName;
    private final TableIdentifier newName;
    private final boolean isView;
    private Map<String, SQLMetric> metrics;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<TableIdentifier, TableIdentifier, Object>> unapply(AlterTableRenameCommand alterTableRenameCommand) {
        return AlterTableRenameCommand$.MODULE$.unapply(alterTableRenameCommand);
    }

    public static Function1<Tuple3<TableIdentifier, TableIdentifier, Object>, AlterTableRenameCommand> tupled() {
        return AlterTableRenameCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<TableIdentifier, Function1<Object, AlterTableRenameCommand>>> curried() {
        return AlterTableRenameCommand$.MODULE$.curried();
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public Seq<LogicalPlan> children() {
        return Command.children$((Command)this);
    }

    public Statistics stats() {
        return Command.stats$((Command)this);
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        AlterTableRenameCommand alterTableRenameCommand = this;
        synchronized (alterTableRenameCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$(this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    @Override
    public Map<String, SQLMetric> metrics() {
        return !this.bitmap$0 ? this.metrics$lzycompute() : this.metrics;
    }

    public TableIdentifier oldName() {
        return this.oldName;
    }

    public TableIdentifier newName() {
        return this.newName;
    }

    public boolean isView() {
        return this.isView;
    }

    @Override
    public Seq<Row> run(SparkSession sparkSession) {
        SessionCatalog catalog = sparkSession.sessionState().catalog();
        if (catalog.isTemporaryTable(this.oldName())) {
            catalog.renameTable(this.oldName(), this.newName());
        } else {
            CatalogTable table = catalog.getTableMetadata(this.oldName());
            DDLUtils$.MODULE$.verifyAlterTableType(catalog, table, this.isView());
            Option<CachedData> optCachedData = sparkSession.sharedState().cacheManager().lookupCachedData(sparkSession.table(this.oldName().unquotedString()));
            Option optStorageLevel = optCachedData.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.cachedRepresentation().cacheBuilder().storageLevel());
            if (optStorageLevel.isDefined()) {
                CommandUtils$.MODULE$.uncacheTableOrView(sparkSession, this.oldName().unquotedString());
            }
            catalog.refreshTable(this.oldName());
            catalog.renameTable(this.oldName(), this.newName());
            optStorageLevel.foreach((Function1 & Serializable & scala.Serializable)storageLevel -> {
                AlterTableRenameCommand.$anonfun$run$2(this, sparkSession, storageLevel);
                return BoxedUnit.UNIT;
            });
        }
        return (Seq)Seq$.MODULE$.empty();
    }

    public AlterTableRenameCommand copy(TableIdentifier oldName, TableIdentifier newName, boolean isView) {
        return new AlterTableRenameCommand(oldName, newName, isView);
    }

    public TableIdentifier copy$default$1() {
        return this.oldName();
    }

    public TableIdentifier copy$default$2() {
        return this.newName();
    }

    public boolean copy$default$3() {
        return this.isView();
    }

    public String productPrefix() {
        return "AlterTableRenameCommand";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.oldName();
                break;
            }
            case 1: {
                object = this.newName();
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToBoolean((boolean)this.isView());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof AlterTableRenameCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof AlterTableRenameCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        AlterTableRenameCommand alterTableRenameCommand = (AlterTableRenameCommand)x$1;
        TableIdentifier tableIdentifier = this.oldName();
        TableIdentifier tableIdentifier2 = alterTableRenameCommand.oldName();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        TableIdentifier tableIdentifier3 = this.newName();
        TableIdentifier tableIdentifier4 = alterTableRenameCommand.newName();
        if (tableIdentifier3 == null) {
            if (tableIdentifier4 != null) {
                return false;
            }
        } else if (!tableIdentifier3.equals(tableIdentifier4)) return false;
        if (this.isView() != alterTableRenameCommand.isView()) return false;
        if (!alterTableRenameCommand.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$run$2(AlterTableRenameCommand $this, SparkSession sparkSession$1, StorageLevel storageLevel) {
        sparkSession$1.catalog().cacheTable($this.newName().unquotedString(), storageLevel);
    }

    public AlterTableRenameCommand(TableIdentifier oldName, TableIdentifier newName, boolean isView) {
        this.oldName = oldName;
        this.newName = newName;
        this.isView = isView;
        Command.$init$((Command)this);
        RunnableCommand.$init$(this);
    }
}

