/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.orc;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.orc.OrcConf;
import org.apache.orc.OrcFile;
import org.apache.orc.Reader;
import org.apache.orc.TypeDescription;
import org.apache.orc.mapred.OrcOutputFormat;
import org.apache.orc.mapred.OrcStruct;
import org.apache.orc.mapreduce.OrcInputFormat;
import org.apache.spark.TaskContext$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.JoinedRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.codegen.GenerateUnsafeProjection$;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.RecordReaderIterator;
import org.apache.spark.sql.execution.datasources.orc.OrcColumnarBatchReader;
import org.apache.spark.sql.execution.datasources.orc.OrcDeserializer;
import org.apache.spark.sql.execution.datasources.orc.OrcFileFormat$;
import org.apache.spark.sql.execution.datasources.orc.OrcFilters$;
import org.apache.spark.sql.execution.datasources.orc.OrcOptions;
import org.apache.spark.sql.execution.datasources.orc.OrcOutputWriter;
import org.apache.spark.sql.execution.datasources.orc.OrcUtils$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import org.apache.spark.util.SerializableConfiguration;
import org.apache.spark.util.Utils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005}wAB\n\u0015\u0011\u0003Q\"E\u0002\u0004%)!\u0005!$\n\u0005\u0006_\u0005!\t!\r\u0005\u0006e\u0005!Ia\r\u0005\u0006\t\u0006!\t!\u0012\u0005\u0006#\u0006!\tA\u0015\u0005\b7\u0006\t\t\u0011\"\u0003]\r\u0011!C\u0003A3\t\u000b=:A\u0011A;\t\u000b]<A\u0011\t=\t\u000be<A\u0011\t=\t\u000bi<A\u0011I>\t\r}<A\u0011IA\u0001\u0011\u001d\t\u0019b\u0002C!\u0003+Aq!a\u0014\b\t\u0003\n\t\u0006C\u0004\u0002r\u001d!\t%a\u001d\t\u000f\u0005mt\u0001\"\u0011\u0002~!9\u0011QR\u0004\u0005B\u0005=\u0005bBAm\u000f\u0011\u0005\u00131\\\u0001\u000e\u001fJ\u001cg)\u001b7f\r>\u0014X.\u0019;\u000b\u0005U1\u0012aA8sG*\u0011q\u0003G\u0001\fI\u0006$\u0018m]8ve\u000e,7O\u0003\u0002\u001a5\u0005IQ\r_3dkRLwN\u001c\u0006\u00037q\t1a]9m\u0015\tib$A\u0003ta\u0006\u00148N\u0003\u0002 A\u00051\u0011\r]1dQ\u0016T\u0011!I\u0001\u0004_J<\u0007CA\u0012\u0002\u001b\u0005!\"!D(sG\u001aKG.\u001a$pe6\fGoE\u0002\u0002M1\u0002\"a\n\u0016\u000e\u0003!R\u0011!K\u0001\u0006g\u000e\fG.Y\u0005\u0003W!\u0012a!\u00118z%\u00164\u0007CA\u0014.\u0013\tq\u0003F\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0004=S:LGOP\u0002\u0001)\u0005\u0011\u0013AD2iK\u000e\\g)[3mI:\u000bW.\u001a\u000b\u0003i]\u0002\"aJ\u001b\n\u0005YB#\u0001B+oSRDQ\u0001O\u0002A\u0002e\nAA\\1nKB\u0011!(\u0011\b\u0003w}\u0002\"\u0001\u0010\u0015\u000e\u0003uR!A\u0010\u0019\u0002\rq\u0012xn\u001c;?\u0013\t\u0001\u0005&\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0005\u000e\u0013aa\u0015;sS:<'B\u0001!)\u0003=\u0019\u0007.Z2l\r&,G\u000e\u001a(b[\u0016\u001cHC\u0001\u001bG\u0011\u00159E\u00011\u0001I\u0003\u0015q\u0017-\\3t!\rIe*\u000f\b\u0003\u00152s!\u0001P&\n\u0003%J!!\u0014\u0015\u0002\u000fA\f7m[1hK&\u0011q\n\u0015\u0002\u0004'\u0016\f(BA')\u0003U9W\r^)v_R,GmU2iK6\f7\u000b\u001e:j]\u001e$\"!O*\t\u000bQ+\u0001\u0019A+\u0002\u0011\u0011\fG/\u0019+za\u0016\u0004\"AV-\u000e\u0003]S!\u0001\u0017\u000e\u0002\u000bQL\b/Z:\n\u0005i;&\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0002;B\u0011alY\u0007\u0002?*\u0011\u0001-Y\u0001\u0005Y\u0006twMC\u0001c\u0003\u0011Q\u0017M^1\n\u0005\u0011|&AB(cU\u0016\u001cGoE\u0003\bM\u0019T\u0007\u000f\u0005\u0002hQ6\ta#\u0003\u0002j-\tQa)\u001b7f\r>\u0014X.\u0019;\u0011\u0005-tW\"\u00017\u000b\u00055T\u0012aB:pkJ\u001cWm]\u0005\u0003_2\u0014!\u0003R1uCN{WO]2f%\u0016<\u0017n\u001d;feB\u0011\u0011\u000f^\u0007\u0002e*\u00111/Y\u0001\u0003S>L!A\f:\u0015\u0003Y\u0004\"aI\u0004\u0002\u0013MDwN\u001d;OC6,G#A\u001d\u0002\u0011Q|7\u000b\u001e:j]\u001e\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002yB\u0011q%`\u0005\u0003}\"\u00121!\u00138u\u0003\u0019)\u0017/^1mgR!\u00111AA\u0005!\r9\u0013QA\u0005\u0004\u0003\u000fA#a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003\u0017a\u0001\u0019AA\u0007\u0003\u0015yG\u000f[3s!\r9\u0013qB\u0005\u0004\u0003#A#aA!os\u0006Y\u0011N\u001c4feN\u001b\u0007.Z7b)!\t9\"a\t\u00020\u0005e\u0002#B\u0014\u0002\u001a\u0005u\u0011bAA\u000eQ\t1q\n\u001d;j_:\u00042AVA\u0010\u0013\r\t\tc\u0016\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007bBA\u0013\u001b\u0001\u0007\u0011qE\u0001\rgB\f'o[*fgNLwN\u001c\t\u0005\u0003S\tY#D\u0001\u001b\u0013\r\tiC\u0007\u0002\r'B\f'o[*fgNLwN\u001c\u0005\b\u0003ci\u0001\u0019AA\u001a\u0003\u001dy\u0007\u000f^5p]N\u0004RAOA\u001bseJ1!a\u000eD\u0005\ri\u0015\r\u001d\u0005\b\u0003wi\u0001\u0019AA\u001f\u0003\u00151\u0017\u000e\\3t!\u0011Ie*a\u0010\u0011\t\u0005\u0005\u00131J\u0007\u0003\u0003\u0007RA!!\u0012\u0002H\u0005\u0011am\u001d\u0006\u0004\u0003\u0013r\u0012A\u00025bI>|\u0007/\u0003\u0003\u0002N\u0005\r#A\u0003$jY\u0016\u001cF/\u0019;vg\u0006a\u0001O]3qCJ,wK]5uKRQ\u00111KA-\u00037\nY'!\u001c\u0011\u0007\u001d\f)&C\u0002\u0002XY\u00111cT;uaV$xK]5uKJ4\u0015m\u0019;pefDq!!\n\u000f\u0001\u0004\t9\u0003C\u0004\u0002^9\u0001\r!a\u0018\u0002\u0007)|'\r\u0005\u0003\u0002b\u0005\u001dTBAA2\u0015\u0011\t)'a\u0012\u0002\u00135\f\u0007O]3ek\u000e,\u0017\u0002BA5\u0003G\u00121AS8c\u0011\u001d\t\tD\u0004a\u0001\u0003gAq!a\u001c\u000f\u0001\u0004\ti\"\u0001\u0006eCR\f7k\u00195f[\u0006\fAb];qa>\u0014HOQ1uG\"$b!a\u0001\u0002v\u0005]\u0004bBA\u0013\u001f\u0001\u0007\u0011q\u0005\u0005\b\u0003sz\u0001\u0019AA\u000f\u0003\u0019\u00198\r[3nC\u0006Y\u0011n]*qY&$\u0018M\u00197f)!\t\u0019!a \u0002\u0002\u0006\r\u0005bBA\u0013!\u0001\u0007\u0011q\u0005\u0005\b\u0003c\u0001\u0002\u0019AA\u001a\u0011\u001d\t)\t\u0005a\u0001\u0003\u000f\u000bA\u0001]1uQB!\u0011\u0011IAE\u0013\u0011\tY)a\u0011\u0003\tA\u000bG\u000f[\u0001\u001fEVLG\u000e\u001a*fC\u0012,'oV5uQB\u000b'\u000f^5uS>tg+\u00197vKN$\u0002#!%\u00020\u0006E\u00161WA\\\u0003w\u000b9-!3\u0011\u000f\u001d\n\u0019*a&\u0002\u001e&\u0019\u0011Q\u0013\u0015\u0003\u0013\u0019+hn\u0019;j_:\f\u0004cA4\u0002\u001a&\u0019\u00111\u0014\f\u0003\u001fA\u000b'\u000f^5uS>tW\r\u001a$jY\u0016\u0004R!SAP\u0003GK1!!)Q\u0005!IE/\u001a:bi>\u0014\b\u0003BAS\u0003Wk!!a*\u000b\u0007\u0005%&$\u0001\u0005dCR\fG._:u\u0013\u0011\ti+a*\u0003\u0017%sG/\u001a:oC2\u0014vn\u001e\u0005\b\u0003K\t\u0002\u0019AA\u0014\u0011\u001d\ty'\u0005a\u0001\u0003;Aq!!.\u0012\u0001\u0004\ti\"A\bqCJ$\u0018\u000e^5p]N\u001b\u0007.Z7b\u0011\u001d\tI,\u0005a\u0001\u0003;\taB]3rk&\u0014X\rZ*dQ\u0016l\u0017\rC\u0004\u0002>F\u0001\r!a0\u0002\u000f\u0019LG\u000e^3sgB!\u0011JTAa!\rY\u00171Y\u0005\u0004\u0003\u000bd'A\u0002$jYR,'\u000fC\u0004\u00022E\u0001\r!a\r\t\u000f\u0005-\u0017\u00031\u0001\u0002N\u0006Q\u0001.\u00193p_B\u001cuN\u001c4\u0011\t\u0005=\u0017Q[\u0007\u0003\u0003#TA!a5\u0002H\u0005!1m\u001c8g\u0013\u0011\t9.!5\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0003=\u0019X\u000f\u001d9peR$\u0015\r^1UsB,G\u0003BA\u0002\u0003;DQ\u0001\u0016\nA\u0002U\u0003")
public class OrcFileFormat
implements FileFormat,
DataSourceRegister,
Serializable {
    public static String getQuotedSchemaString(DataType dataType) {
        return OrcFileFormat$.MODULE$.getQuotedSchemaString(dataType);
    }

    public static void checkFieldNames(Seq<String> seq) {
        OrcFileFormat$.MODULE$.checkFieldNames(seq);
    }

    @Override
    public Option<Seq<String>> vectorTypes(StructType requiredSchema, StructType partitionSchema, SQLConf sqlConf) {
        return FileFormat.vectorTypes$(this, requiredSchema, partitionSchema, sqlConf);
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        return FileFormat.buildReader$(this, sparkSession, dataSchema, partitionSchema, requiredSchema, filters, options, hadoopConf);
    }

    @Override
    public String shortName() {
        return "orc";
    }

    public String toString() {
        return "ORC";
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof OrcFileFormat;
    }

    @Override
    public Option<StructType> inferSchema(SparkSession sparkSession, Map<String, String> options, Seq<FileStatus> files) {
        return OrcUtils$.MODULE$.inferSchema(sparkSession, files, options);
    }

    @Override
    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, Map<String, String> options, StructType dataSchema) {
        OrcOptions orcOptions = new OrcOptions(options, sparkSession.sessionState().conf());
        Configuration conf = job.getConfiguration();
        conf.set(OrcConf.MAPRED_OUTPUT_SCHEMA.getAttribute(), OrcFileFormat$.MODULE$.getQuotedSchemaString((DataType)dataSchema));
        conf.set(OrcConf.COMPRESS.getAttribute(), orcOptions.compressionCodec());
        ((JobConf)conf).setOutputFormat(OrcOutputFormat.class);
        return new OutputWriterFactory(null){

            public OutputWriter newInstance(String path, StructType dataSchema, TaskAttemptContext context) {
                return new OrcOutputWriter(path, dataSchema, context);
            }

            public String getFileExtension(TaskAttemptContext context) {
                String name = context.getConfiguration().get(OrcConf.COMPRESS.getAttribute());
                String compressionExtension = (String)OrcUtils$.MODULE$.extensionsForCompressionCodecNames().getOrElse((Object)name, (Function0 & Serializable & scala.Serializable)() -> "");
                return new StringBuilder(4).append(compressionExtension).append(".orc").toString();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$getFileExtension$1()}, serializedLambda);
            }
        };
    }

    @Override
    public boolean supportBatch(SparkSession sparkSession, StructType schema) {
        SQLConf conf = sparkSession.sessionState().conf();
        return conf.orcVectorizedReaderEnabled() && conf.wholeStageEnabled() && schema.length() <= conf.wholeStageMaxNumFields() && schema.forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)OrcFileFormat.$anonfun$supportBatch$1(x$1)));
    }

    @Override
    public boolean isSplitable(SparkSession sparkSession, Map<String, String> options, Path path) {
        return true;
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReaderWithPartitionValues(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        StructType resultSchema = new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredSchema.fields())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionSchema.fields())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
        SQLConf sqlConf = sparkSession.sessionState().conf();
        boolean enableVectorizedReader = this.supportBatch(sparkSession, resultSchema);
        int capacity = sqlConf.orcVectorizedReaderBatchSize();
        OrcConf.IS_SCHEMA_EVOLUTION_CASE_SENSITIVE.setBoolean(hadoopConf, sqlConf.caseSensitiveAnalysis());
        Broadcast broadcastedConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        boolean isCaseSensitive = sparkSession.sessionState().conf().caseSensitiveAnalysis();
        boolean orcFilterPushDown = sparkSession.sessionState().conf().orcFilterPushDown();
        boolean ignoreCorruptFiles = sparkSession.sessionState().conf().ignoreCorruptFiles();
        return (Function1 & Serializable & scala.Serializable)file -> {
            Iterator iterator;
            Configuration conf = ((SerializableConfiguration)broadcastedConf.value()).value();
            Path filePath = new Path(new URI(file.filePath()));
            FileSystem fs = filePath.getFileSystem(conf);
            OrcFile.ReaderOptions readerOptions = OrcFile.readerOptions((Configuration)conf).filesystem(fs);
            Option resultedColPruneInfo = (Option)Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> OrcFile.createReader((Path)filePath, (OrcFile.ReaderOptions)readerOptions), (Function1 & Serializable & scala.Serializable)reader -> OrcUtils$.MODULE$.requestedColumnIds(isCaseSensitive, dataSchema, requiredSchema, (Reader)reader, conf));
            if (resultedColPruneInfo.isEmpty()) {
                iterator = package$.MODULE$.Iterator().empty();
            } else {
                Object object = orcFilterPushDown ? OrcUtils$.MODULE$.readCatalystSchema(filePath, conf, ignoreCorruptFiles).map((Function1 & Serializable & scala.Serializable)fileSchema -> {
                    OrcFileFormat.$anonfun$buildReaderWithPartitionValues$4(filters, conf, fileSchema);
                    return BoxedUnit.UNIT;
                }) : BoxedUnit.UNIT;
                Tuple2 tuple2 = (Tuple2)resultedColPruneInfo.get();
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                int[] requestedColIds = (int[])tuple2._1();
                boolean canPruneCols = tuple2._2$mcZ$sp();
                Tuple2 tuple22 = new Tuple2((Object)requestedColIds, (Object)BoxesRunTime.boxToBoolean((boolean)canPruneCols));
                Tuple2 tuple23 = tuple22;
                int[] requestedColIds2 = (int[])tuple23._1();
                boolean canPruneCols2 = tuple23._2$mcZ$sp();
                String resultSchemaString = OrcUtils$.MODULE$.orcResultSchemaString(canPruneCols2, dataSchema, resultSchema, partitionSchema, conf);
                Predef$.MODULE$.assert(requestedColIds2.length == requiredSchema.length(), (Function0 & Serializable & scala.Serializable)() -> "[BUG] requested column IDs do not match required schema");
                Configuration taskConf = new Configuration(conf);
                FileSplit fileSplit = new FileSplit(filePath, file.start(), file.length(), (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
                TaskAttemptID attemptId = new TaskAttemptID(new TaskID(new JobID(), TaskType.MAP, 0), 0);
                TaskAttemptContextImpl taskAttemptContext = new TaskAttemptContextImpl(taskConf, attemptId);
                if (enableVectorizedReader) {
                    OrcColumnarBatchReader batchReader = new OrcColumnarBatchReader(capacity);
                    RecordReaderIterator<ColumnarBatch> iter = new RecordReaderIterator<ColumnarBatch>(batchReader);
                    Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).foreach((Function1 & Serializable & scala.Serializable)x$3 -> x$3.addTaskCompletionListener((Function1 & Serializable & scala.Serializable)x$4 -> {
                        iter.close();
                        return BoxedUnit.UNIT;
                    }));
                    int[] requestedDataColIds = (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(requestedColIds2)).$plus$plus((GenTraversableOnce)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])Array$.MODULE$.fill(partitionSchema.length(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1, ClassTag$.MODULE$.Int()))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
                    int[] requestedPartitionColIds = (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])Array$.MODULE$.fill(requiredSchema.length(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1, ClassTag$.MODULE$.Int()))).$plus$plus((GenTraversableOnce)package$.MODULE$.Range().apply(0, partitionSchema.length()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
                    batchReader.initialize((InputSplit)fileSplit, (TaskAttemptContext)taskAttemptContext);
                    batchReader.initBatch(TypeDescription.fromString((String)resultSchemaString), resultSchema.fields(), requestedDataColIds, requestedPartitionColIds, file.partitionValues());
                    iterator = iter;
                } else {
                    RecordReader orcRecordReader = new OrcInputFormat().createRecordReader((InputSplit)fileSplit, (TaskAttemptContext)taskAttemptContext);
                    RecordReaderIterator iter = new RecordReaderIterator(orcRecordReader);
                    Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).foreach((Function1 & Serializable & scala.Serializable)x$5 -> x$5.addTaskCompletionListener((Function1 & Serializable & scala.Serializable)x$6 -> {
                        iter.close();
                        return BoxedUnit.UNIT;
                    }));
                    Seq fullSchema = (Seq)requiredSchema.toAttributes().$plus$plus((GenTraversableOnce)partitionSchema.toAttributes(), Seq$.MODULE$.canBuildFrom());
                    UnsafeProjection unsafeProjection = (UnsafeProjection)GenerateUnsafeProjection$.MODULE$.generate((Object)fullSchema, fullSchema);
                    OrcDeserializer deserializer = new OrcDeserializer(dataSchema, requiredSchema, requestedColIds2);
                    if (partitionSchema.length() == 0) {
                        iterator = iter.map((Function1 & Serializable & scala.Serializable)value -> unsafeProjection.apply(deserializer.deserialize((OrcStruct)value)));
                    } else {
                        JoinedRow joinedRow = new JoinedRow();
                        iterator = iter.map((Function1 & Serializable & scala.Serializable)value -> unsafeProjection.apply((InternalRow)joinedRow.apply(deserializer.deserialize((OrcStruct)value), file.partitionValues())));
                    }
                }
            }
            return iterator;
        };
    }

    @Override
    public boolean supportDataType(DataType dataType) {
        boolean bl;
        DataType dataType2 = dataType;
        if (dataType2 instanceof AtomicType) {
            bl = true;
        } else if (dataType2 instanceof StructType) {
            StructType structType = (StructType)dataType2;
            bl = structType.forall((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)this.supportDataType(f.dataType())));
        } else if (dataType2 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            DataType elementType = arrayType.elementType();
            bl = this.supportDataType(elementType);
        } else if (dataType2 instanceof MapType) {
            MapType mapType = (MapType)dataType2;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            bl = this.supportDataType(keyType) && this.supportDataType(valueType);
        } else if (dataType2 instanceof UserDefinedType) {
            UserDefinedType userDefinedType = (UserDefinedType)dataType2;
            bl = this.supportDataType(userDefinedType.sqlType());
        } else {
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$supportBatch$1(StructField x$1) {
        return x$1.dataType() instanceof AtomicType;
    }

    public static final /* synthetic */ void $anonfun$buildReaderWithPartitionValues$5(Configuration conf$1, StructType fileSchema$1, SearchArgument f) {
        OrcInputFormat.setSearchArgument((Configuration)conf$1, (SearchArgument)f, (String[])fileSchema$1.fieldNames());
    }

    public static final /* synthetic */ void $anonfun$buildReaderWithPartitionValues$4(Seq filters$1, Configuration conf$1, StructType fileSchema) {
        OrcFilters$.MODULE$.createFilter(fileSchema, (Seq<Filter>)filters$1).foreach((Function1 & Serializable & scala.Serializable)f -> {
            OrcFileFormat.$anonfun$buildReaderWithPartitionValues$5(conf$1, fileSchema, f);
            return BoxedUnit.UNIT;
        });
    }

    public OrcFileFormat() {
        FileFormat.$init$(this);
    }
}

