/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.expressions;

import java.io.Serializable;
import org.apache.spark.annotation.InterfaceStability;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Column$;
import org.apache.spark.sql.catalyst.expressions.Ascending$;
import org.apache.spark.sql.catalyst.expressions.CurrentRow$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.FrameType;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.RangeFrame$;
import org.apache.spark.sql.catalyst.expressions.RowFrame$;
import org.apache.spark.sql.catalyst.expressions.SortDirection;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.expressions.SortOrder$;
import org.apache.spark.sql.catalyst.expressions.SpecifiedWindowFrame;
import org.apache.spark.sql.catalyst.expressions.UnboundedFollowing$;
import org.apache.spark.sql.catalyst.expressions.UnboundedPreceding$;
import org.apache.spark.sql.catalyst.expressions.WindowExpression;
import org.apache.spark.sql.catalyst.expressions.WindowFrame;
import org.apache.spark.sql.catalyst.expressions.WindowSpecDefinition;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@InterfaceStability.Stable
@ScalaSignature(bytes="\u0006\u0001\u0005\u001db\u0001B\u0007\u000f\u0001eA\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006I!\t\u0005\ti\u0001\u0011\t\u0011)A\u0005k!A\u0011\b\u0001B\u0001B\u0003%!\b\u0003\u0004>\u0001\u0011\u0005\u0001C\u0010\u0005\u0006\t\u0002!\t!\u0012\u0005\u0006\t\u0002!\t\u0001\u0018\u0005\u0006K\u0002!\tA\u001a\u0005\u0006K\u0002!\tA\u001b\u0005\u0006[\u0002!\tA\u001c\u0005\u0006m\u0002!\ta\u001e\u0005\u0006m\u0002!\tA\u001f\u0005\t\u0003\u0017\u0001A\u0011\u0001\t\u0002\u000e\tQq+\u001b8e_^\u001c\u0006/Z2\u000b\u0005=\u0001\u0012aC3yaJ,7o]5p]NT!!\u0005\n\u0002\u0007M\fHN\u0003\u0002\u0014)\u0005)1\u000f]1sW*\u0011QCF\u0001\u0007CB\f7\r[3\u000b\u0003]\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u000e\u0011\u0005mqR\"\u0001\u000f\u000b\u0003u\tQa]2bY\u0006L!a\b\u000f\u0003\r\u0005s\u0017PU3g\u00035\u0001\u0018M\u001d;ji&|gn\u00159fGB\u0019!EK\u0017\u000f\u0005\rBcB\u0001\u0013(\u001b\u0005)#B\u0001\u0014\u0019\u0003\u0019a$o\\8u}%\tQ$\u0003\u0002*9\u00059\u0001/Y2lC\u001e,\u0017BA\u0016-\u0005\r\u0019V-\u001d\u0006\u0003Sq\u0001\"A\f\u001a\u000e\u0003=R!a\u0004\u0019\u000b\u0005E\u0002\u0012\u0001C2bi\u0006d\u0017p\u001d;\n\u0005Mz#AC#yaJ,7o]5p]\u0006IqN\u001d3feN\u0003Xm\u0019\t\u0004E)2\u0004C\u0001\u00188\u0013\tAtFA\u0005T_J$xJ\u001d3fe\u0006)aM]1nKB\u0011afO\u0005\u0003y=\u00121bV5oI><hI]1nK\u00061A(\u001b8jiz\"BaP!C\u0007B\u0011\u0001\tA\u0007\u0002\u001d!)\u0001\u0005\u0002a\u0001C!)A\u0007\u0002a\u0001k!)\u0011\b\u0002a\u0001u\u0005Y\u0001/\u0019:uSRLwN\u001c\"z)\ryd\t\u0015\u0005\u0006\u000f\u0016\u0001\r\u0001S\u0001\bG>dg*Y7f!\tIUJ\u0004\u0002K\u0017B\u0011A\u0005H\u0005\u0003\u0019r\ta\u0001\u0015:fI\u00164\u0017B\u0001(P\u0005\u0019\u0019FO]5oO*\u0011A\n\b\u0005\u0006#\u0016\u0001\rAU\u0001\tG>dg*Y7fgB\u00191d\u0015%\n\u0005Qc\"A\u0003\u001fsKB,\u0017\r^3e}!\u0012QA\u0016\t\u0003/jk\u0011\u0001\u0017\u0006\u00033r\t!\"\u00198o_R\fG/[8o\u0013\tY\u0006LA\u0004wCJ\f'oZ:\u0015\u0005}j\u0006\"\u00020\u0007\u0001\u0004y\u0016\u0001B2pYN\u00042aG*a!\t\t'-D\u0001\u0011\u0013\t\u0019\u0007C\u0001\u0004D_2,XN\u001c\u0015\u0003\rY\u000bqa\u001c:eKJ\u0014\u0015\u0010F\u0002@O\"DQaR\u0004A\u0002!CQ!U\u0004A\u0002IC#a\u0002,\u0015\u0005}Z\u0007\"\u00020\t\u0001\u0004y\u0006F\u0001\u0005W\u0003-\u0011xn^:CKR<X-\u001a8\u0015\u0007}zG\u000fC\u0003q\u0013\u0001\u0007\u0011/A\u0003ti\u0006\u0014H\u000f\u0005\u0002\u001ce&\u00111\u000f\b\u0002\u0005\u0019>tw\rC\u0003v\u0013\u0001\u0007\u0011/A\u0002f]\u0012\fAB]1oO\u0016\u0014U\r^<fK:$2a\u0010=z\u0011\u0015\u0001(\u00021\u0001r\u0011\u0015)(\u00021\u0001r)\ry4\u0010 \u0005\u0006a.\u0001\r\u0001\u0019\u0005\u0006k.\u0001\r\u0001\u0019\u0015\u0007\u0017y\f\u0019!a\u0002\u0011\u0005my\u0018bAA\u00019\tQA-\u001a9sK\u000e\fG/\u001a3\"\u0005\u0005\u0015\u0011!K+tK\u0002\"\b.\u001a\u0011wKJ\u001c\u0018n\u001c8!o&$\b\u000e\t'p]\u001e\u0004\u0003/\u0019:b[\u0016$XM\u001d\u0011usB,7/\t\u0002\u0002\n\u0005)!G\f\u001b/a\u0005iq/\u001b;i\u0003\u001e<'/Z4bi\u0016$2\u0001YA\b\u0011\u0019\t\t\u0002\u0004a\u0001A\u0006I\u0011mZ4sK\u001e\fG/\u001a\u0015\u0004\u0001\u0005U\u0001\u0003BA\f\u0003CqA!!\u0007\u0002\u001e5\u0011\u00111\u0004\u0006\u00033JIA!a\b\u0002\u001c\u0005\u0011\u0012J\u001c;fe\u001a\f7-Z*uC\nLG.\u001b;z\u0013\u0011\t\u0019#!\n\u0003\rM#\u0018M\u00197f\u0015\u0011\ty\"a\u0007")
public class WindowSpec {
    private final Seq<Expression> partitionSpec;
    private final Seq<SortOrder> orderSpec;
    private final WindowFrame frame;

    public WindowSpec partitionBy(String colName, String ... colNames) {
        return this.partitionBy(colName, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public WindowSpec partitionBy(Column ... cols) {
        return this.partitionBy((Seq<Column>)Predef$.MODULE$.wrapRefArray((Object[])cols));
    }

    public WindowSpec orderBy(String colName, String ... colNames) {
        return this.orderBy(colName, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public WindowSpec orderBy(Column ... cols) {
        return this.orderBy((Seq<Column>)Predef$.MODULE$.wrapRefArray((Object[])cols));
    }

    public WindowSpec partitionBy(String colName, Seq<String> colNames) {
        String string = colName;
        return this.partitionBy((Seq<Column>)((Seq)((TraversableLike)colNames.$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$2 -> Column$.MODULE$.apply((String)x$2), Seq$.MODULE$.canBuildFrom())));
    }

    public WindowSpec partitionBy(Seq<Column> cols) {
        return new WindowSpec((Seq<Expression>)((Seq)cols.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.expr(), Seq$.MODULE$.canBuildFrom())), this.orderSpec, this.frame);
    }

    public WindowSpec orderBy(String colName, Seq<String> colNames) {
        String string = colName;
        return this.orderBy((Seq<Column>)((Seq)((TraversableLike)colNames.$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$5 -> Column$.MODULE$.apply((String)x$5), Seq$.MODULE$.canBuildFrom())));
    }

    public WindowSpec orderBy(Seq<Column> cols) {
        Seq sortOrder = (Seq)cols.map((Function1 & Serializable & scala.Serializable)col -> {
            SortOrder sortOrder;
            Expression expression = col.expr();
            if (expression instanceof SortOrder) {
                SortOrder sortOrder2;
                sortOrder = sortOrder2 = (SortOrder)expression;
            } else if (expression != null) {
                Expression expression2 = expression;
                sortOrder = SortOrder$.MODULE$.apply(expression2, (SortDirection)Ascending$.MODULE$, SortOrder$.MODULE$.apply$default$3());
            } else {
                throw new MatchError((Object)expression);
            }
            return sortOrder;
        }, Seq$.MODULE$.canBuildFrom());
        return new WindowSpec(this.partitionSpec, (Seq<SortOrder>)sortOrder, this.frame);
    }

    public WindowSpec rowsBetween(long start, long end) {
        CurrentRow$ currentRow$;
        CurrentRow$ currentRow$2;
        long l = start;
        if (0L == l) {
            currentRow$2 = CurrentRow$.MODULE$;
        } else if (Long.MIN_VALUE == l) {
            currentRow$2 = UnboundedPreceding$.MODULE$;
        } else if (Integer.MIN_VALUE <= l && l <= Integer.MAX_VALUE) {
            currentRow$2 = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)((int)l)));
        } else {
            throw new AnalysisException(new StringBuilder(39).append("Boundary start is not a valid integer: ").append(l).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        CurrentRow$ boundaryStart = currentRow$2;
        long l2 = end;
        if (0L == l2) {
            currentRow$ = CurrentRow$.MODULE$;
        } else if (Long.MAX_VALUE == l2) {
            currentRow$ = UnboundedFollowing$.MODULE$;
        } else if (Integer.MIN_VALUE <= l2 && l2 <= Integer.MAX_VALUE) {
            currentRow$ = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)((int)l2)));
        } else {
            throw new AnalysisException(new StringBuilder(37).append("Boundary end is not a valid integer: ").append(l2).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        CurrentRow$ boundaryEnd = currentRow$;
        return new WindowSpec(this.partitionSpec, this.orderSpec, (WindowFrame)new SpecifiedWindowFrame((FrameType)RowFrame$.MODULE$, (Expression)boundaryStart, (Expression)boundaryEnd));
    }

    public WindowSpec rangeBetween(long start, long end) {
        long l = start;
        Object object = 0L == l ? CurrentRow$.MODULE$ : (Long.MIN_VALUE == l ? UnboundedPreceding$.MODULE$ : Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)l)));
        CurrentRow$ boundaryStart = object;
        long l2 = end;
        Object object2 = 0L == l2 ? CurrentRow$.MODULE$ : (Long.MAX_VALUE == l2 ? UnboundedFollowing$.MODULE$ : Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)l2)));
        CurrentRow$ boundaryEnd = object2;
        return new WindowSpec(this.partitionSpec, this.orderSpec, (WindowFrame)new SpecifiedWindowFrame((FrameType)RangeFrame$.MODULE$, (Expression)boundaryStart, (Expression)boundaryEnd));
    }

    public WindowSpec rangeBetween(Column start, Column end) {
        return new WindowSpec(this.partitionSpec, this.orderSpec, (WindowFrame)new SpecifiedWindowFrame((FrameType)RangeFrame$.MODULE$, start.expr(), end.expr()));
    }

    public Column withAggregate(Column aggregate) {
        WindowSpecDefinition spec = new WindowSpecDefinition(this.partitionSpec, this.orderSpec, this.frame);
        return new Column((Expression)new WindowExpression(aggregate.expr(), spec));
    }

    public WindowSpec(Seq<Expression> partitionSpec, Seq<SortOrder> orderSpec, WindowFrame frame) {
        this.partitionSpec = partitionSpec;
        this.orderSpec = orderSpec;
        this.frame = frame;
    }
}

