/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Optional;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.encoders.RowEncoder$;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.CurrentBatchTimestamp;
import org.apache.spark.sql.catalyst.expressions.CurrentDate;
import org.apache.spark.sql.catalyst.expressions.CurrentTimestamp;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.v2.StreamingDataSourceV2Relation;
import org.apache.spark.sql.execution.datasources.v2.WriteToDataSourceV2;
import org.apache.spark.sql.execution.streaming.BaseStreamingSink;
import org.apache.spark.sql.execution.streaming.BaseStreamingSource;
import org.apache.spark.sql.execution.streaming.CommitMetadata;
import org.apache.spark.sql.execution.streaming.FakeDataSourceV2$;
import org.apache.spark.sql.execution.streaming.IncrementalExecution;
import org.apache.spark.sql.execution.streaming.MemoryStream;
import org.apache.spark.sql.execution.streaming.MemoryStreamDataSource$;
import org.apache.spark.sql.execution.streaming.MicroBatchExecution$;
import org.apache.spark.sql.execution.streaming.Offset;
import org.apache.spark.sql.execution.streaming.OffsetSeq;
import org.apache.spark.sql.execution.streaming.OffsetSeqMetadata;
import org.apache.spark.sql.execution.streaming.OffsetSeqMetadata$;
import org.apache.spark.sql.execution.streaming.OneTimeExecutor;
import org.apache.spark.sql.execution.streaming.OneTimeTrigger$;
import org.apache.spark.sql.execution.streaming.ProcessingTimeExecutor;
import org.apache.spark.sql.execution.streaming.SerializedOffset;
import org.apache.spark.sql.execution.streaming.Sink;
import org.apache.spark.sql.execution.streaming.Source;
import org.apache.spark.sql.execution.streaming.StreamExecution;
import org.apache.spark.sql.execution.streaming.StreamExecution$;
import org.apache.spark.sql.execution.streaming.StreamingExecutionRelation;
import org.apache.spark.sql.execution.streaming.StreamingRelation;
import org.apache.spark.sql.execution.streaming.StreamingRelationV2;
import org.apache.spark.sql.execution.streaming.TERMINATED$;
import org.apache.spark.sql.execution.streaming.TriggerExecutor;
import org.apache.spark.sql.execution.streaming.WatermarkTracker;
import org.apache.spark.sql.execution.streaming.WatermarkTracker$;
import org.apache.spark.sql.execution.streaming.sources.MicroBatchWriter;
import org.apache.spark.sql.sources.v2.DataSourceOptions;
import org.apache.spark.sql.sources.v2.DataSourceV2;
import org.apache.spark.sql.sources.v2.MicroBatchReadSupport;
import org.apache.spark.sql.sources.v2.StreamWriteSupport;
import org.apache.spark.sql.sources.v2.reader.streaming.MicroBatchReader;
import org.apache.spark.sql.sources.v2.writer.streaming.StreamWriter;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.streaming.ProcessingTime;
import org.apache.spark.sql.streaming.StreamingQueryStatus;
import org.apache.spark.sql.streaming.Trigger;
import org.apache.spark.util.Clock;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t\rd\u0001B\u0016-\u0001eB\u0011B\u0010\u0001\u0003\u0002\u0003\u0006IaP\"\t\u0013\u0011\u0003!\u0011!Q\u0001\n\u0015\u0013\u0006\u0002C*\u0001\u0005\u0003\u0005\u000b\u0011B#\t\u0011Q\u0003!\u0011!Q\u0001\nUC\u0011b\u0018\u0001\u0003\u0002\u0003\u0006I\u0001Y2\t\u0013\u0011\u0004!\u0011!Q\u0001\n\u0015T\u0007\"C6\u0001\u0005\u0003\u0005\u000b\u0011\u00027s\u0011%\u0019\bA!A!\u0002\u0013!x\u000f\u0003\u0005y\u0001\t\u0005\t\u0015!\u0003z\u0011!a\bA!A!\u0002\u0013i\bbBA\u0002\u0001\u0011\u0005\u0011Q\u0001\u0005\n\u0003;\u0001\u0001\u0019!C\t\u0003?A\u0011\"!\u000f\u0001\u0001\u0004%\t\"a\u000f\t\u0011\u0005\u001d\u0003\u0001)Q\u0005\u0003CA\u0011\"!\u0015\u0001\u0005\u0004%I!a\u0015\t\u0011\u0005\u0015\u0005\u0001)A\u0005\u0003+B\u0011\"a\"\u0001\u0005\u0004%I!!#\t\u0011\u0005\r\u0006\u0001)A\u0005\u0003\u0017C1\"!*\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002(\"Y\u0011q\u0016\u0001A\u0002\u0003\u0007I\u0011BAY\u0011-\t)\f\u0001a\u0001\u0002\u0003\u0006K!!+\t\u0015\u0005]\u0006\u0001#b\u0001\n\u0003\nI\fC\u0005\u0002<\u0002\u0001\r\u0011\"\u0003\u0002>\"I\u0011q\u0018\u0001A\u0002\u0013%\u0011\u0011\u0019\u0005\b\u0003\u000b\u0004\u0001\u0015)\u0003~\u0011\u001d\t9\r\u0001C!\u0003\u0013Dq!a3\u0001\t#\ti\rC\u0004\u0002T\u0002!I!!6\t\u000f\u0005m\u0007\u0001\"\u0003\u0002>\"9\u0011Q\u001c\u0001\u0005\n\u0005}\u0007bBAs\u0001\u0011%\u0011q\u001d\u0005\t\u0003[\u0004A\u0011\u0001\u0019\u0002p\"9!1\u0003\u0001\u0005\n\tU\u0001\"\u0004B\u001b\u0001A\u0005\u0019\u0011!A\u0005\n\t]2\tC\u0007\u0003:\u0001\u0001\n1!A\u0001\n\u0013\u0011YD\u001d\u0005\u000e\u0005{\u0001\u0001\u0013aA\u0001\u0002\u0013%!qH<\t\u001b\t\u0005\u0003\u0001%A\u0002\u0002\u0003%IAa\u0011d\u000f\u001d\u0011)\u0005\fE\u0001\u0005\u000f2aa\u000b\u0017\t\u0002\t%\u0003bBA\u0002O\u0011\u0005!\u0011\u000b\u0005\n\u0005':#\u0019!C\u0001\u0005+B\u0001B!\u0019(A\u0003%!q\u000b\u0002\u0014\u001b&\u001c'o\u001c\"bi\u000eDW\t_3dkRLwN\u001c\u0006\u0003[9\n\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005=\u0002\u0014!C3yK\u000e,H/[8o\u0015\t\t$'A\u0002tc2T!a\r\u001b\u0002\u000bM\u0004\u0018M]6\u000b\u0005U2\u0014AB1qC\u000eDWMC\u00018\u0003\ry'oZ\u0002\u0001'\t\u0001!\b\u0005\u0002<y5\tA&\u0003\u0002>Y\ty1\u000b\u001e:fC6,\u00050Z2vi&|g.\u0001\u0007ta\u0006\u00148nU3tg&|g\u000e\u0005\u0002A\u00036\t\u0001'\u0003\u0002Ca\ta1\u000b]1sWN+7o]5p]&\u0011a\bP\u0001\u0005]\u0006lW\r\u0005\u0002G\u001f:\u0011q)\u0014\t\u0003\u0011.k\u0011!\u0013\u0006\u0003\u0015b\na\u0001\u0010:p_Rt$\"\u0001'\u0002\u000bM\u001c\u0017\r\\1\n\u00059[\u0015A\u0002)sK\u0012,g-\u0003\u0002Q#\n11\u000b\u001e:j]\u001eT!AT&\n\u0005\u0011c\u0014AD2iK\u000e\\\u0007o\\5oiJ{w\u000e^\u0001\rC:\fG.\u001f>fIBc\u0017M\u001c\t\u0003-vk\u0011a\u0016\u0006\u00031f\u000bq\u0001\\8hS\u000e\fGN\u0003\u0002[7\u0006)\u0001\u000f\\1og*\u0011A\fM\u0001\tG\u0006$\u0018\r\\=ti&\u0011al\u0016\u0002\f\u0019><\u0017nY1m!2\fg.\u0001\u0003tS:\\\u0007CA\u001eb\u0013\t\u0011GFA\tCCN,7\u000b\u001e:fC6LgnZ*j].L!a\u0018\u001f\u0002\u000fQ\u0014\u0018nZ4feB\u0011a\r[\u0007\u0002O*\u0011Q\u0006M\u0005\u0003S\u001e\u0014q\u0001\u0016:jO\u001e,'/\u0003\u0002ey\u0005aAO]5hO\u0016\u00148\t\\8dWB\u0011Q\u000e]\u0007\u0002]*\u0011qNM\u0001\u0005kRLG.\u0003\u0002r]\n)1\t\\8dW&\u00111\u000eP\u0001\u000b_V$\b/\u001e;N_\u0012,\u0007C\u00014v\u0013\t1xM\u0001\u0006PkR\u0004X\u000f^'pI\u0016L!a\u001d\u001f\u0002\u0019\u0015DHO]1PaRLwN\\:\u0011\t\u0019SX)R\u0005\u0003wF\u00131!T1q\u0003Y!W\r\\3uK\u000eCWmY6q_&tGo\u00148Ti>\u0004\bC\u0001@\u0000\u001b\u0005Y\u0015bAA\u0001\u0017\n9!i\\8mK\u0006t\u0017A\u0002\u001fj]&$h\b\u0006\f\u0002\b\u0005%\u00111BA\u0007\u0003\u001f\t\t\"a\u0005\u0002\u0016\u0005]\u0011\u0011DA\u000e!\tY\u0004\u0001C\u0003?\u0017\u0001\u0007q\bC\u0003E\u0017\u0001\u0007Q\tC\u0003T\u0017\u0001\u0007Q\tC\u0003U\u0017\u0001\u0007Q\u000bC\u0003`\u0017\u0001\u0007\u0001\rC\u0003e\u0017\u0001\u0007Q\rC\u0003l\u0017\u0001\u0007A\u000eC\u0003t\u0017\u0001\u0007A\u000fC\u0003y\u0017\u0001\u0007\u0011\u0010C\u0003}\u0017\u0001\u0007Q0A\u0004t_V\u00148-Z:\u0016\u0005\u0005\u0005\u0002CBA\u0012\u0003[\t\u0019D\u0004\u0003\u0002&\u0005%bb\u0001%\u0002(%\tA*C\u0002\u0002,-\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u00020\u0005E\"aA*fc*\u0019\u00111F&\u0011\u0007m\n)$C\u0002\u000281\u00121CQ1tKN#(/Z1nS:<7k\\;sG\u0016\f1b]8ve\u000e,7o\u0018\u0013fcR!\u0011QHA\"!\rq\u0018qH\u0005\u0004\u0003\u0003Z%\u0001B+oSRD\u0011\"!\u0012\u000e\u0003\u0003\u0005\r!!\t\u0002\u0007a$\u0013'\u0001\u0005t_V\u00148-Z:!Q\rq\u00111\n\t\u0004}\u00065\u0013bAA(\u0017\nAao\u001c7bi&dW-A\u000bsK\u0006$WM\u001d+p\t\u0006$\u0018mU8ve\u000e,W*\u00199\u0016\u0005\u0005U\u0003\u0003CA,\u0003C\n\u0019'a\u001e\u000e\u0005\u0005e#\u0002BA.\u0003;\nq!\\;uC\ndWMC\u0002\u0002`-\u000b!bY8mY\u0016\u001cG/[8o\u0013\rY\u0018\u0011\f\t\u0005\u0003K\n\u0019(\u0004\u0002\u0002h)\u0019Q&!\u001b\u000b\t\u0005-\u0014QN\u0001\u0007e\u0016\fG-\u001a:\u000b\t\u0005=\u0014\u0011O\u0001\u0003mJR1!!\b1\u0013\u0011\t)(a\u001a\u0003!5K7M]8CCR\u001c\u0007NU3bI\u0016\u0014\bC\u0002@\u0002z\u0005u\u00140C\u0002\u0002|-\u0013a\u0001V;qY\u0016\u0014\u0004\u0003BA@\u0003\u0003k!!!\u001c\n\t\u0005\r\u0015Q\u000e\u0002\r\t\u0006$\u0018mU8ve\u000e,gKM\u0001\u0017e\u0016\fG-\u001a:U_\u0012\u000bG/Y*pkJ\u001cW-T1qA\u0005yAO]5hO\u0016\u0014X\t_3dkR|'/\u0006\u0002\u0002\fJA\u0011QRAI\u0003/\u000biJ\u0002\u0004\u0002\u0010\u0002\u0001\u00111\u0012\u0002\ryI,g-\u001b8f[\u0016tGO\u0010\t\u0004}\u0006M\u0015bAAK\u0017\n9\u0001K]8ek\u000e$\bc\u0001@\u0002\u001a&\u0019\u00111T&\u0003\u0019M+'/[1mSj\f'\r\\3\u0011\u0007m\ny*C\u0002\u0002\"2\u0012q\u0002\u0016:jO\u001e,'/\u0012=fGV$xN]\u0001\u0011iJLwmZ3s\u000bb,7-\u001e;pe\u0002\n\u0001c^1uKJl\u0017M]6Ue\u0006\u001c7.\u001a:\u0016\u0005\u0005%\u0006cA\u001e\u0002,&\u0019\u0011Q\u0016\u0017\u0003!]\u000bG/\u001a:nCJ\\GK]1dW\u0016\u0014\u0018\u0001F<bi\u0016\u0014X.\u0019:l)J\f7m[3s?\u0012*\u0017\u000f\u0006\u0003\u0002>\u0005M\u0006\"CA#)\u0005\u0005\t\u0019AAU\u0003E9\u0018\r^3s[\u0006\u00148\u000e\u0016:bG.,'\u000fI\u0001\fY><\u0017nY1m!2\fg.F\u0001V\u0003eI7oQ;se\u0016tGOQ1uG\"\u001cuN\\:ueV\u001cG/\u001a3\u0016\u0003u\fQ$[:DkJ\u0014XM\u001c;CCR\u001c\u0007nQ8ogR\u0014Xo\u0019;fI~#S-\u001d\u000b\u0005\u0003{\t\u0019\r\u0003\u0005\u0002Fa\t\t\u00111\u0001~\u0003iI7oQ;se\u0016tGOQ1uG\"\u001cuN\\:ueV\u001cG/\u001a3!\u0003\u0011\u0019Ho\u001c9\u0015\u0005\u0005u\u0012A\u0005:v]\u0006\u001bG/\u001b<bi\u0016$7\u000b\u001e:fC6$B!!\u0010\u0002P\"1\u0011\u0011[\u000eA\u0002}\nQc\u001d9be.\u001cVm]:j_:4uN]*ue\u0016\fW.\u0001\u000bq_B,H.\u0019;f'R\f'\u000f^(gMN,Go\u001d\u000b\u0005\u0003{\t9\u000e\u0003\u0004\u0002Zr\u0001\raP\u0001\u0019gB\f'o[*fgNLwN\u001c+p%Vt')\u0019;dQ\u0016\u001c\u0018AE5t\u001d\u0016<H)\u0019;b\u0003Z\f\u0017\u000e\\1cY\u0016\f!cY8ogR\u0014Xo\u0019;OKb$()\u0019;dQR\u0019Q0!9\t\r\u0005\rh\u00041\u0001~\u0003Qqw\u000eR1uC\n\u000bGo\u00195fg\u0016s\u0017M\u00197fI\u0006A!/\u001e8CCR\u001c\u0007\u000e\u0006\u0003\u0002>\u0005%\bBBAv?\u0001\u0007q(\u0001\fta\u0006\u00148nU3tg&|g\u000eV8Sk:\u0014\u0015\r^2i\u0003I9\u0018\u000e\u001e5Qe><'/Z:t\u0019>\u001c7.\u001a3\u0016\t\u0005E\u0018q\u001f\u000b\u0005\u0003g\u0014I\u0001\u0005\u0003\u0002v\u0006]H\u0002\u0001\u0003\b\u0003s\u0004#\u0019AA~\u0005\u0005!\u0016\u0003BA\u007f\u0005\u0007\u00012A`A\u0000\u0013\r\u0011\ta\u0013\u0002\b\u001d>$\b.\u001b8h!\rq(QA\u0005\u0004\u0005\u000fY%aA!os\"A!1\u0002\u0011\u0005\u0002\u0004\u0011i!A\u0001g!\u0015q(qBAz\u0013\r\u0011\tb\u0013\u0002\ty\tLh.Y7f}\u00051Ao\u001c&bm\u0006$BAa\u0006\u0003,A1!\u0011\u0004B\u0011\u0005Ki!Aa\u0007\u000b\u0007=\u0014iB\u0003\u0002\u0003 \u0005!!.\u0019<b\u0013\u0011\u0011\u0019Ca\u0007\u0003\u0011=\u0003H/[8oC2\u0004B!!\u001a\u0003(%!!\u0011FA4\u0005\u0019yeMZ:fi\"9!QF\u0011A\u0002\t=\u0012aC:dC2\fw\n\u001d;j_:\u0004RA B\u0019\u0005KI1Aa\rL\u0005\u0019y\u0005\u000f^5p]\u0006\u00112/\u001e9fe\u0012\u001a\b/\u0019:l'\u0016\u001c8/[8o+\u0005y\u0014AE:va\u0016\u0014H\u0005\u001e:jO\u001e,'o\u00117pG.,\u0012\u0001\\\u0001\u0011gV\u0004XM\u001d\u0013pkR\u0004X\u000f^'pI\u0016,\u0012\u0001^\u0001\u000bgV\u0004XM\u001d\u0013tS:\\W#\u00011\u0002'5K7M]8CCR\u001c\u0007.\u0012=fGV$\u0018n\u001c8\u0011\u0005m:3cA\u0014\u0003LA\u0019aP!\u0014\n\u0007\t=3J\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0005\u000f\nABQ!U\u0007\"{\u0016\nR0L\u000bf+\"Aa\u0016\u0011\t\te#qL\u0007\u0003\u00057RAA!\u0018\u0003\u001e\u0005!A.\u00198h\u0013\r\u0001&1L\u0001\u000e\u0005\u0006#6\tS0J\t~[U)\u0017\u0011")
public class MicroBatchExecution
extends StreamExecution {
    private LogicalPlan logicalPlan;
    private final LogicalPlan analyzedPlan;
    private final scala.collection.immutable.Map<String, String> extraOptions;
    private volatile Seq<BaseStreamingSource> sources;
    private final scala.collection.mutable.Map<MicroBatchReader, Tuple2<DataSourceV2, scala.collection.immutable.Map<String, String>>> org$apache$spark$sql$execution$streaming$MicroBatchExecution$$readerToDataSourceMap;
    private final Product triggerExecutor;
    private WatermarkTracker watermarkTracker;
    private boolean isCurrentBatchConstructed;
    private volatile boolean bitmap$0;

    public static String BATCH_ID_KEY() {
        return MicroBatchExecution$.MODULE$.BATCH_ID_KEY();
    }

    public /* synthetic */ SparkSession org$apache$spark$sql$execution$streaming$MicroBatchExecution$$super$sparkSession() {
        return super.sparkSession();
    }

    private /* synthetic */ Clock super$triggerClock() {
        return super.triggerClock();
    }

    private /* synthetic */ OutputMode super$outputMode() {
        return super.outputMode();
    }

    private /* synthetic */ BaseStreamingSink super$sink() {
        return super.sink();
    }

    @Override
    public Seq<BaseStreamingSource> sources() {
        return this.sources;
    }

    public void sources_$eq(Seq<BaseStreamingSource> x$1) {
        this.sources = x$1;
    }

    public scala.collection.mutable.Map<MicroBatchReader, Tuple2<DataSourceV2, scala.collection.immutable.Map<String, String>>> org$apache$spark$sql$execution$streaming$MicroBatchExecution$$readerToDataSourceMap() {
        return this.org$apache$spark$sql$execution$streaming$MicroBatchExecution$$readerToDataSourceMap;
    }

    private Product triggerExecutor() {
        return this.triggerExecutor;
    }

    private WatermarkTracker watermarkTracker() {
        return this.watermarkTracker;
    }

    private void watermarkTracker_$eq(WatermarkTracker x$1) {
        this.watermarkTracker = x$1;
    }

    private LogicalPlan logicalPlan$lzycompute() {
        MicroBatchExecution microBatchExecution = this;
        synchronized (microBatchExecution) {
            if (!this.bitmap$0) {
                Predef$.MODULE$.assert(this.queryExecutionThread() == Thread.currentThread(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(83).append("logicalPlan must be initialized in QueryExecutionThread ").append("but the current thread was ").append(Thread.currentThread()).toString());
                LongRef nextSourceId = LongRef.create((long)0L);
                scala.collection.mutable.Map toExecutionRelationMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
                scala.collection.mutable.Map v2ToExecutionRelationMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
                String[] disabledSources = super.sparkSession().sqlContext().conf().disabledV2StreamingMicroBatchReaders().split(",");
                LogicalPlan _logicalPlan = (LogicalPlan)this.analyzedPlan.transform((PartialFunction)new scala.Serializable(this, toExecutionRelationMap, nextSourceId, disabledSources, v2ToExecutionRelationMap){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ MicroBatchExecution $outer;
                    private final scala.collection.mutable.Map toExecutionRelationMap$1;
                    private final LongRef nextSourceId$1;
                    private final String[] disabledSources$1;
                    private final scala.collection.mutable.Map v2ToExecutionRelationMap$1;

                    /*
                     * Enabled aggressive block sorting
                     */
                    public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        boolean bl = false;
                        StreamingRelationV2 streamingRelationV2 = null;
                        A1 A1 = x1;
                        if (A1 instanceof StreamingRelation) {
                            StreamingRelation streamingRelation = (StreamingRelation)A1;
                            DataSource dataSourceV1 = streamingRelation.dataSource();
                            String sourceName = streamingRelation.sourceName();
                            Seq<Attribute> output = streamingRelation.output();
                            object = this.toExecutionRelationMap$1.getOrElseUpdate((Object)((Object)streamingRelation), (Function0 & Serializable & scala.Serializable)() -> {
                                String metadataPath = new StringBuilder(9).append($this.$outer.resolvedCheckpointRoot()).append("/sources/").append($this.nextSourceId$1.elem).toString();
                                Source source = dataSourceV1.createSource(metadataPath);
                                ++$this.nextSourceId$1.elem;
                                $this.$outer.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Using Source [").append(source).append("] from DataSourceV1 named '").append(sourceName).append("' [").append(dataSourceV1).append("]").toString());
                                return new StreamingExecutionRelation(source, output, $this.$outer.org$apache$spark$sql$execution$streaming$MicroBatchExecution$$super$sparkSession());
                            });
                            return (B1)object;
                        }
                        if (A1 instanceof StreamingRelationV2) {
                            bl = true;
                            streamingRelationV2 = (StreamingRelationV2)A1;
                            DataSourceV2 dataSourceV2 = streamingRelationV2.dataSource();
                            String sourceName = streamingRelationV2.sourceName();
                            scala.collection.immutable.Map<String, String> options = streamingRelationV2.extraOptions();
                            Seq<Attribute> output = streamingRelationV2.output();
                            if (dataSourceV2 instanceof MicroBatchReadSupport) {
                                MicroBatchReadSupport microBatchReadSupport = (MicroBatchReadSupport)dataSourceV2;
                                if (!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.disabledSources$1)).contains((Object)microBatchReadSupport.getClass().getCanonicalName())) {
                                    object = this.v2ToExecutionRelationMap$1.getOrElseUpdate((Object)((Object)streamingRelationV2), (Function0 & Serializable & scala.Serializable)() -> {
                                        String metadataPath = new StringBuilder(9).append($this.$outer.resolvedCheckpointRoot()).append("/sources/").append($this.nextSourceId$1.elem).toString();
                                        MicroBatchReader reader = microBatchReadSupport.createMicroBatchReader(Optional.empty(), metadataPath, new DataSourceOptions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)options).asJava()));
                                        ++$this.nextSourceId$1.elem;
                                        $this.$outer.org$apache$spark$sql$execution$streaming$MicroBatchExecution$$readerToDataSourceMap().update((Object)reader, (Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)microBatchReadSupport), (Object)options));
                                        $this.$outer.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Using MicroBatchReader [").append(reader).append("] from ").append("DataSourceV2 named '").append(sourceName).append("' [").append(microBatchReadSupport).append("]").toString());
                                        return new StreamingExecutionRelation(reader, output, $this.$outer.org$apache$spark$sql$execution$streaming$MicroBatchExecution$$super$sparkSession());
                                    });
                                    return (B1)object;
                                }
                            }
                        }
                        if (bl) {
                            DataSourceV2 dataSourceV2 = streamingRelationV2.dataSource();
                            String sourceName = streamingRelationV2.sourceName();
                            Seq<Attribute> output = streamingRelationV2.output();
                            Option<StreamingRelation> v1Relation = streamingRelationV2.v1Relation();
                            object = this.v2ToExecutionRelationMap$1.getOrElseUpdate((Object)((Object)streamingRelationV2), (Function0 & Serializable & scala.Serializable)() -> {
                                String metadataPath = new StringBuilder(9).append($this.$outer.resolvedCheckpointRoot()).append("/sources/").append($this.nextSourceId$1.elem).toString();
                                if (v1Relation.isEmpty()) {
                                    throw new UnsupportedOperationException(new StringBuilder(52).append("Data source ").append(sourceName).append(" does not support microbatch processing.").toString());
                                }
                                Source source = ((StreamingRelation)((Object)((Object)v1Relation.get()))).dataSource().createSource(metadataPath);
                                ++$this.nextSourceId$1.elem;
                                $this.$outer.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Using Source [").append(source).append("] from DataSourceV2 named '").append(sourceName).append("' [").append(dataSourceV2).append("]").toString());
                                return new StreamingExecutionRelation(source, output, $this.$outer.org$apache$spark$sql$execution$streaming$MicroBatchExecution$$super$sparkSession());
                            });
                            return (B1)object;
                        }
                        object = function1.apply(x1);
                        return (B1)object;
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final boolean isDefinedAt(LogicalPlan x1) {
                        boolean bl = false;
                        StreamingRelationV2 streamingRelationV2 = null;
                        LogicalPlan logicalPlan2 = x1;
                        if (logicalPlan2 instanceof StreamingRelation) {
                            return true;
                        }
                        if (logicalPlan2 instanceof StreamingRelationV2) {
                            bl = true;
                            streamingRelationV2 = (StreamingRelationV2)logicalPlan2;
                            DataSourceV2 dataSourceV2 = streamingRelationV2.dataSource();
                            if (dataSourceV2 instanceof MicroBatchReadSupport) {
                                MicroBatchReadSupport microBatchReadSupport = (MicroBatchReadSupport)dataSourceV2;
                                if (!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.disabledSources$1)).contains((Object)microBatchReadSupport.getClass().getCanonicalName())) {
                                    return true;
                                }
                            }
                        }
                        if (!bl) return false;
                        return true;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.toExecutionRelationMap$1 = toExecutionRelationMap$1;
                        this.nextSourceId$1 = nextSourceId$1;
                        this.disabledSources$1 = disabledSources$1;
                        this.v2ToExecutionRelationMap$1 = v2ToExecutionRelationMap$1;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.spark.sql.execution.streaming.MicroBatchExecution$$anonfun$1 org.apache.spark.sql.execution.datasources.DataSource java.lang.String scala.collection.Seq ), $anonfun$applyOrElse$3(org.apache.spark.sql.execution.streaming.MicroBatchExecution$$anonfun$1 org.apache.spark.sql.sources.v2.MicroBatchReadSupport scala.collection.immutable.Map java.lang.String scala.collection.Seq ), $anonfun$applyOrElse$5(org.apache.spark.sql.execution.streaming.MicroBatchExecution$$anonfun$1 scala.Option java.lang.String org.apache.spark.sql.sources.v2.DataSourceV2 scala.collection.Seq ), $anonfun$applyOrElse$2(org.apache.spark.sql.execution.streaming.Source java.lang.String org.apache.spark.sql.execution.datasources.DataSource ), $anonfun$applyOrElse$4(org.apache.spark.sql.sources.v2.reader.streaming.MicroBatchReader java.lang.String org.apache.spark.sql.sources.v2.MicroBatchReadSupport ), $anonfun$applyOrElse$6(org.apache.spark.sql.execution.streaming.Source java.lang.String org.apache.spark.sql.sources.v2.DataSourceV2 )}, serializedLambda);
                    }
                });
                this.sources_$eq((Seq<BaseStreamingSource>)_logicalPlan.collect((PartialFunction)new scala.Serializable(null){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x2;
                        if (A1 instanceof StreamingExecutionRelation) {
                            StreamingExecutionRelation streamingExecutionRelation = (StreamingExecutionRelation)A1;
                            object = streamingExecutionRelation.source();
                        } else {
                            object = function1.apply(x2);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(LogicalPlan x2) {
                        LogicalPlan logicalPlan2 = x2;
                        boolean bl = logicalPlan2 instanceof StreamingExecutionRelation;
                        return bl;
                    }
                }));
                this.uniqueSources_$eq((Seq<BaseStreamingSource>)((Seq)this.sources().distinct()));
                this.logicalPlan = _logicalPlan;
                this.bitmap$0 = true;
            }
        }
        return this.logicalPlan;
    }

    @Override
    public LogicalPlan logicalPlan() {
        return !this.bitmap$0 ? this.logicalPlan$lzycompute() : this.logicalPlan;
    }

    private boolean isCurrentBatchConstructed() {
        return this.isCurrentBatchConstructed;
    }

    private void isCurrentBatchConstructed_$eq(boolean x$1) {
        this.isCurrentBatchConstructed = x$1;
    }

    @Override
    public void stop() {
        this.state().set(TERMINATED$.MODULE$);
        if (this.queryExecutionThread().isAlive()) {
            super.sparkSession().sparkContext().cancelJobGroup(this.runId().toString());
            this.queryExecutionThread().interrupt();
            this.queryExecutionThread().join();
            super.sparkSession().sparkContext().cancelJobGroup(this.runId().toString());
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Query ").append(this.prettyIdString()).append(" was stopped").toString());
    }

    @Override
    public void runActivatedStream(SparkSession sparkSessionForStream) {
        boolean noDataBatchesEnabled = sparkSessionForStream.sessionState().conf().streamingNoDataMicroBatchesEnabled();
        ((TriggerExecutor)this.triggerExecutor()).execute((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            if (this.isActive()) {
                BooleanRef currentBatchHasNewData = BooleanRef.create((boolean)false);
                this.startTrigger();
                this.reportTimeTaken("triggerExecution", (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    if (this.currentBatchId() < 0L) {
                        this.populateStartOffsets(sparkSessionForStream);
                        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Stream started from ").append(this.committedOffsets()).toString());
                    }
                    this.org$apache$spark$sql$execution$streaming$MicroBatchExecution$$super$sparkSession().sparkContext().setJobDescription(this.getBatchDescriptionString());
                    if (!this.isCurrentBatchConstructed()) {
                        this.isCurrentBatchConstructed_$eq(this.constructNextBatch(noDataBatchesEnabled));
                    }
                    this.recordTriggerOffsets(this.committedOffsets(), this.availableOffsets());
                    currentBatchHasNewData$1.elem = this.isNewDataAvailable();
                    StreamingQueryStatus qual$1 = this.currentStatus();
                    boolean x$1 = this.isNewDataAvailable();
                    String x$2 = qual$1.copy$default$1();
                    boolean x$3 = qual$1.copy$default$3();
                    this.currentStatus_$eq(qual$1.copy(x$2, x$1, x$3));
                    if (this.isCurrentBatchConstructed()) {
                        if (currentBatchHasNewData$1.elem) {
                            this.updateStatusMessage("Processing new data");
                        } else {
                            this.updateStatusMessage("No new data but cleaning up state");
                        }
                        this.runBatch(sparkSessionForStream);
                    } else {
                        this.updateStatusMessage("Waiting for data to arrive");
                    }
                });
                this.finishTrigger(currentBatchHasNewData.elem);
                this.withProgressLocked((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.awaitProgressLockCondition().signalAll());
                if (this.isCurrentBatchConstructed()) {
                    this.currentBatchId_$eq(this.currentBatchId() + 1L);
                    this.isCurrentBatchConstructed_$eq(false);
                } else {
                    Thread.sleep(this.pollingDelayMs());
                }
            }
            this.updateStatusMessage("Waiting for next trigger");
            return this.isActive();
        });
    }

    private void populateStartOffsets(SparkSession sparkSessionToRunBatches) {
        Some some;
        Tuple2 tuple2;
        Option option = this.offsetLog().getLatest();
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            Some some2;
            Tuple2 tuple22;
            long latestBatchId = tuple2._1$mcJ$sp();
            OffsetSeq nextOffsets = (OffsetSeq)tuple2._2();
            this.currentBatchId_$eq(latestBatchId);
            this.isCurrentBatchConstructed_$eq(true);
            this.availableOffsets_$eq(nextOffsets.toStreamProgress(this.sources()));
            if (latestBatchId != 0L) {
                OffsetSeq secondLatestBatchId = (OffsetSeq)this.offsetLog().get(latestBatchId - 1L).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw new IllegalStateException(new StringBuilder(20).append("batch ").append(latestBatchId - 1L).append(" doesn't exist").toString());
                });
                this.committedOffsets_$eq(secondLatestBatchId.toStreamProgress(this.sources()));
            }
            nextOffsets.metadata().foreach((Function1 & Serializable & scala.Serializable)metadata -> {
                MicroBatchExecution.$anonfun$populateStartOffsets$2(this, sparkSessionToRunBatches, metadata);
                return BoxedUnit.UNIT;
            });
            Option option2 = this.commitLog().getLatest();
            if (option2 instanceof Some && (tuple22 = (Tuple2)(some2 = (Some)option2).value()) != null) {
                BoxedUnit boxedUnit;
                long latestCommittedBatchId = tuple22._1$mcJ$sp();
                CommitMetadata commitMetadata = (CommitMetadata)tuple22._2();
                if (latestBatchId == latestCommittedBatchId) {
                    this.availableOffsets().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        void var2_10;
                        Tuple2 tuple2 = x0$1;
                        if (tuple2 != null) {
                            BaseStreamingSource source = (BaseStreamingSource)tuple2._1();
                            Offset end = (Offset)tuple2._2();
                            if (source instanceof Source) {
                                Source source2 = (Source)source;
                                if (end != null) {
                                    Offset offset = end;
                                    Option<Offset> start = this.committedOffsets().get(source2);
                                    Dataset<Row> dataset = source2.getBatch(start, offset);
                                    return var2_10;
                                }
                            }
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return var2_10;
                    });
                    this.currentBatchId_$eq(latestCommittedBatchId + 1L);
                    this.isCurrentBatchConstructed_$eq(false);
                    this.committedOffsets_$eq(this.committedOffsets().$plus$plus((GenTraversableOnce<Tuple2<BaseStreamingSource, Offset>>)this.availableOffsets()));
                    this.watermarkTracker().setWatermark(package$.MODULE$.max(this.watermarkTracker().currentWatermark(), commitMetadata.nextBatchWatermarkMs()));
                    boxedUnit = BoxedUnit.UNIT;
                } else if (latestCommittedBatchId == latestBatchId - 1L) {
                    this.availableOffsets().foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                        Tuple2 tuple2 = x0$2;
                        if (tuple2 == null) return BoxedUnit.UNIT;
                        BaseStreamingSource source = (BaseStreamingSource)tuple2._1();
                        Offset end = (Offset)tuple2._2();
                        if (!(source instanceof Source)) return BoxedUnit.UNIT;
                        Source source2 = (Source)source;
                        if (end == null) return BoxedUnit.UNIT;
                        Offset offset = end;
                        Option start = this.committedOffsets().get(source2).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1);
                        return BoxesRunTime.unboxToBoolean((Object)start.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)MicroBatchExecution.$anonfun$populateStartOffsets$6(offset, x$2))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true)) ? source2.getBatch((Option<Offset>)start, offset) : BoxedUnit.UNIT;
                    });
                    boxedUnit = BoxedUnit.UNIT;
                } else if (latestCommittedBatchId < latestBatchId - 1L) {
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(79).append("Batch completion log latest batch id is ").append(latestCommittedBatchId).append(", which is not trailing ").append("batchid ").append(latestBatchId).append(" by one").toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            } else if (None$.MODULE$.equals(option2)) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "no commit log present");
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError(option2);
            }
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(65).append("Resuming at batch ").append(this.currentBatchId()).append(" with committed offsets ").append(this.committedOffsets()).append(" and available offsets ").append(this.availableOffsets()).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Starting new streaming query.");
            this.currentBatchId_$eq(0L);
            this.watermarkTracker_$eq(WatermarkTracker$.MODULE$.apply(sparkSessionToRunBatches.conf()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
    }

    private boolean isNewDataAvailable() {
        return this.availableOffsets().exists((Function1<Tuple2<BaseStreamingSource, Offset>, Object>)(Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MicroBatchExecution.$anonfun$isNewDataAvailable$1(this, x0$1)));
    }

    private boolean constructNextBatch(boolean noDataBatchesEnabled) {
        boolean bl;
        Object object = new Object();
        try {
            bl = BoxesRunTime.unboxToBoolean(this.withProgressLocked((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                if (this.isCurrentBatchConstructed()) {
                    throw new NonLocalReturnControl.mcZ.sp(object, true);
                }
                scala.collection.immutable.Map latestOffsets = ((TraversableOnce)this.uniqueSources().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2;
                    BaseStreamingSource baseStreamingSource = x0$1;
                    if (baseStreamingSource instanceof Source) {
                        Source source = (Source)baseStreamingSource;
                        this.updateStatusMessage(new StringBuilder(21).append("Getting offsets from ").append(source).toString());
                        tuple2 = (Tuple2)this.reportTimeTaken("getOffset", (Function0 & Serializable & scala.Serializable)() -> new Tuple2((Object)source, source.getOffset()));
                    } else if (baseStreamingSource instanceof MicroBatchReader) {
                        MicroBatchReader microBatchReader = (MicroBatchReader)baseStreamingSource;
                        this.updateStatusMessage(new StringBuilder(21).append("Getting offsets from ").append(microBatchReader).toString());
                        this.reportTimeTaken("setOffsetRange", (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> microBatchReader.setOffsetRange(this.toJava((Option<org.apache.spark.sql.sources.v2.reader.streaming.Offset>)this.availableOffsets().get(microBatchReader).map((Function1 & Serializable & scala.Serializable)off -> microBatchReader.deserializeOffset(off.json()))), Optional.empty()));
                        org.apache.spark.sql.sources.v2.reader.streaming.Offset currentOffset = (org.apache.spark.sql.sources.v2.reader.streaming.Offset)this.reportTimeTaken("getEndOffset", (Function0 & Serializable & scala.Serializable)() -> microBatchReader.getEndOffset());
                        tuple2 = new Tuple2((Object)microBatchReader, (Object)Option$.MODULE$.apply((Object)currentOffset));
                    } else {
                        throw new MatchError((Object)baseStreamingSource);
                    }
                    return tuple2;
                }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                this.availableOffsets_$eq(this.availableOffsets().$plus$plus((GenTraversableOnce<Tuple2<BaseStreamingSource, Offset>>)((MapLike)latestOffsets.filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)MicroBatchExecution.$anonfun$constructNextBatch$7(x0$2)))).mapValues((Function1 & Serializable & scala.Serializable)x$3 -> (Offset)x$3.get())));
                OffsetSeqMetadata qual$1 = this.offsetSeqMetadata();
                long x$1 = this.watermarkTracker().currentWatermark();
                long x$2 = this.super$triggerClock().getTimeMillis();
                scala.collection.immutable.Map<String, String> x$32 = qual$1.copy$default$3();
                this.offsetSeqMetadata_$eq(qual$1.copy(x$1, x$2, x$32));
                boolean lastExecutionRequiresAnotherBatch = noDataBatchesEnabled && Option$.MODULE$.apply((Object)this.lastExecution()).exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.shouldRunAnotherBatch(this.offsetSeqMetadata())));
                boolean shouldConstructNextBatch = this.isNewDataAvailable() || lastExecutionRequiresAnotherBatch;
                this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(113).append("noDataBatchesEnabled = ").append(noDataBatchesEnabled).append(", ").append("lastExecutionRequiresAnotherBatch = ").append(lastExecutionRequiresAnotherBatch).append(", ").append("isNewDataAvailable = ").append(this.isNewDataAvailable()).append(", ").append("shouldConstructNextBatch = ").append(shouldConstructNextBatch).toString());
                if (shouldConstructNextBatch) {
                    this.updateStatusMessage("Writing offsets to log");
                    this.reportTimeTaken("walCommit", (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                        block3: {
                            Predef$.MODULE$.assert(this.offsetLog().add(this.currentBatchId(), this.availableOffsets().toOffsetSeq(this.sources(), this.offsetSeqMetadata())), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append("Concurrent update to the log. Multiple streaming jobs detected for ").append(this.currentBatchId()).toString());
                            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Committed offsets for batch ").append(this.currentBatchId()).append(". ").append("Metadata ").append(this.offsetSeqMetadata().toString()).toString());
                            if (this.currentBatchId() != 0L) {
                                Option prevBatchOff = this.offsetLog().get(this.currentBatchId() - 1L);
                                if (prevBatchOff.isDefined()) {
                                    ((OffsetSeq)prevBatchOff.get()).toStreamProgress(this.sources()).foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
                                        MicroBatchExecution.$anonfun$constructNextBatch$14(x0$3);
                                        return BoxedUnit.UNIT;
                                    });
                                } else {
                                    throw new IllegalStateException(new StringBuilder(20).append("batch ").append(this.currentBatchId() - 1L).append(" doesn't exist").toString());
                                }
                            }
                            if ((long)this.minLogEntriesToMaintain() >= this.currentBatchId()) break block3;
                            this.offsetLog().purge(this.currentBatchId() - (long)this.minLogEntriesToMaintain());
                            this.commitLog().purge(this.currentBatchId() - (long)this.minLogEntriesToMaintain());
                        }
                    });
                    this.noNewData_$eq(false);
                } else {
                    this.noNewData_$eq(true);
                    this.awaitProgressLockCondition().signalAll();
                }
                return shouldConstructNextBatch;
            }));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                bl = ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    private void runBatch(SparkSession sparkSessionToRunBatch) {
        LogicalPlan logicalPlan2;
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(14).append("Running batch ").append(this.currentBatchId()).toString());
        this.newData_$eq((scala.collection.immutable.Map<BaseStreamingSource, LogicalPlan>)((scala.collection.immutable.Map)this.reportTimeTaken("getBatch", (Function0 & Serializable & scala.Serializable)() -> (scala.collection.immutable.Map)this.availableOffsets().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            org.apache.spark.sql.sources.v2.reader.streaming.Offset offset;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                BaseStreamingSource source = (BaseStreamingSource)tuple2._1();
                Offset available = (Offset)tuple2._2();
                if (source instanceof Source) {
                    Source source2 = (Source)source;
                    if (BoxesRunTime.unboxToBoolean((Object)this.committedOffsets().get(source2).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)MicroBatchExecution.$anonfun$runBatch$4(available, x$5))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true))) {
                        Option<Offset> current = this.committedOffsets().get(source2);
                        Dataset<Row> batch = source2.getBatch(current, available);
                        Predef$.MODULE$.assert(batch.isStreaming(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append("DataFrame returned by getBatch from ").append(source2).append(" did not have isStreaming=true\n").append(batch.queryExecution().logical()).toString());
                        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Retrieving data from ").append(source2).append(": ").append(current).append(" -> ").append(available).toString());
                        return Option$.MODULE$.option2Iterable((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)source2), (Object)batch.logicalPlan())));
                    }
                }
            }
            if (tuple2 == null) return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            BaseStreamingSource reader = (BaseStreamingSource)tuple2._1();
            Offset available = (Offset)tuple2._2();
            if (!(reader instanceof MicroBatchReader)) return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            MicroBatchReader microBatchReader = (MicroBatchReader)reader;
            if (!BoxesRunTime.unboxToBoolean((Object)this.committedOffsets().get(microBatchReader).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)MicroBatchExecution.$anonfun$runBatch$8(available, x$6))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true))) return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            Option current = this.committedOffsets().get(microBatchReader).map((Function1 & Serializable & scala.Serializable)off -> microBatchReader.deserializeOffset(off.json()));
            Offset offset2 = available;
            if (offset2 instanceof SerializedOffset) {
                SerializedOffset serializedOffset = (SerializedOffset)offset2;
                offset = microBatchReader.deserializeOffset(serializedOffset.json());
            } else {
                org.apache.spark.sql.sources.v2.reader.streaming.Offset offset3;
                if (!(offset2 instanceof org.apache.spark.sql.sources.v2.reader.streaming.Offset)) throw new MatchError((Object)offset2);
                offset = offset3 = (org.apache.spark.sql.sources.v2.reader.streaming.Offset)offset2;
            }
            org.apache.spark.sql.sources.v2.reader.streaming.Offset availableV2 = offset;
            microBatchReader.setOffsetRange(this.toJava((Option<org.apache.spark.sql.sources.v2.reader.streaming.Offset>)current), Optional.of(availableV2));
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Retrieving data from ").append(microBatchReader).append(": ").append(current).append(" -> ").append(availableV2).toString());
            MicroBatchReader microBatchReader2 = microBatchReader;
            Tuple2 tuple22 = microBatchReader2 instanceof MemoryStream ? Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MemoryStreamDataSource$.MODULE$), (Object)Predef$.MODULE$.Map().empty()) : (Tuple2)this.org$apache$spark$sql$execution$streaming$MicroBatchExecution$$readerToDataSourceMap().getOrElse((Object)microBatchReader, (Function0 & Serializable & scala.Serializable)() -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)FakeDataSourceV2$.MODULE$), (Object)Predef$.MODULE$.Map().empty()));
            Tuple2 tuple23 = tuple22;
            if (tuple23 == null) throw new MatchError((Object)tuple23);
            DataSourceV2 source = (DataSourceV2)tuple23._1();
            scala.collection.immutable.Map options = (scala.collection.immutable.Map)tuple23._2();
            Tuple2 tuple24 = new Tuple2((Object)source, (Object)options);
            Tuple2 tuple25 = tuple24;
            DataSourceV2 source3 = (DataSourceV2)tuple25._1();
            scala.collection.immutable.Map options2 = (scala.collection.immutable.Map)tuple25._2();
            return Option$.MODULE$.option2Iterable((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)microBatchReader), (Object)new StreamingDataSourceV2Relation((Seq<AttributeReference>)microBatchReader.readSchema().toAttributes(), source3, (scala.collection.immutable.Map<String, String>)options2, microBatchReader))));
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom()))));
        LogicalPlan newBatchesPlan = (LogicalPlan)this.logicalPlan().transform((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MicroBatchExecution $outer;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof StreamingExecutionRelation) {
                    StreamingExecutionRelation streamingExecutionRelation = (StreamingExecutionRelation)A1;
                    BaseStreamingSource source = streamingExecutionRelation.source();
                    Seq<Attribute> output = streamingExecutionRelation.output();
                    object = this.$outer.newData().get((Object)source).map((Function1 & Serializable & scala.Serializable)dataPlan -> {
                        Predef$.MODULE$.assert(output.size() == dataPlan.output().size(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Invalid batch: ").append(Utils$.MODULE$.truncatedString(output, ",")).append(" != ").append(Utils$.MODULE$.truncatedString(dataPlan.output(), ",")).toString());
                        Seq aliases = (Seq)((TraversableLike)output.zip((GenIterable)dataPlan.output(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                            Attribute from;
                            Tuple2 tuple2 = x0$1;
                            if (tuple2 == null) {
                                throw new MatchError((Object)tuple2);
                            }
                            Attribute to = (Attribute)tuple2._1();
                            Attribute x$1 = from = (Attribute)tuple2._2();
                            String x$2 = to.name();
                            ExprId x$3 = to.exprId();
                            Some x$4 = new Some((Object)from.metadata());
                            Seq x$5 = Alias$.MODULE$.apply$default$4((Expression)x$1, x$2);
                            Alias alias = new Alias((Expression)x$1, x$2, x$3, x$5, (Option)x$4);
                            return alias;
                        }, Seq$.MODULE$.canBuildFrom());
                        return new Project(aliases, dataPlan);
                    }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                        Seq x$6 = output;
                        boolean x$7 = true;
                        Seq x$8 = LocalRelation$.MODULE$.apply$default$2();
                        return new LocalRelation(x$6, x$8, x$7);
                    });
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan2 = x1;
                boolean bl = logicalPlan2 instanceof StreamingExecutionRelation;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$7(scala.collection.Seq org.apache.spark.sql.catalyst.plans.logical.LogicalPlan ), $anonfun$applyOrElse$10(scala.collection.Seq ), $anonfun$applyOrElse$8(scala.collection.Seq org.apache.spark.sql.catalyst.plans.logical.LogicalPlan ), $anonfun$applyOrElse$9(scala.Tuple2 )}, serializedLambda);
            }
        });
        LogicalPlan newAttributePlan = newBatchesPlan.transformAllExpressions((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MicroBatchExecution $outer;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 instanceof CurrentTimestamp) {
                    CurrentTimestamp currentTimestamp = (CurrentTimestamp)A1;
                    object = new CurrentBatchTimestamp(this.$outer.offsetSeqMetadata().batchTimestampMs(), currentTimestamp.dataType(), (Option)new Some((Object)"Dummy TimeZoneId"));
                } else if (A1 instanceof CurrentDate) {
                    CurrentDate currentDate = (CurrentDate)A1;
                    object = new CurrentBatchTimestamp(this.$outer.offsetSeqMetadata().batchTimestampMs(), currentDate.dataType(), currentDate.timeZoneId());
                } else {
                    object = function1.apply(x2);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Expression x2) {
                Expression expression = x2;
                boolean bl = expression instanceof CurrentTimestamp ? true : expression instanceof CurrentDate;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        BaseStreamingSink baseStreamingSink = super.sink();
        if (baseStreamingSink instanceof Sink) {
            logicalPlan2 = newAttributePlan;
        } else if (baseStreamingSink instanceof StreamWriteSupport) {
            StreamWriteSupport streamWriteSupport = (StreamWriteSupport)baseStreamingSink;
            StreamWriter writer = streamWriteSupport.createStreamWriter(String.valueOf(this.runId()), newAttributePlan.schema(), super.outputMode(), new DataSourceOptions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.extraOptions).asJava()));
            logicalPlan2 = new WriteToDataSourceV2(new MicroBatchWriter(this.currentBatchId(), writer), newAttributePlan);
        } else {
            throw new IllegalArgumentException(new StringBuilder(22).append("unknown sink type for ").append(super.sink()).toString());
        }
        LogicalPlan triggerLogicalPlan = logicalPlan2;
        sparkSessionToRunBatch.sparkContext().setLocalProperty(MicroBatchExecution$.MODULE$.BATCH_ID_KEY(), ((Object)BoxesRunTime.boxToLong((long)this.currentBatchId())).toString());
        sparkSessionToRunBatch.sparkContext().setLocalProperty(StreamExecution$.MODULE$.IS_CONTINUOUS_PROCESSING(), ((Object)BoxesRunTime.boxToBoolean((boolean)false)).toString());
        this.reportTimeTaken("queryPlanning", (Function0 & Serializable & scala.Serializable)() -> {
            this.lastExecution_$eq(new IncrementalExecution(sparkSessionToRunBatch, triggerLogicalPlan, this.super$outputMode(), this.checkpointFile("state"), this.runId(), this.currentBatchId(), this.offsetSeqMetadata()));
            return this.lastExecution().executedPlan();
        });
        Dataset nextBatch = new Dataset(sparkSessionToRunBatch, this.lastExecution(), RowEncoder$.MODULE$.apply(this.lastExecution().analyzed().schema()));
        this.reportTimeTaken("addBatch", (Function0 & Serializable & scala.Serializable)() -> SQLExecution$.MODULE$.withNewExecutionId(sparkSessionToRunBatch, this.lastExecution(), (Function0 & Serializable & scala.Serializable)() -> {
            Object object;
            BaseStreamingSink baseStreamingSink = this.super$sink();
            if (baseStreamingSink instanceof Sink) {
                Sink sink = (Sink)baseStreamingSink;
                sink.addBatch(this.currentBatchId(), nextBatch);
                object = BoxedUnit.UNIT;
            } else if (baseStreamingSink instanceof StreamWriteSupport) {
                object = nextBatch.collect();
            } else {
                throw new MatchError((Object)baseStreamingSink);
            }
            return object;
        }));
        this.withProgressLocked((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.watermarkTracker().updateWatermark(this.lastExecution().executedPlan());
            this.commitLog().add(this.currentBatchId(), new CommitMetadata(this.watermarkTracker().currentWatermark()));
            this.committedOffsets_$eq(this.committedOffsets().$plus$plus((GenTraversableOnce<Tuple2<BaseStreamingSource, Offset>>)this.availableOffsets()));
        });
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Completed batch ").append(this.currentBatchId()).toString());
    }

    public <T> T withProgressLocked(Function0<T> f) {
        Object object;
        this.awaitProgressLock().lock();
        try {
            object = f.apply();
        }
        finally {
            this.awaitProgressLock().unlock();
        }
        return (T)object;
    }

    private Optional<org.apache.spark.sql.sources.v2.reader.streaming.Offset> toJava(Option<org.apache.spark.sql.sources.v2.reader.streaming.Offset> scalaOption) {
        return Optional.ofNullable(scalaOption.orNull(Predef$.MODULE$.$conforms()));
    }

    public static final /* synthetic */ void $anonfun$populateStartOffsets$2(MicroBatchExecution $this, SparkSession sparkSessionToRunBatches$1, OffsetSeqMetadata metadata) {
        OffsetSeqMetadata$.MODULE$.setSessionConf(metadata, sparkSessionToRunBatches$1.conf());
        $this.offsetSeqMetadata_$eq(OffsetSeqMetadata$.MODULE$.apply(metadata.batchWatermarkMs(), metadata.batchTimestampMs(), sparkSessionToRunBatches$1.conf()));
        $this.watermarkTracker_$eq(WatermarkTracker$.MODULE$.apply(sparkSessionToRunBatches$1.conf()));
        $this.watermarkTracker().setWatermark(metadata.batchWatermarkMs());
    }

    public static final /* synthetic */ boolean $anonfun$populateStartOffsets$6(Offset x3$1, Offset x$2) {
        Offset offset = x$2;
        Offset offset2 = x3$1;
        return !(offset != null ? !((Object)offset).equals(offset2) : offset2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$isNewDataAvailable$2(Offset available$1, Offset committed) {
        Offset offset = committed;
        Offset offset2 = available$1;
        return offset == null ? offset2 != null : !((Object)offset).equals(offset2);
    }

    public static final /* synthetic */ boolean $anonfun$isNewDataAvailable$1(MicroBatchExecution $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        BaseStreamingSource source = (BaseStreamingSource)tuple2._1();
        Offset available = (Offset)tuple2._2();
        boolean bl = BoxesRunTime.unboxToBoolean((Object)$this.committedOffsets().get(source).map((Function1 & Serializable & scala.Serializable)committed -> BoxesRunTime.boxToBoolean((boolean)MicroBatchExecution.$anonfun$isNewDataAvailable$2(available, committed))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true));
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$constructNextBatch$7(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Option o = (Option)tuple2._2();
        boolean bl = o.nonEmpty();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$constructNextBatch$14(Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            BaseStreamingSource src = (BaseStreamingSource)tuple2._1();
            Offset off = (Offset)tuple2._2();
            if (src instanceof Source) {
                Source source = (Source)src;
                source.commit(off);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (tuple2 != null) {
            BaseStreamingSource reader = (BaseStreamingSource)tuple2._1();
            Offset off = (Offset)tuple2._2();
            if (reader instanceof MicroBatchReader) {
                MicroBatchReader microBatchReader = (MicroBatchReader)reader;
                microBatchReader.commit(microBatchReader.deserializeOffset(off.json()));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        BaseStreamingSource src = (BaseStreamingSource)tuple2._1();
        throw new IllegalArgumentException(new StringBuilder(47).append("Unknown source is found at constructNextBatch: ").append(src).toString());
    }

    public static final /* synthetic */ boolean $anonfun$runBatch$4(Offset available$2, Offset x$5) {
        Offset offset = x$5;
        Offset offset2 = available$2;
        return offset == null ? offset2 != null : !((Object)offset).equals(offset2);
    }

    public static final /* synthetic */ boolean $anonfun$runBatch$8(Offset available$3, Offset x$6) {
        Offset offset = x$6;
        Offset offset2 = available$3;
        return offset == null ? offset2 != null : !((Object)offset).equals(offset2);
    }

    public MicroBatchExecution(SparkSession sparkSession, String name, String checkpointRoot, LogicalPlan analyzedPlan, BaseStreamingSink sink, Trigger trigger, Clock triggerClock, OutputMode outputMode, scala.collection.immutable.Map<String, String> extraOptions, boolean deleteCheckpointOnStop) {
        Product product;
        this.analyzedPlan = analyzedPlan;
        this.extraOptions = extraOptions;
        super(sparkSession, name, checkpointRoot, analyzedPlan, sink, trigger, triggerClock, outputMode, deleteCheckpointOnStop);
        this.sources = (Seq)Seq$.MODULE$.empty();
        this.org$apache$spark$sql$execution$streaming$MicroBatchExecution$$readerToDataSourceMap = Map$.MODULE$.empty();
        Trigger trigger2 = super.trigger();
        if (trigger2 instanceof ProcessingTime) {
            ProcessingTime processingTime = (ProcessingTime)trigger2;
            product = new ProcessingTimeExecutor(processingTime, super.triggerClock());
        } else if (OneTimeTrigger$.MODULE$.equals(trigger2)) {
            product = new OneTimeExecutor();
        } else {
            throw new IllegalStateException(new StringBuilder(25).append("Unknown type of trigger: ").append(super.trigger()).toString());
        }
        this.triggerExecutor = product;
        this.isCurrentBatchConstructed = false;
    }
}

