/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.Serializable;
import java.util.UUID;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.io.FileCommitProtocol;
import org.apache.spark.sql.execution.streaming.FileStreamSinkLog;
import org.apache.spark.sql.execution.streaming.SinkFileStatus;
import org.apache.spark.sql.execution.streaming.SinkFileStatus$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015e\u0001\u0002\f\u0018\u0001\u0011B\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\t\u0007\u0002\u0011\t\u0011)A\u0005q!)A\t\u0001C\u0001\u000b\"I!\n\u0001a\u0001\u0002\u0004%Ia\u0013\u0005\n)\u0002\u0001\r\u00111A\u0005\nUC\u0011b\u0017\u0001A\u0002\u0003\u0005\u000b\u0015\u0002'\t\u0013\u0001\u0004\u0001\u0019!a\u0001\n\u0013\t\u0007\"C3\u0001\u0001\u0004\u0005\r\u0011\"\u0003g\u0011%A\u0007\u00011A\u0001B\u0003&!\rC\u0005k\u0001\u0001\u0007\t\u0019!C\u0005W\"Iq\u000e\u0001a\u0001\u0002\u0004%I\u0001\u001d\u0005\ne\u0002\u0001\r\u0011!Q!\n1DQa\u001d\u0001\u0005\u0002QDQa\u001e\u0001\u0005BaDq!a\u0002\u0001\t\u0003\nI\u0001C\u0004\u0002F\u0001!\t%a\u0012\t\u000f\u0005-\u0003\u0001\"\u0011\u0002N!9\u0011\u0011\f\u0001\u0005B\u0005m\u0003bBA7\u0001\u0011\u0005\u0013q\u000e\u0005\b\u0003s\u0002A\u0011IA>\u0011\u001d\ty\b\u0001C!\u0003\u0003\u0013!$T1oS\u001a,7\u000f\u001e$jY\u0016\u001cu.\\7jiB\u0013x\u000e^8d_2T!\u0001G\r\u0002\u0013M$(/Z1nS:<'B\u0001\u000e\u001c\u0003%)\u00070Z2vi&|gN\u0003\u0002\u001d;\u0005\u00191/\u001d7\u000b\u0005yy\u0012!B:qCJ\\'B\u0001\u0011\"\u0003\u0019\t\u0007/Y2iK*\t!%A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001K5\u001a\u0004C\u0001\u0014,\u001b\u00059#B\u0001\u0015*\u0003\tIwN\u0003\u0002+;\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002-O\t\u0011b)\u001b7f\u0007>lW.\u001b;Qe>$xnY8m!\tq\u0013'D\u00010\u0015\u0005\u0001\u0014!B:dC2\f\u0017B\u0001\u001a0\u00051\u0019VM]5bY&T\u0018M\u00197f!\t!T'D\u0001*\u0013\t1\u0014FA\u0004M_\u001e<\u0017N\\4\u0002\u000b)|'-\u00133\u0011\u0005e\u0002eB\u0001\u001e?!\tYt&D\u0001=\u0015\ti4%\u0001\u0004=e>|GOP\u0005\u0003\u007f=\na\u0001\u0015:fI\u00164\u0017BA!C\u0005\u0019\u0019FO]5oO*\u0011qhL\u0001\u0005a\u0006$\b.\u0001\u0004=S:LGO\u0010\u000b\u0004\r\"K\u0005CA$\u0001\u001b\u00059\u0002\"B\u001c\u0004\u0001\u0004A\u0004\"B\"\u0004\u0001\u0004A\u0014AC1eI\u0016$g)\u001b7fgV\tA\nE\u0002N%bj\u0011A\u0014\u0006\u0003\u001fB\u000bq!\\;uC\ndWM\u0003\u0002R_\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005Ms%aC!se\u0006L()\u001e4gKJ\fa\"\u00193eK\u00124\u0015\u000e\\3t?\u0012*\u0017\u000f\u0006\u0002W3B\u0011afV\u0005\u00031>\u0012A!\u00168ji\"9!,BA\u0001\u0002\u0004a\u0015a\u0001=%c\u0005Y\u0011\r\u001a3fI\u001aKG.Z:!Q\t1Q\f\u0005\u0002/=&\u0011ql\f\u0002\niJ\fgn]5f]R\fqAZ5mK2{w-F\u0001c!\t95-\u0003\u0002e/\t\tb)\u001b7f'R\u0014X-Y7TS:\\Gj\\4\u0002\u0017\u0019LG.\u001a'pO~#S-\u001d\u000b\u0003-\u001eDqA\u0017\u0005\u0002\u0002\u0003\u0007!-\u0001\u0005gS2,Gj\\4!Q\tIQ,A\u0004cCR\u001c\u0007.\u00133\u0016\u00031\u0004\"AL7\n\u00059|#\u0001\u0002'p]\u001e\f1BY1uG\"LEm\u0018\u0013fcR\u0011a+\u001d\u0005\b5.\t\t\u00111\u0001m\u0003!\u0011\u0017\r^2i\u0013\u0012\u0004\u0013\u0001F:fiV\u0004X*\u00198jM\u0016\u001cHo\u00149uS>t7\u000fF\u0002WkZDQ\u0001Y\u0007A\u0002\tDQA[\u0007A\u00021\f\u0001b]3ukBTuN\u0019\u000b\u0003-fDQA\u001f\bA\u0002m\f!B[8c\u0007>tG/\u001a=u!\ra\u00181A\u0007\u0002{*\u0011ap`\u0001\n[\u0006\u0004(/\u001a3vG\u0016T1!!\u0001 \u0003\u0019A\u0017\rZ8pa&\u0019\u0011QA?\u0003\u0015){'mQ8oi\u0016DH/A\u0005d_6l\u0017\u000e\u001e&pER)a+a\u0003\u0002\u000e!)!p\u0004a\u0001w\"9\u0011qB\bA\u0002\u0005E\u0011a\u0003;bg.\u001cu.\\7jiN\u0004b!a\u0005\u0002\u001e\u0005\rb\u0002BA\u000b\u00033q1aOA\f\u0013\u0005\u0001\u0014bAA\u000e_\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u0010\u0003C\u00111aU3r\u0015\r\tYb\f\t\u0005\u0003K\tyD\u0004\u0003\u0002(\u0005mb\u0002BA\u0015\u0003sqA!a\u000b\u000289!\u0011QFA\u001b\u001d\u0011\ty#a\r\u000f\u0007m\n\t$C\u0001#\u0013\t\u0001\u0013%\u0003\u0002\u001f?%\u0011!&H\u0005\u0003Q%J1!!\u0010(\u0003I1\u0015\u000e\\3D_6l\u0017\u000e\u001e)s_R|7m\u001c7\n\t\u0005\u0005\u00131\t\u0002\u0012)\u0006\u001c8nQ8n[&$X*Z:tC\u001e,'bAA\u001fO\u0005A\u0011MY8si*{'\rF\u0002W\u0003\u0013BQA\u001f\tA\u0002m\f\u0011b]3ukB$\u0016m]6\u0015\u0007Y\u000by\u0005C\u0004\u0002RE\u0001\r!a\u0015\u0002\u0017Q\f7o[\"p]R,\u0007\u0010\u001e\t\u0004y\u0006U\u0013bAA,{\n\u0011B+Y:l\u0003R$X-\u001c9u\u0007>tG/\u001a=u\u0003=qWm\u001e+bg.$V-\u001c9GS2,Gc\u0002\u001d\u0002^\u0005}\u0013\u0011\u000e\u0005\b\u0003#\u0012\u0002\u0019AA*\u0011\u001d\t\tG\u0005a\u0001\u0003G\n1\u0001Z5s!\u0011q\u0013Q\r\u001d\n\u0007\u0005\u001dtF\u0001\u0004PaRLwN\u001c\u0005\u0007\u0003W\u0012\u0002\u0019\u0001\u001d\u0002\u0007\u0015DH/\u0001\foK^$\u0016m]6UK6\u0004h)\u001b7f\u0003\n\u001c\b+\u0019;i)\u001dA\u0014\u0011OA:\u0003oBq!!\u0015\u0014\u0001\u0004\t\u0019\u0006\u0003\u0004\u0002vM\u0001\r\u0001O\u0001\fC\n\u001cx\u000e\\;uK\u0012K'\u000f\u0003\u0004\u0002lM\u0001\r\u0001O\u0001\u000bG>lW.\u001b;UCN\\G\u0003BA\u0012\u0003{Bq!!\u0015\u0015\u0001\u0004\t\u0019&A\u0005bE>\u0014H\u000fV1tWR\u0019a+a!\t\u000f\u0005ES\u00031\u0001\u0002T\u0001")
public class ManifestFileCommitProtocol
extends FileCommitProtocol
implements scala.Serializable,
Logging {
    private final String path;
    private transient ArrayBuffer<String> addedFiles;
    private transient FileStreamSinkLog fileLog;
    private long batchId;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ArrayBuffer<String> addedFiles() {
        return this.addedFiles;
    }

    private void addedFiles_$eq(ArrayBuffer<String> x$1) {
        this.addedFiles = x$1;
    }

    private FileStreamSinkLog fileLog() {
        return this.fileLog;
    }

    private void fileLog_$eq(FileStreamSinkLog x$1) {
        this.fileLog = x$1;
    }

    private long batchId() {
        return this.batchId;
    }

    private void batchId_$eq(long x$1) {
        this.batchId = x$1;
    }

    public void setupManifestOptions(FileStreamSinkLog fileLog, long batchId) {
        this.fileLog_$eq(fileLog);
        this.batchId_$eq(batchId);
    }

    public void setupJob(JobContext jobContext) {
        Predef$.MODULE$.require(this.fileLog() != null, (Function0 & Serializable & scala.Serializable)() -> "setupManifestOptions must be called before this function");
    }

    public void commitJob(JobContext jobContext, Seq<FileCommitProtocol.TaskCommitMessage> taskCommits) {
        Predef$.MODULE$.require(this.fileLog() != null, (Function0 & Serializable & scala.Serializable)() -> "setupManifestOptions must be called before this function");
        SinkFileStatus[] fileStatuses = (SinkFileStatus[])((TraversableOnce)taskCommits.flatMap((Function1 & Serializable & scala.Serializable)x$1 -> (Seq)x$1.obj(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(SinkFileStatus.class));
        if (!this.fileLog().add(this.batchId(), (Object[])fileStatuses)) {
            throw new IllegalStateException(new StringBuilder(25).append("Race while writing batch ").append(this.batchId()).toString());
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Committed batch ").append(this.batchId()).toString());
    }

    public void abortJob(JobContext jobContext) {
        Predef$.MODULE$.require(this.fileLog() != null, (Function0 & Serializable & scala.Serializable)() -> "setupManifestOptions must be called before this function");
    }

    public void setupTask(TaskAttemptContext taskContext) {
        this.addedFiles_$eq((ArrayBuffer<String>)new ArrayBuffer());
    }

    public String newTaskTempFile(TaskAttemptContext taskContext, Option<String> dir, String ext) {
        int split = taskContext.getTaskAttemptID().getTaskID().getId();
        String uuid = UUID.randomUUID().toString();
        int arg$macro$1 = split;
        String arg$macro$2 = uuid;
        String arg$macro$3 = ext;
        String filename = new StringOps("part-%05d-%s%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)arg$macro$1), arg$macro$2, arg$macro$3}));
        String file = (String)dir.map((Function1 & Serializable & scala.Serializable)d -> new Path(new Path($this.path, d), filename).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> new Path($this.path, filename).toString());
        this.addedFiles().$plus$eq((Object)file);
        return file;
    }

    public String newTaskTempFileAbsPath(TaskAttemptContext taskContext, String absoluteDir, String ext) {
        throw new UnsupportedOperationException(new StringBuilder(52).append((Object)this).append(" does not support adding files with an absolute path").toString());
    }

    public FileCommitProtocol.TaskCommitMessage commitTask(TaskAttemptContext taskContext) {
        FileCommitProtocol.TaskCommitMessage taskCommitMessage;
        if (this.addedFiles().nonEmpty()) {
            FileSystem fs = new Path((String)this.addedFiles().head()).getFileSystem(taskContext.getConfiguration());
            Seq statuses = (Seq)this.addedFiles().map((Function1 & Serializable & scala.Serializable)f -> SinkFileStatus$.MODULE$.apply(fs.getFileStatus(new Path(f))), ArrayBuffer$.MODULE$.canBuildFrom());
            taskCommitMessage = new FileCommitProtocol.TaskCommitMessage((Object)statuses);
        } else {
            taskCommitMessage = new FileCommitProtocol.TaskCommitMessage((Object)Seq$.MODULE$.empty());
        }
        return taskCommitMessage;
    }

    public void abortTask(TaskAttemptContext taskContext) {
    }

    public ManifestFileCommitProtocol(String jobId, String path) {
        this.path = path;
        Logging.$init$((Logging)this);
    }
}

