/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.streaming;

import java.util.Locale;
import java.util.Optional;
import org.apache.spark.annotation.InterfaceStability;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Utils$;
import org.apache.spark.sql.execution.streaming.BaseStreamingSource;
import org.apache.spark.sql.execution.streaming.StreamingRelation;
import org.apache.spark.sql.execution.streaming.StreamingRelation$;
import org.apache.spark.sql.execution.streaming.StreamingRelationV2;
import org.apache.spark.sql.sources.StreamSourceProvider;
import org.apache.spark.sql.sources.v2.ContinuousReadSupport;
import org.apache.spark.sql.sources.v2.DataSourceOptions;
import org.apache.spark.sql.sources.v2.MicroBatchReadSupport;
import org.apache.spark.sql.sources.v2.reader.streaming.ContinuousReader;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.mutable.HashMap;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@InterfaceStability.Evolving
@ScalaSignature(bytes="\u0006\u0001\u0005=f\u0001B\u000f\u001f\u0005%B\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\u0007w\u0001!\t\u0001\t\u001f\t\u000b\u0001\u0003A\u0011A!\t\u000b=\u0003A\u0011\u0001)\t\u000b=\u0003A\u0011\u0001-\t\u000bm\u0003A\u0011\u0001/\t\u000bm\u0003A\u0011A1\t\u000bm\u0003A\u0011A4\t\u000bm\u0003A\u0011A7\t\u000bM\u0004A\u0011\u0001;\t\u000bM\u0004A\u0011\u0001?\t\u000f\u0005-\u0001\u0001\"\u0001\u0002\u000e!9\u00111\u0002\u0001\u0005\u0002\u00055\u0002bBA\u001a\u0001\u0011\u0005\u0011Q\u0007\u0005\b\u0003s\u0001A\u0011AA\u001e\u0011\u001d\ty\u0004\u0001C\u0001\u0003\u0003Bq!!\u0012\u0001\t\u0003\t9\u0005C\u0004\u0002L\u0001!\t!!\u0014\t\u000f\u0005E\u0003\u0001\"\u0001\u0002T!A1\t\u0001a\u0001\n\u0013\ti\u0006C\u0005\u0002`\u0001\u0001\r\u0011\"\u0003\u0002b!9\u0011Q\u000e\u0001!B\u0013!\u0005\"CA8\u0001\u0001\u0007I\u0011BA9\u0011%\tI\b\u0001a\u0001\n\u0013\tY\b\u0003\u0005\u0002\u0000\u0001\u0001\u000b\u0015BA:\u0011%\t\t\t\u0001a\u0001\n\u0013\t\u0019\tC\u0005\u0002\u0012\u0002\u0001\r\u0011\"\u0003\u0002\u0014\"A\u0011q\u0013\u0001!B\u0013\t)I\u0001\tECR\f7\u000b\u001e:fC6\u0014V-\u00193fe*\u0011q\u0004I\u0001\ngR\u0014X-Y7j]\u001eT!!\t\u0012\u0002\u0007M\fHN\u0003\u0002$I\u0005)1\u000f]1sW*\u0011QEJ\u0001\u0007CB\f7\r[3\u000b\u0003\u001d\n1a\u001c:h\u0007\u0001\u00192\u0001\u0001\u00161!\tYc&D\u0001-\u0015\u0005i\u0013!B:dC2\f\u0017BA\u0018-\u0005\u0019\te.\u001f*fMB\u0011\u0011\u0007N\u0007\u0002e)\u00111GI\u0001\tS:$XM\u001d8bY&\u0011QG\r\u0002\b\u0019><w-\u001b8h\u00031\u0019\b/\u0019:l'\u0016\u001c8/[8o!\tA\u0014(D\u0001!\u0013\tQ\u0004E\u0001\u0007Ta\u0006\u00148nU3tg&|g.\u0001\u0004=S:LGO\u0010\u000b\u0003{}\u0002\"A\u0010\u0001\u000e\u0003yAQA\u000e\u0002A\u0002]\naAZ8s[\u0006$HCA\u001fC\u0011\u0015\u00195\u00011\u0001E\u0003\u0019\u0019x.\u001e:dKB\u0011Q\t\u0014\b\u0003\r*\u0003\"a\u0012\u0017\u000e\u0003!S!!\u0013\u0015\u0002\rq\u0012xn\u001c;?\u0013\tYE&\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u001b:\u0013aa\u0015;sS:<'BA&-\u0003\u0019\u00198\r[3nCR\u0011Q(\u0015\u0005\u0006\u001f\u0012\u0001\rA\u0015\t\u0003'Zk\u0011\u0001\u0016\u0006\u0003+\u0002\nQ\u0001^=qKNL!a\u0016+\u0003\u0015M#(/^2u)f\u0004X\r\u0006\u0002>3\")!,\u0002a\u0001\t\u0006a1o\u00195f[\u0006\u001cFO]5oO\u00061q\u000e\u001d;j_:$2!P/`\u0011\u0015qf\u00011\u0001E\u0003\rYW-\u001f\u0005\u0006A\u001a\u0001\r\u0001R\u0001\u0006m\u0006dW/\u001a\u000b\u0004{\t\u001c\u0007\"\u00020\b\u0001\u0004!\u0005\"\u00021\b\u0001\u0004!\u0007CA\u0016f\u0013\t1GFA\u0004C_>dW-\u00198\u0015\u0007uB\u0017\u000eC\u0003_\u0011\u0001\u0007A\tC\u0003a\u0011\u0001\u0007!\u000e\u0005\u0002,W&\u0011A\u000e\f\u0002\u0005\u0019>tw\rF\u0002>]>DQAX\u0005A\u0002\u0011CQ\u0001Y\u0005A\u0002A\u0004\"aK9\n\u0005Id#A\u0002#pk\ndW-A\u0004paRLwN\\:\u0015\u0005u*\b\"B:\u000b\u0001\u00041\b\u0003B<{\t\u0012k\u0011\u0001\u001f\u0006\u0003s2\n!bY8mY\u0016\u001cG/[8o\u0013\tY\bPA\u0002NCB$\"!P?\t\u000bM\\\u0001\u0019\u0001@\u0011\u000b}\fI\u0001\u0012#\u000e\u0005\u0005\u0005!\u0002BA\u0002\u0003\u000b\tA!\u001e;jY*\u0011\u0011qA\u0001\u0005U\u00064\u0018-C\u0002|\u0003\u0003\tA\u0001\\8bIR\u0011\u0011q\u0002\t\u0005\u0003#\t9C\u0004\u0003\u0002\u0014\u0005\rb\u0002BA\u000b\u0003CqA!a\u0006\u0002 9!\u0011\u0011DA\u000f\u001d\r9\u00151D\u0005\u0002O%\u0011QEJ\u0005\u0003G\u0011J!!\t\u0012\n\u0007\u0005\u0015\u0002%A\u0004qC\u000e\\\u0017mZ3\n\t\u0005%\u00121\u0006\u0002\n\t\u0006$\u0018M\u0012:b[\u0016T1!!\n!)\u0011\ty!a\f\t\r\u0005ER\u00021\u0001E\u0003\u0011\u0001\u0018\r\u001e5\u0002\t)\u001cxN\u001c\u000b\u0005\u0003\u001f\t9\u0004\u0003\u0004\u000229\u0001\r\u0001R\u0001\u0004GN4H\u0003BA\b\u0003{Aa!!\r\u0010\u0001\u0004!\u0015aA8sGR!\u0011qBA\"\u0011\u0019\t\t\u0004\u0005a\u0001\t\u00069\u0001/\u0019:rk\u0016$H\u0003BA\b\u0003\u0013Ba!!\r\u0012\u0001\u0004!\u0015\u0001\u0002;fqR$B!a\u0004\u0002P!1\u0011\u0011\u0007\nA\u0002\u0011\u000b\u0001\u0002^3yi\u001aKG.\u001a\u000b\u0005\u0003+\nY\u0006\u0005\u00039\u0003/\"\u0015bAA-A\t9A)\u0019;bg\u0016$\bBBA\u0019'\u0001\u0007A)F\u0001E\u0003)\u0019x.\u001e:dK~#S-\u001d\u000b\u0005\u0003G\nI\u0007E\u0002,\u0003KJ1!a\u001a-\u0005\u0011)f.\u001b;\t\u0011\u0005-T#!AA\u0002\u0011\u000b1\u0001\u001f\u00132\u0003\u001d\u0019x.\u001e:dK\u0002\n1#^:feN\u0003XmY5gS\u0016$7k\u00195f[\u0006,\"!a\u001d\u0011\t-\n)HU\u0005\u0004\u0003ob#AB(qi&|g.A\fvg\u0016\u00148\u000b]3dS\u001aLW\rZ*dQ\u0016l\u0017m\u0018\u0013fcR!\u00111MA?\u0011%\tY\u0007GA\u0001\u0002\u0004\t\u0019(\u0001\u000bvg\u0016\u00148\u000b]3dS\u001aLW\rZ*dQ\u0016l\u0017\rI\u0001\rKb$(/Y(qi&|gn]\u000b\u0003\u0003\u000b\u0003b!a\"\u0002\u000e\u0012#UBAAE\u0015\r\tY\t_\u0001\b[V$\u0018M\u00197f\u0013\u0011\ty)!#\u0003\u000f!\u000b7\u000f['ba\u0006\u0001R\r\u001f;sC>\u0003H/[8og~#S-\u001d\u000b\u0005\u0003G\n)\nC\u0005\u0002lm\t\t\u00111\u0001\u0002\u0006\u0006iQ\r\u001f;sC>\u0003H/[8og\u0002B3\u0001AAN!\u0011\ti*!+\u000f\t\u0005}\u0015QU\u0007\u0003\u0003CS1!a)#\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003O\u000b\t+\u0001\nJ]R,'OZ1dKN#\u0018MY5mSRL\u0018\u0002BAV\u0003[\u0013\u0001\"\u0012<pYZLgn\u001a\u0006\u0005\u0003O\u000b\t\u000b")
public final class DataStreamReader
implements Logging {
    private final SparkSession sparkSession;
    private String source;
    private Option<StructType> userSpecifiedSchema;
    private HashMap<String, String> extraOptions;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public DataStreamReader format(String source) {
        this.source_$eq(source);
        return this;
    }

    public DataStreamReader schema(StructType schema) {
        this.userSpecifiedSchema_$eq((Option<StructType>)Option$.MODULE$.apply((Object)schema));
        return this;
    }

    public DataStreamReader schema(String schemaString) {
        this.userSpecifiedSchema_$eq((Option<StructType>)Option$.MODULE$.apply((Object)StructType$.MODULE$.fromDDL(schemaString)));
        return this;
    }

    public DataStreamReader option(String key, String value) {
        this.extraOptions().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value));
        return this;
    }

    public DataStreamReader option(String key, boolean value) {
        return this.option(key, ((Object)BoxesRunTime.boxToBoolean((boolean)value)).toString());
    }

    public DataStreamReader option(String key, long value) {
        return this.option(key, ((Object)BoxesRunTime.boxToLong((long)value)).toString());
    }

    public DataStreamReader option(String key, double value) {
        return this.option(key, ((Object)BoxesRunTime.boxToDouble((double)value)).toString());
    }

    public DataStreamReader options(Map<String, String> options) {
        this.extraOptions().$plus$plus$eq(options);
        return this;
    }

    public DataStreamReader options(java.util.Map<String, String> options) {
        this.options((Map<String, String>)((Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(options).asScala()));
        return this;
    }

    public Dataset<Row> load() {
        Dataset<Row> dataset;
        String string = this.source().toLowerCase(Locale.ROOT);
        String string2 = DDLUtils$.MODULE$.HIVE_PROVIDER();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw new AnalysisException("Hive data source can only be used with tables, you can not read files of Hive data source directly.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        Object ds = DataSource$.MODULE$.lookupDataSource(this.source(), this.sparkSession.sqlContext().conf()).newInstance();
        SparkSession x$1 = this.sparkSession;
        Option<StructType> x$2 = this.userSpecifiedSchema();
        String x$3 = this.source();
        scala.collection.immutable.Map x$4 = this.extraOptions().toMap(Predef$.MODULE$.$conforms());
        Seq<String> x$5 = DataSource$.MODULE$.apply$default$3();
        Seq<String> x$6 = DataSource$.MODULE$.apply$default$5();
        Option<BucketSpec> x$7 = DataSource$.MODULE$.apply$default$6();
        Option<CatalogTable> x$8 = DataSource$.MODULE$.apply$default$8();
        DataSource v1DataSource = new DataSource(x$1, x$3, x$5, x$2, x$6, x$7, (scala.collection.immutable.Map<String, String>)x$4, x$8);
        Object obj = ds;
        Object object = obj instanceof StreamSourceProvider ? new Some((Object)StreamingRelation$.MODULE$.apply(v1DataSource)) : None$.MODULE$;
        None$ v1Relation = object;
        Object obj2 = ds;
        if (obj2 instanceof MicroBatchReadSupport) {
            StructType structType;
            MicroBatchReadSupport microBatchReadSupport = (MicroBatchReadSupport)obj2;
            scala.collection.immutable.Map<String, String> sessionOptions = DataSourceV2Utils$.MODULE$.extractSessionConfigs(microBatchReadSupport, this.sparkSession.sessionState().conf());
            scala.collection.immutable.Map options = sessionOptions.$plus$plus(this.extraOptions());
            DataSourceOptions dataSourceOptions = new DataSourceOptions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)options).asJava());
            BaseStreamingSource tempReader = null;
            try {
                String x$9 = "temporaryReader";
                String x$10 = Utils$.MODULE$.createTempDir$default$1();
                tempReader = microBatchReadSupport.createMicroBatchReader(Optional.ofNullable(this.userSpecifiedSchema().orNull(Predef$.MODULE$.$conforms())), Utils$.MODULE$.createTempDir(x$10, x$9).getCanonicalPath(), dataSourceOptions);
                structType = tempReader.readSchema();
            }
            finally {
                if (tempReader != null) {
                    tempReader.stop();
                    tempReader = null;
                }
            }
            StructType schema = structType;
            dataset = Dataset$.MODULE$.ofRows(this.sparkSession, (LogicalPlan)new StreamingRelationV2(microBatchReadSupport, this.source(), (scala.collection.immutable.Map<String, String>)options, (Seq<Attribute>)schema.toAttributes(), (Option<StreamingRelation>)v1Relation, this.sparkSession));
        } else if (obj2 instanceof ContinuousReadSupport) {
            ContinuousReadSupport continuousReadSupport = (ContinuousReadSupport)obj2;
            scala.collection.immutable.Map<String, String> sessionOptions = DataSourceV2Utils$.MODULE$.extractSessionConfigs(continuousReadSupport, this.sparkSession.sessionState().conf());
            scala.collection.immutable.Map options = sessionOptions.$plus$plus(this.extraOptions());
            DataSourceOptions dataSourceOptions = new DataSourceOptions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)options).asJava());
            String x$11 = "temporaryReader";
            String x$12 = Utils$.MODULE$.createTempDir$default$1();
            ContinuousReader tempReader = continuousReadSupport.createContinuousReader(Optional.ofNullable(this.userSpecifiedSchema().orNull(Predef$.MODULE$.$conforms())), Utils$.MODULE$.createTempDir(x$12, x$11).getCanonicalPath(), dataSourceOptions);
            dataset = Dataset$.MODULE$.ofRows(this.sparkSession, (LogicalPlan)new StreamingRelationV2(continuousReadSupport, this.source(), (scala.collection.immutable.Map<String, String>)options, (Seq<Attribute>)tempReader.readSchema().toAttributes(), (Option<StreamingRelation>)v1Relation, this.sparkSession));
        } else {
            dataset = Dataset$.MODULE$.ofRows(this.sparkSession, (LogicalPlan)StreamingRelation$.MODULE$.apply(v1DataSource));
        }
        return dataset;
    }

    public Dataset<Row> load(String path) {
        return this.option("path", path).load();
    }

    public Dataset<Row> json(String path) {
        return this.format("json").load(path);
    }

    public Dataset<Row> csv(String path) {
        return this.format("csv").load(path);
    }

    public Dataset<Row> orc(String path) {
        return this.format("orc").load(path);
    }

    public Dataset<Row> parquet(String path) {
        return this.format("parquet").load(path);
    }

    public Dataset<Row> text(String path) {
        return this.format("text").load(path);
    }

    public Dataset<String> textFile(String path) {
        if (this.userSpecifiedSchema().nonEmpty()) {
            throw new AnalysisException("User specified schema not supported with `textFile`", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        return this.text(path).select("value", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).as(this.sparkSession.implicits().newStringEncoder());
    }

    private String source() {
        return this.source;
    }

    private void source_$eq(String x$1) {
        this.source = x$1;
    }

    private Option<StructType> userSpecifiedSchema() {
        return this.userSpecifiedSchema;
    }

    private void userSpecifiedSchema_$eq(Option<StructType> x$1) {
        this.userSpecifiedSchema = x$1;
    }

    private HashMap<String, String> extraOptions() {
        return this.extraOptions;
    }

    private void extraOptions_$eq(HashMap<String, String> x$1) {
        this.extraOptions = x$1;
    }

    public DataStreamReader(SparkSession sparkSession) {
        this.sparkSession = sparkSession;
        Logging.$init$((Logging)this);
        this.source = sparkSession.sessionState().conf().defaultDataSourceName();
        this.userSpecifiedSchema = None$.MODULE$;
        this.extraOptions = new HashMap();
    }
}

